/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.CredentialContext;
import org.apache.gravitino.credential.CredentialGenerator;
import org.apache.gravitino.credential.CredentialProvider;

public abstract class CredentialProviderDelegator<T extends Credential>
implements CredentialProvider {
    protected Map<String, String> properties;
    private volatile CredentialGenerator<T> generator;

    @Override
    public void initialize(Map<String, String> properties) {
        this.properties = properties;
        this.generator = this.loadGenerator();
        this.generator.initialize(properties);
    }

    @Override
    public Credential getCredential(CredentialContext context) {
        try {
            return this.generator.generate(context);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate credential using " + this.getGeneratorClassName(), e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.generator != null) {
            this.generator.close();
        }
    }

    protected abstract String getGeneratorClassName();

    private CredentialGenerator<T> loadGenerator() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> generatorClass = Class.forName(this.getGeneratorClassName(), true, classLoader);
            Constructor<?> constructor = generatorClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (CredentialGenerator)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load or instantiate CredentialGenerator: " + this.getGeneratorClassName(), e);
        }
    }
}

