/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileBaseImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateStoreFileSystemImpl
extends StateStoreFileBaseImpl {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreFileSystemImpl.class);
    public static final String FEDERATION_STORE_FS_PATH = "dfs.federation.router.store.driver.fs.path";
    private FileSystem fs;
    private String workPath;

    @Override
    protected boolean exists(String path) {
        try {
            return this.fs.exists(new Path(path));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected boolean mkdir(String path) {
        try {
            return this.fs.mkdirs(new Path(path));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected boolean rename(String src, String dst) {
        try {
            FileUtil.rename((FileSystem)this.fs, (Path)new Path(src), (Path)new Path(dst), (Options.Rename[])new Options.Rename[]{Options.Rename.OVERWRITE});
            return true;
        }
        catch (Exception e) {
            LOG.error("Cannot rename {} to {}", new Object[]{src, dst, e});
            return false;
        }
    }

    @Override
    protected boolean remove(String path) {
        try {
            return this.fs.delete(new Path(path), true);
        }
        catch (Exception e) {
            LOG.error("Cannot remove {}", (Object)path, (Object)e);
            return false;
        }
    }

    @Override
    protected String getRootDir() {
        if (this.workPath == null) {
            String rootPath = this.getConf().get(FEDERATION_STORE_FS_PATH);
            try {
                URI workUri = new URI(rootPath);
                this.fs = FileSystem.get((URI)workUri, (Configuration)this.getConf());
            }
            catch (Exception ex) {
                return null;
            }
            this.workPath = rootPath;
        }
        return this.workPath;
    }

    @Override
    protected int getConcurrentFilesAccessNumThreads() {
        return this.getConf().getInt("dfs.federation.router.store.driver.fs.async.threads", 0);
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.fs != null) {
            this.fs.close();
        }
    }

    @Override
    protected <T extends BaseRecord> BufferedReader getReader(String pathName) {
        BufferedReader reader = null;
        Path path = new Path(pathName);
        try {
            FSDataInputStream fdis = this.fs.open(path);
            InputStreamReader isr = new InputStreamReader((InputStream)fdis, StandardCharsets.UTF_8);
            reader = new BufferedReader(isr);
        }
        catch (IOException ex) {
            LOG.error("Cannot open read stream for {}", (Object)path, (Object)ex);
        }
        return reader;
    }

    @Override
    @VisibleForTesting
    public <T extends BaseRecord> BufferedWriter getWriter(String pathName) {
        BufferedWriter writer = null;
        Path path = new Path(pathName);
        try {
            FSDataOutputStream fdos = this.fs.create(path, true);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fdos, StandardCharsets.UTF_8);
            writer = new BufferedWriter(osw);
        }
        catch (IOException ex) {
            LOG.error("Cannot open write stream for {}", (Object)path, (Object)ex);
        }
        return writer;
    }

    @Override
    protected List<String> getChildren(String pathName) {
        Path path = new Path(this.workPath, pathName);
        try {
            FileStatus[] files = this.fs.listStatus(path);
            ArrayList<String> ret = new ArrayList<String>(files.length);
            for (FileStatus file : files) {
                Path filePath = file.getPath();
                String fileName = filePath.getName();
                ret.add(fileName);
            }
            return ret;
        }
        catch (Exception e) {
            LOG.error("Cannot get children for {}", (Object)pathName, (Object)e);
            return Collections.emptyList();
        }
    }
}

