/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.containerlaunch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;

public class ClasspathConstructor {
    public static final String CLASS_PATH_SEPARATOR = "<CPS>";
    private final List<String> pathElements = new ArrayList<String>();

    public List<String> yarnApplicationClasspath(Configuration config) {
        String[] cp = config.getTrimmedStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_CROSS_PLATFORM_APPLICATION_CLASSPATH);
        return cp != null ? Arrays.asList(cp) : new ArrayList(0);
    }

    public String toString() {
        return this.buildClasspath();
    }

    public String buildClasspath() {
        return ServiceUtils.join(this.pathElements, CLASS_PATH_SEPARATOR, false);
    }

    public List<String> getPathElements() {
        return Collections.unmodifiableList(this.pathElements);
    }

    public void append(String path) {
        this.pathElements.add(path);
    }

    public void insert(String path) {
        this.pathElements.add(0, path);
    }

    public void appendAll(Collection<String> paths) {
        this.pathElements.addAll(paths);
    }

    public void insertAll(Collection<String> paths) {
        this.pathElements.addAll(0, paths);
    }

    public void addLibDir(String pathToLibDir) {
        this.append(this.buildLibDir(pathToLibDir));
    }

    public void insertLibDir(String pathToLibDir) {
        this.insert(this.buildLibDir(pathToLibDir));
    }

    public void addClassDirectory(String pathToDir) {
        this.append(this.appendDirectoryTerminator(pathToDir));
    }

    public void insertClassDirectory(String pathToDir) {
        this.insert(this.buildLibDir(this.appendDirectoryTerminator(pathToDir)));
    }

    public void addRemoteClasspathEnvVar() {
        this.append(ApplicationConstants.Environment.CLASSPATH.$$());
    }

    public void insertRemoteClasspathEnvVar() {
        this.append(ApplicationConstants.Environment.CLASSPATH.$$());
    }

    public String buildLibDir(String pathToLibDir) {
        String dir = this.appendDirectoryTerminator(pathToLibDir);
        dir = dir + "*";
        return dir;
    }

    private String appendDirectoryTerminator(String pathToLibDir) {
        String dir = pathToLibDir.trim();
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        return dir;
    }

    public Collection<String> splitClasspath(String localpath) {
        String separator = System.getProperty("path.separator");
        return StringUtils.getStringCollection((String)localpath, (String)separator);
    }

    public Collection<String> localJVMClasspath() {
        return this.splitClasspath(System.getProperty("java.class.path"));
    }
}

