/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.kafka.clients.consumer.internals.TimedRequestState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;

public class TopicMetadataRequestManager
implements RequestManager {
    private final Time time;
    private final boolean allowAutoTopicCreation;
    private final List<TopicMetadataRequestState> inflightRequests;
    private final long retryBackoffMs;
    private final long retryBackoffMaxMs;
    private final Logger log;
    private final LogContext logContext;

    public TopicMetadataRequestManager(LogContext context, Time time, ConsumerConfig config) {
        this.logContext = context;
        this.log = this.logContext.logger(this.getClass());
        this.time = time;
        this.inflightRequests = new LinkedList<TopicMetadataRequestState>();
        this.retryBackoffMs = config.getLong("retry.backoff.ms");
        this.retryBackoffMaxMs = config.getLong("retry.backoff.max.ms");
        this.allowAutoTopicCreation = config.getBoolean("allow.auto.create.topics");
    }

    @Override
    public NetworkClientDelegate.PollResult poll(long currentTimeMs) {
        List<TopicMetadataRequestState> expiredRequests = this.inflightRequests.stream().filter(TimedRequestState::isExpired).collect(Collectors.toList());
        expiredRequests.forEach(rec$ -> ((TopicMetadataRequestState)rec$).expire());
        List<NetworkClientDelegate.UnsentRequest> requests = this.inflightRequests.stream().map(req -> ((TopicMetadataRequestState)req).send(currentTimeMs)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return requests.isEmpty() ? NetworkClientDelegate.PollResult.EMPTY : new NetworkClientDelegate.PollResult(0L, requests);
    }

    public CompletableFuture<Map<String, List<PartitionInfo>>> requestAllTopicsMetadata(long deadlineMs) {
        TopicMetadataRequestState newRequest = new TopicMetadataRequestState(this.logContext, deadlineMs, this.retryBackoffMs, this.retryBackoffMaxMs);
        this.inflightRequests.add(newRequest);
        return newRequest.future;
    }

    public CompletableFuture<Map<String, List<PartitionInfo>>> requestTopicMetadata(String topic, long deadlineMs) {
        TopicMetadataRequestState newRequest = new TopicMetadataRequestState(this.logContext, topic, deadlineMs, this.retryBackoffMs, this.retryBackoffMaxMs);
        this.inflightRequests.add(newRequest);
        return newRequest.future;
    }

    List<TopicMetadataRequestState> inflightRequests() {
        return this.inflightRequests;
    }

    class TopicMetadataRequestState
    extends TimedRequestState {
        private final String topic;
        private final boolean allTopics;
        CompletableFuture<Map<String, List<PartitionInfo>>> future;

        public TopicMetadataRequestState(LogContext logContext, long deadlineMs, long retryBackoffMs, long retryBackoffMaxMs) {
            super(logContext, TopicMetadataRequestState.class.getSimpleName(), retryBackoffMs, retryBackoffMaxMs, TopicMetadataRequestState.deadlineTimer(TopicMetadataRequestManager.this.time, deadlineMs));
            this.future = new CompletableFuture();
            this.topic = null;
            this.allTopics = true;
        }

        public TopicMetadataRequestState(LogContext logContext, String topic, long deadlineMs, long retryBackoffMs, long retryBackoffMaxMs) {
            super(logContext, TopicMetadataRequestState.class.getSimpleName(), retryBackoffMs, retryBackoffMaxMs, TopicMetadataRequestState.deadlineTimer(TopicMetadataRequestManager.this.time, deadlineMs));
            this.future = new CompletableFuture();
            this.topic = topic;
            this.allTopics = false;
        }

        private Optional<NetworkClientDelegate.UnsentRequest> send(long currentTimeMs) {
            if (!this.canSendRequest(currentTimeMs)) {
                return Optional.empty();
            }
            this.onSendAttempt(currentTimeMs);
            MetadataRequest.Builder request = this.allTopics ? MetadataRequest.Builder.allTopics() : new MetadataRequest.Builder(Collections.singletonList(this.topic), TopicMetadataRequestManager.this.allowAutoTopicCreation);
            return Optional.of(this.createUnsentRequest(request));
        }

        private void expire() {
            this.completeFutureAndRemoveRequest(new TimeoutException("Timeout expired while fetching topic metadata"));
        }

        private NetworkClientDelegate.UnsentRequest createUnsentRequest(MetadataRequest.Builder request) {
            NetworkClientDelegate.UnsentRequest unsent = new NetworkClientDelegate.UnsentRequest(request, Optional.empty());
            return unsent.whenComplete((response, exception) -> {
                if (response == null) {
                    this.handleError((Throwable)exception, unsent.handler().completionTimeMs());
                } else {
                    this.handleResponse((ClientResponse)response);
                }
            });
        }

        private void handleError(Throwable exception, long completionTimeMs) {
            if (exception instanceof RetriableException) {
                if (this.isExpired()) {
                    this.completeFutureAndRemoveRequest(new TimeoutException("Timeout expired while fetching topic metadata"));
                } else {
                    this.onFailedAttempt(completionTimeMs);
                }
            } else {
                this.completeFutureAndRemoveRequest(exception);
            }
        }

        private void handleResponse(ClientResponse response) {
            try {
                Map<String, List<PartitionInfo>> res = this.handleTopicMetadataResponse((MetadataResponse)response.responseBody());
                this.future.complete(res);
                TopicMetadataRequestManager.this.inflightRequests.remove(this);
            }
            catch (Exception e) {
                this.handleError(e, response.receivedTimeMs());
            }
        }

        private void completeFutureAndRemoveRequest(Throwable throwable) {
            this.future.completeExceptionally(throwable);
            TopicMetadataRequestManager.this.inflightRequests.remove(this);
        }

        private Map<String, List<PartitionInfo>> handleTopicMetadataResponse(MetadataResponse response) {
            Cluster cluster = response.buildCluster();
            Set<String> unauthorizedTopics = cluster.unauthorizedTopics();
            if (!unauthorizedTopics.isEmpty()) {
                throw new TopicAuthorizationException(unauthorizedTopics);
            }
            Map<String, Errors> errors = response.errors();
            if (!errors.isEmpty()) {
                TopicMetadataRequestManager.this.log.debug("Topic metadata fetch included errors: {}", errors);
                for (Map.Entry<String, Errors> errorEntry : errors.entrySet()) {
                    String topic = errorEntry.getKey();
                    Errors error = errorEntry.getValue();
                    if (error == Errors.INVALID_TOPIC_EXCEPTION) {
                        throw new InvalidTopicException("Topic '" + topic + "' is invalid");
                    }
                    if (error == Errors.UNKNOWN_TOPIC_OR_PARTITION) continue;
                    if (error.exception() instanceof RetriableException) {
                        throw error.exception();
                    }
                    throw new KafkaException("Unexpected error fetching metadata for topic " + topic, error.exception());
                }
            }
            HashMap<String, List<PartitionInfo>> topicsPartitionInfos = new HashMap<String, List<PartitionInfo>>();
            for (String topic : cluster.topics()) {
                topicsPartitionInfos.put(topic, cluster.partitionsForTopic(topic));
            }
            return topicsPartitionInfos;
        }

        public String topic() {
            return this.topic;
        }
    }
}

