/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.ojalgo.access.IntIndex;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Variable;

public abstract class Presolvers {
    public static final ExpressionsBasedModel.Presolver OPPOSITE_SIGN = new ExpressionsBasedModel.Presolver(20){

        @Override
        public boolean simplify(Expression expression, Set<IntIndex> fixedVariables) {
            boolean tmpValid;
            Variable tmpFreeVariable;
            BigDecimal tmpCompUppLim;
            boolean tmpDidFixVariable = false;
            ExpressionsBasedModel tmpModel = expression.getModel();
            BigDecimal tmpFixedValue = expression.calculateFixedValue(fixedVariables);
            BigDecimal tmpCompLowLim = expression.getLowerLimit();
            if (tmpCompLowLim != null && tmpFixedValue.signum() != 0) {
                tmpCompLowLim = tmpCompLowLim.subtract(tmpFixedValue);
            }
            if ((tmpCompUppLim = expression.getUpperLimit()) != null && tmpFixedValue.signum() != 0) {
                tmpCompUppLim = tmpCompUppLim.subtract(tmpFixedValue);
            }
            if (tmpCompLowLim != null && tmpCompLowLim.signum() >= 0 && expression.isNegative(fixedVariables)) {
                if (tmpCompLowLim.signum() == 0) {
                    for (IntIndex tmpLinear : expression.getLinearKeySet()) {
                        if (fixedVariables.contains(tmpLinear)) continue;
                        tmpFreeVariable = tmpModel.getVariable(tmpLinear.index);
                        tmpValid = tmpFreeVariable.validate(BigMath.ZERO, tmpModel.options.slack, tmpModel.options.debug_appender);
                        expression.setInfeasible(!tmpValid);
                        if (!tmpValid) continue;
                        tmpFreeVariable.level(BigMath.ZERO);
                        tmpFreeVariable.setValue(BigMath.ZERO);
                        tmpDidFixVariable = true;
                    }
                    expression.setRedundant(true);
                } else {
                    expression.setInfeasible(true);
                }
            }
            if (tmpCompUppLim != null && tmpCompUppLim.signum() <= 0 && expression.isPositive(fixedVariables)) {
                if (tmpCompUppLim.signum() == 0) {
                    for (IntIndex tmpLinear : expression.getLinearKeySet()) {
                        if (fixedVariables.contains(tmpLinear)) continue;
                        tmpFreeVariable = tmpModel.getVariable(tmpLinear.index);
                        tmpValid = tmpFreeVariable.validate(BigMath.ZERO, tmpModel.options.slack, tmpModel.options.debug_appender);
                        expression.setInfeasible(!tmpValid);
                        if (!tmpValid) continue;
                        tmpFreeVariable.level(BigMath.ZERO);
                        tmpFreeVariable.setValue(BigMath.ZERO);
                        tmpDidFixVariable = true;
                    }
                    expression.setRedundant(true);
                } else {
                    expression.setInfeasible(true);
                }
            }
            return tmpDidFixVariable;
        }
    };
    public static final ExpressionsBasedModel.Presolver ZERO_ONE_TWO = new ExpressionsBasedModel.Presolver(10){

        @Override
        public boolean simplify(Expression expression, Set<IntIndex> fixedVariables) {
            boolean tmpDidFixVariable = false;
            if (expression.countLinearFactors() <= fixedVariables.size() + 2) {
                BigDecimal tmpFixedValue = expression.calculateFixedValue(fixedVariables);
                HashSet<IntIndex> tmpRemainingLinear = new HashSet<IntIndex>(expression.getLinearKeySet());
                tmpRemainingLinear.removeAll(fixedVariables);
                switch (tmpRemainingLinear.size()) {
                    case 0: {
                        tmpDidFixVariable = Presolvers.doCase0(expression, tmpFixedValue, tmpRemainingLinear);
                        break;
                    }
                    case 1: {
                        tmpDidFixVariable = Presolvers.doCase1(expression, tmpFixedValue, tmpRemainingLinear);
                        break;
                    }
                    case 2: {
                        tmpDidFixVariable = Presolvers.doCase2(expression, tmpFixedValue, tmpRemainingLinear);
                        break;
                    }
                }
            }
            return tmpDidFixVariable;
        }
    };

    static boolean doCase0(Expression expression, BigDecimal fixedValue, HashSet<IntIndex> remaining) {
        expression.setRedundant(true);
        ExpressionsBasedModel tmpModel = expression.getModel();
        boolean tmpValid = expression.validate(fixedValue, tmpModel.options.slack, tmpModel.options.debug_appender);
        if (tmpValid) {
            expression.setInfeasible(false);
            expression.level(fixedValue);
        } else {
            expression.setInfeasible(true);
        }
        return false;
    }

    static boolean doCase1(Expression expression, BigDecimal fixedValue, HashSet<IntIndex> remaining) {
        ExpressionsBasedModel tmpModel = expression.getModel();
        IntIndex tmpIndex = remaining.iterator().next();
        Variable tmpVariable = tmpModel.getVariable(tmpIndex.index);
        BigDecimal tmpFactor = expression.get(tmpIndex);
        if (expression.isEqualityConstraint()) {
            BigDecimal tmpCompensatedLevel = BigFunction.SUBTRACT.invoke(expression.getUpperLimit(), fixedValue);
            BigDecimal tmpSolutionValue = BigFunction.DIVIDE.invoke(tmpCompensatedLevel, tmpFactor);
            expression.setRedundant(true);
            boolean tmpValid = tmpVariable.validate(tmpSolutionValue, tmpModel.options.slack, tmpModel.options.debug_appender);
            if (tmpValid) {
                expression.setInfeasible(false);
                tmpVariable.level(tmpSolutionValue);
            } else {
                expression.setInfeasible(true);
            }
        } else {
            BigDecimal tmpUpperSolution;
            BigDecimal tmpLowerLimit = expression.getLowerLimit();
            BigDecimal tmpUpperLimit = expression.getUpperLimit();
            BigDecimal tmpCompensatedLower = tmpLowerLimit != null ? BigFunction.SUBTRACT.invoke(tmpLowerLimit, fixedValue) : tmpLowerLimit;
            BigDecimal tmpCompensatedUpper = tmpUpperLimit != null ? BigFunction.SUBTRACT.invoke(tmpUpperLimit, fixedValue) : tmpUpperLimit;
            BigDecimal tmpLowerSolution = tmpCompensatedLower != null ? BigFunction.DIVIDE.invoke(tmpCompensatedLower, tmpFactor) : tmpCompensatedLower;
            BigDecimal bigDecimal = tmpUpperSolution = tmpCompensatedUpper != null ? BigFunction.DIVIDE.invoke(tmpCompensatedUpper, tmpFactor) : tmpCompensatedUpper;
            if (tmpFactor.signum() < 0) {
                BigDecimal tmpVal = tmpLowerSolution;
                tmpLowerSolution = tmpUpperSolution;
                tmpUpperSolution = tmpVal;
            }
            BigDecimal tmpOldLower = tmpVariable.getLowerLimit();
            BigDecimal tmpOldUpper = tmpVariable.getUpperLimit();
            BigDecimal tmpNewLower = tmpOldLower;
            if (tmpLowerSolution != null) {
                tmpNewLower = tmpOldLower != null ? tmpOldLower.max(tmpLowerSolution) : tmpLowerSolution;
            }
            BigDecimal tmpNewUpper = tmpOldUpper;
            if (tmpUpperSolution != null) {
                tmpNewUpper = tmpOldUpper != null ? tmpOldUpper.min(tmpUpperSolution) : tmpUpperSolution;
            }
            if (tmpVariable.isInteger()) {
                if (tmpNewLower != null) {
                    tmpNewLower = tmpNewLower.setScale(0, RoundingMode.CEILING);
                }
                if (tmpNewUpper != null) {
                    tmpNewUpper = tmpNewUpper.setScale(0, RoundingMode.FLOOR);
                }
            }
            ((Variable)tmpVariable.lower(tmpNewLower)).upper(tmpNewUpper);
            expression.setRedundant(true);
            boolean tmpInfeasible = tmpNewLower != null && tmpNewUpper != null && tmpNewLower.compareTo(tmpNewUpper) > 0;
            expression.setInfeasible(tmpInfeasible);
        }
        if (tmpVariable.isEqualityConstraint()) {
            tmpVariable.setValue(tmpVariable.getLowerLimit());
            return true;
        }
        return false;
    }

    static boolean doCase2(Expression expression, BigDecimal fixedValue, HashSet<IntIndex> remaining) {
        BigDecimal tmpNewLimit;
        BigDecimal tmpUpperLimit;
        ExpressionsBasedModel tmpModel = expression.getModel();
        Iterator<IntIndex> tmpIterator = remaining.iterator();
        IntIndex tmpIndexA = tmpIterator.next();
        Variable tmpVariableA = tmpModel.getVariable(tmpIndexA.index);
        BigDecimal tmpFactorA = expression.get(tmpIndexA);
        BigDecimal tmpLowerA = tmpVariableA.getLowerLimit();
        BigDecimal tmpUpperA = tmpVariableA.getUpperLimit();
        IntIndex tmpIndexB = tmpIterator.next();
        Variable tmpVariableB = tmpModel.getVariable(tmpIndexB.index);
        BigDecimal tmpFactorB = expression.get(tmpIndexB);
        BigDecimal tmpLowerB = tmpVariableB.getLowerLimit();
        BigDecimal tmpUpperB = tmpVariableB.getUpperLimit();
        BigDecimal tmpLowerLimit = expression.getLowerLimit() != null ? BigFunction.SUBTRACT.invoke(expression.getLowerLimit(), fixedValue) : expression.getLowerLimit();
        BigDecimal bigDecimal = tmpUpperLimit = expression.getUpperLimit() != null ? BigFunction.SUBTRACT.invoke(expression.getUpperLimit(), fixedValue) : expression.getUpperLimit();
        if (tmpLowerLimit != null) {
            BigDecimal tmpOtherUpperB;
            BigDecimal tmpOtherUpperA = tmpFactorB.signum() == 1 ? tmpVariableB.getUpperLimit() : tmpVariableB.getLowerLimit();
            BigDecimal bigDecimal2 = tmpOtherUpperB = tmpFactorA.signum() == 1 ? tmpVariableA.getUpperLimit() : tmpVariableA.getLowerLimit();
            if (tmpOtherUpperA != null) {
                tmpNewLimit = BigFunction.DIVIDE.invoke(tmpLowerLimit.subtract(tmpFactorB.multiply(tmpOtherUpperA)), tmpFactorA);
                if (tmpFactorA.signum() == 1) {
                    tmpLowerA = tmpLowerA != null ? tmpLowerA.max(tmpNewLimit) : tmpNewLimit;
                } else {
                    BigDecimal bigDecimal3 = tmpUpperA = tmpUpperA != null ? tmpUpperA.min(tmpNewLimit) : tmpNewLimit;
                }
            }
            if (tmpOtherUpperB != null) {
                tmpNewLimit = BigFunction.DIVIDE.invoke(tmpLowerLimit.subtract(tmpFactorA.multiply(tmpOtherUpperB)), tmpFactorB);
                if (tmpFactorB.signum() == 1) {
                    tmpLowerB = tmpLowerB != null ? tmpLowerB.max(tmpNewLimit) : tmpNewLimit;
                } else {
                    BigDecimal bigDecimal4 = tmpUpperB = tmpUpperB != null ? tmpUpperB.min(tmpNewLimit) : tmpNewLimit;
                }
            }
        }
        if (tmpUpperLimit != null) {
            BigDecimal tmpOtherLowerB;
            BigDecimal tmpOtherLowerA = tmpFactorB.signum() == 1 ? tmpVariableB.getLowerLimit() : tmpVariableB.getUpperLimit();
            BigDecimal bigDecimal5 = tmpOtherLowerB = tmpFactorA.signum() == 1 ? tmpVariableA.getLowerLimit() : tmpVariableA.getUpperLimit();
            if (tmpOtherLowerA != null) {
                tmpNewLimit = BigFunction.DIVIDE.invoke(tmpUpperLimit.subtract(tmpFactorB.multiply(tmpOtherLowerA)), tmpFactorA);
                if (tmpFactorA.signum() == 1) {
                    tmpUpperA = tmpUpperA != null ? tmpUpperA.min(tmpNewLimit) : tmpNewLimit;
                } else {
                    BigDecimal bigDecimal6 = tmpLowerA = tmpLowerA != null ? tmpLowerA.max(tmpNewLimit) : tmpNewLimit;
                }
            }
            if (tmpOtherLowerB != null) {
                tmpNewLimit = BigFunction.DIVIDE.invoke(tmpUpperLimit.subtract(tmpFactorA.multiply(tmpOtherLowerB)), tmpFactorB);
                if (tmpFactorB.signum() == 1) {
                    tmpUpperB = tmpUpperB != null ? tmpUpperB.min(tmpNewLimit) : tmpNewLimit;
                } else {
                    BigDecimal bigDecimal7 = tmpLowerB = tmpLowerB != null ? tmpLowerB.max(tmpNewLimit) : tmpNewLimit;
                }
            }
        }
        if (tmpVariableA.isInteger()) {
            if (tmpLowerA != null) {
                tmpLowerA = tmpLowerA.setScale(0, RoundingMode.CEILING);
            }
            if (tmpUpperA != null) {
                tmpUpperA = tmpUpperA.setScale(0, RoundingMode.FLOOR);
            }
        }
        if (tmpVariableB.isInteger()) {
            if (tmpLowerB != null) {
                tmpLowerB = tmpLowerB.setScale(0, RoundingMode.CEILING);
            }
            if (tmpUpperB != null) {
                tmpUpperB = tmpUpperB.setScale(0, RoundingMode.FLOOR);
            }
        }
        ((Variable)tmpVariableA.lower(tmpLowerA)).upper(tmpUpperA);
        ((Variable)tmpVariableB.lower(tmpLowerB)).upper(tmpUpperB);
        return tmpVariableA.isEqualityConstraint() || tmpVariableB.isEqualityConstraint();
    }
}

