/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.metrics.OpportunisticSchedulerMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMCriticalThreadUncaughtExceptionHandler;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingMonitorManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerNMDoneChangeResourceEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerRecoverEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeFinishedContainersPulledByAMEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeResourceUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ClusterNodeTracker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeFilter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerHealth;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ReleaseContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerContext;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class AbstractYarnScheduler<T extends SchedulerApplicationAttempt, N extends SchedulerNode>
extends AbstractService
implements ResourceScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractYarnScheduler.class);
    private static final Resource ZERO_RESOURCE = Resource.newInstance((int)0, (int)0);
    protected final ClusterNodeTracker<N> nodeTracker = new ClusterNodeTracker();
    protected Resource minimumAllocation;
    protected volatile RMContext rmContext;
    private volatile Priority maxClusterLevelAppPriority;
    protected ActivitiesManager activitiesManager;
    protected SchedulerHealth schedulerHealth = new SchedulerHealth();
    protected volatile long lastNodeUpdateTime;
    protected final long THREAD_JOIN_TIMEOUT_MS = 1000L;
    private volatile Clock clock;
    protected long updateInterval = -1L;
    @VisibleForTesting
    Thread updateThread;
    private final Object updateThreadMonitor = new Object();
    private Timer releaseCache;
    protected ConcurrentMap<ApplicationId, SchedulerApplication<T>> applications;
    protected int nmExpireInterval;
    protected long nmHeartbeatInterval;
    private long skipNodeInterval;
    private static final List<Container> EMPTY_CONTAINER_LIST = new ArrayList<Container>();
    protected static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource((int)0), null, null, null);
    protected final ReentrantReadWriteLock.ReadLock readLock;
    protected final ReentrantReadWriteLock.WriteLock writeLock;
    private boolean autoUpdateContainers = false;
    protected SchedulingMonitorManager schedulingMonitorManager = new SchedulingMonitorManager();
    private boolean migration;

    public AbstractYarnScheduler(String name) {
        super(name);
        this.clock = SystemClock.getInstance();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.migration = conf.getBoolean("yarn.scheduler.fair.migration.mode", false);
        this.nmExpireInterval = conf.getInt("yarn.nm.liveness-monitor.expiry-interval-ms", 600000);
        this.nmHeartbeatInterval = conf.getLong("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 1000L);
        this.skipNodeInterval = YarnConfiguration.getSkipNodeInterval((Configuration)conf);
        long configuredMaximumAllocationWaitTime = conf.getLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 10000L);
        this.nodeTracker.setConfiguredMaxAllocationWaitTime(configuredMaximumAllocationWaitTime);
        this.maxClusterLevelAppPriority = this.getMaxPriorityFromConf(conf);
        if (!this.migration) {
            this.releaseCache = new Timer("Pending Container Clear Timer");
        }
        this.autoUpdateContainers = conf.getBoolean("yarn.resourcemanager.auto-update.containers", false);
        if (this.updateInterval > 0L) {
            this.updateThread = new UpdateThread();
            this.updateThread.setName("SchedulerUpdateThread");
            this.updateThread.setUncaughtExceptionHandler(new RMCriticalThreadUncaughtExceptionHandler(this.rmContext));
            this.updateThread.setDaemon(true);
        }
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        if (!this.migration) {
            if (this.updateThread != null) {
                this.updateThread.start();
            }
            this.schedulingMonitorManager.startAll();
            this.createReleaseCache();
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.updateThread != null) {
            this.updateThread.interrupt();
            this.updateThread.join(1000L);
        }
        if (this.releaseCache != null) {
            this.releaseCache.cancel();
            this.releaseCache = null;
        }
        this.schedulingMonitorManager.stop();
        super.serviceStop();
    }

    @VisibleForTesting
    public ClusterNodeTracker<N> getNodeTracker() {
        return this.nodeTracker;
    }

    @VisibleForTesting
    public SchedulingMonitorManager getSchedulingMonitorManager() {
        return this.schedulingMonitorManager;
    }

    @Override
    public List<Container> getTransferredContainers(ApplicationAttemptId currentAttempt) {
        ApplicationId appId = currentAttempt.getApplicationId();
        SchedulerApplication app = (SchedulerApplication)this.applications.get(appId);
        ArrayList<Container> containerList = new ArrayList<Container>();
        if (app == null) {
            return containerList;
        }
        List<RMContainer> liveContainers = ((SchedulerApplicationAttempt)app.getCurrentAppAttempt()).pullContainersToTransfer();
        ContainerId amContainerId = null;
        if (((RMApp)this.rmContext.getRMApps().get(appId)).getCurrentAppAttempt().getMasterContainer() != null) {
            amContainerId = ((RMApp)this.rmContext.getRMApps().get(appId)).getCurrentAppAttempt().getMasterContainer().getId();
        }
        for (RMContainer rmContainer : liveContainers) {
            if (rmContainer.getContainerId().equals((Object)amContainerId)) continue;
            containerList.add(rmContainer.getContainer());
        }
        return containerList;
    }

    public Map<ApplicationId, SchedulerApplication<T>> getSchedulerApplications() {
        return this.applications;
    }

    public List<N> getBlacklistedNodes(final SchedulerApplicationAttempt app) {
        NodeFilter nodeFilter = new NodeFilter(){

            @Override
            public boolean accept(SchedulerNode node) {
                return SchedulerAppUtils.isPlaceBlacklisted(app, node, LOG);
            }
        };
        return this.nodeTracker.getNodes(nodeFilter);
    }

    public List<N> getNodes(NodeFilter filter) {
        return this.nodeTracker.getNodes(filter);
    }

    public boolean shouldContainersBeAutoUpdated() {
        return this.autoUpdateContainers;
    }

    @Override
    public Resource getClusterResource() {
        return this.nodeTracker.getClusterCapacity();
    }

    @Override
    public Resource getMinimumResourceCapability() {
        return this.minimumAllocation;
    }

    @Override
    public Resource getMaximumResourceCapability() {
        return this.nodeTracker.getMaxAllowedAllocation();
    }

    @Override
    public Resource getMaximumResourceCapability(String queueName) {
        return this.getMaximumResourceCapability();
    }

    protected void initMaximumResourceCapability(Resource maximumAllocation) {
        this.nodeTracker.setConfiguredMaxAllocation(maximumAllocation);
    }

    public SchedulerHealth getSchedulerHealth() {
        return this.schedulerHealth;
    }

    protected void setLastNodeUpdateTime(long time) {
        this.lastNodeUpdateTime = time;
    }

    public long getLastNodeUpdateTime() {
        return this.lastNodeUpdateTime;
    }

    public long getSkipNodeInterval() {
        return this.skipNodeInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void containerLaunchedOnNode(ContainerId containerId, SchedulerNode node) {
        this.readLock.lock();
        try {
            T application = this.getCurrentAttemptForContainer(containerId);
            if (application == null) {
                LOG.info("Unknown application " + containerId.getApplicationAttemptId().getApplicationId() + " launched container " + containerId + " on node: " + node);
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), containerId));
                return;
            }
            ((SchedulerApplicationAttempt)application).containerLaunchedOnNode(containerId, node.getNodeID());
            node.containerStarted(containerId);
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void containerIncreasedOnNode(ContainerId containerId, SchedulerNode node, Container increasedContainerReportedByNM) {
        T application = this.getCurrentAttemptForContainer(containerId);
        if (application == null) {
            LOG.info("Unknown application " + containerId.getApplicationAttemptId().getApplicationId() + " increased container " + containerId + " on node: " + node);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), containerId));
            return;
        }
        RMContainer rmContainer = this.getRMContainer(containerId);
        if (rmContainer == null) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), containerId));
            return;
        }
        rmContainer.handle((Event)new RMContainerNMDoneChangeResourceEvent(containerId, increasedContainerReportedByNM.getResource()));
    }

    public T getApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
        SchedulerApplication app = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        return app == null ? null : (T)app.getCurrentAppAttempt();
    }

    @Override
    public SchedulerAppReport getSchedulerAppInfo(ApplicationAttemptId appAttemptId) {
        T attempt = this.getApplicationAttempt(appAttemptId);
        if (attempt == null) {
            LOG.debug("Request for appInfo of unknown attempt {}", (Object)appAttemptId);
            return null;
        }
        return new SchedulerAppReport((SchedulerApplicationAttempt)attempt);
    }

    @Override
    public ApplicationResourceUsageReport getAppResourceUsageReport(ApplicationAttemptId appAttemptId) {
        T attempt = this.getApplicationAttempt(appAttemptId);
        if (attempt == null) {
            LOG.debug("Request for appInfo of unknown attempt {}", (Object)appAttemptId);
            return null;
        }
        return ((SchedulerApplicationAttempt)attempt).getResourceUsageReport();
    }

    public T getCurrentAttemptForContainer(ContainerId containerId) {
        return this.getApplicationAttempt(containerId.getApplicationAttemptId());
    }

    @Override
    public RMContainer getRMContainer(ContainerId containerId) {
        T attempt = this.getCurrentAttemptForContainer(containerId);
        return attempt == null ? null : ((SchedulerApplicationAttempt)attempt).getRMContainer(containerId);
    }

    @Override
    public SchedulerNodeReport getNodeReport(NodeId nodeId) {
        return this.nodeTracker.getNodeReport(nodeId);
    }

    @Override
    public String moveApplication(ApplicationId appId, String newQueue) throws YarnException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support moving apps between queues");
    }

    @Override
    public void preValidateMoveApplication(ApplicationId appId, String newQueue) throws YarnException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support pre-validation of moving apps between queues");
    }

    @Override
    public void removeQueue(String queueName) throws YarnException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support removing queues");
    }

    @Override
    public void addQueue(Queue newQueue) throws YarnException, IOException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support this operation");
    }

    @Override
    public void setEntitlement(String queue, QueueEntitlement entitlement) throws YarnException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support this operation");
    }

    private void killOrphanContainerOnNode(RMNode node, NMContainerStatus container) {
        if (!container.getContainerState().equals((Object)ContainerState.COMPLETE)) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), container.getContainerId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverContainersOnNode(List<NMContainerStatus> containerReports, RMNode nm) {
        this.writeLock.lock();
        try {
            if (!this.rmContext.isWorkPreservingRecoveryEnabled() || containerReports == null || containerReports != null && containerReports.isEmpty()) {
                return;
            }
            for (NMContainerStatus container : containerReports) {
                Container masterContainer;
                RMAppAttempt appAttempt;
                ApplicationId appId = container.getContainerId().getApplicationAttemptId().getApplicationId();
                RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appId);
                if (rmApp == null) {
                    LOG.error("Skip recovering container " + container + " for unknown application.");
                    this.killOrphanContainerOnNode(nm, container);
                    continue;
                }
                SchedulerApplication schedulerApp = (SchedulerApplication)this.applications.get(appId);
                if (schedulerApp == null) {
                    LOG.info("Skip recovering container  " + container + " for unknown SchedulerApplication. Application current state is " + (Object)((Object)rmApp.getState()));
                    this.killOrphanContainerOnNode(nm, container);
                    continue;
                }
                LOG.info("Recovering container " + container);
                Object schedulerAttempt = schedulerApp.getCurrentAppAttempt();
                if (!(rmApp.getApplicationSubmissionContext().getKeepContainersAcrossApplicationAttempts() || !((SchedulerApplicationAttempt)schedulerAttempt).isStopped() && ((SchedulerApplicationAttempt)schedulerAttempt).getApplicationAttemptId().equals((Object)container.getContainerId().getApplicationAttemptId()))) {
                    LOG.info("Skip recovering container " + container + " for already stopped attempt.");
                    this.killOrphanContainerOnNode(nm, container);
                    continue;
                }
                Queue queue = schedulerApp.getQueue();
                String queueName = queue instanceof CSQueue ? ((CSQueue)queue).getQueuePath() : queue.getQueueName();
                RMContainer rmContainer = this.recoverAndCreateContainer(container, nm, queueName);
                rmContainer.handle((Event)new RMContainerRecoverEvent(container.getContainerId(), container));
                N schedulerNode = this.nodeTracker.getNode(nm.getNodeID());
                ((SchedulerNode)schedulerNode).recoverContainer(rmContainer);
                Queue queueToRecover = ((SchedulerApplicationAttempt)schedulerAttempt).getQueue();
                queueToRecover.recoverContainer(this.getClusterResource(), (SchedulerApplicationAttempt)schedulerAttempt, rmContainer);
                boolean recovered = ((SchedulerApplicationAttempt)schedulerAttempt).recoverContainer((SchedulerNode)schedulerNode, rmContainer);
                if (recovered && rmContainer.getExecutionType() == ExecutionType.OPPORTUNISTIC) {
                    OpportunisticSchedulerMetrics.getMetrics().incrAllocatedOppContainers(1);
                }
                if ((appAttempt = rmApp.getCurrentAppAttempt()) != null && (masterContainer = appAttempt.getMasterContainer()) != null && masterContainer.getId().equals((Object)rmContainer.getContainerId())) {
                    ((RMContainerImpl)rmContainer).setAMContainer(true);
                }
                if (!((SchedulerApplicationAttempt)schedulerAttempt).getPendingRelease().remove(container.getContainerId())) continue;
                rmContainer.handle((Event)new RMContainerFinishedEvent(container.getContainerId(), SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released by application"), RMContainerEventType.RELEASED));
                LOG.info(container.getContainerId() + " is released by application.");
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private RMContainer recoverAndCreateContainer(NMContainerStatus status, RMNode node, String queueName) {
        Container container = Container.newInstance((ContainerId)status.getContainerId(), (NodeId)node.getNodeID(), (String)node.getHttpAddress(), (Resource)status.getAllocatedResource(), (Priority)status.getPriority(), null);
        container.setVersion(status.getVersion());
        container.setExecutionType(status.getExecutionType());
        container.setAllocationRequestId(status.getAllocationRequestId());
        container.setAllocationTags(status.getAllocationTags());
        ApplicationAttemptId attemptId = container.getId().getApplicationAttemptId();
        RMContainerImpl rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), attemptId, node.getNodeID(), ((SchedulerApplication)this.applications.get(attemptId.getApplicationId())).getUser(), this.rmContext, status.getCreationTime(), status.getNodeLabelExpression());
        rmContainer.setQueueName(queueName);
        return rmContainer;
    }

    private void recoverResourceRequestForContainer(RMContainer rmContainer) {
        ContainerRequest containerRequest = rmContainer.getContainerRequest();
        if (containerRequest == null) {
            return;
        }
        T schedulerAttempt = this.getCurrentAttemptForContainer(rmContainer.getContainerId());
        if (schedulerAttempt != null) {
            ((SchedulerApplicationAttempt)schedulerAttempt).recoverResourceRequestsForContainer(containerRequest);
        }
    }

    protected void createReleaseCache() {
        this.releaseCache.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractYarnScheduler.this.clearPendingContainerCache();
                LOG.info("Release request cache is cleaned up");
            }
        }, this.nmExpireInterval);
    }

    @VisibleForTesting
    public void clearPendingContainerCache() {
        for (SchedulerApplication app : this.applications.values()) {
            Object attempt = app.getCurrentAppAttempt();
            if (attempt == null) continue;
            for (ContainerId containerId : ((SchedulerApplicationAttempt)attempt).getPendingRelease()) {
                RMAuditLogger.logFailure(app.getUser(), "AM Released Container", "Unauthorized access or invalid container", "Scheduler", "Trying to release container not owned by app or with invalid id.", ((SchedulerApplicationAttempt)attempt).getApplicationId(), containerId, null);
            }
            ((SchedulerApplicationAttempt)attempt).getPendingRelease().clear();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void completedContainer(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info("Container " + containerStatus.getContainerId() + " completed with event " + (Object)((Object)event) + ", but corresponding RMContainer doesn't exist.");
            return;
        }
        if (rmContainer.getExecutionType() == ExecutionType.GUARANTEED) {
            this.completedContainerInternal(rmContainer, containerStatus, event);
            this.completeOustandingUpdatesWhichAreReserved(rmContainer, containerStatus, event);
        } else {
            ContainerId containerId = rmContainer.getContainerId();
            rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, event));
            T schedulerAttempt = this.getCurrentAttemptForContainer(containerId);
            if (schedulerAttempt != null && ((SchedulerApplicationAttempt)schedulerAttempt).removeRMContainer(containerId)) {
                OpportunisticSchedulerMetrics.getMetrics().incrReleasedOppContainers(1);
            }
            LOG.debug("Completed container: {} in state: {} event:{}", new Object[]{rmContainer.getContainerId(), rmContainer.getState(), event});
            N node = this.getSchedulerNode(rmContainer.getNodeId());
            if (node != null) {
                ((SchedulerNode)node).releaseContainer(rmContainer.getContainerId(), false);
            }
        }
        this.recoverResourceRequestForContainer(rmContainer);
    }

    private void completeOustandingUpdatesWhichAreReserved(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        ContainerId containerToUpdate;
        RMContainer resContainer;
        N schedulerNode = this.getSchedulerNode(rmContainer.getNodeId());
        if (schedulerNode != null && (resContainer = ((SchedulerNode)schedulerNode).getReservedContainer()) != null && resContainer.getReservedSchedulerKey() != null && (containerToUpdate = resContainer.getReservedSchedulerKey().getContainerToUpdate()) != null && containerToUpdate.equals((Object)containerStatus.getContainerId())) {
            this.completedContainerInternal(resContainer, ContainerStatus.newInstance((ContainerId)resContainer.getContainerId(), (ContainerState)containerStatus.getState(), (String)containerStatus.getDiagnostics(), (int)containerStatus.getExitStatus()), event);
        }
    }

    protected abstract void completedContainerInternal(RMContainer var1, ContainerStatus var2, RMContainerEventType var3);

    protected void releaseContainers(List<ContainerId> containers, SchedulerApplicationAttempt attempt) {
        for (ContainerId containerId : containers) {
            RMContainer rmContainer = this.getRMContainer(containerId);
            if (rmContainer == null) {
                if (System.currentTimeMillis() - ResourceManager.getClusterTimeStamp() < (long)this.nmExpireInterval) {
                    LOG.info(containerId + " doesn't exist. Add the container to the release request cache as it maybe on recovery.");
                    attempt.getPendingRelease().add(containerId);
                } else {
                    RMAuditLogger.logFailure(attempt.getUser(), "AM Released Container", "Unauthorized access or invalid container", "Scheduler", "Trying to release container not owned by app or with invalid id.", attempt.getApplicationId(), containerId, null);
                }
            }
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(containerId, "Container released by application"), RMContainerEventType.RELEASED);
        }
    }

    public N getSchedulerNode(NodeId nodeId) {
        return this.nodeTracker.getNode(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAllApps(String sourceQueue, String destQueue) throws YarnException {
        this.writeLock.lock();
        try {
            try {
                this.getQueueInfo(destQueue, false, false);
            }
            catch (IOException e) {
                LOG.warn(e.toString());
                throw new YarnException((Throwable)e);
            }
            for (ApplicationAttemptId appAttemptId : this.getAppsFromQueue(sourceQueue)) {
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppManagerEvent(appAttemptId.getApplicationId(), destQueue, RMAppManagerEventType.APP_MOVE));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killAllAppsInQueue(String queueName) throws YarnException {
        this.writeLock.lock();
        try {
            for (ApplicationAttemptId app : this.getAppsFromQueue(queueName)) {
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(app.getApplicationId(), RMAppEventType.KILL, "Application killed due to expiry of reservation queue " + queueName + "."));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNodeResource(RMNode nm, ResourceOption resourceOption) {
        this.writeLock.lock();
        try {
            N node = this.getSchedulerNode(nm.getNodeID());
            if (node == null) {
                LOG.info("Node: " + nm.getNodeID() + " has already been taken out of scheduling. Skip updating its resource");
                return;
            }
            Resource newResource = resourceOption.getResource();
            int timeout = resourceOption.getOverCommitTimeout();
            Resource oldResource = ((SchedulerNode)node).getTotalResource();
            if (!oldResource.equals((Object)newResource)) {
                this.rmContext.getNodeLabelManager().updateNodeResource(nm.getNodeID(), newResource);
                LOG.info("Update resource on node: {} from: {}, to: {} in {} ms", new Object[]{((SchedulerNode)node).getNodeName(), oldResource, newResource, timeout});
                this.nodeTracker.removeNode(nm.getNodeID());
                ((SchedulerNode)node).updateTotalResource(newResource);
                ((SchedulerNode)node).setOvercommitTimeOut(timeout);
                this.signalContainersIfOvercommitted((SchedulerNode)node, timeout == 0);
                this.nodeTracker.addNode(node);
            } else {
                LOG.warn("Update resource on node: " + ((SchedulerNode)node).getNodeName() + " with the same resource: " + newResource);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public EnumSet<YarnServiceProtos.SchedulerResourceTypes> getSchedulingResourceTypes() {
        return EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY);
    }

    @Override
    public Set<String> getPlanQueues() throws YarnException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support reservations");
    }

    public boolean placementConstraintEnabled() {
        return false;
    }

    protected void refreshMaximumAllocation(Resource newMaxAlloc) {
        this.nodeTracker.setConfiguredMaxAllocation(newMaxAlloc);
    }

    @Override
    public List<ResourceRequest> getPendingResourceRequestsForAttempt(ApplicationAttemptId attemptId) {
        T attempt = this.getApplicationAttempt(attemptId);
        if (attempt != null) {
            return ((SchedulerApplicationAttempt)attempt).getAppSchedulingInfo().getAllResourceRequests();
        }
        return null;
    }

    @Override
    public List<SchedulingRequest> getPendingSchedulingRequestsForAttempt(ApplicationAttemptId attemptId) {
        T attempt = this.getApplicationAttempt(attemptId);
        if (attempt != null) {
            return ((SchedulerApplicationAttempt)attempt).getAppSchedulingInfo().getAllSchedulingRequests();
        }
        return null;
    }

    @Override
    public Priority checkAndGetApplicationPriority(Priority priorityRequestedByApp, UserGroupInformation user, String queuePath, ApplicationId applicationId) throws YarnException {
        return Priority.newInstance((int)0);
    }

    @Override
    public Priority updateApplicationPriority(Priority newPriority, ApplicationId applicationId, SettableFuture<Object> future, UserGroupInformation user) throws YarnException {
        return Priority.newInstance((int)0);
    }

    @Override
    public Priority getMaxClusterLevelAppPriority() {
        return this.maxClusterLevelAppPriority;
    }

    private Priority getMaxPriorityFromConf(Configuration conf) {
        return Priority.newInstance((int)conf.getInt("yarn.cluster.max-application-priority", 0));
    }

    @Override
    public void setClusterMaxPriority(Configuration conf) throws YarnException {
        try {
            this.maxClusterLevelAppPriority = this.getMaxPriorityFromConf(conf);
        }
        catch (NumberFormatException e) {
            throw new YarnException((Throwable)e);
        }
        LOG.info("Updated the cluste max priority to maxClusterLevelAppPriority = " + this.maxClusterLevelAppPriority);
    }

    private SchedContainerChangeRequest createSchedContainerChangeRequest(UpdateContainerRequest request, boolean increase) throws YarnException {
        ContainerId containerId = request.getContainerId();
        RMContainer rmContainer = this.getRMContainer(containerId);
        if (null == rmContainer) {
            String msg = "Failed to get rmContainer for " + (increase ? "increase" : "decrease") + " request, with container-id=" + containerId;
            throw new InvalidResourceRequestException(msg);
        }
        N schedulerNode = this.getSchedulerNode(rmContainer.getAllocatedNode());
        return new SchedContainerChangeRequest(this.rmContext, (SchedulerNode)schedulerNode, rmContainer, request.getCapability());
    }

    protected List<SchedContainerChangeRequest> createSchedContainerChangeRequests(List<UpdateContainerRequest> changeRequests, boolean increase) {
        ArrayList<SchedContainerChangeRequest> schedulerChangeRequests = new ArrayList<SchedContainerChangeRequest>();
        for (UpdateContainerRequest r : changeRequests) {
            SchedContainerChangeRequest sr = null;
            try {
                sr = this.createSchedContainerChangeRequest(r, increase);
            }
            catch (YarnException e) {
                LOG.warn("Error happens when checking increase request, Ignoring.. exception=", (Throwable)e);
                continue;
            }
            schedulerChangeRequests.add(sr);
        }
        return schedulerChangeRequests;
    }

    public ActivitiesManager getActivitiesManager() {
        return this.activitiesManager;
    }

    public Clock getClock() {
        return this.clock;
    }

    @VisibleForTesting
    public void setClock(Clock clock) {
        this.clock = clock;
    }

    @Lock(value={Lock.NoLock.class})
    public SchedulerNode getNode(NodeId nodeId) {
        return this.nodeTracker.getNode(nodeId);
    }

    private List<ContainerStatus> updateNewContainerInfo(RMNode nm, SchedulerNode schedulerNode) {
        List<UpdatedContainerInfo> containerInfoList = nm.pullContainerUpdates();
        ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
        ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
        ArrayList<Map.Entry<ApplicationId, ContainerStatus>> updateExistContainers = new ArrayList<Map.Entry<ApplicationId, ContainerStatus>>();
        for (UpdatedContainerInfo containerInfo : containerInfoList) {
            newlyLaunchedContainers.addAll(containerInfo.getNewlyLaunchedContainers());
            completedContainers.addAll(containerInfo.getCompletedContainers());
            updateExistContainers.addAll(containerInfo.getUpdateContainers());
        }
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), schedulerNode);
        }
        List<Container> newlyIncreasedContainers = nm.pullNewlyIncreasedContainers();
        for (Container container : newlyIncreasedContainers) {
            this.containerIncreasedOnNode(container.getId(), schedulerNode, container);
        }
        for (Map.Entry entry : updateExistContainers) {
            String strExposedPorts;
            RMContainer rmContainer;
            SchedulerApplication app = (SchedulerApplication)this.applications.get(entry.getKey());
            ContainerId containerId = ((ContainerStatus)entry.getValue()).getContainerId();
            if (app == null || app.getCurrentAppAttempt() == null || (rmContainer = ((SchedulerApplicationAttempt)app.getCurrentAppAttempt()).getRMContainer(containerId)) == null || rmContainer.getExposedPorts() != null && rmContainer.getExposedPorts().size() > 0 || null == (strExposedPorts = ((ContainerStatus)entry.getValue()).getExposedPorts()) || strExposedPorts.isEmpty()) continue;
            Gson gson = new Gson();
            Map exposedPorts = (Map)gson.fromJson(strExposedPorts, new TypeToken<Map<String, List<Map<String, String>>>>(){}.getType());
            LOG.info("update exist container " + containerId.getContainerId() + ", strExposedPorts = " + strExposedPorts);
            rmContainer.setExposedPorts(exposedPorts);
        }
        return completedContainers;
    }

    private int updateCompletedContainers(List<ContainerStatus> completedContainers, Resource releasedResources, NodeId nodeId, SchedulerNode schedulerNode) {
        int releasedContainers = 0;
        ArrayList<ContainerId> untrackedContainerIdList = new ArrayList<ContainerId>();
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug("Container FINISHED: {}", (Object)containerId);
            RMContainer container = this.getRMContainer(containerId);
            this.completedContainer(container, completedContainer, RMContainerEventType.FINISHED);
            if (schedulerNode != null) {
                schedulerNode.releaseContainer(containerId, true);
            }
            if (container != null) {
                Resource rrs;
                ++releasedContainers;
                Resource ars = container.getAllocatedResource();
                if (ars != null) {
                    Resources.addTo((Resource)releasedResources, (Resource)ars);
                }
                if ((rrs = container.getReservedResource()) == null) continue;
                Resources.addTo((Resource)releasedResources, (Resource)rrs);
                continue;
            }
            untrackedContainerIdList.add(containerId);
        }
        if (!untrackedContainerIdList.isEmpty()) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeFinishedContainersPulledByAMEvent(nodeId, untrackedContainerIdList));
        }
        return releasedContainers;
    }

    protected void updateSchedulerHealthInformation(Resource releasedResources, int releasedContainers) {
        this.schedulerHealth.updateSchedulerReleaseDetails(this.getLastNodeUpdateTime(), releasedResources);
        this.schedulerHealth.updateSchedulerReleaseCounts(releasedContainers);
    }

    protected void updateNodeResourceUtilization(RMNode nm, SchedulerNode schedulerNode) {
        schedulerNode.setAggregatedContainersUtilization(nm.getAggregatedContainersUtilization());
        schedulerNode.setNodeUtilization(nm.getNodeUtilization());
    }

    protected void nodeUpdate(RMNode nm) {
        LOG.debug("nodeUpdate: {} cluster capacity: {}", (Object)nm, (Object)this.getClusterResource());
        SchedulerNode schedulerNode = this.getNode(nm.getNodeID());
        List<ContainerStatus> completedContainers = this.updateNewContainerInfo(nm, schedulerNode);
        if (schedulerNode != null) {
            schedulerNode.notifyNodeUpdate();
        }
        Resource releasedResources = Resource.newInstance((int)0, (int)0);
        int releasedContainers = this.updateCompletedContainers(completedContainers, releasedResources, nm.getNodeID(), schedulerNode);
        if (nm.getState() == NodeState.DECOMMISSIONING && schedulerNode != null && schedulerNode.getTotalResource().compareTo(schedulerNode.getAllocatedResource()) != 0) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeResourceUpdateEvent(nm.getNodeID(), ResourceOption.newInstance((Resource)schedulerNode.getAllocatedResource(), (int)0)));
        }
        this.updateSchedulerHealthInformation(releasedResources, releasedContainers);
        if (schedulerNode != null) {
            this.updateNodeResourceUtilization(nm, schedulerNode);
        }
        if (schedulerNode != null) {
            this.signalContainersIfOvercommitted(schedulerNode, true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node being looked for scheduling " + nm + " availableResource: " + (schedulerNode == null ? "unknown (decommissioned)" : schedulerNode.getUnallocatedResource()));
        }
    }

    private void signalContainersIfOvercommitted(SchedulerNode schedulerNode, boolean kill) {
        Resource unallocated;
        ResourceCalculator rc;
        if (!schedulerNode.isOvercommitTimeOutSet()) {
            return;
        }
        SchedulerEventType eventType = SchedulerEventType.MARK_CONTAINER_FOR_PREEMPTION;
        if (kill) {
            eventType = SchedulerEventType.MARK_CONTAINER_FOR_KILLABLE;
            if (!schedulerNode.isOvercommitTimedOut()) {
                return;
            }
        }
        if (Resources.fitsIn((ResourceCalculator)(rc = this.getResourceCalculator()), (Resource)ZERO_RESOURCE, (Resource)(unallocated = Resource.newInstance((Resource)schedulerNode.getUnallocatedResource())))) {
            return;
        }
        LOG.info("{} is overcommitted ({}), preempt/kill containers", (Object)schedulerNode.getNodeID(), (Object)unallocated);
        for (RMContainer container : schedulerNode.getContainersToKill()) {
            LOG.info("Send {} to {} to free up {}", new Object[]{eventType, container.getContainerId(), container.getAllocatedResource()});
            ApplicationAttemptId appId = container.getApplicationAttemptId();
            ContainerPreemptEvent event = new ContainerPreemptEvent(appId, container, eventType);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)event);
            Resources.addTo((Resource)unallocated, (Resource)container.getAllocatedResource());
            if (!Resources.fitsIn((ResourceCalculator)rc, (Resource)ZERO_RESOURCE, (Resource)unallocated)) continue;
            LOG.debug("Enough unallocated resources {}", (Object)unallocated);
            break;
        }
    }

    @Override
    public Resource getNormalizedResource(Resource requestedResource, Resource maxResourceCapability) {
        return SchedulerUtils.getNormalizedResource(requestedResource, this.getResourceCalculator(), this.getMinimumResourceCapability(), maxResourceCapability, this.getMinimumResourceCapability());
    }

    protected void normalizeResourceRequests(List<ResourceRequest> asks) {
        this.normalizeResourceRequests(asks, null);
    }

    protected void normalizeResourceRequests(List<ResourceRequest> asks, String queueName) {
        Resource maxAllocation = this.getMaximumResourceCapability(queueName);
        for (ResourceRequest ask : asks) {
            ask.setCapability(this.getNormalizedResource(ask.getCapability(), maxAllocation));
        }
    }

    protected void handleContainerUpdates(SchedulerApplicationAttempt appAttempt, ContainerUpdates updates) {
        List<UpdateContainerRequest> decreaseRequests;
        List<UpdateContainerRequest> demotionRequests;
        List<UpdateContainerRequest> increaseRequests;
        List<UpdateContainerRequest> promotionRequests = updates.getPromotionRequests();
        if (promotionRequests != null && !promotionRequests.isEmpty()) {
            LOG.info("Promotion Update requests : " + promotionRequests);
            this.handleIncreaseRequests(appAttempt, promotionRequests);
        }
        if ((increaseRequests = updates.getIncreaseRequests()) != null && !increaseRequests.isEmpty()) {
            LOG.info("Resource increase requests : " + increaseRequests);
            this.handleIncreaseRequests(appAttempt, increaseRequests);
        }
        if ((demotionRequests = updates.getDemotionRequests()) != null && !demotionRequests.isEmpty()) {
            LOG.info("Demotion Update requests : " + demotionRequests);
            this.handleDecreaseRequests(appAttempt, demotionRequests);
        }
        if ((decreaseRequests = updates.getDecreaseRequests()) != null && !decreaseRequests.isEmpty()) {
            LOG.info("Resource decrease requests : " + decreaseRequests);
            this.handleDecreaseRequests(appAttempt, decreaseRequests);
        }
    }

    private void handleIncreaseRequests(SchedulerApplicationAttempt applicationAttempt, List<UpdateContainerRequest> updateContainerRequests) {
        for (UpdateContainerRequest uReq : updateContainerRequests) {
            RMContainer rmContainer = this.rmContext.getScheduler().getRMContainer(uReq.getContainerId());
            if (rmContainer != null) {
                SchedulerNode schedulerNode = this.rmContext.getScheduler().getSchedulerNode(rmContainer.getContainer().getNodeId());
                if (applicationAttempt.getUpdateContext().checkAndAddToOutstandingIncreases(rmContainer, schedulerNode, uReq)) continue;
                applicationAttempt.addToUpdateContainerErrors(UpdateContainerError.newInstance((String)"UPDATE_OUTSTANDING_ERROR", (UpdateContainerRequest)uReq));
                continue;
            }
            LOG.warn("Cannot promote non-existent (or completed) Container [" + uReq.getContainerId() + "]");
        }
    }

    private void handleDecreaseRequests(SchedulerApplicationAttempt appAttempt, List<UpdateContainerRequest> demotionRequests) {
        OpportunisticContainerContext oppCntxt = appAttempt.getOpportunisticContainerContext();
        for (UpdateContainerRequest uReq : demotionRequests) {
            RMContainer rmContainer = this.rmContext.getScheduler().getRMContainer(uReq.getContainerId());
            if (rmContainer != null) {
                SchedulerNode schedulerNode = this.rmContext.getScheduler().getSchedulerNode(rmContainer.getContainer().getNodeId());
                if (appAttempt.getUpdateContext().checkAndAddToOutstandingDecreases(uReq, schedulerNode, rmContainer.getContainer())) {
                    RMContainer demotedRMContainer;
                    if (ContainerUpdateType.DEMOTE_EXECUTION_TYPE == uReq.getContainerUpdateType()) {
                        demotedRMContainer = this.createDemotedRMContainer(appAttempt, oppCntxt, rmContainer);
                        if (demotedRMContainer == null) continue;
                        OpportunisticSchedulerMetrics.getMetrics().incrAllocatedOppContainers(1);
                        appAttempt.addToNewlyDemotedContainers(uReq.getContainerId(), demotedRMContainer);
                        continue;
                    }
                    demotedRMContainer = this.createDecreasedRMContainer(appAttempt, uReq, rmContainer);
                    appAttempt.addToNewlyDecreasedContainers(uReq.getContainerId(), demotedRMContainer);
                    continue;
                }
                appAttempt.addToUpdateContainerErrors(UpdateContainerError.newInstance((String)"UPDATE_OUTSTANDING_ERROR", (UpdateContainerRequest)uReq));
                continue;
            }
            LOG.warn("Cannot demote/decrease non-existent (or completed) Container [" + uReq.getContainerId() + "]");
        }
    }

    private RMContainer createDecreasedRMContainer(SchedulerApplicationAttempt appAttempt, UpdateContainerRequest uReq, RMContainer rmContainer) {
        SchedulerRequestKey sk = SchedulerRequestKey.extractFrom((Container)rmContainer.getContainer());
        Container decreasedContainer = BuilderUtils.newContainer((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)appAttempt.getApplicationAttemptId(), (long)appAttempt.getNewContainerId()), (NodeId)rmContainer.getContainer().getNodeId(), (String)rmContainer.getContainer().getNodeHttpAddress(), (Resource)Resources.none(), (Priority)sk.getPriority(), null, (ExecutionType)rmContainer.getExecutionType(), (long)sk.getAllocationRequestId());
        decreasedContainer.setVersion(rmContainer.getContainer().getVersion());
        RMContainerImpl newRmContainer = new RMContainerImpl(decreasedContainer, sk, appAttempt.getApplicationAttemptId(), decreasedContainer.getNodeId(), appAttempt.getUser(), this.rmContext, rmContainer.isRemotelyAllocated());
        appAttempt.addRMContainer(decreasedContainer.getId(), rmContainer);
        ((AbstractYarnScheduler)this.rmContext.getScheduler()).getNode(decreasedContainer.getNodeId()).allocateContainer(newRmContainer);
        return newRmContainer;
    }

    private RMContainer createDemotedRMContainer(SchedulerApplicationAttempt appAttempt, OpportunisticContainerContext oppCntxt, RMContainer rmContainer) {
        SchedulerRequestKey sk = SchedulerRequestKey.extractFrom((Container)rmContainer.getContainer());
        Container demotedContainer = BuilderUtils.newContainer((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)appAttempt.getApplicationAttemptId(), (long)oppCntxt.getContainerIdGenerator().generateContainerId()), (NodeId)rmContainer.getContainer().getNodeId(), (String)rmContainer.getContainer().getNodeHttpAddress(), (Resource)rmContainer.getContainer().getResource(), (Priority)sk.getPriority(), null, (ExecutionType)ExecutionType.OPPORTUNISTIC, (long)sk.getAllocationRequestId());
        demotedContainer.setVersion(rmContainer.getContainer().getVersion());
        return SchedulerUtils.createOpportunisticRmContainer(this.rmContext, demotedContainer, false);
    }

    protected void rollbackContainerUpdate(ContainerId containerId) {
        RMContainer rmContainer = this.getRMContainer(containerId);
        if (rmContainer == null) {
            LOG.info("Cannot rollback resource for container " + containerId + ". The container does not exist.");
            return;
        }
        T app = this.getCurrentAttemptForContainer(containerId);
        if (this.getCurrentAttemptForContainer(containerId) == null) {
            LOG.info("Cannot rollback resource for container " + containerId + ". The application that the container belongs to does not exist.");
            return;
        }
        if (Resources.fitsIn((Resource)rmContainer.getLastConfirmedResource(), (Resource)rmContainer.getContainer().getResource())) {
            LOG.info("Roll back resource for container " + containerId);
            this.handleDecreaseRequests((SchedulerApplicationAttempt)app, Arrays.asList(UpdateContainerRequest.newInstance((int)rmContainer.getContainer().getVersion(), (ContainerId)rmContainer.getContainerId(), (ContainerUpdateType)ContainerUpdateType.DECREASE_RESOURCE, (Resource)rmContainer.getLastConfirmedResource(), null)));
        }
    }

    @Override
    public List<NodeId> getNodeIds(String resourceName) {
        return this.nodeTracker.getNodeIdsByResourceName(resourceName);
    }

    public void asyncContainerRelease(RMContainer container) {
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new ReleaseContainerEvent(container));
    }

    public Resource getMinimumAllocation() {
        Resource ret = ResourceUtils.getResourceTypesMinimumAllocation();
        LOG.info("Minimum allocation = " + ret);
        return ret;
    }

    public Resource getMaximumAllocation() {
        Resource ret = ResourceUtils.getResourceTypesMaximumAllocation();
        LOG.info("Maximum allocation = " + ret);
        return ret;
    }

    @Override
    public long checkAndGetApplicationLifetime(String queueName, long lifetime) {
        return lifetime;
    }

    @Override
    public long getMaximumApplicationLifetime(String queueName) {
        return -1L;
    }

    @VisibleForTesting
    public abstract void killContainer(RMContainer var1);

    @VisibleForTesting
    public void update() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerUpdate() {
        Object object = this.updateThreadMonitor;
        synchronized (object) {
            this.updateThreadMonitor.notify();
        }
    }

    @Override
    public void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        try {
            LOG.info("Reinitializing SchedulingMonitorManager ...");
            this.schedulingMonitorManager.reinitialize(rmContext, conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean attemptAllocationOnNode(SchedulerApplicationAttempt appAttempt, SchedulingRequest schedulingRequest, SchedulerNode schedulerNode) {
        return false;
    }

    @Override
    public void resetSchedulerMetrics() {
    }

    private List<ApplicationAttemptId> getAppsFromQueue(String queueName) throws YarnException {
        List apps = this.getAppsInQueue(queueName);
        if (apps == null) {
            throw new YarnException("The specified queue: " + queueName + " doesn't exist");
        }
        return apps;
    }

    private class UpdateThread
    extends Thread {
        private UpdateThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Object object = AbstractYarnScheduler.this.updateThreadMonitor;
                    synchronized (object) {
                        AbstractYarnScheduler.this.updateThreadMonitor.wait(AbstractYarnScheduler.this.updateInterval);
                    }
                    AbstractYarnScheduler.this.update();
                }
                catch (InterruptedException ie) {
                    LOG.warn("Scheduler UpdateThread interrupted. Exiting.");
                    return;
                }
                catch (Exception e) {
                    LOG.error("Exception in scheduler UpdateThread", (Throwable)e);
                }
            }
        }
    }
}

