/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleAction;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleActions;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleMatcher;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleMatchers;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.schema.MappingRulesDescription;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.schema.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingRuleCreator {
    private static final String ALL_USER = "*";
    private static Logger LOG = LoggerFactory.getLogger(MappingRuleCreator.class);

    public MappingRulesDescription getMappingRulesFromJsonFile(String filePath) throws IOException {
        byte[] fileContents = Files.readAllBytes(Paths.get(filePath, new String[0]));
        return this.getMappingRulesFromJson(fileContents);
    }

    MappingRulesDescription getMappingRulesFromJson(byte[] contents) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (MappingRulesDescription)objectMapper.readValue(contents, MappingRulesDescription.class);
    }

    MappingRulesDescription getMappingRulesFromJson(String contents) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (MappingRulesDescription)objectMapper.readValue(contents, MappingRulesDescription.class);
    }

    public List<MappingRule> getMappingRulesFromFile(String jsonPath) throws IOException {
        MappingRulesDescription desc = this.getMappingRulesFromJsonFile(jsonPath);
        return this.getMappingRules(desc);
    }

    public List<MappingRule> getMappingRulesFromString(String json) throws IOException {
        MappingRulesDescription desc = this.getMappingRulesFromJson(json);
        return this.getMappingRules(desc);
    }

    @VisibleForTesting
    List<MappingRule> getMappingRules(MappingRulesDescription rules) {
        ArrayList<MappingRule> mappingRules = new ArrayList<MappingRule>();
        for (Rule rule : rules.getRules()) {
            this.checkMandatoryParameters(rule);
            MappingRuleMatcher matcher = this.createMatcher(rule);
            MappingRuleAction action = this.createAction(rule);
            this.setFallbackToAction(rule, action);
            MappingRule mappingRule = new MappingRule(matcher, action);
            mappingRules.add(mappingRule);
        }
        return mappingRules;
    }

    private MappingRuleMatcher createMatcher(Rule rule) {
        String matches = rule.getMatches();
        Rule.Type type = rule.getType();
        MappingRuleMatcher matcher = null;
        switch (type) {
            case USER: {
                if (ALL_USER.equals(matches)) {
                    matcher = MappingRuleMatchers.createAllMatcher();
                    break;
                }
                matcher = MappingRuleMatchers.createUserMatcher(matches);
                break;
            }
            case GROUP: {
                Preconditions.checkArgument((!ALL_USER.equals(matches) ? 1 : 0) != 0, (Object)"Cannot match '*' for groups");
                matcher = MappingRuleMatchers.createUserGroupMatcher(matches);
                break;
            }
            case APPLICATION: {
                matcher = MappingRuleMatchers.createApplicationNameMatcher(matches);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
            }
        }
        return matcher;
    }

    private MappingRuleAction createAction(Rule rule) {
        boolean create;
        Rule.Policy policy = rule.getPolicy();
        String queue = rule.getParentQueue();
        if (rule.getCreate() == null) {
            LOG.debug("Create flag is not set for rule {},using \"true\" as default", (Object)rule);
            create = true;
        } else {
            create = rule.getCreate();
        }
        MappingRuleAction action = null;
        switch (policy) {
            case DEFAULT_QUEUE: {
                action = MappingRuleActions.createPlaceToDefaultAction();
                break;
            }
            case REJECT: {
                action = MappingRuleActions.createRejectAction();
                break;
            }
            case PRIMARY_GROUP: {
                action = MappingRuleActions.createPlaceToQueueAction(this.getTargetQueue(queue, "%primary_group"), create);
                break;
            }
            case SECONDARY_GROUP: {
                action = MappingRuleActions.createPlaceToQueueAction(this.getTargetQueue(queue, "%secondary_group"), create);
                break;
            }
            case PRIMARY_GROUP_USER: {
                action = MappingRuleActions.createPlaceToQueueAction(this.getTargetQueue(rule.getParentQueue(), "%primary_group.%user"), create);
                break;
            }
            case SECONDARY_GROUP_USER: {
                action = MappingRuleActions.createPlaceToQueueAction(this.getTargetQueue(rule.getParentQueue(), "%secondary_group.%user"), create);
                break;
            }
            case SPECIFIED: {
                action = MappingRuleActions.createPlaceToQueueAction("%specified", create);
                break;
            }
            case CUSTOM: {
                String customTarget = rule.getCustomPlacement();
                Preconditions.checkArgument((customTarget != null ? 1 : 0) != 0, (Object)"custom queue is undefined");
                action = MappingRuleActions.createPlaceToQueueAction(customTarget, create);
                break;
            }
            case USER: {
                action = MappingRuleActions.createPlaceToQueueAction(this.getTargetQueue(rule.getParentQueue(), "%user"), create);
                break;
            }
            case APPLICATION_NAME: {
                action = MappingRuleActions.createPlaceToQueueAction(this.getTargetQueue(rule.getParentQueue(), "%application"), create);
                break;
            }
            case SET_DEFAULT_QUEUE: {
                String defaultQueue = rule.getValue();
                Preconditions.checkArgument((defaultQueue != null ? 1 : 0) != 0, (Object)"default queue is undefined");
                action = MappingRuleActions.createUpdateDefaultAction(defaultQueue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported policy: " + (Object)((Object)policy));
            }
        }
        return action;
    }

    private void setFallbackToAction(Rule rule, MappingRuleAction action) {
        Rule.FallbackResult fallbackResult = rule.getFallbackResult();
        if (fallbackResult == null) {
            action.setFallbackSkip();
            LOG.debug("Fallback is not defined for rule {}, using SKIP as default", (Object)rule);
            return;
        }
        switch (fallbackResult) {
            case PLACE_DEFAULT: {
                action.setFallbackDefaultPlacement();
                break;
            }
            case REJECT: {
                action.setFallbackReject();
                break;
            }
            case SKIP: {
                action.setFallbackSkip();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported fallback rule " + (Object)((Object)fallbackResult));
            }
        }
    }

    private String getTargetQueue(String parent, String placeholder) {
        return parent == null ? placeholder : parent + "." + placeholder;
    }

    private void checkMandatoryParameters(Rule rule) {
        Preconditions.checkArgument((rule.getPolicy() != null ? 1 : 0) != 0, (Object)"Rule policy is undefined");
        Preconditions.checkArgument((rule.getType() != null ? 1 : 0) != 0, (Object)"Rule type is undefined");
        Preconditions.checkArgument((rule.getMatches() != null ? 1 : 0) != 0, (Object)"Match string is undefined");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)rule.getMatches()) ? 1 : 0) != 0, (Object)"Match string is empty");
    }
}

