/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.classification.VisibleForTesting;

public abstract class AbfsRetryPolicy {
    private final int maxRetryCount;
    private final String retryPolicyAbbreviation;

    protected AbfsRetryPolicy(int maxRetryCount, String retryPolicyAbbreviation) {
        this.maxRetryCount = maxRetryCount;
        this.retryPolicyAbbreviation = retryPolicyAbbreviation;
    }

    public boolean shouldRetry(int retryCount, int statusCode) {
        return retryCount < this.maxRetryCount && (statusCode < 100 || statusCode == 408 || statusCode == 410 || statusCode == 429 || statusCode >= 500 && statusCode != 501 && statusCode != 505);
    }

    public abstract long getRetryInterval(int var1);

    public String getAbbreviation() {
        return this.retryPolicyAbbreviation;
    }

    @VisibleForTesting
    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public String toString() {
        return "AbfsRetryPolicy of subtype: " + this.retryPolicyAbbreviation + " and max retry count: " + this.maxRetryCount;
    }
}

