/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlock;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.store.DataBlocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzureBlockManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsOutputStream.class);
    private final DataBlocks.BlockFactory blockFactory;
    private AbfsBlock activeBlock;
    private long blockCount = 0L;
    private final int blockSize;
    private AbfsOutputStream abfsOutputStream;

    protected AzureBlockManager(AbfsOutputStream abfsOutputStream, DataBlocks.BlockFactory blockFactory, int blockSize) {
        this.abfsOutputStream = abfsOutputStream;
        this.blockFactory = blockFactory;
        this.blockSize = blockSize;
    }

    protected final synchronized AbfsBlock createBlock(long position) throws IOException {
        return this.createBlockInternal(position);
    }

    protected abstract AbfsBlock createBlockInternal(long var1) throws IOException;

    public synchronized AbfsBlock getActiveBlock() {
        return this.activeBlock;
    }

    public synchronized void setActiveBlock(AbfsBlock activeBlock) {
        this.activeBlock = activeBlock;
    }

    protected synchronized boolean hasActiveBlock() {
        return this.activeBlock != null;
    }

    protected DataBlocks.BlockFactory getBlockFactory() {
        return this.blockFactory;
    }

    public long getBlockCount() {
        return this.blockCount;
    }

    protected void setBlockCount(long blockCount) {
        this.blockCount = blockCount;
    }

    protected int getBlockSize() {
        return this.blockSize;
    }

    protected AbfsOutputStream getAbfsOutputStream() {
        return this.abfsOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearActiveBlock() {
        AzureBlockManager azureBlockManager = this;
        synchronized (azureBlockManager) {
            if (this.activeBlock != null) {
                LOG.debug("Clearing active block");
            }
            this.activeBlock = null;
        }
    }

    void close() {
        if (this.hasActiveBlock()) {
            this.clearActiveBlock();
        }
        LOG.debug("AzureBlockManager closed.");
    }
}

