/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import com.sun.jersey.api.container.ContainerException;
import java.io.IOException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSMDCFilter;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.util.HttpExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@InterfaceAudience.Private
public class KMSExceptionsProvider
implements ExceptionMapper<Exception> {
    private static Logger LOG = LoggerFactory.getLogger(KMSExceptionsProvider.class);
    private static final Logger EXCEPTION_LOG = KMS.LOG;
    private static final String ENTER = System.getProperty("line.separator");

    protected Response createResponse(Response.Status status, Throwable ex) {
        return HttpExceptionUtils.createJerseyExceptionResponse((Response.Status)status, (Throwable)ex);
    }

    protected String getOneLineMessage(Throwable exception) {
        int i;
        String message = exception.getMessage();
        if (message != null && (i = message.indexOf(ENTER)) > -1) {
            message = message.substring(0, i);
        }
        return message;
    }

    public Response toResponse(Exception exception) {
        Response.Status status;
        boolean doAudit = true;
        Throwable throwable = exception;
        if (exception instanceof ContainerException) {
            throwable = exception.getCause();
        }
        if (throwable instanceof SecurityException) {
            status = Response.Status.FORBIDDEN;
        } else if (throwable instanceof AuthenticationException) {
            status = Response.Status.FORBIDDEN;
            doAudit = false;
        } else if (throwable instanceof AuthorizationException) {
            status = Response.Status.FORBIDDEN;
            doAudit = false;
        } else if (throwable instanceof AccessControlException) {
            status = Response.Status.FORBIDDEN;
        } else if (exception instanceof IOException) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
            this.log(status, throwable);
        } else if (exception instanceof UnsupportedOperationException) {
            status = Response.Status.BAD_REQUEST;
        } else if (exception instanceof IllegalArgumentException) {
            status = Response.Status.BAD_REQUEST;
        } else {
            status = Response.Status.INTERNAL_SERVER_ERROR;
            this.log(status, throwable);
        }
        if (doAudit) {
            KMSWebApp.getKMSAudit().error(KMSMDCFilter.getUgi(), KMSMDCFilter.getMethod(), KMSMDCFilter.getURL(), this.getOneLineMessage(exception));
        }
        EXCEPTION_LOG.warn("User {} request {} {} caused exception.", new Object[]{KMSMDCFilter.getUgi(), KMSMDCFilter.getMethod(), KMSMDCFilter.getURL(), exception});
        return this.createResponse(status, throwable);
    }

    protected void log(Response.Status status, Throwable ex) {
        UserGroupInformation ugi = KMSMDCFilter.getUgi();
        String method = KMSMDCFilter.getMethod();
        String url = KMSMDCFilter.getURL();
        String remoteClientAddress = KMSMDCFilter.getRemoteClientAddress();
        String msg = this.getOneLineMessage(ex);
        LOG.warn("User:'{}' Method:{} URL:{} From:{} Response:{}-{}", new Object[]{ugi, method, url, remoteClientAddress, status, msg, ex});
    }
}

