/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@Metrics(about="Metrics for Router Federation Interceptor", context="fedr")
public final class RouterMetrics {
    private static final MetricsInfo RECORD_INFO = Interns.info((String)"RouterMetrics", (String)"Router Federation Interceptor");
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    @Metric(value={"# of applications failed to be submitted"})
    private MutableGaugeInt numAppsFailedSubmitted;
    @Metric(value={"# of applications failed to be created"})
    private MutableGaugeInt numAppsFailedCreated;
    @Metric(value={"# of applications failed to be killed"})
    private MutableGaugeInt numAppsFailedKilled;
    @Metric(value={"# of application reports failed to be retrieved"})
    private MutableGaugeInt numAppsFailedRetrieved;
    @Metric(value={"# of multiple applications reports failed to be retrieved"})
    private MutableGaugeInt numMultipleAppsFailedRetrieved;
    @Metric(value={"# of getApplicationAttempts failed to be retrieved"})
    private MutableGaugeInt numAppAttemptsFailedRetrieved;
    @Metric(value={"# of getClusterMetrics failed to be retrieved"})
    private MutableGaugeInt numGetClusterMetricsFailedRetrieved;
    @Metric(value={"# of getClusterNodes failed to be retrieved"})
    private MutableGaugeInt numGetClusterNodesFailedRetrieved;
    @Metric(value={"# of getNodeToLabels failed to be retrieved"})
    private MutableGaugeInt numGetNodeToLabelsFailedRetrieved;
    @Metric(value={"# of getNodeToLabels failed to be retrieved"})
    private MutableGaugeInt numGetLabelsToNodesFailedRetrieved;
    @Metric(value={"# of getClusterNodeLabels failed to be retrieved"})
    private MutableGaugeInt numGetClusterNodeLabelsFailedRetrieved;
    @Metric(value={"# of getApplicationAttemptReports failed to be retrieved"})
    private MutableGaugeInt numAppAttemptReportFailedRetrieved;
    @Metric(value={"# of getQueueUserAcls failed to be retrieved"})
    private MutableGaugeInt numGetQueueUserAclsFailedRetrieved;
    @Metric(value={"# of getContainerReport failed to be retrieved"})
    private MutableGaugeInt numGetContainerReportFailedRetrieved;
    @Metric(value={"# of getContainers failed to be retrieved"})
    private MutableGaugeInt numGetContainersFailedRetrieved;
    @Metric(value={"# of listReservations failed to be retrieved"})
    private MutableGaugeInt numListReservationsFailedRetrieved;
    @Metric(value={"# of getResourceTypeInfo failed to be retrieved"})
    private MutableGaugeInt numGetResourceTypeInfo;
    @Metric(value={"# of failApplicationAttempt failed to be retrieved"})
    private MutableGaugeInt numFailAppAttemptFailedRetrieved;
    @Metric(value={"# of updateApplicationPriority failed to be retrieved"})
    private MutableGaugeInt numUpdateAppPriorityFailedRetrieved;
    @Metric(value={"# of updateApplicationPriority failed to be retrieved"})
    private MutableGaugeInt numUpdateAppTimeoutsFailedRetrieved;
    @Metric(value={"# of signalToContainer failed to be retrieved"})
    private MutableGaugeInt numSignalToContainerFailedRetrieved;
    @Metric(value={"# of getQueueInfo failed to be retrieved"})
    private MutableGaugeInt numGetQueueInfoFailedRetrieved;
    @Metric(value={"# of moveApplicationAcrossQueues failed to be retrieved"})
    private MutableGaugeInt numMoveApplicationAcrossQueuesFailedRetrieved;
    @Metric(value={"# of getResourceProfiles failed to be retrieved"})
    private MutableGaugeInt numGetResourceProfilesFailedRetrieved;
    @Metric(value={"# of getResourceProfile failed to be retrieved"})
    private MutableGaugeInt numGetResourceProfileFailedRetrieved;
    @Metric(value={"# of getAttributesToNodes failed to be retrieved"})
    private MutableGaugeInt numGetAttributesToNodesFailedRetrieved;
    @Metric(value={"# of getClusterNodeAttributes failed to be retrieved"})
    private MutableGaugeInt numGetClusterNodeAttributesFailedRetrieved;
    @Metric(value={"# of getNodesToAttributes failed to be retrieved"})
    private MutableGaugeInt numGetNodesToAttributesFailedRetrieved;
    @Metric(value={"# of getNewReservation failed to be retrieved"})
    private MutableGaugeInt numGetNewReservationFailedRetrieved;
    @Metric(value={"# of submitReservation failed to be retrieved"})
    private MutableGaugeInt numSubmitReservationFailedRetrieved;
    @Metric(value={"# of submitReservation failed to be retrieved"})
    private MutableGaugeInt numUpdateReservationFailedRetrieved;
    @Metric(value={"# of deleteReservation failed to be retrieved"})
    private MutableGaugeInt numDeleteReservationFailedRetrieved;
    @Metric(value={"# of listReservation failed to be retrieved"})
    private MutableGaugeInt numListReservationFailedRetrieved;
    @Metric(value={"# of getAppActivities failed to be retrieved"})
    private MutableGaugeInt numGetAppActivitiesFailedRetrieved;
    @Metric(value={"# of getAppStatistics failed to be retrieved"})
    private MutableGaugeInt numGetAppStatisticsFailedRetrieved;
    @Metric(value={"# of getAppPriority failed to be retrieved"})
    private MutableGaugeInt numGetAppPriorityFailedRetrieved;
    @Metric(value={"# of getAppQueue failed to be retrieved"})
    private MutableGaugeInt numGetAppQueueFailedRetrieved;
    @Metric(value={"# of updateAppQueue failed to be retrieved"})
    private MutableGaugeInt numUpdateAppQueueFailedRetrieved;
    @Metric(value={"# of getAppTimeout failed to be retrieved"})
    private MutableGaugeInt numGetAppTimeoutFailedRetrieved;
    @Metric(value={"# of getAppTimeouts failed to be retrieved"})
    private MutableGaugeInt numGetAppTimeoutsFailedRetrieved;
    @Metric(value={"# of refreshQueues failed to be retrieved"})
    private MutableGaugeInt numRefreshQueuesFailedRetrieved;
    @Metric(value={"# of getRMNodeLabels failed to be retrieved"})
    private MutableGaugeInt numGetRMNodeLabelsFailedRetrieved;
    @Metric(value={"# of checkUserAccessToQueue failed to be retrieved"})
    private MutableGaugeInt numCheckUserAccessToQueueFailedRetrieved;
    @Metric(value={"# of refreshNodes failed to be retrieved"})
    private MutableGaugeInt numRefreshNodesFailedRetrieved;
    @Metric(value={"# of getDelegationToken failed to be retrieved"})
    private MutableGaugeInt numGetDelegationTokenFailedRetrieved;
    @Metric(value={"# of renewDelegationToken failed to be retrieved"})
    private MutableGaugeInt numRenewDelegationTokenFailedRetrieved;
    @Metric(value={"# of renewDelegationToken failed to be retrieved"})
    private MutableGaugeInt numCancelDelegationTokenFailedRetrieved;
    @Metric(value={"# of dumpSchedulerLogs failed to be retrieved"})
    private MutableGaugeInt numDumpSchedulerLogsFailedRetrieved;
    @Metric(value={"# of getActivities failed to be retrieved"})
    private MutableGaugeInt numGetActivitiesFailedRetrieved;
    @Metric(value={"# of getBulkActivities failed to be retrieved"})
    private MutableGaugeInt numGetBulkActivitiesFailedRetrieved;
    @Metric(value={"# of getSchedulerInfo failed to be retrieved"})
    private MutableGaugeInt numGetSchedulerInfoFailedRetrieved;
    @Metric(value={"# of refreshSuperUserGroupsConfiguration failed to be retrieved"})
    private MutableGaugeInt numRefreshSuperUserGroupsConfigurationFailedRetrieved;
    @Metric(value={"# of refreshUserToGroupsMappings failed to be retrieved"})
    private MutableGaugeInt numRefreshUserToGroupsMappingsFailedRetrieved;
    @Metric(value={"# of deregisterSubCluster failed to be retrieved"})
    private MutableGaugeInt numDeregisterSubClusterFailedRetrieved;
    @Metric(value={"# of saveFederationQueuePolicy failed to be retrieved"})
    private MutableGaugeInt numSaveFederationQueuePolicyFailedRetrieved;
    @Metric(value={"# of batchSaveFederationQueuePolicies failed to be retrieved"})
    private MutableGaugeInt numBatchSaveFederationQueuePoliciesFailedRetrieved;
    @Metric(value={"# of listFederationQueuePolicies failed to be retrieved"})
    private MutableGaugeInt numListFederationQueuePoliciesFailedRetrieved;
    @Metric(value={"# of deleteFederationApplication failed to be retrieved"})
    private MutableGaugeInt numDeleteFederationApplicationFailedRetrieved;
    @Metric(value={"# of getFederationSubClusters failed to be retrieved"})
    private MutableGaugeInt numGetFederationSubClustersFailedRetrieved;
    @Metric(value={"# of deleteFederationPoliciesByQueues failed to be retrieved"})
    private MutableGaugeInt numDeleteFederationPoliciesByQueuesRetrieved;
    @Metric(value={"# of refreshAdminAcls failed to be retrieved"})
    private MutableGaugeInt numRefreshAdminAclsFailedRetrieved;
    @Metric(value={"# of refreshServiceAcls failed to be retrieved"})
    private MutableGaugeInt numRefreshServiceAclsFailedRetrieved;
    @Metric(value={"# of replaceLabelsOnNodes failed to be retrieved"})
    private MutableGaugeInt numReplaceLabelsOnNodesFailedRetrieved;
    @Metric(value={"# of replaceLabelsOnNode failed to be retrieved"})
    private MutableGaugeInt numReplaceLabelsOnNodeFailedRetrieved;
    @Metric(value={"# of addToClusterNodeLabels failed to be retrieved"})
    private MutableGaugeInt numAddToClusterNodeLabelsFailedRetrieved;
    @Metric(value={"# of removeFromClusterNodeLabels failed to be retrieved"})
    private MutableGaugeInt numRemoveFromClusterNodeLabelsFailedRetrieved;
    @Metric(value={"# of numUpdateSchedulerConfiguration failed to be retrieved"})
    private MutableGaugeInt numUpdateSchedulerConfigurationFailedRetrieved;
    @Metric(value={"# of numGetSchedulerConfiguration failed to be retrieved"})
    private MutableGaugeInt numGetSchedulerConfigurationFailedRetrieved;
    @Metric(value={"# of getClusterInfo failed to be retrieved"})
    private MutableGaugeInt numGetClusterInfoFailedRetrieved;
    @Metric(value={"# of getClusterUserInfo failed to be retrieved"})
    private MutableGaugeInt numGetClusterUserInfoFailedRetrieved;
    @Metric(value={"# of updateNodeResource failed to be retrieved"})
    private MutableGaugeInt numUpdateNodeResourceFailedRetrieved;
    @Metric(value={"# of refreshNodesResources failed to be retrieved"})
    private MutableGaugeInt numRefreshNodesResourcesFailedRetrieved;
    @Metric(value={"# of checkForDecommissioningNodes failed to be retrieved"})
    private MutableGaugeInt numCheckForDecommissioningNodesFailedRetrieved;
    @Metric(value={"# of refreshClusterMaxPriority failed to be retrieved"})
    private MutableGaugeInt numRefreshClusterMaxPriorityFailedRetrieved;
    @Metric(value={"# of mapAttributesToNodes failed to be retrieved"})
    private MutableGaugeInt numMapAttributesToNodesFailedRetrieved;
    @Metric(value={"# of getGroupsForUser failed to be retrieved"})
    private MutableGaugeInt numGetGroupsForUserFailedRetrieved;
    @Metric(value={"Total number of successful Submitted apps and latency(ms)"})
    private MutableRate totalSucceededAppsSubmitted;
    @Metric(value={"Total number of successful Killed apps and latency(ms)"})
    private MutableRate totalSucceededAppsKilled;
    @Metric(value={"Total number of successful Created apps and latency(ms)"})
    private MutableRate totalSucceededAppsCreated;
    @Metric(value={"Total number of successful Retrieved app reports and latency(ms)"})
    private MutableRate totalSucceededAppsRetrieved;
    @Metric(value={"Total number of successful Retrieved multiple apps reports and latency(ms)"})
    private MutableRate totalSucceededMultipleAppsRetrieved;
    @Metric(value={"Total number of successful Retrieved appAttempt reports and latency(ms)"})
    private MutableRate totalSucceededAppAttemptsRetrieved;
    @Metric(value={"Total number of successful Retrieved getClusterMetrics and latency(ms)"})
    private MutableRate totalSucceededGetClusterMetricsRetrieved;
    @Metric(value={"Total number of successful Retrieved getClusterNodes and latency(ms)"})
    private MutableRate totalSucceededGetClusterNodesRetrieved;
    @Metric(value={"Total number of successful Retrieved getNodeToLabels and latency(ms)"})
    private MutableRate totalSucceededGetNodeToLabelsRetrieved;
    @Metric(value={"Total number of successful Retrieved getNodeToLabels and latency(ms)"})
    private MutableRate totalSucceededGetLabelsToNodesRetrieved;
    @Metric(value={"Total number of successful Retrieved getClusterNodeLabels and latency(ms)"})
    private MutableRate totalSucceededGetClusterNodeLabelsRetrieved;
    @Metric(value={"Total number of successful Retrieved getApplicationAttemptReport and latency(ms)"})
    private MutableRate totalSucceededAppAttemptReportRetrieved;
    @Metric(value={"Total number of successful Retrieved getQueueUserAcls and latency(ms)"})
    private MutableRate totalSucceededGetQueueUserAclsRetrieved;
    @Metric(value={"Total number of successful Retrieved getContainerReport and latency(ms)"})
    private MutableRate totalSucceededGetContainerReportRetrieved;
    @Metric(value={"Total number of successful Retrieved getContainers and latency(ms)"})
    private MutableRate totalSucceededGetContainersRetrieved;
    @Metric(value={"Total number of successful Retrieved listReservations and latency(ms)"})
    private MutableRate totalSucceededListReservationsRetrieved;
    @Metric(value={"Total number of successful Retrieved getResourceTypeInfo and latency(ms)"})
    private MutableRate totalSucceededGetResourceTypeInfoRetrieved;
    @Metric(value={"Total number of successful Retrieved failApplicationAttempt and latency(ms)"})
    private MutableRate totalSucceededFailAppAttemptRetrieved;
    @Metric(value={"Total number of successful Retrieved updateApplicationPriority and latency(ms)"})
    private MutableRate totalSucceededUpdateAppPriorityRetrieved;
    @Metric(value={"Total number of successful Retrieved updateApplicationTimeouts and latency(ms)"})
    private MutableRate totalSucceededUpdateAppTimeoutsRetrieved;
    @Metric(value={"Total number of successful Retrieved signalToContainer and latency(ms)"})
    private MutableRate totalSucceededSignalToContainerRetrieved;
    @Metric(value={"Total number of successful Retrieved getQueueInfo and latency(ms)"})
    private MutableRate totalSucceededGetQueueInfoRetrieved;
    @Metric(value={"Total number of successful Retrieved moveApplicationAcrossQueues and latency(ms)"})
    private MutableRate totalSucceededMoveApplicationAcrossQueuesRetrieved;
    @Metric(value={"Total number of successful Retrieved getResourceProfiles and latency(ms)"})
    private MutableRate totalSucceededGetResourceProfilesRetrieved;
    @Metric(value={"Total number of successful Retrieved getResourceProfile and latency(ms)"})
    private MutableRate totalSucceededGetResourceProfileRetrieved;
    @Metric(value={"Total number of successful Retrieved getAttributesToNodes and latency(ms)"})
    private MutableRate totalSucceededGetAttributesToNodesRetrieved;
    @Metric(value={"Total number of successful Retrieved getClusterNodeAttributes and latency(ms)"})
    private MutableRate totalSucceededGetClusterNodeAttributesRetrieved;
    @Metric(value={"Total number of successful Retrieved getNodesToAttributes and latency(ms)"})
    private MutableRate totalSucceededGetNodesToAttributesRetrieved;
    @Metric(value={"Total number of successful Retrieved GetNewReservation and latency(ms)"})
    private MutableRate totalSucceededGetNewReservationRetrieved;
    @Metric(value={"Total number of successful Retrieved SubmitReservation and latency(ms)"})
    private MutableRate totalSucceededSubmitReservationRetrieved;
    @Metric(value={"Total number of successful Retrieved UpdateReservation and latency(ms)"})
    private MutableRate totalSucceededUpdateReservationRetrieved;
    @Metric(value={"Total number of successful Retrieved DeleteReservation and latency(ms)"})
    private MutableRate totalSucceededDeleteReservationRetrieved;
    @Metric(value={"Total number of successful Retrieved ListReservation and latency(ms)"})
    private MutableRate totalSucceededListReservationRetrieved;
    @Metric(value={"Total number of successful Retrieved GetAppActivities and latency(ms)"})
    private MutableRate totalSucceededGetAppActivitiesRetrieved;
    @Metric(value={"Total number of successful Retrieved GetAppStatistics and latency(ms)"})
    private MutableRate totalSucceededGetAppStatisticsRetrieved;
    @Metric(value={"Total number of successful Retrieved GetAppPriority and latency(ms)"})
    private MutableRate totalSucceededGetAppPriorityRetrieved;
    @Metric(value={"Total number of successful Retrieved GetAppQueue and latency(ms)"})
    private MutableRate totalSucceededGetAppQueueRetrieved;
    @Metric(value={"Total number of successful Retrieved UpdateAppQueue and latency(ms)"})
    private MutableRate totalSucceededUpdateAppQueueRetrieved;
    @Metric(value={"Total number of successful Retrieved GetAppTimeout and latency(ms)"})
    private MutableRate totalSucceededGetAppTimeoutRetrieved;
    @Metric(value={"Total number of successful Retrieved GetAppTimeouts and latency(ms)"})
    private MutableRate totalSucceededGetAppTimeoutsRetrieved;
    @Metric(value={"Total number of successful Retrieved RefreshQueues and latency(ms)"})
    private MutableRate totalSucceededRefreshQueuesRetrieved;
    @Metric(value={"Total number of successful Retrieved GetRMNodeLabels and latency(ms)"})
    private MutableRate totalSucceededGetRMNodeLabelsRetrieved;
    @Metric(value={"Total number of successful Retrieved CheckUserAccessToQueue and latency(ms)"})
    private MutableRate totalSucceededCheckUserAccessToQueueRetrieved;
    @Metric(value={"Total number of successful Retrieved RefreshNodes and latency(ms)"})
    private MutableRate totalSucceededRefreshNodesRetrieved;
    @Metric(value={"Total number of successful Retrieved GetDelegationToken and latency(ms)"})
    private MutableRate totalSucceededGetDelegationTokenRetrieved;
    @Metric(value={"Total number of successful Retrieved RenewDelegationToken and latency(ms)"})
    private MutableRate totalSucceededRenewDelegationTokenRetrieved;
    @Metric(value={"Total number of successful Retrieved CancelDelegationToken and latency(ms)"})
    private MutableRate totalSucceededCancelDelegationTokenRetrieved;
    @Metric(value={"Total number of successful Retrieved DumpSchedulerLogs and latency(ms)"})
    private MutableRate totalSucceededDumpSchedulerLogsRetrieved;
    @Metric(value={"Total number of successful Retrieved GetActivities and latency(ms)"})
    private MutableRate totalSucceededGetActivitiesRetrieved;
    @Metric(value={"Total number of successful Retrieved GetBulkActivities and latency(ms)"})
    private MutableRate totalSucceededGetBulkActivitiesRetrieved;
    @Metric(value={"Total number of successful Retrieved RefreshSuperUserGroupsConfig and latency(ms)"})
    private MutableRate totalSucceededRefreshSuperUserGroupsConfigurationRetrieved;
    @Metric(value={"Total number of successful Retrieved RefreshUserToGroupsMappings and latency(ms)"})
    private MutableRate totalSucceededRefreshUserToGroupsMappingsRetrieved;
    @Metric(value={"Total number of successful Retrieved ReplaceLabelsOnNodes and latency(ms)"})
    private MutableRate totalSucceededReplaceLabelsOnNodesRetrieved;
    @Metric(value={"Total number of successful Retrieved ReplaceLabelsOnNode and latency(ms)"})
    private MutableRate totalSucceededReplaceLabelsOnNodeRetrieved;
    @Metric(value={"Total number of successful Retrieved GetSchedulerInfo and latency(ms)"})
    private MutableRate totalSucceededGetSchedulerInfoRetrieved;
    @Metric(value={"Total number of successful Retrieved DeregisterSubCluster and latency(ms)"})
    private MutableRate totalSucceededDeregisterSubClusterRetrieved;
    @Metric(value={"Total number of successful Retrieved SaveFederationQueuePolicy and latency(ms)"})
    private MutableRate totalSucceededSaveFederationQueuePolicyRetrieved;
    @Metric(value={"Total number of successful Retrieved BatchSaveFederationQueuePolicies and latency(ms)"})
    private MutableRate totalSucceededBatchSaveFederationQueuePoliciesRetrieved;
    @Metric(value={"Total number of successful Retrieved ListFederationQueuePolicies and latency(ms)"})
    private MutableRate totalSucceededListFederationQueuePoliciesFailedRetrieved;
    @Metric(value={"Total number of successful Retrieved DeleteFederationApplication and latency(ms)"})
    private MutableRate totalSucceededDeleteFederationApplicationFailedRetrieved;
    @Metric(value={"Total number of successful Retrieved getFederationSubClusters and latency(ms)"})
    private MutableRate totalSucceededGetFederationSubClustersRetrieved;
    @Metric(value={"Total number of successful Retrieved DeleteFederationPoliciesByQueues and latency(ms)"})
    private MutableRate totalSucceededDeleteFederationPoliciesByQueuesRetrieved;
    @Metric(value={"Total number of successful Retrieved RefreshAdminAcls and latency(ms)"})
    private MutableRate totalSucceededRefreshAdminAclsRetrieved;
    @Metric(value={"Total number of successful Retrieved RefreshServiceAcls and latency(ms)"})
    private MutableRate totalSucceededRefreshServiceAclsRetrieved;
    @Metric(value={"Total number of successful Retrieved AddToClusterNodeLabels and latency(ms)"})
    private MutableRate totalSucceededAddToClusterNodeLabelsRetrieved;
    @Metric(value={"Total number of successful Retrieved RemoveFromClusterNodeLabels and latency(ms)"})
    private MutableRate totalSucceededRemoveFromClusterNodeLabelsRetrieved;
    @Metric(value={"Total number of successful Retrieved updateSchedulerConfiguration and latency(ms)"})
    private MutableRate totalSucceededUpdateSchedulerConfigurationRetrieved;
    @Metric(value={"Total number of successful Retrieved getSchedulerConfiguration and latency(ms)"})
    private MutableRate totalSucceededGetSchedulerConfigurationRetrieved;
    @Metric(value={"Total number of successful Retrieved GetClusterInfoRetrieved and latency(ms)"})
    private MutableRate totalSucceededGetClusterInfoRetrieved;
    @Metric(value={"Total number of successful Retrieved GetClusterUserInfoRetrieved and latency(ms)"})
    private MutableRate totalSucceededGetClusterUserInfoRetrieved;
    @Metric(value={"Total number of successful Retrieved UpdateNodeResource and latency(ms)"})
    private MutableRate totalSucceededUpdateNodeResourceRetrieved;
    @Metric(value={"Total number of successful Retrieved RefreshNodesResources and latency(ms)"})
    private MutableRate totalSucceededRefreshNodesResourcesRetrieved;
    @Metric(value={"Total number of successful Retrieved CheckForDecommissioningNodes and latency(ms)"})
    private MutableRate totalSucceededCheckForDecommissioningNodesRetrieved;
    @Metric(value={"Total number of successful Retrieved RefreshClusterMaxPriority and latency(ms)"})
    private MutableRate totalSucceededRefreshClusterMaxPriorityRetrieved;
    @Metric(value={"Total number of successful Retrieved MapAttributesToNodes and latency(ms)"})
    private MutableRate totalSucceededMapAttributesToNodesRetrieved;
    @Metric(value={"Total number of successful Retrieved GetGroupsForUser and latency(ms)"})
    private MutableRate totalSucceededGetGroupsForUsersRetrieved;
    private MutableQuantiles submitApplicationLatency;
    private MutableQuantiles getNewApplicationLatency;
    private MutableQuantiles killApplicationLatency;
    private MutableQuantiles getApplicationReportLatency;
    private MutableQuantiles getApplicationsReportLatency;
    private MutableQuantiles getApplicationAttemptReportLatency;
    private MutableQuantiles getClusterMetricsLatency;
    private MutableQuantiles getClusterNodesLatency;
    private MutableQuantiles getNodeToLabelsLatency;
    private MutableQuantiles getLabelToNodesLatency;
    private MutableQuantiles getClusterNodeLabelsLatency;
    private MutableQuantiles getApplicationAttemptsLatency;
    private MutableQuantiles getQueueUserAclsLatency;
    private MutableQuantiles getContainerReportLatency;
    private MutableQuantiles getContainerLatency;
    private MutableQuantiles listReservationsLatency;
    private MutableQuantiles listResourceTypeInfoLatency;
    private MutableQuantiles failAppAttemptLatency;
    private MutableQuantiles updateAppPriorityLatency;
    private MutableQuantiles updateAppTimeoutsLatency;
    private MutableQuantiles signalToContainerLatency;
    private MutableQuantiles getQueueInfoLatency;
    private MutableQuantiles moveApplicationAcrossQueuesLatency;
    private MutableQuantiles getResourceProfilesLatency;
    private MutableQuantiles getResourceProfileLatency;
    private MutableQuantiles getAttributesToNodesLatency;
    private MutableQuantiles getClusterNodeAttributesLatency;
    private MutableQuantiles getNodesToAttributesLatency;
    private MutableQuantiles getNewReservationLatency;
    private MutableQuantiles submitReservationLatency;
    private MutableQuantiles updateReservationLatency;
    private MutableQuantiles deleteReservationLatency;
    private MutableQuantiles listReservationLatency;
    private MutableQuantiles getAppActivitiesLatency;
    private MutableQuantiles getAppStatisticsLatency;
    private MutableQuantiles getAppPriorityLatency;
    private MutableQuantiles getAppQueueLatency;
    private MutableQuantiles getUpdateQueueLatency;
    private MutableQuantiles getAppTimeoutLatency;
    private MutableQuantiles getAppTimeoutsLatency;
    private MutableQuantiles refreshQueuesLatency;
    private MutableQuantiles getRMNodeLabelsLatency;
    private MutableQuantiles checkUserAccessToQueueLatency;
    private MutableQuantiles refreshNodesLatency;
    private MutableQuantiles getDelegationTokenLatency;
    private MutableQuantiles renewDelegationTokenLatency;
    private MutableQuantiles cancelDelegationTokenLatency;
    private MutableQuantiles dumpSchedulerLogsLatency;
    private MutableQuantiles getActivitiesLatency;
    private MutableQuantiles getBulkActivitiesLatency;
    private MutableQuantiles getSchedulerInfoRetrievedLatency;
    private MutableQuantiles refreshSuperUserGroupsConfLatency;
    private MutableQuantiles refreshUserToGroupsMappingsLatency;
    private MutableQuantiles refreshDeregisterSubClusterLatency;
    private MutableQuantiles saveFederationQueuePolicyLatency;
    private MutableQuantiles batchSaveFederationQueuePoliciesLatency;
    private MutableQuantiles listFederationQueuePoliciesLatency;
    private MutableQuantiles deleteFederationApplicationLatency;
    private MutableQuantiles getFederationSubClustersLatency;
    private MutableQuantiles deleteFederationPoliciesByQueuesLatency;
    private MutableQuantiles refreshAdminAclsLatency;
    private MutableQuantiles refreshServiceAclsLatency;
    private MutableQuantiles replaceLabelsOnNodesLatency;
    private MutableQuantiles replaceLabelsOnNodeLatency;
    private MutableQuantiles addToClusterNodeLabelsLatency;
    private MutableQuantiles removeFromClusterNodeLabelsLatency;
    private MutableQuantiles updateSchedulerConfigLatency;
    private MutableQuantiles getSchedulerConfigurationLatency;
    private MutableQuantiles getClusterInfoLatency;
    private MutableQuantiles getClusterUserInfoLatency;
    private MutableQuantiles updateNodeResourceLatency;
    private MutableQuantiles refreshNodesResourcesLatency;
    private MutableQuantiles checkForDecommissioningNodesLatency;
    private MutableQuantiles refreshClusterMaxPriorityLatency;
    private MutableQuantiles mapAttributesToNodesLatency;
    private MutableQuantiles getGroupsForUserLatency;
    private static volatile RouterMetrics instance = null;
    private static MetricsRegistry registry;

    private RouterMetrics() {
        registry = new MetricsRegistry(RECORD_INFO);
        registry.tag(RECORD_INFO, "Router");
        this.getNewApplicationLatency = registry.newQuantiles("getNewApplicationLatency", "latency of get new application", "ops", "latency", 10);
        this.submitApplicationLatency = registry.newQuantiles("submitApplicationLatency", "latency of submit application", "ops", "latency", 10);
        this.killApplicationLatency = registry.newQuantiles("killApplicationLatency", "latency of kill application", "ops", "latency", 10);
        this.getApplicationReportLatency = registry.newQuantiles("getApplicationReportLatency", "latency of get application report", "ops", "latency", 10);
        this.getApplicationsReportLatency = registry.newQuantiles("getApplicationsReportLatency", "latency of get applications report", "ops", "latency", 10);
        this.getApplicationAttemptReportLatency = registry.newQuantiles("getApplicationAttemptReportLatency", "latency of get applicationattempt report", "ops", "latency", 10);
        this.getClusterMetricsLatency = registry.newQuantiles("getClusterMetricsLatency", "latency of get cluster metrics", "ops", "latency", 10);
        this.getClusterNodesLatency = registry.newQuantiles("getClusterNodesLatency", "latency of get cluster nodes", "ops", "latency", 10);
        this.getNodeToLabelsLatency = registry.newQuantiles("getNodeToLabelsLatency", "latency of get node labels", "ops", "latency", 10);
        this.getLabelToNodesLatency = registry.newQuantiles("getLabelToNodesLatency", "latency of get label nodes", "ops", "latency", 10);
        this.getClusterNodeLabelsLatency = registry.newQuantiles("getClusterNodeLabelsLatency", "latency of get cluster node labels", "ops", "latency", 10);
        this.getApplicationAttemptsLatency = registry.newQuantiles("getApplicationAttemptsLatency", "latency of get application attempts", "ops", "latency", 10);
        this.getQueueUserAclsLatency = registry.newQuantiles("getQueueUserAclsLatency", "latency of get queue user acls", "ops", "latency", 10);
        this.getContainerReportLatency = registry.newQuantiles("getContainerReportLatency", "latency of get container report", "ops", "latency", 10);
        this.getContainerLatency = registry.newQuantiles("getContainerLatency", "latency of get container", "ops", "latency", 10);
        this.listReservationsLatency = registry.newQuantiles("listReservationsLatency", "latency of list reservations", "ops", "latency", 10);
        this.listResourceTypeInfoLatency = registry.newQuantiles("getResourceTypeInfoLatency", "latency of get resource type info", "ops", "latency", 10);
        this.failAppAttemptLatency = registry.newQuantiles("failApplicationAttemptLatency", "latency of fail application attempt", "ops", "latency", 10);
        this.updateAppPriorityLatency = registry.newQuantiles("updateApplicationPriorityLatency", "latency of update application priority", "ops", "latency", 10);
        this.updateAppTimeoutsLatency = registry.newQuantiles("updateApplicationTimeoutsLatency", "latency of update application timeouts", "ops", "latency", 10);
        this.signalToContainerLatency = registry.newQuantiles("signalToContainerLatency", "latency of signal to container timeouts", "ops", "latency", 10);
        this.getQueueInfoLatency = registry.newQuantiles("getQueueInfoLatency", "latency of get queue info timeouts", "ops", "latency", 10);
        this.moveApplicationAcrossQueuesLatency = registry.newQuantiles("moveApplicationAcrossQueuesLatency", "latency of move application across queues timeouts", "ops", "latency", 10);
        this.getResourceProfilesLatency = registry.newQuantiles("getResourceProfilesLatency", "latency of get resource profiles timeouts", "ops", "latency", 10);
        this.getResourceProfileLatency = registry.newQuantiles("getResourceProfileLatency", "latency of get resource profile timeouts", "ops", "latency", 10);
        this.getAttributesToNodesLatency = registry.newQuantiles("getAttributesToNodesLatency", "latency of get attributes to nodes timeouts", "ops", "latency", 10);
        this.getClusterNodeAttributesLatency = registry.newQuantiles("getClusterNodeAttributesLatency", "latency of get cluster node attributes timeouts", "ops", "latency", 10);
        this.getNodesToAttributesLatency = registry.newQuantiles("getNodesToAttributesLatency", "latency of get nodes to attributes timeouts", "ops", "latency", 10);
        this.getNewReservationLatency = registry.newQuantiles("getNewReservationLatency", "latency of get new reservation timeouts", "ops", "latency", 10);
        this.submitReservationLatency = registry.newQuantiles("submitReservationLatency", "latency of submit reservation timeouts", "ops", "latency", 10);
        this.updateReservationLatency = registry.newQuantiles("updateReservationLatency", "latency of update reservation timeouts", "ops", "latency", 10);
        this.deleteReservationLatency = registry.newQuantiles("deleteReservationLatency", "latency of delete reservation timeouts", "ops", "latency", 10);
        this.listReservationLatency = registry.newQuantiles("listReservationLatency", "latency of list reservation timeouts", "ops", "latency", 10);
        this.getAppActivitiesLatency = registry.newQuantiles("getAppActivitiesLatency", "latency of get app activities timeouts", "ops", "latency", 10);
        this.getAppStatisticsLatency = registry.newQuantiles("getAppStatisticsLatency", "latency of get app statistics timeouts", "ops", "latency", 10);
        this.getAppPriorityLatency = registry.newQuantiles("getAppPriorityLatency", "latency of get app priority timeouts", "ops", "latency", 10);
        this.getAppQueueLatency = registry.newQuantiles("getAppQueueLatency", "latency of get app queue timeouts", "ops", "latency", 10);
        this.getUpdateQueueLatency = registry.newQuantiles("getUpdateQueueLatency", "latency of update app queue timeouts", "ops", "latency", 10);
        this.getAppTimeoutLatency = registry.newQuantiles("getAppTimeoutLatency", "latency of get apptimeout timeouts", "ops", "latency", 10);
        this.getAppTimeoutsLatency = registry.newQuantiles("getAppTimeoutsLatency", "latency of get apptimeouts timeouts", "ops", "latency", 10);
        this.refreshQueuesLatency = registry.newQuantiles("refreshQueuesLatency", "latency of get refresh queues timeouts", "ops", "latency", 10);
        this.getRMNodeLabelsLatency = registry.newQuantiles("getRMNodeLabelsLatency", "latency of get rmnodelabels timeouts", "ops", "latency", 10);
        this.checkUserAccessToQueueLatency = registry.newQuantiles("checkUserAccessToQueueLatency", "latency of get apptimeouts timeouts", "ops", "latency", 10);
        this.refreshNodesLatency = registry.newQuantiles("refreshNodesLatency", "latency of get refresh nodes timeouts", "ops", "latency", 10);
        this.getDelegationTokenLatency = registry.newQuantiles("getDelegationTokenLatency", "latency of get delegation token timeouts", "ops", "latency", 10);
        this.renewDelegationTokenLatency = registry.newQuantiles("renewDelegationTokenLatency", "latency of renew delegation token timeouts", "ops", "latency", 10);
        this.cancelDelegationTokenLatency = registry.newQuantiles("cancelDelegationTokenLatency", "latency of cancel delegation token timeouts", "ops", "latency", 10);
        this.dumpSchedulerLogsLatency = registry.newQuantiles("dumpSchedulerLogsLatency", "latency of dump scheduler logs timeouts", "ops", "latency", 10);
        this.getActivitiesLatency = registry.newQuantiles("getActivitiesLatency", "latency of get activities timeouts", "ops", "latency", 10);
        this.getBulkActivitiesLatency = registry.newQuantiles("getBulkActivitiesLatency", "latency of get bulk activities timeouts", "ops", "latency", 10);
        this.getSchedulerInfoRetrievedLatency = registry.newQuantiles("getSchedulerInfoRetrievedLatency", "latency of get scheduler info timeouts", "ops", "latency", 10);
        this.refreshSuperUserGroupsConfLatency = registry.newQuantiles("refreshSuperUserGroupsConfLatency", "latency of refresh superuser groups configuration timeouts", "ops", "latency", 10);
        this.refreshUserToGroupsMappingsLatency = registry.newQuantiles("refreshUserToGroupsMappingsLatency", "latency of refresh user to groups mappings timeouts", "ops", "latency", 10);
        this.refreshDeregisterSubClusterLatency = registry.newQuantiles("refreshDeregisterSubClusterLatency", "latency of deregister subcluster timeouts", "ops", "latency", 10);
        this.saveFederationQueuePolicyLatency = registry.newQuantiles("saveFederationQueuePolicyLatency", "latency of save federation queue policy timeouts", "ops", "latency", 10);
        this.batchSaveFederationQueuePoliciesLatency = registry.newQuantiles("batchSaveFederationQueuePoliciesLatency", "latency of batch save federationqueuepolicies timeouts", "ops", "latency", 10);
        this.listFederationQueuePoliciesLatency = registry.newQuantiles("listFederationQueuePoliciesLatency", "latency of list federationqueuepolicies timeouts", "ops", "latency", 10);
        this.deleteFederationApplicationLatency = registry.newQuantiles("deleteFederationApplicationLatency", "latency of delete FederationApplication timeouts", "ops", "latency", 10);
        this.getFederationSubClustersLatency = registry.newQuantiles("getFederationSubClustersLatency", "latency of get FederationSubClusters timeouts", "ops", "latency", 10);
        this.deleteFederationPoliciesByQueuesLatency = registry.newQuantiles("deleteFederationPoliciesByQueuesLatency", "latency of delete FederationPoliciesByQueues timeouts", "ops", "latency", 10);
        this.refreshAdminAclsLatency = registry.newQuantiles("refreshAdminAclsLatency", "latency of refresh admin acls timeouts", "ops", "latency", 10);
        this.refreshServiceAclsLatency = registry.newQuantiles("refreshServiceAclsLatency", "latency of refresh service acls timeouts", "ops", "latency", 10);
        this.replaceLabelsOnNodesLatency = registry.newQuantiles("replaceLabelsOnNodesLatency", "latency of replace labels on nodes timeouts", "ops", "latency", 10);
        this.replaceLabelsOnNodeLatency = registry.newQuantiles("replaceLabelsOnNodeLatency", "latency of replace labels on node timeouts", "ops", "latency", 10);
        this.addToClusterNodeLabelsLatency = registry.newQuantiles("addToClusterNodeLabelsLatency", "latency of add cluster nodelabels timeouts", "ops", "latency", 10);
        this.removeFromClusterNodeLabelsLatency = registry.newQuantiles("removeFromClusterNodeLabelsLatency", "latency of remove cluster nodelabels timeouts", "ops", "latency", 10);
        this.updateSchedulerConfigLatency = registry.newQuantiles("updateSchedulerConfigurationLatency", "latency of update scheduler configuration timeouts", "ops", "latency", 10);
        this.getSchedulerConfigurationLatency = registry.newQuantiles("getSchedulerConfigurationLatency", "latency of get scheduler configuration timeouts", "ops", "latency", 10);
        this.getClusterInfoLatency = registry.newQuantiles("getClusterInfoLatency", "latency of get cluster info timeouts", "ops", "latency", 10);
        this.getClusterUserInfoLatency = registry.newQuantiles("getClusterUserInfoLatency", "latency of get cluster user info timeouts", "ops", "latency", 10);
        this.updateNodeResourceLatency = registry.newQuantiles("updateNodeResourceLatency", "latency of update node resource timeouts", "ops", "latency", 10);
        this.refreshNodesResourcesLatency = registry.newQuantiles("refreshNodesResourcesLatency", "latency of refresh nodes resources timeouts", "ops", "latency", 10);
        this.checkForDecommissioningNodesLatency = registry.newQuantiles("checkForDecommissioningNodesLatency", "latency of check for decommissioningnodes timeouts", "ops", "latency", 10);
        this.refreshClusterMaxPriorityLatency = registry.newQuantiles("refreshClusterMaxPriorityLatency", "latency of refresh cluster max priority timeouts", "ops", "latency", 10);
        this.mapAttributesToNodesLatency = registry.newQuantiles("mapAttributesToNodesLatency", "latency of map attributes to nodes timeouts", "ops", "latency", 10);
        this.getGroupsForUserLatency = registry.newQuantiles("getGroupsForUserLatency", "latency of get groups for user timeouts", "ops", "latency", 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RouterMetrics getMetrics() {
        if (isInitialized.get()) return instance;
        Class<RouterMetrics> clazz = RouterMetrics.class;
        synchronized (RouterMetrics.class) {
            if (instance != null) return instance;
            instance = (RouterMetrics)DefaultMetricsSystem.instance().register("RouterMetrics", "Metrics for the Yarn Router", (Object)new RouterMetrics());
            isInitialized.set(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @VisibleForTesting
    static synchronized void destroy() {
        isInitialized.set(false);
        instance = null;
    }

    @VisibleForTesting
    public long getNumSucceededAppsCreated() {
        return this.totalSucceededAppsCreated.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededAppsSubmitted() {
        return this.totalSucceededAppsSubmitted.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededAppsKilled() {
        return this.totalSucceededAppsKilled.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededAppsRetrieved() {
        return this.totalSucceededAppsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededAppAttemptsRetrieved() {
        return this.totalSucceededAppAttemptsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededMultipleAppsRetrieved() {
        return this.totalSucceededMultipleAppsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetClusterMetricsRetrieved() {
        return this.totalSucceededGetClusterMetricsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetClusterNodesRetrieved() {
        return this.totalSucceededGetClusterNodesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetNodeToLabelsRetrieved() {
        return this.totalSucceededGetNodeToLabelsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetLabelsToNodesRetrieved() {
        return this.totalSucceededGetLabelsToNodesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetClusterNodeLabelsRetrieved() {
        return this.totalSucceededGetClusterNodeLabelsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededAppAttemptReportRetrieved() {
        return this.totalSucceededAppAttemptReportRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetQueueUserAclsRetrieved() {
        return this.totalSucceededGetQueueUserAclsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetContainerReportRetrieved() {
        return this.totalSucceededGetContainerReportRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetContainersRetrieved() {
        return this.totalSucceededGetContainersRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededListReservationsRetrieved() {
        return this.totalSucceededListReservationsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetResourceTypeInfoRetrieved() {
        return this.totalSucceededGetResourceTypeInfoRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededFailAppAttemptRetrieved() {
        return this.totalSucceededFailAppAttemptRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededUpdateAppPriorityRetrieved() {
        return this.totalSucceededUpdateAppPriorityRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededUpdateAppTimeoutsRetrieved() {
        return this.totalSucceededUpdateAppTimeoutsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededSignalToContainerRetrieved() {
        return this.totalSucceededSignalToContainerRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetQueueInfoRetrieved() {
        return this.totalSucceededGetQueueInfoRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededMoveApplicationAcrossQueuesRetrieved() {
        return this.totalSucceededMoveApplicationAcrossQueuesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetResourceProfilesRetrieved() {
        return this.totalSucceededGetResourceProfilesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetResourceProfileRetrieved() {
        return this.totalSucceededGetResourceProfileRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetAttributesToNodesRetrieved() {
        return this.totalSucceededGetAttributesToNodesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetClusterNodeAttributesRetrieved() {
        return this.totalSucceededGetClusterNodeAttributesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetNodesToAttributesRetrieved() {
        return this.totalSucceededGetNodesToAttributesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetNewReservationRetrieved() {
        return this.totalSucceededGetNewReservationRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededSubmitReservationRetrieved() {
        return this.totalSucceededSubmitReservationRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededUpdateReservationRetrieved() {
        return this.totalSucceededUpdateReservationRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededDeleteReservationRetrieved() {
        return this.totalSucceededDeleteReservationRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededListReservationRetrieved() {
        return this.totalSucceededListReservationRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetAppActivitiesRetrieved() {
        return this.totalSucceededGetAppActivitiesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetAppStatisticsRetrieved() {
        return this.totalSucceededGetAppStatisticsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetAppPriorityRetrieved() {
        return this.totalSucceededGetAppPriorityRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetAppQueueRetrieved() {
        return this.totalSucceededGetAppQueueRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededUpdateAppQueueRetrieved() {
        return this.totalSucceededUpdateAppQueueRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetAppTimeoutRetrieved() {
        return this.totalSucceededGetAppTimeoutRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetAppTimeoutsRetrieved() {
        return this.totalSucceededGetAppTimeoutsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededRefreshQueuesRetrieved() {
        return this.totalSucceededRefreshQueuesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededRefreshNodesRetrieved() {
        return this.totalSucceededRefreshNodesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetRMNodeLabelsRetrieved() {
        return this.totalSucceededGetRMNodeLabelsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededCheckUserAccessToQueueRetrieved() {
        return this.totalSucceededCheckUserAccessToQueueRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetDelegationTokenRetrieved() {
        return this.totalSucceededGetDelegationTokenRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededRenewDelegationTokenRetrieved() {
        return this.totalSucceededRenewDelegationTokenRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededCancelDelegationTokenRetrieved() {
        return this.totalSucceededCancelDelegationTokenRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededDumpSchedulerLogsRetrieved() {
        return this.totalSucceededDumpSchedulerLogsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetActivitiesRetrieved() {
        return this.totalSucceededGetActivitiesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetBulkActivitiesRetrieved() {
        return this.totalSucceededGetBulkActivitiesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetSchedulerInfoRetrieved() {
        return this.totalSucceededGetSchedulerInfoRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededDeregisterSubClusterRetrieved() {
        return this.totalSucceededDeregisterSubClusterRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededSaveFederationQueuePolicyRetrieved() {
        return this.totalSucceededSaveFederationQueuePolicyRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededBatchSaveFederationQueuePoliciesRetrieved() {
        return this.totalSucceededBatchSaveFederationQueuePoliciesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededListFederationQueuePoliciesFailedRetrieved() {
        return this.totalSucceededListFederationQueuePoliciesFailedRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededDeleteFederationApplicationFailedRetrieved() {
        return this.totalSucceededDeleteFederationApplicationFailedRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetFederationSubClustersRetrieved() {
        return this.totalSucceededGetFederationSubClustersRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededDeleteFederationPoliciesByQueuesRetrieved() {
        return this.totalSucceededDeleteFederationPoliciesByQueuesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededRefreshAdminAclsRetrieved() {
        return this.totalSucceededRefreshAdminAclsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededRefreshServiceAclsRetrieved() {
        return this.totalSucceededRefreshServiceAclsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededAddToClusterNodeLabelsRetrieved() {
        return this.totalSucceededAddToClusterNodeLabelsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededRemoveFromClusterNodeLabelsRetrieved() {
        return this.totalSucceededRemoveFromClusterNodeLabelsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededUpdateSchedulerConfigurationRetrieved() {
        return this.totalSucceededUpdateSchedulerConfigurationRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetSchedulerConfigurationRetrieved() {
        return this.totalSucceededGetSchedulerConfigurationRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetClusterInfoRetrieved() {
        return this.totalSucceededGetClusterInfoRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetClusterUserInfoRetrieved() {
        return this.totalSucceededGetClusterUserInfoRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededUpdateNodeResourceRetrieved() {
        return this.totalSucceededUpdateNodeResourceRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededRefreshNodesResourcesRetrieved() {
        return this.totalSucceededRefreshNodesResourcesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededCheckForDecommissioningNodesRetrieved() {
        return this.totalSucceededCheckForDecommissioningNodesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededRefreshClusterMaxPriorityRetrieved() {
        return this.totalSucceededRefreshClusterMaxPriorityRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededMapAttributesToNodesRetrieved() {
        return this.totalSucceededMapAttributesToNodesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededGetGroupsForUsersRetrieved() {
        return this.totalSucceededGetGroupsForUsersRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededRefreshSuperUserGroupsConfigurationRetrieved() {
        return this.totalSucceededRefreshSuperUserGroupsConfigurationRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededReplaceLabelsOnNodesRetrieved() {
        return this.totalSucceededReplaceLabelsOnNodesRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededReplaceLabelsOnNodeRetrieved() {
        return this.totalSucceededReplaceLabelsOnNodeRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public double getLatencySucceededAppsCreated() {
        return this.totalSucceededAppsCreated.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededAppsSubmitted() {
        return this.totalSucceededAppsSubmitted.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededAppsKilled() {
        return this.totalSucceededAppsKilled.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetAppAttemptReport() {
        return this.totalSucceededAppAttemptReportRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetAppReport() {
        return this.totalSucceededAppsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededMultipleGetAppReport() {
        return this.totalSucceededMultipleAppsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetClusterMetricsRetrieved() {
        return this.totalSucceededGetClusterMetricsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetClusterNodesRetrieved() {
        return this.totalSucceededGetClusterNodesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetNodeToLabelsRetrieved() {
        return this.totalSucceededGetNodeToLabelsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetLabelsToNodesRetrieved() {
        return this.totalSucceededGetLabelsToNodesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetClusterNodeLabelsRetrieved() {
        return this.totalSucceededGetClusterNodeLabelsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededAppAttemptRetrieved() {
        return this.totalSucceededAppAttemptsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetQueueUserAclsRetrieved() {
        return this.totalSucceededGetQueueUserAclsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetContainerReportRetrieved() {
        return this.totalSucceededGetContainerReportRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetContainersRetrieved() {
        return this.totalSucceededGetContainersRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededListReservationsRetrieved() {
        return this.totalSucceededListReservationsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetResourceTypeInfoRetrieved() {
        return this.totalSucceededGetResourceTypeInfoRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededFailAppAttemptRetrieved() {
        return this.totalSucceededFailAppAttemptRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededUpdateAppPriorityRetrieved() {
        return this.totalSucceededUpdateAppPriorityRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededUpdateAppTimeoutsRetrieved() {
        return this.totalSucceededUpdateAppTimeoutsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededSignalToContainerRetrieved() {
        return this.totalSucceededSignalToContainerRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetQueueInfoRetrieved() {
        return this.totalSucceededGetQueueInfoRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededMoveApplicationAcrossQueuesRetrieved() {
        return this.totalSucceededMoveApplicationAcrossQueuesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetResourceProfilesRetrieved() {
        return this.totalSucceededGetResourceProfilesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetResourceProfileRetrieved() {
        return this.totalSucceededGetResourceProfileRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetAttributesToNodesRetrieved() {
        return this.totalSucceededGetAttributesToNodesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetClusterNodeAttributesRetrieved() {
        return this.totalSucceededGetClusterNodeAttributesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetNodesToAttributesRetrieved() {
        return this.totalSucceededGetNodesToAttributesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetNewReservationRetrieved() {
        return this.totalSucceededGetNewReservationRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededSubmitReservationRetrieved() {
        return this.totalSucceededSubmitReservationRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededUpdateReservationRetrieved() {
        return this.totalSucceededUpdateReservationRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededDeleteReservationRetrieved() {
        return this.totalSucceededDeleteReservationRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededListReservationRetrieved() {
        return this.totalSucceededListReservationRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetAppActivitiesRetrieved() {
        return this.totalSucceededGetAppActivitiesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetAppStatisticsRetrieved() {
        return this.totalSucceededGetAppStatisticsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetAppPriorityRetrieved() {
        return this.totalSucceededGetAppPriorityRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetAppQueueRetrieved() {
        return this.totalSucceededGetAppQueueRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededUpdateAppQueueRetrieved() {
        return this.totalSucceededUpdateAppQueueRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetAppTimeoutRetrieved() {
        return this.totalSucceededGetAppTimeoutRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetAppTimeoutsRetrieved() {
        return this.totalSucceededGetAppTimeoutsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededRefreshQueuesRetrieved() {
        return this.totalSucceededRefreshQueuesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededRefreshNodesRetrieved() {
        return this.totalSucceededRefreshNodesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetRMNodeLabelsRetrieved() {
        return this.totalSucceededGetRMNodeLabelsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededCheckUserAccessToQueueRetrieved() {
        return this.totalSucceededCheckUserAccessToQueueRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetDelegationTokenRetrieved() {
        return this.totalSucceededGetDelegationTokenRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededRenewDelegationTokenRetrieved() {
        return this.totalSucceededRenewDelegationTokenRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededCancelDelegationTokenRetrieved() {
        return this.totalSucceededCancelDelegationTokenRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededDumpSchedulerLogsRetrieved() {
        return this.totalSucceededDumpSchedulerLogsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetActivitiesRetrieved() {
        return this.totalSucceededGetActivitiesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetBulkActivitiesRetrieved() {
        return this.totalSucceededGetBulkActivitiesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetSchedulerInfoRetrieved() {
        return this.totalSucceededGetSchedulerInfoRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededDeregisterSubClusterRetrieved() {
        return this.totalSucceededDeregisterSubClusterRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededSaveFederationQueuePolicyRetrieved() {
        return this.totalSucceededSaveFederationQueuePolicyRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededBatchSaveFederationQueuePoliciesRetrieved() {
        return this.totalSucceededBatchSaveFederationQueuePoliciesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededListFederationQueuePoliciesRetrieved() {
        return this.totalSucceededListFederationQueuePoliciesFailedRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededDeleteFederationApplicationFailedRetrieved() {
        return this.totalSucceededDeleteFederationApplicationFailedRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetFederationSubClustersRetrieved() {
        return this.totalSucceededGetFederationSubClustersRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededDeleteFederationPoliciesByQueuesRetrieved() {
        return this.totalSucceededDeleteFederationPoliciesByQueuesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededRefreshAdminAclsRetrieved() {
        return this.totalSucceededRefreshAdminAclsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededRefreshServiceAclsRetrieved() {
        return this.totalSucceededRefreshServiceAclsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededAddToClusterNodeLabelsRetrieved() {
        return this.totalSucceededAddToClusterNodeLabelsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededRemoveFromClusterNodeLabelsRetrieved() {
        return this.totalSucceededRemoveFromClusterNodeLabelsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededUpdateSchedulerConfigurationRetrieved() {
        return this.totalSucceededUpdateSchedulerConfigurationRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetSchedulerConfigurationRetrieved() {
        return this.totalSucceededGetSchedulerConfigurationRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetClusterInfoRetrieved() {
        return this.totalSucceededGetClusterInfoRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetClusterUserInfoRetrieved() {
        return this.totalSucceededGetClusterUserInfoRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededUpdateNodeResourceRetrieved() {
        return this.totalSucceededUpdateNodeResourceRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededRefreshNodesResourcesRetrieved() {
        return this.totalSucceededRefreshNodesResourcesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededCheckForDecommissioningNodesRetrieved() {
        return this.totalSucceededCheckForDecommissioningNodesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededRefreshClusterMaxPriorityRetrieved() {
        return this.totalSucceededRefreshClusterMaxPriorityRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededMapAttributesToNodesRetrieved() {
        return this.totalSucceededMapAttributesToNodesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetGroupsForUsersRetrieved() {
        return this.totalSucceededGetGroupsForUsersRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededRefreshSuperUserGroupsConfigurationRetrieved() {
        return this.totalSucceededRefreshSuperUserGroupsConfigurationRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededReplaceLabelsOnNodesRetrieved() {
        return this.totalSucceededReplaceLabelsOnNodesRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededReplaceLabelsOnNodeRetrieved() {
        return this.totalSucceededReplaceLabelsOnNodeRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public int getAppsFailedCreated() {
        return this.numAppsFailedCreated.value();
    }

    @VisibleForTesting
    public int getAppsFailedSubmitted() {
        return this.numAppsFailedSubmitted.value();
    }

    @VisibleForTesting
    public int getAppsFailedKilled() {
        return this.numAppsFailedKilled.value();
    }

    @VisibleForTesting
    public int getAppsFailedRetrieved() {
        return this.numAppsFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getAppAttemptsFailedRetrieved() {
        return this.numAppAttemptsFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getMultipleAppsFailedRetrieved() {
        return this.numMultipleAppsFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getClusterMetricsFailedRetrieved() {
        return this.numGetClusterMetricsFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getClusterNodesFailedRetrieved() {
        return this.numGetClusterNodesFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getNodeToLabelsFailedRetrieved() {
        return this.numGetNodeToLabelsFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getLabelsToNodesFailedRetrieved() {
        return this.numGetLabelsToNodesFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getGetClusterNodeLabelsFailedRetrieved() {
        return this.numGetClusterNodeLabelsFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getAppAttemptReportFailedRetrieved() {
        return this.numAppAttemptReportFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getQueueUserAclsFailedRetrieved() {
        return this.numGetQueueUserAclsFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getContainerReportFailedRetrieved() {
        return this.numGetContainerReportFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getContainersFailedRetrieved() {
        return this.numGetContainersFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getListReservationsFailedRetrieved() {
        return this.numListReservationsFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getGetResourceTypeInfoRetrieved() {
        return this.numGetResourceTypeInfo.value();
    }

    @VisibleForTesting
    public int getFailApplicationAttemptFailedRetrieved() {
        return this.numFailAppAttemptFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getUpdateApplicationPriorityFailedRetrieved() {
        return this.numUpdateAppPriorityFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getUpdateApplicationTimeoutsFailedRetrieved() {
        return this.numUpdateAppTimeoutsFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getSignalToContainerFailedRetrieved() {
        return this.numSignalToContainerFailedRetrieved.value();
    }

    public int getQueueInfoFailedRetrieved() {
        return this.numGetQueueInfoFailedRetrieved.value();
    }

    public int getMoveApplicationAcrossQueuesFailedRetrieved() {
        return this.numMoveApplicationAcrossQueuesFailedRetrieved.value();
    }

    public int getResourceProfilesFailedRetrieved() {
        return this.numGetResourceProfilesFailedRetrieved.value();
    }

    public int getResourceProfileFailedRetrieved() {
        return this.numGetResourceProfileFailedRetrieved.value();
    }

    public int getAttributesToNodesFailedRetrieved() {
        return this.numGetAttributesToNodesFailedRetrieved.value();
    }

    public int getClusterNodeAttributesFailedRetrieved() {
        return this.numGetClusterNodeAttributesFailedRetrieved.value();
    }

    public int getNodesToAttributesFailedRetrieved() {
        return this.numGetNodesToAttributesFailedRetrieved.value();
    }

    public int getNewReservationFailedRetrieved() {
        return this.numGetNewReservationFailedRetrieved.value();
    }

    public int getSubmitReservationFailedRetrieved() {
        return this.numSubmitReservationFailedRetrieved.value();
    }

    public int getUpdateReservationFailedRetrieved() {
        return this.numUpdateReservationFailedRetrieved.value();
    }

    public int getDeleteReservationFailedRetrieved() {
        return this.numDeleteReservationFailedRetrieved.value();
    }

    public int getListReservationFailedRetrieved() {
        return this.numListReservationFailedRetrieved.value();
    }

    public int getAppActivitiesFailedRetrieved() {
        return this.numGetAppActivitiesFailedRetrieved.value();
    }

    public int getAppStatisticsFailedRetrieved() {
        return this.numGetAppStatisticsFailedRetrieved.value();
    }

    public int getAppPriorityFailedRetrieved() {
        return this.numGetAppPriorityFailedRetrieved.value();
    }

    public int getAppQueueFailedRetrieved() {
        return this.numGetAppQueueFailedRetrieved.value();
    }

    public int getUpdateAppQueueFailedRetrieved() {
        return this.numUpdateAppQueueFailedRetrieved.value();
    }

    public int getAppTimeoutFailedRetrieved() {
        return this.numGetAppTimeoutFailedRetrieved.value();
    }

    public int getAppTimeoutsFailedRetrieved() {
        return this.numGetAppTimeoutsFailedRetrieved.value();
    }

    public int getRefreshQueuesFailedRetrieved() {
        return this.numRefreshQueuesFailedRetrieved.value();
    }

    public int getRMNodeLabelsFailedRetrieved() {
        return this.numGetRMNodeLabelsFailedRetrieved.value();
    }

    public int getCheckUserAccessToQueueFailedRetrieved() {
        return this.numCheckUserAccessToQueueFailedRetrieved.value();
    }

    public int getNumRefreshNodesFailedRetrieved() {
        return this.numRefreshNodesFailedRetrieved.value();
    }

    public int getNumRefreshSuperUserGroupsConfigurationFailedRetrieved() {
        return this.numRefreshSuperUserGroupsConfigurationFailedRetrieved.value();
    }

    public int getNumRefreshUserToGroupsMappingsFailedRetrieved() {
        return this.numRefreshUserToGroupsMappingsFailedRetrieved.value();
    }

    public int getDeregisterSubClusterFailedRetrieved() {
        return this.numDeregisterSubClusterFailedRetrieved.value();
    }

    public int getSaveFederationQueuePolicyFailedRetrieved() {
        return this.numSaveFederationQueuePolicyFailedRetrieved.value();
    }

    public int getBatchSaveFederationQueuePoliciesFailedRetrieved() {
        return this.numBatchSaveFederationQueuePoliciesFailedRetrieved.value();
    }

    public int getListFederationQueuePoliciesFailedRetrieved() {
        return this.numListFederationQueuePoliciesFailedRetrieved.value();
    }

    public int getDeleteFederationApplicationFailedRetrieved() {
        return this.numDeleteFederationApplicationFailedRetrieved.value();
    }

    public int getFederationSubClustersFailedRetrieved() {
        return this.numGetFederationSubClustersFailedRetrieved.value();
    }

    public int getDeleteFederationPoliciesByQueuesRetrieved() {
        return this.numDeleteFederationPoliciesByQueuesRetrieved.value();
    }

    public int getNumRefreshAdminAclsFailedRetrieved() {
        return this.numRefreshAdminAclsFailedRetrieved.value();
    }

    public int getNumRefreshServiceAclsFailedRetrieved() {
        return this.numRefreshServiceAclsFailedRetrieved.value();
    }

    public int getNumReplaceLabelsOnNodesFailedRetrieved() {
        return this.numReplaceLabelsOnNodesFailedRetrieved.value();
    }

    public int getNumReplaceLabelsOnNodeFailedRetrieved() {
        return this.numReplaceLabelsOnNodeFailedRetrieved.value();
    }

    public int getNumAddToClusterNodeLabelsFailedRetrieved() {
        return this.numAddToClusterNodeLabelsFailedRetrieved.value();
    }

    public int getNumRemoveFromClusterNodeLabelsFailedRetrieved() {
        return this.numRemoveFromClusterNodeLabelsFailedRetrieved.value();
    }

    public int getUpdateSchedulerConfigurationFailedRetrieved() {
        return this.numUpdateSchedulerConfigurationFailedRetrieved.value();
    }

    public int getSchedulerConfigurationFailedRetrieved() {
        return this.numGetSchedulerConfigurationFailedRetrieved.value();
    }

    public int getClusterInfoFailedRetrieved() {
        return this.numGetClusterInfoFailedRetrieved.value();
    }

    public int getClusterUserInfoFailedRetrieved() {
        return this.numGetClusterUserInfoFailedRetrieved.value();
    }

    public int getUpdateNodeResourceFailedRetrieved() {
        return this.numUpdateNodeResourceFailedRetrieved.value();
    }

    public int getRefreshNodesResourcesFailedRetrieved() {
        return this.numRefreshNodesResourcesFailedRetrieved.value();
    }

    public int getCheckForDecommissioningNodesFailedRetrieved() {
        return this.numCheckForDecommissioningNodesFailedRetrieved.value();
    }

    public int getRefreshClusterMaxPriorityFailedRetrieved() {
        return this.numRefreshClusterMaxPriorityFailedRetrieved.value();
    }

    public int getMapAttributesToNodesFailedRetrieved() {
        return this.numMapAttributesToNodesFailedRetrieved.value();
    }

    public int getGroupsForUserFailedRetrieved() {
        return this.numGetGroupsForUserFailedRetrieved.value();
    }

    public int getDelegationTokenFailedRetrieved() {
        return this.numGetDelegationTokenFailedRetrieved.value();
    }

    public int getRenewDelegationTokenFailedRetrieved() {
        return this.numRenewDelegationTokenFailedRetrieved.value();
    }

    public int getCancelDelegationTokenFailedRetrieved() {
        return this.numCancelDelegationTokenFailedRetrieved.value();
    }

    public int getDumpSchedulerLogsFailedRetrieved() {
        return this.numDumpSchedulerLogsFailedRetrieved.value();
    }

    public int getActivitiesFailedRetrieved() {
        return this.numGetActivitiesFailedRetrieved.value();
    }

    public int getBulkActivitiesFailedRetrieved() {
        return this.numGetBulkActivitiesFailedRetrieved.value();
    }

    public int getSchedulerInfoFailedRetrieved() {
        return this.numGetSchedulerInfoFailedRetrieved.value();
    }

    public void succeededAppsCreated(long duration) {
        this.totalSucceededAppsCreated.add(duration);
        this.getNewApplicationLatency.add(duration);
    }

    public void succeededAppsSubmitted(long duration) {
        this.totalSucceededAppsSubmitted.add(duration);
        this.submitApplicationLatency.add(duration);
    }

    public void succeededAppsKilled(long duration) {
        this.totalSucceededAppsKilled.add(duration);
        this.killApplicationLatency.add(duration);
    }

    public void succeededAppsRetrieved(long duration) {
        this.totalSucceededAppsRetrieved.add(duration);
        this.getApplicationReportLatency.add(duration);
    }

    public void succeededMultipleAppsRetrieved(long duration) {
        this.totalSucceededMultipleAppsRetrieved.add(duration);
        this.getApplicationsReportLatency.add(duration);
    }

    public void succeededAppAttemptsRetrieved(long duration) {
        this.totalSucceededAppAttemptsRetrieved.add(duration);
        this.getApplicationAttemptsLatency.add(duration);
    }

    public void succeededGetClusterMetricsRetrieved(long duration) {
        this.totalSucceededGetClusterMetricsRetrieved.add(duration);
        this.getClusterMetricsLatency.add(duration);
    }

    public void succeededGetClusterNodesRetrieved(long duration) {
        this.totalSucceededGetClusterNodesRetrieved.add(duration);
        this.getClusterNodesLatency.add(duration);
    }

    public void succeededGetNodeToLabelsRetrieved(long duration) {
        this.totalSucceededGetNodeToLabelsRetrieved.add(duration);
        this.getNodeToLabelsLatency.add(duration);
    }

    public void succeededGetLabelsToNodesRetrieved(long duration) {
        this.totalSucceededGetLabelsToNodesRetrieved.add(duration);
        this.getLabelToNodesLatency.add(duration);
    }

    public void succeededGetClusterNodeLabelsRetrieved(long duration) {
        this.totalSucceededGetClusterNodeLabelsRetrieved.add(duration);
        this.getClusterNodeLabelsLatency.add(duration);
    }

    public void succeededAppAttemptReportRetrieved(long duration) {
        this.totalSucceededAppAttemptReportRetrieved.add(duration);
        this.getApplicationAttemptReportLatency.add(duration);
    }

    public void succeededGetQueueUserAclsRetrieved(long duration) {
        this.totalSucceededGetQueueUserAclsRetrieved.add(duration);
        this.getQueueUserAclsLatency.add(duration);
    }

    public void succeededGetContainerReportRetrieved(long duration) {
        this.totalSucceededGetContainerReportRetrieved.add(duration);
        this.getContainerReportLatency.add(duration);
    }

    public void succeededGetContainersRetrieved(long duration) {
        this.totalSucceededGetContainersRetrieved.add(duration);
        this.getContainerLatency.add(duration);
    }

    public void succeededListReservationsRetrieved(long duration) {
        this.totalSucceededListReservationsRetrieved.add(duration);
        this.listReservationsLatency.add(duration);
    }

    public void succeededGetResourceTypeInfoRetrieved(long duration) {
        this.totalSucceededGetResourceTypeInfoRetrieved.add(duration);
        this.listResourceTypeInfoLatency.add(duration);
    }

    public void succeededFailAppAttemptRetrieved(long duration) {
        this.totalSucceededFailAppAttemptRetrieved.add(duration);
        this.failAppAttemptLatency.add(duration);
    }

    public void succeededUpdateAppPriorityRetrieved(long duration) {
        this.totalSucceededUpdateAppPriorityRetrieved.add(duration);
        this.updateAppPriorityLatency.add(duration);
    }

    public void succeededUpdateAppTimeoutsRetrieved(long duration) {
        this.totalSucceededUpdateAppTimeoutsRetrieved.add(duration);
        this.updateAppTimeoutsLatency.add(duration);
    }

    public void succeededSignalToContainerRetrieved(long duration) {
        this.totalSucceededSignalToContainerRetrieved.add(duration);
        this.signalToContainerLatency.add(duration);
    }

    public void succeededGetQueueInfoRetrieved(long duration) {
        this.totalSucceededGetQueueInfoRetrieved.add(duration);
        this.getQueueInfoLatency.add(duration);
    }

    public void succeededMoveApplicationAcrossQueuesRetrieved(long duration) {
        this.totalSucceededMoveApplicationAcrossQueuesRetrieved.add(duration);
        this.moveApplicationAcrossQueuesLatency.add(duration);
    }

    public void succeededGetResourceProfilesRetrieved(long duration) {
        this.totalSucceededGetResourceProfilesRetrieved.add(duration);
        this.getResourceProfilesLatency.add(duration);
    }

    public void succeededGetResourceProfileRetrieved(long duration) {
        this.totalSucceededGetResourceProfileRetrieved.add(duration);
        this.getResourceProfileLatency.add(duration);
    }

    public void succeededGetAttributesToNodesRetrieved(long duration) {
        this.totalSucceededGetAttributesToNodesRetrieved.add(duration);
        this.getAttributesToNodesLatency.add(duration);
    }

    public void succeededGetClusterNodeAttributesRetrieved(long duration) {
        this.totalSucceededGetClusterNodeAttributesRetrieved.add(duration);
        this.getClusterNodeAttributesLatency.add(duration);
    }

    public void succeededGetNodesToAttributesRetrieved(long duration) {
        this.totalSucceededGetNodesToAttributesRetrieved.add(duration);
        this.getNodesToAttributesLatency.add(duration);
    }

    public void succeededGetNewReservationRetrieved(long duration) {
        this.totalSucceededGetNewReservationRetrieved.add(duration);
        this.getNewReservationLatency.add(duration);
    }

    public void succeededSubmitReservationRetrieved(long duration) {
        this.totalSucceededSubmitReservationRetrieved.add(duration);
        this.submitReservationLatency.add(duration);
    }

    public void succeededUpdateReservationRetrieved(long duration) {
        this.totalSucceededUpdateReservationRetrieved.add(duration);
        this.updateReservationLatency.add(duration);
    }

    public void succeededDeleteReservationRetrieved(long duration) {
        this.totalSucceededDeleteReservationRetrieved.add(duration);
        this.deleteReservationLatency.add(duration);
    }

    public void succeededListReservationRetrieved(long duration) {
        this.totalSucceededListReservationRetrieved.add(duration);
        this.listReservationLatency.add(duration);
    }

    public void succeededGetAppActivitiesRetrieved(long duration) {
        this.totalSucceededGetAppActivitiesRetrieved.add(duration);
        this.getAppActivitiesLatency.add(duration);
    }

    public void succeededGetAppStatisticsRetrieved(long duration) {
        this.totalSucceededGetAppStatisticsRetrieved.add(duration);
        this.getAppStatisticsLatency.add(duration);
    }

    public void succeededGetAppPriorityRetrieved(long duration) {
        this.totalSucceededGetAppPriorityRetrieved.add(duration);
        this.getAppPriorityLatency.add(duration);
    }

    public void succeededGetAppQueueRetrieved(long duration) {
        this.totalSucceededGetAppQueueRetrieved.add(duration);
        this.getAppQueueLatency.add(duration);
    }

    public void succeededUpdateAppQueueRetrieved(long duration) {
        this.totalSucceededUpdateAppQueueRetrieved.add(duration);
        this.getUpdateQueueLatency.add(duration);
    }

    public void succeededGetAppTimeoutRetrieved(long duration) {
        this.totalSucceededGetAppTimeoutRetrieved.add(duration);
        this.getAppTimeoutLatency.add(duration);
    }

    public void succeededGetAppTimeoutsRetrieved(long duration) {
        this.totalSucceededGetAppTimeoutsRetrieved.add(duration);
        this.getAppTimeoutsLatency.add(duration);
    }

    public void succeededRefreshQueuesRetrieved(long duration) {
        this.totalSucceededRefreshQueuesRetrieved.add(duration);
        this.refreshQueuesLatency.add(duration);
    }

    public void succeededRefreshNodesRetrieved(long duration) {
        this.totalSucceededRefreshNodesRetrieved.add(duration);
        this.refreshNodesLatency.add(duration);
    }

    public void succeededGetRMNodeLabelsRetrieved(long duration) {
        this.totalSucceededGetRMNodeLabelsRetrieved.add(duration);
        this.getRMNodeLabelsLatency.add(duration);
    }

    public void succeededCheckUserAccessToQueueRetrieved(long duration) {
        this.totalSucceededCheckUserAccessToQueueRetrieved.add(duration);
        this.checkUserAccessToQueueLatency.add(duration);
    }

    public void succeededGetDelegationTokenRetrieved(long duration) {
        this.totalSucceededGetDelegationTokenRetrieved.add(duration);
        this.getDelegationTokenLatency.add(duration);
    }

    public void succeededRenewDelegationTokenRetrieved(long duration) {
        this.totalSucceededRenewDelegationTokenRetrieved.add(duration);
        this.renewDelegationTokenLatency.add(duration);
    }

    public void succeededCancelDelegationTokenRetrieved(long duration) {
        this.totalSucceededCancelDelegationTokenRetrieved.add(duration);
        this.cancelDelegationTokenLatency.add(duration);
    }

    public void succeededDumpSchedulerLogsRetrieved(long duration) {
        this.totalSucceededDumpSchedulerLogsRetrieved.add(duration);
        this.dumpSchedulerLogsLatency.add(duration);
    }

    public void succeededGetActivitiesLatencyRetrieved(long duration) {
        this.totalSucceededGetActivitiesRetrieved.add(duration);
        this.getActivitiesLatency.add(duration);
    }

    public void succeededGetBulkActivitiesRetrieved(long duration) {
        this.totalSucceededGetBulkActivitiesRetrieved.add(duration);
        this.getBulkActivitiesLatency.add(duration);
    }

    public void succeededGetSchedulerInfoRetrieved(long duration) {
        this.totalSucceededGetSchedulerInfoRetrieved.add(duration);
        this.getSchedulerInfoRetrievedLatency.add(duration);
    }

    public void succeededDeregisterSubClusterRetrieved(long duration) {
        this.totalSucceededDeregisterSubClusterRetrieved.add(duration);
        this.refreshDeregisterSubClusterLatency.add(duration);
    }

    public void succeededSaveFederationQueuePolicyRetrieved(long duration) {
        this.totalSucceededSaveFederationQueuePolicyRetrieved.add(duration);
        this.saveFederationQueuePolicyLatency.add(duration);
    }

    public void succeededBatchSaveFederationQueuePoliciesRetrieved(long duration) {
        this.totalSucceededBatchSaveFederationQueuePoliciesRetrieved.add(duration);
        this.batchSaveFederationQueuePoliciesLatency.add(duration);
    }

    public void succeededListFederationQueuePoliciesRetrieved(long duration) {
        this.totalSucceededListFederationQueuePoliciesFailedRetrieved.add(duration);
        this.listFederationQueuePoliciesLatency.add(duration);
    }

    public void succeededDeleteFederationApplicationFailedRetrieved(long duration) {
        this.totalSucceededDeleteFederationApplicationFailedRetrieved.add(duration);
        this.deleteFederationApplicationLatency.add(duration);
    }

    public void succeededGetFederationSubClustersRetrieved(long duration) {
        this.totalSucceededGetFederationSubClustersRetrieved.add(duration);
        this.getFederationSubClustersLatency.add(duration);
    }

    public void succeededDeleteFederationPoliciesByQueuesRetrieved(long duration) {
        this.totalSucceededDeleteFederationPoliciesByQueuesRetrieved.add(duration);
        this.deleteFederationPoliciesByQueuesLatency.add(duration);
    }

    public void succeededRefreshAdminAclsRetrieved(long duration) {
        this.totalSucceededRefreshAdminAclsRetrieved.add(duration);
        this.refreshAdminAclsLatency.add(duration);
    }

    public void succeededRefreshServiceAclsRetrieved(long duration) {
        this.totalSucceededRefreshServiceAclsRetrieved.add(duration);
        this.refreshServiceAclsLatency.add(duration);
    }

    public void succeededAddToClusterNodeLabelsRetrieved(long duration) {
        this.totalSucceededAddToClusterNodeLabelsRetrieved.add(duration);
        this.addToClusterNodeLabelsLatency.add(duration);
    }

    public void succeededRemoveFromClusterNodeLabelsRetrieved(long duration) {
        this.totalSucceededRemoveFromClusterNodeLabelsRetrieved.add(duration);
        this.removeFromClusterNodeLabelsLatency.add(duration);
    }

    public void succeededUpdateSchedulerConfigurationRetrieved(long duration) {
        this.totalSucceededUpdateSchedulerConfigurationRetrieved.add(duration);
        this.updateSchedulerConfigLatency.add(duration);
    }

    public void succeededGetSchedulerConfigurationRetrieved(long duration) {
        this.totalSucceededGetSchedulerConfigurationRetrieved.add(duration);
        this.getSchedulerConfigurationLatency.add(duration);
    }

    public void succeededGetClusterInfoRetrieved(long duration) {
        this.totalSucceededGetClusterInfoRetrieved.add(duration);
        this.getClusterInfoLatency.add(duration);
    }

    public void succeededGetClusterUserInfoRetrieved(long duration) {
        this.totalSucceededGetClusterUserInfoRetrieved.add(duration);
        this.getClusterUserInfoLatency.add(duration);
    }

    public void succeededUpdateNodeResourceRetrieved(long duration) {
        this.totalSucceededUpdateNodeResourceRetrieved.add(duration);
        this.updateNodeResourceLatency.add(duration);
    }

    public void succeededRefreshNodesResourcesRetrieved(long duration) {
        this.totalSucceededRefreshNodesResourcesRetrieved.add(duration);
        this.refreshNodesResourcesLatency.add(duration);
    }

    public void succeededCheckForDecommissioningNodesRetrieved(long duration) {
        this.totalSucceededCheckForDecommissioningNodesRetrieved.add(duration);
        this.checkForDecommissioningNodesLatency.add(duration);
    }

    public void succeededRefreshClusterMaxPriorityRetrieved(long duration) {
        this.totalSucceededRefreshClusterMaxPriorityRetrieved.add(duration);
        this.refreshClusterMaxPriorityLatency.add(duration);
    }

    public void succeededMapAttributesToNodesRetrieved(long duration) {
        this.totalSucceededMapAttributesToNodesRetrieved.add(duration);
        this.mapAttributesToNodesLatency.add(duration);
    }

    public void succeededGetGroupsForUsersRetrieved(long duration) {
        this.totalSucceededGetGroupsForUsersRetrieved.add(duration);
        this.getGroupsForUserLatency.add(duration);
    }

    public void succeededRefreshSuperUserGroupsConfRetrieved(long duration) {
        this.totalSucceededRefreshSuperUserGroupsConfigurationRetrieved.add(duration);
        this.refreshSuperUserGroupsConfLatency.add(duration);
    }

    public void succeededRefreshUserToGroupsMappingsRetrieved(long duration) {
        this.totalSucceededRefreshUserToGroupsMappingsRetrieved.add(duration);
        this.refreshUserToGroupsMappingsLatency.add(duration);
    }

    public void succeededReplaceLabelsOnNodesRetrieved(long duration) {
        this.totalSucceededReplaceLabelsOnNodesRetrieved.add(duration);
        this.replaceLabelsOnNodesLatency.add(duration);
    }

    public void succeededReplaceLabelsOnNodeRetrieved(long duration) {
        this.totalSucceededReplaceLabelsOnNodeRetrieved.add(duration);
        this.replaceLabelsOnNodeLatency.add(duration);
    }

    public void incrAppsFailedCreated() {
        this.numAppsFailedCreated.incr();
    }

    public void incrAppsFailedSubmitted() {
        this.numAppsFailedSubmitted.incr();
    }

    public void incrAppsFailedKilled() {
        this.numAppsFailedKilled.incr();
    }

    public void incrAppsFailedRetrieved() {
        this.numAppsFailedRetrieved.incr();
    }

    public void incrMultipleAppsFailedRetrieved() {
        this.numMultipleAppsFailedRetrieved.incr();
    }

    public void incrAppAttemptsFailedRetrieved() {
        this.numAppAttemptsFailedRetrieved.incr();
    }

    public void incrGetClusterMetricsFailedRetrieved() {
        this.numGetClusterMetricsFailedRetrieved.incr();
    }

    public void incrClusterNodesFailedRetrieved() {
        this.numGetClusterNodesFailedRetrieved.incr();
    }

    public void incrNodeToLabelsFailedRetrieved() {
        this.numGetNodeToLabelsFailedRetrieved.incr();
    }

    public void incrLabelsToNodesFailedRetrieved() {
        this.numGetLabelsToNodesFailedRetrieved.incr();
    }

    public void incrClusterNodeLabelsFailedRetrieved() {
        this.numGetClusterNodeLabelsFailedRetrieved.incr();
    }

    public void incrAppAttemptReportFailedRetrieved() {
        this.numAppAttemptReportFailedRetrieved.incr();
    }

    public void incrQueueUserAclsFailedRetrieved() {
        this.numGetQueueUserAclsFailedRetrieved.incr();
    }

    public void incrGetContainerReportFailedRetrieved() {
        this.numGetContainerReportFailedRetrieved.incr();
    }

    public void incrGetContainersFailedRetrieved() {
        this.numGetContainersFailedRetrieved.incr();
    }

    public void incrListReservationsFailedRetrieved() {
        this.numListReservationsFailedRetrieved.incr();
    }

    public void incrResourceTypeInfoFailedRetrieved() {
        this.numGetResourceTypeInfo.incr();
    }

    public void incrFailAppAttemptFailedRetrieved() {
        this.numFailAppAttemptFailedRetrieved.incr();
    }

    public void incrUpdateAppPriorityFailedRetrieved() {
        this.numUpdateAppPriorityFailedRetrieved.incr();
    }

    public void incrUpdateApplicationTimeoutsRetrieved() {
        this.numUpdateAppTimeoutsFailedRetrieved.incr();
    }

    public void incrSignalToContainerFailedRetrieved() {
        this.numSignalToContainerFailedRetrieved.incr();
    }

    public void incrGetQueueInfoFailedRetrieved() {
        this.numGetQueueInfoFailedRetrieved.incr();
    }

    public void incrMoveApplicationAcrossQueuesFailedRetrieved() {
        this.numMoveApplicationAcrossQueuesFailedRetrieved.incr();
    }

    public void incrGetResourceProfilesFailedRetrieved() {
        this.numGetResourceProfilesFailedRetrieved.incr();
    }

    public void incrGetResourceProfileFailedRetrieved() {
        this.numGetResourceProfileFailedRetrieved.incr();
    }

    public void incrGetAttributesToNodesFailedRetrieved() {
        this.numGetAttributesToNodesFailedRetrieved.incr();
    }

    public void incrGetClusterNodeAttributesFailedRetrieved() {
        this.numGetClusterNodeAttributesFailedRetrieved.incr();
    }

    public void incrGetNodesToAttributesFailedRetrieved() {
        this.numGetNodesToAttributesFailedRetrieved.incr();
    }

    public void incrGetNewReservationFailedRetrieved() {
        this.numGetNewReservationFailedRetrieved.incr();
    }

    public void incrSubmitReservationFailedRetrieved() {
        this.numSubmitReservationFailedRetrieved.incr();
    }

    public void incrUpdateReservationFailedRetrieved() {
        this.numUpdateReservationFailedRetrieved.incr();
    }

    public void incrDeleteReservationFailedRetrieved() {
        this.numDeleteReservationFailedRetrieved.incr();
    }

    public void incrListReservationFailedRetrieved() {
        this.numListReservationFailedRetrieved.incr();
    }

    public void incrGetAppActivitiesFailedRetrieved() {
        this.numGetAppActivitiesFailedRetrieved.incr();
    }

    public void incrGetAppStatisticsFailedRetrieved() {
        this.numGetAppStatisticsFailedRetrieved.incr();
    }

    public void incrGetAppPriorityFailedRetrieved() {
        this.numGetAppPriorityFailedRetrieved.incr();
    }

    public void incrGetAppQueueFailedRetrieved() {
        this.numGetAppQueueFailedRetrieved.incr();
    }

    public void incrUpdateAppQueueFailedRetrieved() {
        this.numUpdateAppQueueFailedRetrieved.incr();
    }

    public void incrGetAppTimeoutFailedRetrieved() {
        this.numGetAppTimeoutFailedRetrieved.incr();
    }

    public void incrGetAppTimeoutsFailedRetrieved() {
        this.numGetAppTimeoutsFailedRetrieved.incr();
    }

    public void incrRefreshQueuesFailedRetrieved() {
        this.numRefreshQueuesFailedRetrieved.incr();
    }

    public void incrGetRMNodeLabelsFailedRetrieved() {
        this.numGetRMNodeLabelsFailedRetrieved.incr();
    }

    public void incrCheckUserAccessToQueueFailedRetrieved() {
        this.numCheckUserAccessToQueueFailedRetrieved.incr();
    }

    public void incrRefreshNodesFailedRetrieved() {
        this.numRefreshNodesFailedRetrieved.incr();
    }

    public void incrRefreshSuperUserGroupsConfigurationFailedRetrieved() {
        this.numRefreshSuperUserGroupsConfigurationFailedRetrieved.incr();
    }

    public void incrRefreshUserToGroupsMappingsFailedRetrieved() {
        this.numRefreshUserToGroupsMappingsFailedRetrieved.incr();
    }

    public void incrDeregisterSubClusterFailedRetrieved() {
        this.numDeregisterSubClusterFailedRetrieved.incr();
    }

    public void incrSaveFederationQueuePolicyFailedRetrieved() {
        this.numSaveFederationQueuePolicyFailedRetrieved.incr();
    }

    public void incrBatchSaveFederationQueuePoliciesFailedRetrieved() {
        this.numBatchSaveFederationQueuePoliciesFailedRetrieved.incr();
    }

    public void incrListFederationQueuePoliciesFailedRetrieved() {
        this.numListFederationQueuePoliciesFailedRetrieved.incr();
    }

    public void incrDeleteFederationApplicationFailedRetrieved() {
        this.numDeleteFederationApplicationFailedRetrieved.incr();
    }

    public void incrGetFederationSubClustersFailedRetrieved() {
        this.numGetFederationSubClustersFailedRetrieved.incr();
    }

    public void incrDeleteFederationPoliciesByQueuesRetrieved() {
        this.numDeleteFederationPoliciesByQueuesRetrieved.incr();
    }

    public void incrRefreshAdminAclsFailedRetrieved() {
        this.numRefreshAdminAclsFailedRetrieved.incr();
    }

    public void incrRefreshServiceAclsFailedRetrieved() {
        this.numRefreshServiceAclsFailedRetrieved.incr();
    }

    public void incrAddToClusterNodeLabelsFailedRetrieved() {
        this.numAddToClusterNodeLabelsFailedRetrieved.incr();
    }

    public void incrRemoveFromClusterNodeLabelsFailedRetrieved() {
        this.numRemoveFromClusterNodeLabelsFailedRetrieved.incr();
    }

    public void incrUpdateSchedulerConfigurationFailedRetrieved() {
        this.numUpdateSchedulerConfigurationFailedRetrieved.incr();
    }

    public void incrGetSchedulerConfigurationFailedRetrieved() {
        this.numGetSchedulerConfigurationFailedRetrieved.incr();
    }

    public void incrGetClusterInfoFailedRetrieved() {
        this.numGetClusterInfoFailedRetrieved.incr();
    }

    public void incrGetClusterUserInfoFailedRetrieved() {
        this.numGetClusterUserInfoFailedRetrieved.incr();
    }

    public void incrUpdateNodeResourceFailedRetrieved() {
        this.numUpdateNodeResourceFailedRetrieved.incr();
    }

    public void incrRefreshNodesResourcesFailedRetrieved() {
        this.numRefreshNodesResourcesFailedRetrieved.incr();
    }

    public void incrCheckForDecommissioningNodesFailedRetrieved() {
        this.numCheckForDecommissioningNodesFailedRetrieved.incr();
    }

    public void incrRefreshClusterMaxPriorityFailedRetrieved() {
        this.numRefreshClusterMaxPriorityFailedRetrieved.incr();
    }

    public void incrMapAttributesToNodesFailedRetrieved() {
        this.numMapAttributesToNodesFailedRetrieved.incr();
    }

    public void incrGetGroupsForUserFailedRetrieved() {
        this.numGetGroupsForUserFailedRetrieved.incr();
    }

    public void incrGetDelegationTokenFailedRetrieved() {
        this.numGetDelegationTokenFailedRetrieved.incr();
    }

    public void incrRenewDelegationTokenFailedRetrieved() {
        this.numRenewDelegationTokenFailedRetrieved.incr();
    }

    public void incrCancelDelegationTokenFailedRetrieved() {
        this.numCancelDelegationTokenFailedRetrieved.incr();
    }

    public void incrReplaceLabelsOnNodesFailedRetrieved() {
        this.numReplaceLabelsOnNodesFailedRetrieved.incr();
    }

    public void incrReplaceLabelsOnNodeFailedRetrieved() {
        this.numReplaceLabelsOnNodeFailedRetrieved.incr();
    }

    public void incrDumpSchedulerLogsFailedRetrieved() {
        this.numDumpSchedulerLogsFailedRetrieved.incr();
    }

    public void incrGetActivitiesFailedRetrieved() {
        this.numGetActivitiesFailedRetrieved.incr();
    }

    public void incrGetBulkActivitiesFailedRetrieved() {
        this.numGetBulkActivitiesFailedRetrieved.incr();
    }

    public void incrGetSchedulerInfoFailedRetrieved() {
        this.numGetSchedulerInfoFailedRetrieved.incr();
    }
}

