/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.annotations;

import org.apache.hadoop.shaded.org.eclipse.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.apache.hadoop.shaded.org.eclipse.jetty.annotations.AnnotationParser;
import org.apache.hadoop.shaded.org.eclipse.jetty.annotations.WebFilterAnnotation;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.WebAppContext;

public class WebFilterAnnotationHandler
extends AbstractDiscoverableAnnotationHandler {
    private static final Logger LOG = Log.getLogger(WebFilterAnnotationHandler.class);

    public WebFilterAnnotationHandler(WebAppContext context) {
        super(context);
    }

    @Override
    public void handle(AnnotationParser.ClassInfo info, String annotationName) {
        if (annotationName == null || !"org.apache.hadoop.shaded.javax.servlet.annotation.WebFilter".equals(annotationName)) {
            return;
        }
        WebFilterAnnotation wfAnnotation = new WebFilterAnnotation(this._context, info.getClassName(), info.getContainingResource());
        this.addAnnotation(wfAnnotation);
    }

    @Override
    public void handle(AnnotationParser.FieldInfo info, String annotationName) {
        if (annotationName == null || !"org.apache.hadoop.shaded.javax.servlet.annotation.WebFilter".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebFilter not applicable for fields: " + info.getClassInfo().getClassName() + "." + info.getFieldName(), new Object[0]);
    }

    @Override
    public void handle(AnnotationParser.MethodInfo info, String annotationName) {
        if (annotationName == null || !"org.apache.hadoop.shaded.javax.servlet.annotation.WebFilter".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebFilter not applicable for methods: " + info.getClassInfo().getClassName() + "." + info.getMethodName() + " " + info.getSignature(), new Object[0]);
    }
}

