/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Exchanger;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.io.ByteStreams;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureCleanup {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureCleanup.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestProcedureCleanup.class);
    private static final int PROCEDURE_EXECUTOR_SLOTS = 2;
    private static WALProcedureStore procStore;
    private static ProcedureExecutor<Void> procExecutor;
    private static HBaseCommonTestingUtility htu;
    private static FileSystem fs;
    private static Path testDir;
    private static Path logDir;
    @Rule
    public final TestName name = new TestName();

    private void createProcExecutor() throws Exception {
        logDir = new Path(testDir, this.name.getMethodName());
        procStore = ProcedureTestingUtility.createWalStore(htu.getConfiguration(), logDir);
        procExecutor = new ProcedureExecutor(htu.getConfiguration(), null, (ProcedureStore)procStore);
        procStore.start(2);
        ProcedureTestingUtility.initAndStartWorkers(procExecutor, 2, true, true);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        htu = new HBaseCommonTestingUtility();
        htu.getConfiguration().setBoolean("hbase.procedure.store.wal.exec.cleanup.on.load", true);
        testDir = htu.getDataTestDir();
        fs = testDir.getFileSystem(htu.getConfiguration());
        Assert.assertTrue((testDir.depth() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testProcedureShouldNotCleanOnLoad() throws Exception {
        this.createProcExecutor();
        RootProcedure proc = new RootProcedure();
        long rootProc = procExecutor.submitProcedure((Procedure)proc);
        LOG.info("Begin to execute " + rootProc);
        htu.waitFor(10000L, () -> procExecutor.getProcedures().size() >= 2);
        SuspendProcedure suspendProcedure = (SuspendProcedure)((Object)procExecutor.getProcedures().get(1));
        suspendProcedure.latch.countDown();
        Thread.sleep(100L);
        LOG.info("Begin to roll log ");
        procStore.rollWriterForTesting();
        LOG.info("finish to roll log ");
        Thread.sleep(500L);
        LOG.info("begin to restart1 ");
        ProcedureTestingUtility.restart(procExecutor, true);
        LOG.info("finish to restart1 ");
        Assert.assertTrue((procExecutor.getProcedure(rootProc) != null ? 1 : 0) != 0);
        Thread.sleep(500L);
        LOG.info("begin to restart2 ");
        ProcedureTestingUtility.restart(procExecutor, true);
        LOG.info("finish to restart2 ");
        Assert.assertTrue((procExecutor.getProcedure(rootProc) != null ? 1 : 0) != 0);
    }

    @Test
    public void testProcedureUpdatedShouldClean() throws Exception {
        this.createProcExecutor();
        SuspendProcedure suspendProcedure = new SuspendProcedure();
        long suspendProc = procExecutor.submitProcedure((Procedure)suspendProcedure);
        LOG.info("Begin to execute " + suspendProc);
        suspendProcedure.latch.countDown();
        Thread.sleep(500L);
        LOG.info("begin to restart1 ");
        ProcedureTestingUtility.restart(procExecutor, true);
        LOG.info("finish to restart1 ");
        htu.waitFor(10000L, () -> procExecutor.getProcedure(suspendProc) != null);
        suspendProcedure = (SuspendProcedure)procExecutor.getProcedure(suspendProc);
        suspendProcedure.latch.countDown();
        Thread.sleep(500L);
        Assert.assertTrue((procStore.getActiveLogs().size() == 1 ? 1 : 0) != 0);
        LOG.info("begin to restart2");
        ProcedureTestingUtility.restart(procExecutor, true, false);
        LOG.info("finish to restart2");
        Assert.assertTrue((procStore.getActiveLogs().size() == 2 ? 1 : 0) != 0);
        procExecutor.startWorkers();
    }

    @Test
    public void testProcedureDeletedShouldClean() throws Exception {
        this.createProcExecutor();
        WaitProcedure waitProcedure = new WaitProcedure();
        long waitProce = procExecutor.submitProcedure((Procedure)waitProcedure);
        LOG.info("Begin to execute " + waitProce);
        Thread.sleep(500L);
        LOG.info("begin to restart1 ");
        ProcedureTestingUtility.restart(procExecutor, true);
        LOG.info("finish to restart1 ");
        htu.waitFor(10000L, () -> procExecutor.getProcedure(waitProce) != null);
        waitProcedure = (WaitProcedure)procExecutor.getProcedure(waitProce);
        waitProcedure.latch.countDown();
        Thread.sleep(500L);
        Assert.assertTrue((procStore.getActiveLogs().size() == 1 ? 1 : 0) != 0);
        LOG.info("begin to restart2");
        ProcedureTestingUtility.restart(procExecutor, true, false);
        LOG.info("finish to restart2");
        Assert.assertTrue((procStore.getActiveLogs().size() == 2 ? 1 : 0) != 0);
        procExecutor.startWorkers();
    }

    private void corrupt(FileStatus file) throws IOException {
        LOG.info("Corrupt " + file);
        Path tmpFile = file.getPath().suffix(".tmp");
        try (FSDataInputStream in = fs.open(file.getPath());
             FSDataOutputStream out = fs.create(tmpFile);){
            ByteStreams.copy((InputStream)ByteStreams.limit((InputStream)in, (long)(file.getLen() - 1L)), (OutputStream)out);
        }
        fs.delete(file.getPath(), false);
        fs.rename(tmpFile, file.getPath());
    }

    @Test
    public void testResetDeleteWhenBuildingHoldingCleanupTracker() throws Exception {
        this.createProcExecutor();
        ExchangeProcedure proc1 = new ExchangeProcedure();
        ExchangeProcedure proc2 = new ExchangeProcedure();
        procExecutor.submitProcedure((Procedure)proc1);
        long procId2 = procExecutor.submitProcedure((Procedure)proc2);
        Thread.sleep(500L);
        procStore.rollWriterForTesting();
        proc1.exchanger.exchange(Boolean.TRUE);
        Thread.sleep(500L);
        FileStatus[] walFiles = fs.listStatus(logDir);
        Arrays.sort(walFiles, (f1, f2) -> f1.getPath().getName().compareTo(f2.getPath().getName()));
        this.corrupt(walFiles[0]);
        ProcedureTestingUtility.restart(procExecutor, false, true);
        proc2 = (ExchangeProcedure)procExecutor.getProcedure(procId2);
        proc2.exchanger.exchange(Boolean.TRUE);
        htu.waitFor(10000L, () -> !fs.exists(walFiles[0].getPath()));
    }

    public static class RootProcedure
    extends ProcedureTestingUtility.NoopProcedure<Void> {
        private boolean childSpwaned = false;

        @Override
        protected Procedure<Void>[] execute(Void env) throws ProcedureSuspendedException {
            if (!this.childSpwaned) {
                this.childSpwaned = true;
                return new Procedure[]{new SuspendProcedure()};
            }
            return null;
        }
    }

    public static class SuspendProcedure
    extends ProcedureTestingUtility.NoopProcedure<Void> {
        private CountDownLatch latch = new CountDownLatch(1);

        @Override
        protected Procedure<Void>[] execute(Void env) throws ProcedureSuspendedException {
            LOG.info("suspend here");
            this.latch.countDown();
            throw new ProcedureSuspendedException();
        }
    }

    public static class WaitProcedure
    extends ProcedureTestingUtility.NoopProcedure<Void> {
        private CountDownLatch latch = new CountDownLatch(1);

        @Override
        protected Procedure<Void>[] execute(Void env) throws ProcedureSuspendedException {
            LOG.info("wait here");
            try {
                this.latch.await();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOG.info("finished");
            return null;
        }
    }

    public static final class ExchangeProcedure
    extends ProcedureTestingUtility.NoopProcedure<Void> {
        private final Exchanger<Boolean> exchanger = new Exchanger();

        @Override
        protected Procedure<Void>[] execute(Void env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            if (this.exchanger.exchange(Boolean.TRUE).booleanValue()) {
                return new Procedure[]{this};
            }
            return null;
        }
    }
}

