/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class QuotaRetriever
implements Closeable,
Iterable<QuotaSettings> {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaRetriever.class);
    private final Queue<QuotaSettings> cache = new ArrayDeque<QuotaSettings>();
    private ResultScanner scanner;
    private Connection connection;
    private Table table;
    private final boolean isManagedConnection;

    public QuotaRetriever(Connection conn) throws IOException {
        this(conn, (QuotaFilter)null);
    }

    public QuotaRetriever(Connection conn, QuotaFilter filter) throws IOException {
        this(conn, QuotaTableUtil.makeScan(filter));
    }

    public QuotaRetriever(Connection conn, Scan scan) throws IOException {
        this.isManagedConnection = false;
        this.init(conn, scan);
    }

    QuotaRetriever(Configuration conf, Scan scan) throws IOException {
        this.isManagedConnection = true;
        this.init(ConnectionFactory.createConnection(conf), scan);
    }

    private void init(Connection conn, Scan scan) throws IOException {
        this.connection = Objects.requireNonNull(conn);
        this.table = this.connection.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
        try {
            this.scanner = this.table.getScanner(scan);
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException ioe) {
                LOG.warn("Failed getting scanner and then failed close on cleanup", (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.table != null) {
            this.table.close();
            this.table = null;
        }
        if (this.isManagedConnection && this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    public QuotaSettings next() throws IOException {
        if (this.cache.isEmpty()) {
            Result result = this.scanner.next();
            if (result != null && Bytes.equals(result.getRow(), QuotaTableUtil.getExceedThrottleQuotaRowKey())) {
                result = this.scanner.next();
            }
            if (result == null) {
                return null;
            }
            QuotaTableUtil.parseResultToCollection(result, this.cache);
        }
        return this.cache.poll();
    }

    @Override
    public Iterator<QuotaSettings> iterator() {
        return new Iter();
    }

    @Deprecated
    public static QuotaRetriever open(Configuration conf) throws IOException {
        return QuotaRetriever.open(conf, null);
    }

    @Deprecated
    public static QuotaRetriever open(Configuration conf, QuotaFilter filter) throws IOException {
        Scan scan = QuotaTableUtil.makeScan(filter);
        return new QuotaRetriever(conf, scan);
    }

    private class Iter
    implements Iterator<QuotaSettings> {
        QuotaSettings cache;

        public Iter() {
            try {
                this.cache = QuotaRetriever.this.next();
            }
            catch (IOException e) {
                LOG.warn(StringUtils.stringifyException((Throwable)e));
            }
        }

        @Override
        public boolean hasNext() {
            return this.cache != null;
        }

        @Override
        public QuotaSettings next() {
            QuotaSettings result = this.cache;
            try {
                this.cache = QuotaRetriever.this.next();
            }
            catch (IOException e) {
                LOG.warn(StringUtils.stringifyException((Throwable)e));
            }
            return result;
        }

        @Override
        public void remove() {
            throw new RuntimeException("remove() not supported");
        }
    }
}

