/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.api.records;

import java.text.NumberFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;

public abstract class JobId
implements Comparable<JobId> {
    protected static final String JOB = "job";
    protected static final char SEPARATOR = '_';
    static final ThreadLocal<NumberFormat> jobIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(4);
            return fmt;
        }
    };

    public abstract ApplicationId getAppId();

    public abstract int getId();

    public abstract void setAppId(ApplicationId var1);

    public abstract void setId(int var1);

    public String toString() {
        StringBuilder builder = new StringBuilder(JOB);
        builder.append('_');
        builder.append(this.getAppId().getClusterTimestamp());
        builder.append('_');
        builder.append(jobIdFormat.get().format(this.getId()));
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getAppId().hashCode();
        result = 31 * result + this.getId();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobId other = (JobId)obj;
        if (!this.getAppId().equals((Object)other.getAppId())) {
            return false;
        }
        return this.getId() == other.getId();
    }

    @Override
    public int compareTo(JobId other) {
        int appIdComp = this.getAppId().compareTo(other.getAppId());
        if (appIdComp == 0) {
            return this.getId() - other.getId();
        }
        return appIdComp;
    }
}

