/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum RubyEvent {
    LINE("line"),
    CLASS("class", false),
    END("end", false),
    CALL("call"),
    RETURN("return"),
    C_CALL("c_call"),
    C_RETURN("c_return"),
    B_CALL("b_call"),
    B_RETURN("b_return"),
    THREAD_BEGIN("thread_begin"),
    THREAD_END("thread_end"),
    RAISE("raise"),
    COVERAGE("coverage"),
    A_CALL("a_call"),
    A_RETURN("a_return");

    public static Set<RubyEvent> ALL_EVENTS;
    public static EnumSet ALL_EVENTS_ENUMSET;
    private final String event_name;
    private final boolean requiresDebug;
    private static final Map<String, RubyEvent> fromName;

    private RubyEvent(String event_name) {
        this(event_name, true);
    }

    private RubyEvent(String event_name, boolean requiresDebug) {
        this.event_name = event_name;
        this.requiresDebug = requiresDebug;
    }

    @Deprecated
    public int getLineNumberOffset() {
        return 0;
    }

    public String getName() {
        return this.event_name;
    }

    public static RubyEvent fromOrdinal(int value2) {
        return value2 < 0 || value2 >= RubyEvent.values().length ? null : RubyEvent.values()[value2];
    }

    public static RubyEvent fromName(String name2) {
        return fromName.get(name2);
    }

    public boolean requiresDebug() {
        return this.requiresDebug;
    }

    static {
        ALL_EVENTS = Collections.synchronizedSet(EnumSet.allOf(RubyEvent.class));
        ALL_EVENTS_ENUMSET = EnumSet.copyOf(ALL_EVENTS);
        fromName = new HashMap<String, RubyEvent>();
        for (RubyEvent event2 : RubyEvent.values()) {
            fromName.put(event2.getName(), event2);
        }
    }
}

