/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.metrics.ScanMetricsRegionInfo;
import org.apache.hadoop.hbase.client.metrics.ScanMetricsUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionScanMetricsData {
    private final Map<String, AtomicLong> counters = new HashMap<String, AtomicLong>();
    private ScanMetricsRegionInfo scanMetricsRegionInfo = ScanMetricsRegionInfo.EMPTY_SCAN_METRICS_REGION_INFO;

    AtomicLong createCounter(String counterName) {
        return ScanMetricsUtil.createCounter(this.counters, counterName);
    }

    void setCounter(String counterName, long value) {
        ScanMetricsUtil.setCounter(this.counters, counterName, value);
    }

    void addToCounter(String counterName, long delta) {
        ScanMetricsUtil.addToCounter(this.counters, counterName, delta);
    }

    Map<String, Long> collectMetrics(boolean reset) {
        return ScanMetricsUtil.collectMetrics(this.counters, reset);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.scanMetricsRegionInfo + ",Counters=" + this.counters + "]";
    }

    void initScanMetricsRegionInfo(String encodedRegionName, ServerName serverName) {
        if (this.scanMetricsRegionInfo != ScanMetricsRegionInfo.EMPTY_SCAN_METRICS_REGION_INFO) {
            throw new UnsupportedOperationException("ScanMetricsRegionInfo has already been initialized to " + this.scanMetricsRegionInfo + " and cannot be re-initialized to region: " + encodedRegionName + " and server: " + serverName);
        }
        this.scanMetricsRegionInfo = new ScanMetricsRegionInfo(encodedRegionName, serverName);
    }

    ScanMetricsRegionInfo getScanMetricsRegionInfo() {
        return this.scanMetricsRegionInfo;
    }
}

