/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.MemoryConfiguration;
import io.questdb.std.Os;

public class MemoryConfigurationImpl
implements MemoryConfiguration {
    private final long configuredLimitBytes;
    private final long configuredLimitPercent;
    private final long ramUsageLimit;
    private final long totalSystemMemory;

    public MemoryConfigurationImpl(long configuredLimitBytes, long configuredLimitPercent) {
        this.configuredLimitBytes = configuredLimitBytes;
        this.configuredLimitPercent = configuredLimitPercent;
        this.totalSystemMemory = Os.getMemorySizeFromMXBean();
        assert (this.totalSystemMemory >= -1L) : "Os.getMemorySizeFromMXBean() reported negative memory size";
        this.ramUsageLimit = MemoryConfigurationImpl.resolveRamUsageLimit(configuredLimitBytes, configuredLimitPercent, this.totalSystemMemory);
    }

    public static long resolveRamUsageLimit(long configuredLimitBytes, long configuredLimitPercent, long totalSystemMemory) {
        long limitByPercent;
        long l = limitByPercent = totalSystemMemory != -1L ? totalSystemMemory / 100L * configuredLimitPercent : 0L;
        return configuredLimitBytes == 0L ? limitByPercent : (limitByPercent == 0L ? configuredLimitBytes : Math.min(configuredLimitBytes, limitByPercent));
    }

    @Override
    public long getRamUsageLimitBytes() {
        return this.configuredLimitBytes;
    }

    @Override
    public long getRamUsageLimitPercent() {
        return this.configuredLimitPercent;
    }

    @Override
    public long getResolvedRamUsageLimitBytes() {
        return this.ramUsageLimit;
    }

    @Override
    public long getTotalSystemMemory() {
        return this.totalSystemMemory;
    }
}

