/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.BuildInformation;
import io.questdb.ConfigPropertyKey;
import io.questdb.ConfigPropertyValue;
import io.questdb.FactoryProvider;
import io.questdb.Metrics;
import io.questdb.TelemetryConfiguration;
import io.questdb.VolumeDefinitions;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.std.FilesFacade;
import io.questdb.std.IOURingFacade;
import io.questdb.std.IOURingFacadeImpl;
import io.questdb.std.NanosecondClock;
import io.questdb.std.NanosecondClockImpl;
import io.questdb.std.ObjObjHashMap;
import io.questdb.std.Rnd;
import io.questdb.std.RostiAllocFacade;
import io.questdb.std.RostiAllocFacadeImpl;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.datetime.millitime.MillisecondClockImpl;
import io.questdb.std.str.CharSink;
import java.util.Map;
import java.util.function.LongSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CairoConfiguration {
    public static final int O_ASYNC = 64;
    public static final int O_DIRECT = 16384;
    public static final int O_NONE = 0;
    public static final int O_SYNC = 128;
    public static final ThreadLocal<Rnd> RANDOM = new ThreadLocal();

    public boolean attachPartitionCopy();

    default public boolean disableColumnPurgeJob() {
        return false;
    }

    public boolean enableTestFactories();

    default public boolean exportConfiguration(CharSink<?> sink) {
        return false;
    }

    default public boolean freeLeakedReaders() {
        return true;
    }

    @Nullable
    default public ObjObjHashMap<ConfigPropertyKey, ConfigPropertyValue> getAllPairs() {
        return null;
    }

    public boolean getAllowTableRegistrySharedWrite();

    @NotNull
    default public String getArchivedCrashFilePrefix() {
        return "crash+";
    }

    @NotNull
    public String getAttachPartitionSuffix();

    public DateFormat getBackupDirTimestampFormat();

    public int getBackupMkDirMode();

    public CharSequence getBackupRoot();

    public CharSequence getBackupTempDirName();

    public int getBinaryEncodingMaxLength();

    public int getBindVariablePoolSize();

    @NotNull
    public BuildInformation getBuildInformation();

    public boolean getCairoSqlLegacyOperatorPrecedence();

    @NotNull
    public CharSequence getCheckpointRoot();

    @NotNull
    public SqlExecutionCircuitBreakerConfiguration getCircuitBreakerConfiguration();

    public int getColumnAliasGeneratedMaxSize();

    public int getColumnIndexerQueueCapacity();

    public int getColumnPurgeQueueCapacity();

    public long getColumnPurgeRetryDelay();

    public long getColumnPurgeRetryDelayLimit();

    public double getColumnPurgeRetryDelayMultiplier();

    public int getColumnPurgeTaskPoolCapacity();

    public long getCommitLatency();

    public int getCommitMode();

    @NotNull
    public CharSequence getConfRoot();

    @NotNull
    public LongSupplier getCopyIDSupplier();

    public int getCopyPoolCapacity();

    public int getCountDistinctCapacity();

    public double getCountDistinctLoadFactor();

    public int getCreateAsSelectRetryCount();

    public int getCreateTableColumnModelPoolCapacity();

    public long getCreateTableModelBatchSize();

    public long getDataAppendPageSize();

    public long getDataIndexKeyAppendPageSize();

    public long getDataIndexValueAppendPageSize();

    public long getDatabaseIdHi();

    public long getDatabaseIdLo();

    @NotNull
    public CharSequence getDbDirectory();

    @NotNull
    public String getDbRoot();

    public boolean getDebugWalApplyBlockFailureNoRetry();

    @NotNull
    public DateLocale getDefaultDateLocale();

    public int getDefaultSeqPartTxnCount();

    public boolean getDefaultSymbolCacheFlag();

    public int getDefaultSymbolCapacity();

    public int getDetachedMkDirMode();

    default public Map<String, String> getEnv() {
        return System.getenv();
    }

    public int getExplainPoolCapacity();

    @NotNull
    public FactoryProvider getFactoryProvider();

    public int getFileOperationRetryCount();

    public boolean getFileDescriptorCacheEnabled();

    @NotNull
    public FilesFacade getFilesFacade();

    public long getGroupByAllocatorDefaultChunkSize();

    public long getGroupByAllocatorMaxChunkSize();

    public int getGroupByMapCapacity();

    public int getGroupByMergeShardQueueCapacity();

    public int getGroupByPoolCapacity();

    public long getGroupByPresizeMaxCapacity();

    public long getGroupByPresizeMaxHeapSize();

    public int getGroupByShardingThreshold();

    @NotNull
    default public IOURingFacade getIOURingFacade() {
        return IOURingFacadeImpl.INSTANCE;
    }

    public int getIdGenerateBatchStep();

    public long getIdleCheckInterval();

    public int getInactiveReaderMaxOpenPartitions();

    public long getInactiveReaderTTL();

    public long getInactiveWalWriterTTL();

    public long getInactiveWriterTTL();

    public int getIndexValueBlockSize();

    public long getInsertModelBatchSize();

    public int getInsertModelPoolCapacity();

    @NotNull
    public String getInstallRoot();

    public int getLatestByQueueCapacity();

    @NotNull
    public CharSequence getLegacyCheckpointRoot();

    public boolean getLogLevelVerbose();

    public boolean getLogSqlQueryProgressExe();

    public DateFormat getLogTimestampFormat();

    public String getLogTimestampTimezone();

    public DateLocale getLogTimestampTimezoneLocale();

    public TimeZoneRules getLogTimestampTimezoneRules();

    public long getMatViewInsertAsSelectBatchSize();

    public int getMatViewMaxRefreshIntervals();

    public int getMatViewMaxRefreshRetries();

    public long getMatViewRefreshIntervalsUpdatePeriod();

    public long getMatViewRefreshOomRetryTimeout();

    public int getMatViewRowsPerQueryEstimate();

    public int getMaxCrashFiles();

    public int getMaxFileNameLength();

    public int getMaxSqlRecompileAttempts();

    public int getMaxSwapFileCount();

    public int getMaxSymbolNotEqualsCount();

    public int getMaxUncommittedRows();

    public int getMetadataPoolCapacity();

    public Metrics getMetrics();

    @NotNull
    default public MicrosecondClock getMicrosecondClock() {
        return MicrosecondClockImpl.INSTANCE;
    }

    @NotNull
    default public MillisecondClock getMillisecondClock() {
        return MillisecondClockImpl.INSTANCE;
    }

    public long getMiscAppendPageSize();

    public int getMkDirMode();

    @NotNull
    default public NanosecondClock getNanosecondClock() {
        return NanosecondClockImpl.INSTANCE;
    }

    public int getO3CallbackQueueCapacity();

    public int getO3ColumnMemorySize();

    public int getO3CopyQueueCapacity();

    public int getO3LagCalculationWindowsSize();

    default public double getO3LagDecreaseFactor() {
        return 0.5;
    }

    default public double getO3LagIncreaseFactor() {
        return 1.5;
    }

    public int getO3LastPartitionMaxSplits();

    public long getO3MaxLag();

    public int getO3MemMaxPages();

    public long getO3MinLag();

    public int getO3OpenColumnQueueCapacity();

    public int getO3PartitionQueueCapacity();

    public int getO3PurgeDiscoveryQueueCapacity();

    @NotNull
    default public String getOGCrashFilePrefix() {
        return "hs_err_pid+";
    }

    public int getPageFrameReduceColumnListCapacity();

    public int getPageFrameReduceQueueCapacity();

    public int getPageFrameReduceRowIdListCapacity();

    public int getPageFrameReduceShardCount();

    public int getParallelIndexThreshold();

    public int getPartitionEncoderParquetCompressionCodec();

    public int getPartitionEncoderParquetCompressionLevel();

    public int getPartitionEncoderParquetDataPageSize();

    public int getPartitionEncoderParquetRowGroupSize();

    public int getPartitionEncoderParquetVersion();

    public long getPartitionO3SplitMinSize();

    public int getPartitionPurgeListCapacity();

    public int getPreferencesStringPoolCapacity();

    public int getQueryCacheEventQueueCapacity();

    public int getQueryRegistryPoolSize();

    @NotNull
    default public Rnd getRandom() {
        Rnd rnd = RANDOM.get();
        if (rnd == null) {
            rnd = new Rnd(this.getNanosecondClock().getTicks(), this.getMicrosecondClock().getTicks());
            RANDOM.set(rnd);
        }
        return rnd;
    }

    public int getReaderPoolMaxSegments();

    public int getRenameTableModelPoolCapacity();

    public int getRepeatMigrationsFromVersion();

    public int getRndFunctionMemoryMaxPages();

    public int getRndFunctionMemoryPageSize();

    @NotNull
    default public RostiAllocFacade getRostiAllocFacade() {
        return RostiAllocFacadeImpl.INSTANCE;
    }

    public boolean getSampleByDefaultAlignmentCalendar();

    public int getSampleByIndexSearchPageSize();

    public int getScoreboardFormat();

    public long getSequencerCheckInterval();

    @NotNull
    public CharSequence getSnapshotInstanceId();

    public long getSpinLockTimeout();

    public int getSqlAsOfJoinLookAhead();

    public int getSqlAsOfJoinMapEvacuationThreshold();

    public int getSqlAsOfJoinShortCircuitCacheCapacity();

    public int getSqlCharacterStoreCapacity();

    public int getSqlCharacterStoreSequencePoolCapacity();

    public int getSqlColumnPoolCapacity();

    public int getSqlCompilerPoolCapacity();

    public int getSqlCopyBufferSize();

    public CharSequence getSqlCopyInputRoot();

    public CharSequence getSqlCopyInputWorkRoot();

    public int getSqlCopyLogRetentionDays();

    public long getSqlCopyMaxIndexChunkSize();

    public int getSqlCopyQueueCapacity();

    public int getSqlDistinctTimestampKeyCapacity();

    public double getSqlDistinctTimestampLoadFactor();

    public int getSqlExpressionPoolCapacity();

    public double getSqlFastMapLoadFactor();

    public int getSqlHashJoinLightValueMaxPages();

    public int getSqlHashJoinLightValuePageSize();

    public int getSqlHashJoinValueMaxPages();

    public int getSqlHashJoinValuePageSize();

    public int getSqlJitBindVarsMemoryMaxPages();

    public int getSqlJitBindVarsMemoryPageSize();

    public int getSqlJitIRMemoryMaxPages();

    public int getSqlJitIRMemoryPageSize();

    public int getSqlJitMode();

    public int getSqlJitPageAddressCacheThreshold();

    public int getSqlJoinContextPoolCapacity();

    public int getSqlJoinMetadataMaxResizes();

    public int getSqlJoinMetadataPageSize();

    public long getSqlLatestByRowCount();

    public int getSqlLexerPoolCapacity();

    public int getSqlMapMaxPages();

    public int getSqlMapMaxResizes();

    public int getSqlMaxNegativeLimit();

    public int getSqlModelPoolCapacity();

    public int getSqlOrderByRadixSortThreshold();

    public int getSqlPageFrameMaxRows();

    public int getSqlPageFrameMinRows();

    public double getSqlParallelFilterPreTouchThreshold();

    public int getSqlParallelWorkStealingThreshold();

    public int getSqlParquetFrameCacheCapacity();

    public int getSqlSmallMapKeyCapacity();

    public long getSqlSmallMapPageSize();

    public int getSqlSortKeyMaxPages();

    public long getSqlSortKeyPageSize();

    public int getSqlSortLightValueMaxPages();

    public long getSqlSortLightValuePageSize();

    public int getSqlSortValueMaxPages();

    public int getSqlSortValuePageSize();

    public int getSqlUnorderedMapMaxEntrySize();

    public int getSqlWindowInitialRangeBufferSize();

    public int getSqlWindowMaxRecursion();

    public int getSqlWindowRowIdMaxPages();

    public int getSqlWindowRowIdPageSize();

    public int getSqlWindowStoreMaxPages();

    public int getSqlWindowStorePageSize();

    public int getSqlWindowTreeKeyMaxPages();

    public int getSqlWindowTreeKeyPageSize();

    public int getStrFunctionMaxBufferLength();

    public long getSymbolTableAppendPageSize();

    public long getSystemDataAppendPageSize();

    public int getSystemO3ColumnMemorySize();

    @NotNull
    public CharSequence getSystemTableNamePrefix();

    public long getSystemWalDataAppendPageSize();

    public long getSystemWalEventAppendPageSize();

    public long getTableRegistryAutoReloadFrequency();

    public int getTableRegistryCompactionThreshold();

    @NotNull
    public TelemetryConfiguration getTelemetryConfiguration();

    public CharSequence getTempRenamePendingTablePrefix();

    @NotNull
    public TextConfiguration getTextConfiguration();

    public int getTxnScoreboardEntryCount();

    public int getVectorAggregateQueueCapacity();

    @NotNull
    public VolumeDefinitions getVolumeDefinitions();

    public int getWalApplyLookAheadTransactionCount();

    public long getWalApplyTableTimeQuota();

    public long getWalDataAppendPageSize();

    public boolean getWalEnabledDefault();

    public long getWalEventAppendPageSize();

    public double getWalLagRowsMultiplier();

    public long getWalMaxLagSize();

    public int getWalMaxLagTxnCount();

    public int getWalMaxSegmentFileDescriptorsCache();

    public long getWalPurgeInterval();

    default public int getWalPurgeWaitBeforeDelete() {
        return 0;
    }

    public int getWalRecreateDistressedSequencerAttempts();

    public long getWalSegmentRolloverRowCount();

    public long getWalSegmentRolloverSize();

    public int getWalTxnNotificationQueueCapacity();

    public int getWalWriterPoolMaxSegments();

    public int getWindowColumnPoolCapacity();

    public int getWithClauseModelPoolCapacity();

    public long getWorkStealTimeoutNanos();

    public long getWriteBackOffTimeoutOnMemPressureMs();

    public long getWriterAsyncCommandBusyWaitTimeout();

    public long getWriterAsyncCommandMaxTimeout();

    public int getWriterCommandQueueCapacity();

    public long getWriterCommandQueueSlotSize();

    public int getWriterFileOpenOpts();

    public int getWriterTickRowsCountMod();

    public boolean isCheckpointRecoveryEnabled();

    public boolean isColumnAliasExpressionEnabled();

    public boolean isDevModeEnabled();

    public boolean isGroupByPresizeEnabled();

    public boolean isIOURingEnabled();

    public boolean isMatViewEnabled();

    public boolean isMatViewParallelSqlEnabled();

    public boolean isMultiKeyDedupEnabled();

    public boolean isO3QuickSortEnabled();

    public boolean isParallelIndexingEnabled();

    public boolean isPartitionEncoderParquetRawArrayEncoding();

    public boolean isPartitionEncoderParquetStatisticsEnabled();

    public boolean isPartitionO3OverwriteControlEnabled();

    public boolean isQueryTracingEnabled();

    public boolean isReadOnlyInstance();

    public boolean isSqlJitDebugEnabled();

    public boolean isSqlOrderBySortEnabled();

    public boolean isSqlParallelFilterEnabled();

    public boolean isSqlParallelFilterPreTouchEnabled();

    public boolean isSqlParallelGroupByEnabled();

    public boolean isSqlParallelReadParquetEnabled();

    public boolean isSqlParallelTopKEnabled();

    public boolean isTableTypeConversionEnabled();

    default public boolean isValidateSampleByFillType() {
        return true;
    }

    public boolean isWalApplyEnabled();

    public boolean isWalApplyParallelSqlEnabled();

    public boolean isWalSupported();

    public boolean isWriterMixedIOEnabled();

    public boolean mangleTableDirNames();

    public int maxArrayElementCount();

    public boolean useFastAsOfJoin();

    public boolean useWithinLatestByOptimisation();
}

