/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.DedupColumnCommitAddresses;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.O3Basket;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3OpenColumnJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.TableMetadata;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.griffin.engine.table.parquet.OwnedMemoryPartitionDescriptor;
import io.questdb.griffin.engine.table.parquet.ParquetCompression;
import io.questdb.griffin.engine.table.parquet.PartitionDecoder;
import io.questdb.griffin.engine.table.parquet.PartitionDescriptor;
import io.questdb.griffin.engine.table.parquet.PartitionUpdater;
import io.questdb.griffin.engine.table.parquet.RowGroupBuffers;
import io.questdb.griffin.engine.table.parquet.RowGroupStatBuffers;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Job;
import io.questdb.mp.Sequence;
import io.questdb.std.DirectIntList;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.ReadOnlyObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;
import io.questdb.tasks.O3OpenColumnTask;
import io.questdb.tasks.O3PartitionTask;
import java.util.concurrent.atomic.AtomicInteger;

public class O3PartitionJob
extends AbstractQueueConsumerJob<O3PartitionTask> {
    private static final Log LOG = LogFactory.getLog(O3PartitionJob.class);

    public O3PartitionJob(MessageBus messageBus) {
        super(messageBus.getO3PartitionQueue(), messageBus.getO3PartitionSubSeq());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processParquetPartition(Path pathToTable, int partitionBy, ReadOnlyObjList<? extends MemoryCR> oooColumns, long srcOooLo, long srcOooHi, long partitionTimestamp, long sortedTimestampsAddr, TableWriter tableWriter, long srcNameTxn, long partitionUpdateSinkAddr, long dedupColSinkAddr, long o3TimestampMin, O3Basket o3Basket, long newPartitionSize, long oldPartitionSize) {
        long srcOooBatchRowSize = srcOooHi - srcOooLo + 1L;
        TableMetadata tableWriterMetadata = tableWriter.getMetadata();
        Path path = Path.getThreadLocal(pathToTable);
        TableUtils.setPathForParquetPartition(path, partitionBy, partitionTimestamp, srcNameTxn);
        int partitionIndex = tableWriter.getPartitionIndexByTimestamp(partitionTimestamp);
        long parquetSize = tableWriter.getPartitionParquetFileSize(partitionIndex);
        long duplicateCount = 0L;
        CairoConfiguration cairoConfiguration = tableWriter.getConfiguration();
        FilesFacade ff = tableWriter.getFilesFacade();
        try (PartitionDecoder partitionDecoder = new PartitionDecoder();
             RowGroupBuffers rowGroupBuffers = new RowGroupBuffers(66);
             DirectIntList parquetColumns = new DirectIntList(2L * (long)tableWriterMetadata.getColumnCount(), 45);){
            long parquetAddr = 0L;
            try (RowGroupStatBuffers rowGroupStatBuffers = new RowGroupStatBuffers(66);
                 PartitionUpdater partitionUpdater = new PartitionUpdater(ff);
                 OwnedMemoryPartitionDescriptor partitionDescriptor = new OwnedMemoryPartitionDescriptor();){
                parquetAddr = TableUtils.mapRO(ff, path.$(), LOG, parquetSize, 17);
                partitionDecoder.of(parquetAddr, parquetSize, 66);
                int rowGroupCount = partitionDecoder.metadata().rowGroupCount();
                int timestampIndex = tableWriterMetadata.getTimestampIndex();
                int timestampColumnType = tableWriterMetadata.getColumnType(timestampIndex);
                assert (ColumnType.isTimestamp(timestampColumnType));
                int compressionCodec = cairoConfiguration.getPartitionEncoderParquetCompressionCodec();
                int compressionLevel = cairoConfiguration.getPartitionEncoderParquetCompressionLevel();
                int rowGroupSize = cairoConfiguration.getPartitionEncoderParquetRowGroupSize();
                int dataPageSize = cairoConfiguration.getPartitionEncoderParquetDataPageSize();
                boolean statisticsEnabled = cairoConfiguration.isPartitionEncoderParquetStatisticsEnabled();
                boolean rawArrayEncoding = cairoConfiguration.isPartitionEncoderParquetRawArrayEncoding();
                int opts = cairoConfiguration.getWriterFileOpenOpts();
                partitionUpdater.of(path.$(), opts, parquetSize, timestampIndex, ParquetCompression.packCompressionCodecLevel(compressionCodec, compressionLevel), statisticsEnabled, rawArrayEncoding, rowGroupSize, dataPageSize);
                long mergeRangeLo = srcOooLo;
                for (int rowGroup = 1; rowGroup < rowGroupCount; ++rowGroup) {
                    parquetColumns.clear();
                    parquetColumns.add(timestampIndex);
                    parquetColumns.add(timestampColumnType);
                    partitionDecoder.readRowGroupStats(rowGroupStatBuffers, parquetColumns, rowGroup);
                    long min = rowGroupStatBuffers.getMinValueLong(0);
                    long mergeRangeHi = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, min, mergeRangeLo, srcOooHi, 1);
                    if (mergeRangeHi < mergeRangeLo) continue;
                    duplicateCount += O3PartitionJob.mergeRowGroup(partitionDescriptor, partitionUpdater, parquetColumns, oooColumns, sortedTimestampsAddr, tableWriter, partitionDecoder, rowGroupBuffers, rowGroup - 1, timestampIndex, partitionTimestamp, mergeRangeLo, mergeRangeHi, tableWriterMetadata, srcOooBatchRowSize, dedupColSinkAddr);
                    mergeRangeLo = mergeRangeHi + 1L;
                }
                if (mergeRangeLo <= srcOooHi) {
                    duplicateCount += O3PartitionJob.mergeRowGroup(partitionDescriptor, partitionUpdater, parquetColumns, oooColumns, sortedTimestampsAddr, tableWriter, partitionDecoder, rowGroupBuffers, rowGroupCount - 1, timestampIndex, partitionTimestamp, mergeRangeLo, srcOooHi, tableWriterMetadata, srcOooBatchRowSize, dedupColSinkAddr);
                }
                partitionUpdater.updateFileMetadata();
            }
            finally {
                ff.munmap(parquetAddr, parquetSize, 17);
            }
            long newParquetSize = Files.length(path.$());
            O3PartitionJob.updateParquetIndexes(partitionBy, partitionTimestamp, tableWriter, srcNameTxn, o3Basket, newPartitionSize, newParquetSize, pathToTable, path, ff, partitionDecoder, tableWriterMetadata, parquetColumns, rowGroupBuffers);
        }
        catch (Throwable th) {
            LOG.error().$("process partition error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(th).I$();
            path.of(pathToTable);
            TableUtils.setPathForParquetPartition(path, partitionBy, partitionTimestamp, srcNameTxn);
            long fd = TableUtils.openRW(ff, path.$(), LOG, cairoConfiguration.getWriterFileOpenOpts());
            if (!ff.truncate(fd, parquetSize)) {
                LOG.error().$("could not truncate partition file [path=").$(path).I$();
            }
            ff.close(fd);
            tableWriter.o3BumpErrorCount(CairoException.isCairoOomError(th));
        }
        finally {
            path.of(pathToTable);
            TableUtils.setPathForParquetPartition(path, partitionBy, partitionTimestamp, srcNameTxn);
            long fileSize = Files.length(path.$());
            Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr, partitionTimestamp);
            Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 8L, o3TimestampMin);
            Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 16L, newPartitionSize - duplicateCount);
            Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 24L, oldPartitionSize);
            Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 32L, 1L);
            Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 40L, 0L);
            Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 56L, fileSize);
            tableWriter.o3CountDownDoneLatch();
            tableWriter.o3ClockDownPartitionUpdateCount();
        }
    }

    public static void processPartition(Path pathToTable, int partitionBy, ObjList<MemoryMA> columns, ReadOnlyObjList<? extends MemoryCR> oooColumns, long srcOooLo, long srcOooHi, long srcOooMax, long o3TimestampMin, long partitionTimestamp, long maxTimestamp, long srcDataMax, long srcNameTxn, boolean last, long txn, long sortedTimestampsAddr, TableWriter tableWriter, AtomicInteger columnCounter, O3Basket o3Basket, long newPartitionSize, long oldPartitionSize, long partitionUpdateSinkAddr, long dedupColSinkAddr, boolean isParquet, long o3TimestampLo, long o3TimestampHi) {
        TableMetadata metadata = tableWriter.getMetadata();
        int timestampIndex = metadata.getTimestampIndex();
        if (isParquet) {
            O3PartitionJob.processParquetPartition(pathToTable, partitionBy, oooColumns, srcOooLo, srcOooHi, partitionTimestamp, sortedTimestampsAddr, tableWriter, srcNameTxn, partitionUpdateSinkAddr, dedupColSinkAddr, o3TimestampMin, o3Basket, newPartitionSize, oldPartitionSize);
            return;
        }
        Path path = Path.getThreadLocal(pathToTable);
        long srcTimestampFd = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        long srcDataNewPartitionSize = newPartitionSize;
        long o3SplitPartitionSize = 0L;
        if (srcDataMax < 1L) {
            if (!last) {
                try {
                    LOG.debug().$("would create [path=").$(path.slash$()).I$();
                    TableUtils.setPathForNativePartition(path.trimTo(pathToTable.size()), partitionBy, partitionTimestamp, txn - 1L);
                    TableUtils.createDirsOrFail(ff, path.slash(), tableWriter.getConfiguration().getMkDirMode());
                }
                catch (Throwable e) {
                    LOG.error().$("process new partition error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                    tableWriter.o3BumpErrorCount(CairoException.isCairoOomError(e));
                    tableWriter.o3ClockDownPartitionUpdateCount();
                    tableWriter.o3CountDownDoneLatch();
                    throw e;
                }
            }
            assert (oldPartitionSize == 0L);
            if (tableWriter.isCommitReplaceMode()) {
                assert (srcOooLo <= srcOooHi);
                o3TimestampMin = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOooLo);
            }
            O3PartitionJob.publishOpenColumnTasks(txn, columns, oooColumns, pathToTable, srcOooLo, srcOooHi, srcOooMax, o3TimestampMin, partitionTimestamp, partitionTimestamp, 0, 0L, 0L, 0, 0L, 0L, 0L, 0L, 0, 0L, 0L, 0L, srcNameTxn, 5, 0L, 0L, 0L, timestampIndex, sortedTimestampsAddr, newPartitionSize, oldPartitionSize, 0L, tableWriter, columnCounter, o3Basket, partitionUpdateSinkAddr, dedupColSinkAddr);
        } else {
            int openColumnMode;
            long oldPartitionTimestamp;
            long newMinPartitionTimestamp;
            long prefixHi;
            long prefixLo;
            int prefixType;
            long suffixHi;
            long suffixLo;
            int suffixType;
            long mergeO3Hi;
            long mergeO3Lo;
            long mergeDataHi;
            long mergeDataLo;
            int mergeType;
            long srcTimestampAddr = 0L;
            long srcTimestampSize = 0L;
            try {
                boolean canAppendOnly;
                boolean overlaps;
                int branch;
                long mergeEquals;
                long dataTimestampHi;
                if (last) {
                    dataTimestampHi = maxTimestamp;
                    srcTimestampSize = srcDataMax * 8L;
                    srcTimestampFd = -columns.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex)).getFd();
                    srcTimestampAddr = TableUtils.mapRW(ff, -srcTimestampFd, srcTimestampSize, 6);
                } else {
                    srcTimestampSize = srcDataMax * 8L;
                    TableUtils.setPathForNativePartition(path.trimTo(pathToTable.size()), partitionBy, partitionTimestamp, srcNameTxn);
                    srcTimestampFd = TableUtils.openRW(ff, TableUtils.dFile(path, metadata.getColumnName(timestampIndex), -1L), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                    srcTimestampAddr = TableUtils.mapRW(ff, srcTimestampFd, srcTimestampSize, 6);
                    dataTimestampHi = Unsafe.getUnsafe().getLong(srcTimestampAddr + srcTimestampSize - 8L);
                }
                long dataTimestampLo = Unsafe.getUnsafe().getLong(srcTimestampAddr);
                mergeType = -1;
                mergeDataLo = -1L;
                mergeDataHi = -1L;
                mergeO3Lo = -1L;
                mergeO3Hi = -1L;
                suffixType = -1;
                suffixLo = -1L;
                suffixHi = -1L;
                assert (srcTimestampFd != -1L && srcTimestampFd != 1L);
                long l = mergeEquals = tableWriter.isCommitDedupMode() || tableWriter.isCommitReplaceMode() ? 1L : 0L;
                if (o3TimestampLo >= dataTimestampLo) {
                    if (o3TimestampLo >= dataTimestampHi + mergeEquals) {
                        branch = 1;
                        suffixType = 1;
                        suffixLo = srcOooLo;
                        suffixHi = srcOooHi;
                        prefixType = 2;
                        prefixLo = 0L;
                        prefixHi = srcDataMax - 1L;
                    } else {
                        prefixLo = 0L;
                        prefixHi = Vect.boundedBinarySearch64Bit(srcTimestampAddr, o3TimestampLo - mergeEquals, 0L, srcDataMax - 1L, 1);
                        prefixType = prefixLo <= prefixHi ? 2 : -1;
                        mergeDataLo = prefixHi + 1L;
                        mergeO3Lo = srcOooLo;
                        if (o3TimestampHi < dataTimestampHi) {
                            branch = 2;
                            mergeO3Hi = srcOooHi;
                            mergeDataHi = Vect.boundedBinarySearch64Bit(srcTimestampAddr, o3TimestampHi, mergeDataLo, srcDataMax - 1L, 1);
                            assert (mergeDataHi > -1L);
                            mergeType = mergeDataLo > mergeDataHi ? 1 : 3;
                            suffixType = 2;
                            suffixLo = mergeDataHi + 1L;
                            suffixHi = srcDataMax - 1L;
                            assert (suffixLo <= suffixHi);
                        } else if (o3TimestampHi > dataTimestampHi) {
                            branch = 3;
                            mergeO3Hi = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, dataTimestampHi, srcOooLo, srcOooHi, tableWriter.isCommitDedupMode() ? 1 : -1);
                            mergeDataHi = srcDataMax - 1L;
                            assert (mergeDataLo <= mergeDataHi);
                            mergeType = 3;
                            suffixType = 1;
                            suffixLo = mergeO3Hi + 1L;
                            if (suffixLo > srcOooHi && tableWriter.isCommitReplaceMode()) {
                                suffixLo = srcOooHi;
                            }
                            suffixHi = srcOooHi;
                            assert (suffixLo <= suffixHi) : String.format("Branch %,d suffixLo %,d > suffixHi %,d", branch, suffixLo, suffixHi);
                        } else {
                            branch = 4;
                            mergeType = 3;
                            mergeO3Hi = srcOooHi;
                            mergeDataHi = srcDataMax - 1L;
                            assert (mergeDataLo <= mergeDataHi);
                        }
                    }
                } else {
                    prefixType = 1;
                    prefixLo = srcOooLo;
                    if (dataTimestampLo <= o3TimestampHi) {
                        mergeDataLo = 0L;
                        prefixHi = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, dataTimestampLo - 1L, srcOooLo, srcOooHi, 1);
                        mergeO3Lo = prefixHi + 1L;
                        if (o3TimestampHi < dataTimestampHi) {
                            branch = 5;
                            mergeType = 3;
                            mergeO3Hi = srcOooHi;
                            mergeDataHi = Vect.boundedBinarySearch64Bit(srcTimestampAddr, o3TimestampHi, 0L, srcDataMax - 1L, 1);
                            suffixLo = mergeDataHi + 1L;
                            suffixType = 2;
                            suffixHi = srcDataMax - 1L;
                            assert (suffixLo <= suffixHi) : String.format("Branch %,d suffixLo %,d > suffixHi %,d", branch, suffixLo, suffixHi);
                        } else if (o3TimestampHi > dataTimestampHi) {
                            branch = 6;
                            mergeDataHi = srcDataMax - 1L;
                            mergeO3Hi = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, dataTimestampHi - 1L + mergeEquals, mergeO3Lo, srcOooHi, 1);
                            mergeType = mergeO3Lo > mergeO3Hi && !tableWriter.isCommitReplaceMode() ? 2 : 3;
                            if (mergeO3Hi < srcOooHi) {
                                suffixLo = mergeO3Hi + 1L;
                                suffixType = 1;
                                suffixHi = Math.max(suffixLo, srcOooHi);
                            }
                        } else {
                            branch = 7;
                            mergeType = 3;
                            mergeO3Hi = srcOooHi;
                            mergeDataHi = srcDataMax - 1L;
                        }
                    } else {
                        branch = 8;
                        prefixHi = srcOooHi;
                        suffixType = 2;
                        suffixLo = 0L;
                        suffixHi = srcDataMax - 1L;
                    }
                }
                boolean bl = overlaps = mergeType == 3;
                if (tableWriter.isCommitReplaceMode()) {
                    if (prefixHi < prefixLo) {
                        prefixType = -1;
                        prefixLo = 0L;
                        prefixHi = -1L;
                    }
                    if (suffixHi < suffixLo) {
                        suffixType = -1;
                    }
                }
                newMinPartitionTimestamp = !tableWriter.isCommitReplaceMode() ? Math.min(o3TimestampMin, dataTimestampLo) : O3PartitionJob.calculateMinDataTimestampAfterReplacement(srcTimestampAddr, sortedTimestampsAddr, prefixType, suffixType, prefixLo, suffixLo, srcOooLo, srcOooHi);
                if (tableWriter.isCommitReplaceMode()) {
                    if (mergeType == 3) {
                        newPartitionSize -= mergeDataHi - mergeDataLo + 1L;
                        srcDataNewPartitionSize -= mergeDataHi - mergeDataLo + 1L;
                    }
                    if (srcOooLo <= srcOooHi) {
                        if (mergeType == 3) {
                            long o3RangeHi;
                            long o3RangeLo;
                            long removedDataRangeHi;
                            long removedDataRangeLo;
                            if (prefixType == 1) {
                                prefixHi = mergeO3Hi;
                                mergeType = -1;
                                mergeO3Hi = -1L;
                                mergeO3Lo = -1L;
                                mergeDataHi = -1L;
                                mergeDataLo = -1L;
                                removedDataRangeLo = 0L;
                                removedDataRangeHi = suffixLo - 1L;
                                o3RangeLo = prefixLo;
                                o3RangeHi = prefixHi;
                            } else if (suffixType == 1) {
                                suffixLo = mergeO3Lo;
                                mergeType = -1;
                                mergeO3Hi = -1L;
                                mergeO3Lo = -1L;
                                mergeDataHi = -1L;
                                mergeDataLo = -1L;
                                removedDataRangeLo = prefixHi + 1L;
                                removedDataRangeHi = srcDataMax - 1L;
                                o3RangeLo = suffixLo;
                                o3RangeHi = suffixHi;
                            } else {
                                removedDataRangeLo = mergeDataLo;
                                removedDataRangeHi = mergeDataHi;
                                o3RangeLo = mergeO3Lo;
                                o3RangeHi = mergeO3Hi;
                            }
                            if (removedDataRangeHi - removedDataRangeLo > 0L && removedDataRangeHi - removedDataRangeLo == o3RangeHi - o3RangeLo && Unsafe.getUnsafe().getLong(srcTimestampAddr + removedDataRangeLo * 8L) == TableWriter.getTimestampIndexValue(sortedTimestampsAddr, o3RangeLo) && Unsafe.getUnsafe().getLong(srcTimestampAddr + removedDataRangeHi * 8L) == TableWriter.getTimestampIndexValue(sortedTimestampsAddr, o3RangeHi) && tableWriter.checkReplaceCommitIdenticalToPartition(partitionTimestamp, srcNameTxn, srcDataMax, removedDataRangeLo, removedDataRangeHi, o3RangeLo, o3RangeHi)) {
                                LOG.info().$("replace commit resulted in identical data [table=").$safe(tableWriter.getTableToken().getTableName()).$(", partitionTimestamp=").$ts(partitionTimestamp).$(", srcNameTxn=").$(srcNameTxn).I$();
                                O3PartitionJob.updatePartition(ff, srcTimestampAddr, srcTimestampSize, srcTimestampFd, tableWriter, partitionUpdateSinkAddr, partitionTimestamp, newMinPartitionTimestamp, oldPartitionSize, oldPartitionSize, 0);
                                return;
                            }
                        }
                    } else {
                        boolean noop = mergeType == 1 && prefixType == 2 && suffixType == 2;
                        noop |= suffixType == 2 && suffixLo == 0L && suffixHi == srcDataMax - 1L;
                        if (noop |= prefixType == 2 && prefixLo == 0L && prefixHi == srcDataMax - 1L) {
                            O3PartitionJob.updatePartition(ff, srcTimestampAddr, srcTimestampSize, srcTimestampFd, tableWriter, partitionUpdateSinkAddr, partitionTimestamp, newMinPartitionTimestamp, oldPartitionSize, oldPartitionSize, 0);
                            return;
                        }
                        if (prefixType == 1) {
                            prefixType = -1;
                            prefixLo = 0L;
                            prefixHi = -1L;
                        }
                        mergeType = -1;
                        if (suffixType == 1) {
                            suffixType = -1;
                        }
                        if (prefixType == -1 && suffixType == -1) {
                            O3PartitionJob.updatePartition(ff, srcTimestampAddr, srcTimestampSize, srcTimestampFd, tableWriter, partitionUpdateSinkAddr, partitionTimestamp, Long.MAX_VALUE, 0L, oldPartitionSize, 1);
                            return;
                        }
                        if (prefixType == 2 && prefixHi >= prefixLo && suffixType == -1) {
                            if (prefixHi - prefixLo + 1L == srcDataMax) {
                                O3PartitionJob.updatePartition(ff, srcTimestampAddr, srcTimestampSize, srcTimestampFd, tableWriter, partitionUpdateSinkAddr, partitionTimestamp, newMinPartitionTimestamp, prefixHi + 1L, oldPartitionSize, 0);
                                return;
                            }
                            if (prefixHi > prefixLo) {
                                suffixHi = suffixLo = prefixHi--;
                                suffixType = 2;
                            }
                        }
                    }
                }
                LOG.debug().$("o3 merge [branch=").$(branch).$(", prefixType=").$(prefixType).$(", prefixLo=").$(prefixLo).$(", prefixHi=").$(prefixHi).$(", o3TimestampLo=").$ts(o3TimestampLo).$(", o3TimestampHi=").$ts(o3TimestampHi).$(", o3TimestampMin=").$ts(o3TimestampMin).$(", dataTimestampLo=").$ts(dataTimestampLo).$(", dataTimestampHi=").$ts(dataTimestampHi).$(", partitionTimestamp=").$ts(partitionTimestamp).$(", srcDataMax=").$(srcDataMax).$(", mergeType=").$(mergeType).$(", mergeDataLo=").$(mergeDataLo).$(", mergeDataHi=").$(mergeDataHi).$(", mergeO3Lo=").$(mergeO3Lo).$(", mergeO3Hi=").$(mergeO3Hi).$(", suffixType=").$(suffixType).$(", suffixLo=").$(suffixLo).$(", suffixHi=").$(suffixHi).$(", table=").$(pathToTable).I$();
                oldPartitionTimestamp = partitionTimestamp;
                boolean partitionSplit = false;
                if (prefixType == 2 && (mergeType == 3 || mergeType == 1) && prefixHi >= tableWriter.getPartitionO3SplitThreshold() && prefixHi > 2L * (mergeDataHi - mergeDataLo + suffixHi - suffixLo + mergeO3Hi - mergeO3Lo)) {
                    long maxSourceTimestamp = Unsafe.getUnsafe().getLong(srcTimestampAddr + prefixHi * 8L);
                    assert (maxSourceTimestamp <= o3TimestampLo);
                    boolean canSplit = true;
                    if (maxSourceTimestamp == o3TimestampLo) {
                        long newPrefixHi = -1L + Vect.boundedBinarySearch64Bit(srcTimestampAddr, o3TimestampLo, prefixLo, prefixHi - 1L, -1);
                        if (newPrefixHi > -1L) {
                            long shiftLeft = prefixHi - newPrefixHi;
                            long newMergeDataLo = mergeDataLo - shiftLeft;
                            if (newPrefixHi >= tableWriter.getPartitionO3SplitThreshold() && newPrefixHi > 2L * (mergeDataHi - newMergeDataLo + suffixHi - suffixLo + mergeO3Hi - mergeO3Lo)) {
                                prefixHi = newPrefixHi;
                                mergeDataLo = newMergeDataLo;
                                maxSourceTimestamp = Unsafe.getUnsafe().getLong(srcTimestampAddr + prefixHi * 8L);
                                mergeType = 3;
                                assert (maxSourceTimestamp < o3TimestampLo);
                            } else {
                                canSplit = false;
                            }
                        } else {
                            canSplit = false;
                        }
                    }
                    if (canSplit) {
                        partitionSplit = true;
                        partitionTimestamp = maxSourceTimestamp + 1L;
                        prefixType = -1;
                        srcDataNewPartitionSize = prefixHi + 1L;
                        o3SplitPartitionSize = newPartitionSize - srcDataNewPartitionSize;
                        LOG.info().$("o3 split partition [table=").$(tableWriter.getTableToken()).$(", timestamp=").$ts(oldPartitionTimestamp).$(", nameTxn=").$(srcNameTxn).$(", srcDataNewPartitionSize=").$(srcDataNewPartitionSize).$(", o3SplitPartitionSize=").$(o3SplitPartitionSize).$(", newPartitionTimestamp=").$ts(partitionTimestamp).$(", nameTxn=").$(txn).I$();
                    }
                }
                boolean bl2 = canAppendOnly = !partitionSplit;
                canAppendOnly = tableWriter.isCommitReplaceMode() ? (canAppendOnly &= !overlaps && suffixType == 1) : (canAppendOnly &= mergeType == -1 && (prefixType == -1 || prefixType == 2));
                if (canAppendOnly) {
                    openColumnMode = 1;
                } else {
                    TableUtils.setPathForNativePartition(path.trimTo(pathToTable.size()), partitionBy, partitionTimestamp, txn);
                    TableUtils.createDirsOrFail(ff, path.slash(), tableWriter.getConfiguration().getMkDirMode());
                    openColumnMode = last ? 4 : 3;
                }
            }
            catch (Throwable e) {
                LOG.error().$("process existing partition error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
                O3Utils.close(ff, srcTimestampFd);
                tableWriter.o3BumpErrorCount(CairoException.isCairoOomError(e));
                tableWriter.o3ClockDownPartitionUpdateCount();
                tableWriter.o3CountDownDoneLatch();
                throw e;
            }
            Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr, partitionTimestamp);
            O3PartitionJob.publishOpenColumnTasks(txn, columns, oooColumns, pathToTable, srcOooLo, srcOooHi, srcOooMax, newMinPartitionTimestamp, partitionTimestamp, oldPartitionTimestamp, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeO3Lo, mergeO3Hi, suffixType, suffixLo, suffixHi, srcDataMax, srcNameTxn, openColumnMode, srcTimestampFd, srcTimestampAddr, srcTimestampSize, timestampIndex, sortedTimestampsAddr, srcDataNewPartitionSize, oldPartitionSize, o3SplitPartitionSize, tableWriter, columnCounter, o3Basket, partitionUpdateSinkAddr, dedupColSinkAddr);
        }
    }

    public static void processPartition(O3PartitionTask task, long cursor, Sequence subSeq) {
        Path pathToTable = task.getPathToTable();
        int partitionBy = task.getPartitionBy();
        ObjList<MemoryMA> columns = task.getColumns();
        ReadOnlyObjList<? extends MemoryCR> oooColumns = task.getO3Columns();
        long srcOooLo = task.getSrcOooLo();
        long srcOooHi = task.getSrcOooHi();
        long srcOooMax = task.getSrcOooMax();
        long oooTimestampMin = task.getOooTimestampMin();
        long partitionTimestamp = task.getPartitionTimestamp();
        long maxTimestamp = task.getMaxTimestamp();
        long srcDataMax = task.getSrcDataMax();
        long srcNameTxn = task.getSrcNameTxn();
        boolean last = task.isLast();
        long txn = task.getTxn();
        long sortedTimestampsAddr = task.getSortedTimestampsAddr();
        TableWriter tableWriter = task.getTableWriter();
        AtomicInteger columnCounter = task.getColumnCounter();
        O3Basket o3Basket = task.getO3Basket();
        long newPartitionSize = task.getNewPartitionSize();
        long oldPartitionSize = task.getOldPartitionSize();
        long partitionUpdateSinkAddr = task.getPartitionUpdateSinkAddr();
        long dedupColSinkAddr = task.getDedupColSinkAddr();
        boolean isParquet = task.isParquet();
        long o3TimestampLo = task.getO3TimestampLo();
        long o3TimestampHi = task.getO3TimestampHi();
        subSeq.done(cursor);
        O3PartitionJob.processPartition(pathToTable, partitionBy, columns, oooColumns, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, partitionTimestamp, maxTimestamp, srcDataMax, srcNameTxn, last, txn, sortedTimestampsAddr, tableWriter, columnCounter, o3Basket, newPartitionSize, oldPartitionSize, partitionUpdateSinkAddr, dedupColSinkAddr, isParquet, o3TimestampLo, o3TimestampHi);
    }

    private static long calculateMinDataTimestampAfterReplacement(long srcDataTimestampAddr, long o3TimestampsAddr, int prefixType, int suffixType, long prefixLo, long suffixLo, long srcOooLo, long srcOooHi) {
        if (prefixType == 2) {
            return Unsafe.getUnsafe().getLong(srcDataTimestampAddr + prefixLo * 8L);
        }
        if (srcOooLo <= srcOooHi) {
            return TableWriter.getTimestampIndexValue(o3TimestampsAddr, srcOooLo);
        }
        if (suffixType == 2) {
            return Unsafe.getUnsafe().getLong(srcDataTimestampAddr + suffixLo * 8L);
        }
        return Long.MAX_VALUE;
    }

    private static long createMergeIndex(long srcDataTimestampAddr, long sortedTimestampsAddr, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, long indexSize) {
        long timestampIndexAddr = Unsafe.malloc(indexSize, 45);
        Vect.mergeTwoLongIndexesAsc(srcDataTimestampAddr, mergeDataLo, mergeDataHi - mergeDataLo + 1L, sortedTimestampsAddr + mergeOOOLo * 16L, mergeOOOHi - mergeOOOLo + 1L, timestampIndexAddr);
        return timestampIndexAddr;
    }

    private static long getDedupRows(long partitionTimestamp, long srcNameTxn, long srcTimestampAddr, long mergeDataLo, long mergeDataHi, long sortedTimestampsAddr, long mergeOOOLo, long mergeOOOHi, ReadOnlyObjList<? extends MemoryCR> oooColumns, DedupColumnCommitAddresses dedupCommitAddresses, long dedupColSinkAddr, TableWriter tableWriter, Path tableRootPath, long tempIndexAddr) {
        if (dedupCommitAddresses == null || dedupCommitAddresses.getColumnCount() == 0) {
            return Vect.mergeDedupTimestampWithLongIndexAsc(srcTimestampAddr, mergeDataLo, mergeDataHi, sortedTimestampsAddr, mergeOOOLo, mergeOOOHi, tempIndexAddr);
        }
        return O3PartitionJob.getDedupRowsWithAdditionalKeys(partitionTimestamp, srcNameTxn, srcTimestampAddr, mergeDataLo, mergeDataHi, sortedTimestampsAddr, mergeOOOLo, mergeOOOHi, oooColumns, dedupCommitAddresses, dedupColSinkAddr, tableWriter, tableRootPath, tempIndexAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getDedupRowsWithAdditionalKeys(long partitionTimestamp, long srcNameTxn, long srcTimestampAddr, long mergeDataLo, long mergeDataHi, long sortedTimestampsAddr, long mergeOOOLo, long mergeOOOHi, ReadOnlyObjList<? extends MemoryCR> oooColumns, DedupColumnCommitAddresses dedupCommitAddresses, long dedupColSinkAddr, TableWriter tableWriter, Path tableRootPath, long tempIndexAddr) {
        LOG.info().$("merge dedup with additional keys [table=").$(tableWriter.getTableToken()).$(", columnRowCount=").$(mergeDataHi - mergeDataLo + 1L).$(", o3RowCount=").$(mergeOOOHi - mergeOOOLo + 1L).I$();
        TableMetadata metadata = tableWriter.getMetadata();
        int dedupColumnIndex = 0;
        int tableRootPathLen = tableRootPath.size();
        FilesFacade ff = tableWriter.getFilesFacade();
        int mapMemTag = 6;
        try {
            dedupCommitAddresses.clear(dedupColSinkAddr);
            for (int i = 0; i < metadata.getColumnCount(); ++i) {
                int columnType = metadata.getColumnType(i);
                if (columnType <= 0 || !metadata.isDedupKey(i) || i == metadata.getTimestampIndex()) continue;
                int columnSize = !ColumnType.isVarSize(columnType) ? ColumnType.sizeOf(columnType) : -1;
                long columnTop = tableWriter.getColumnTop(partitionTimestamp, i, mergeDataHi + 1L);
                String columnName = metadata.getColumnName(i);
                long columnNameTxn = tableWriter.getColumnNameTxn(partitionTimestamp, i);
                long addr = DedupColumnCommitAddresses.setColValues(dedupColSinkAddr, dedupColumnIndex, columnType, columnSize, columnTop);
                if (columnTop > mergeDataHi) {
                    DedupColumnCommitAddresses.setColAddressValues(addr, 0L);
                    if (columnSize > 0) {
                        long oooColAddress = oooColumns.get(TableWriter.getPrimaryColumnIndex(i)).addressOf(0L);
                        DedupColumnCommitAddresses.setO3DataAddressValues(addr, oooColAddress);
                        DedupColumnCommitAddresses.setReservedValuesSet1(addr, -1L, -1L, -1L);
                    } else {
                        long oooVarColAddress = oooColumns.get(TableWriter.getPrimaryColumnIndex(i)).addressOf(0L);
                        long oooVarColSize = oooColumns.get(TableWriter.getPrimaryColumnIndex(i)).addressHi() - oooVarColAddress;
                        long oooAuxColAddress = oooColumns.get(TableWriter.getSecondaryColumnIndex(i)).addressOf(0L);
                        DedupColumnCommitAddresses.setO3DataAddressValues(addr, oooAuxColAddress, oooVarColAddress, oooVarColSize);
                        DedupColumnCommitAddresses.setReservedValuesSet1(addr, -1L, -1L, -1L);
                        DedupColumnCommitAddresses.setReservedValuesSet2(addr, 0L, -1L);
                    }
                } else if (columnSize > 0) {
                    TableUtils.setSinkForNativePartition(tableRootPath.trimTo(tableRootPathLen).slash(), tableWriter.getPartitionBy(), partitionTimestamp, srcNameTxn);
                    long fd = TableUtils.openRO(ff, TableUtils.dFile(tableRootPath, columnName, columnNameTxn), LOG);
                    long fixMapSize = (mergeDataHi + 1L - columnTop) * (long)columnSize;
                    long fixMappedAddress = TableUtils.mapAppendColumnBuffer(ff, fd, 0L, fixMapSize, false, mapMemTag);
                    DedupColumnCommitAddresses.setColAddressValues(addr, Math.abs(fixMappedAddress) - columnTop * (long)columnSize);
                    long oooColAddress = oooColumns.get(TableWriter.getPrimaryColumnIndex(i)).addressOf(0L);
                    DedupColumnCommitAddresses.setO3DataAddressValues(addr, oooColAddress);
                    DedupColumnCommitAddresses.setReservedValuesSet1(addr, fixMappedAddress, fixMapSize, fd);
                } else {
                    long rows = mergeDataHi + 1L - columnTop;
                    ColumnTypeDriver driver = ColumnType.getDriver(columnType);
                    long auxMapSize = driver.getAuxVectorSize(rows);
                    TableUtils.setSinkForNativePartition(tableRootPath.trimTo(tableRootPathLen).slash(), tableWriter.getPartitionBy(), partitionTimestamp, srcNameTxn);
                    long auxFd = TableUtils.openRO(ff, TableUtils.iFile(tableRootPath, columnName, columnNameTxn), LOG);
                    long auxMappedAddress = TableUtils.mapAppendColumnBuffer(ff, auxFd, 0L, auxMapSize, false, mapMemTag);
                    long varMapSize = driver.getDataVectorSizeAt(auxMappedAddress, rows - 1L);
                    if (varMapSize > 0L) {
                        TableUtils.setSinkForNativePartition(tableRootPath.trimTo(tableRootPathLen).slash(), tableWriter.getPartitionBy(), partitionTimestamp, srcNameTxn);
                    }
                    long varFd = varMapSize > 0L ? TableUtils.openRO(ff, TableUtils.dFile(tableRootPath, columnName, columnNameTxn), LOG) : -1L;
                    long varMappedAddress = varMapSize > 0L ? TableUtils.mapAppendColumnBuffer(ff, varFd, 0L, varMapSize, false, mapMemTag) : 0L;
                    long auxRecSize = driver.auxRowsToBytes(1L);
                    DedupColumnCommitAddresses.setColAddressValues(addr, auxMappedAddress - columnTop * auxRecSize, varMappedAddress, varMapSize);
                    MemoryCR oooVarCol = oooColumns.get(TableWriter.getPrimaryColumnIndex(i));
                    long oooVarColAddress = oooVarCol.addressOf(0L);
                    long oooVarColSize = oooVarCol.addressHi() - oooVarColAddress;
                    long oooAuxColAddress = oooColumns.get(TableWriter.getSecondaryColumnIndex(i)).addressOf(0L);
                    DedupColumnCommitAddresses.setO3DataAddressValues(addr, oooAuxColAddress, oooVarColAddress, oooVarColSize);
                    DedupColumnCommitAddresses.setReservedValuesSet1(addr, auxMappedAddress, auxMapSize, auxFd);
                    DedupColumnCommitAddresses.setReservedValuesSet2(addr, varMappedAddress, varFd);
                }
                ++dedupColumnIndex;
            }
            long l = Vect.mergeDedupTimestampWithLongIndexIntKeys(srcTimestampAddr, mergeDataLo, mergeDataHi, sortedTimestampsAddr, mergeOOOLo, mergeOOOHi, tempIndexAddr, dedupCommitAddresses.getColumnCount(), DedupColumnCommitAddresses.getAddress(dedupColSinkAddr));
            return l;
        }
        finally {
            int n = dedupCommitAddresses.getColumnCount();
            for (int i = 0; i < n; ++i) {
                long varMappedAddress;
                long mappedAddress = DedupColumnCommitAddresses.getColReserved1(dedupColSinkAddr, i);
                long mappedAddressSize = DedupColumnCommitAddresses.getColReserved2(dedupColSinkAddr, i);
                if (mappedAddressSize > 0L) {
                    TableUtils.mapAppendColumnBufferRelease(ff, mappedAddress, 0L, mappedAddressSize, mapMemTag);
                    long fd = DedupColumnCommitAddresses.getColReserved3(dedupColSinkAddr, i);
                    ff.close(fd);
                }
                if ((varMappedAddress = DedupColumnCommitAddresses.getColReserved4(dedupColSinkAddr, i)) <= 0L) continue;
                long varMappedLength = DedupColumnCommitAddresses.getColVarDataLen(dedupColSinkAddr, i);
                TableUtils.mapAppendColumnBufferRelease(ff, varMappedAddress, 0L, varMappedLength, mapMemTag);
                long varFd = DedupColumnCommitAddresses.getColReserved5(dedupColSinkAddr, i);
                ff.close(varFd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long mergeRowGroup(PartitionDescriptor partitionDescriptor, PartitionUpdater partitionUpdater, DirectIntList parquetColumns, ReadOnlyObjList<? extends MemoryCR> oooColumns, long sortedTimestampsAddr, TableWriter tableWriter, PartitionDecoder decoder, RowGroupBuffers rowGroupBuffers, int rowGroupIndex, int timestampIndex, long partitionTimestamp, long mergeRangeLo, long mergeRangeHi, TableRecordMetadata tableWriterMetadata, long srcOooBatchRowSize, long dedupColSinkAddr) {
        long timestampMergeIndexAddr;
        parquetColumns.clear();
        int timestampColumnChunkIndex = -1;
        int columnCount = tableWriterMetadata.getColumnCount();
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            int columnType = tableWriterMetadata.getColumnType(columnIndex);
            if (columnType < 0) continue;
            if (columnIndex == timestampIndex) {
                timestampColumnChunkIndex = (int)parquetColumns.size() / 2;
            }
            parquetColumns.add(columnIndex);
            parquetColumns.add(columnType);
        }
        int rowGroupSize = decoder.metadata().rowGroupSize(rowGroupIndex);
        decoder.decodeRowGroup(rowGroupBuffers, parquetColumns, rowGroupIndex, 0, rowGroupSize);
        assert (timestampColumnChunkIndex > -1);
        long timestampDataPtr = rowGroupBuffers.getChunkDataPtr(timestampColumnChunkIndex);
        assert (timestampDataPtr != 0L);
        long mergeBatchRowCount = mergeRangeHi - mergeRangeLo + 1L;
        long mergeRowCount = mergeBatchRowCount + (long)rowGroupSize;
        long duplicateCount = 0L;
        long timestampMergeIndexSize = mergeRowCount * 16L;
        if (!tableWriter.isCommitDedupMode()) {
            timestampMergeIndexAddr = O3PartitionJob.createMergeIndex(timestampDataPtr, sortedTimestampsAddr, 0L, rowGroupSize - 1, mergeRangeLo, mergeRangeHi, timestampMergeIndexSize);
        } else {
            long dedupRows;
            DedupColumnCommitAddresses dedupCommitAddresses = tableWriter.getDedupCommitAddresses();
            timestampMergeIndexAddr = Unsafe.malloc(timestampMergeIndexSize, 45);
            try {
                if (dedupCommitAddresses == null || dedupCommitAddresses.getColumnCount() == 0) {
                    dedupRows = Vect.mergeDedupTimestampWithLongIndexAsc(timestampDataPtr, 0L, rowGroupSize - 1, sortedTimestampsAddr, mergeRangeLo, mergeRangeHi, timestampMergeIndexAddr);
                } else {
                    int dedupColumnIndex = 0;
                    dedupCommitAddresses.clear(dedupColSinkAddr);
                    int n = (int)parquetColumns.size() / 2;
                    for (int bufferIndex = 0; bufferIndex < n; ++bufferIndex) {
                        int columnIndex = parquetColumns.get((long)bufferIndex * 2L);
                        int columnType = tableWriterMetadata.getColumnType(columnIndex);
                        assert (columnIndex >= 0);
                        assert (columnType >= 0);
                        if (!tableWriterMetadata.isDedupKey(columnIndex) || columnIndex == timestampIndex) continue;
                        int columnSize = !ColumnType.isVarSize(columnType) ? ColumnType.sizeOf(columnType) : -1;
                        long columnTop = tableWriter.getColumnTop(partitionTimestamp, columnIndex, rowGroupSize);
                        long addr = DedupColumnCommitAddresses.setColValues(dedupColSinkAddr, dedupColumnIndex++, columnType, columnSize, columnTop);
                        if (columnSize > 0) {
                            DedupColumnCommitAddresses.setColAddressValues(addr, rowGroupBuffers.getChunkDataPtr(bufferIndex));
                            long oooColAddress = oooColumns.get(TableWriter.getPrimaryColumnIndex(columnIndex)).addressOf(0L);
                            DedupColumnCommitAddresses.setO3DataAddressValues(addr, oooColAddress);
                            continue;
                        }
                        DedupColumnCommitAddresses.setColAddressValues(addr, rowGroupBuffers.getChunkAuxPtr(bufferIndex), rowGroupBuffers.getChunkDataPtr(bufferIndex), rowGroupBuffers.getChunkDataSize(bufferIndex));
                        MemoryCR oooVarCol = oooColumns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                        long oooVarColAddress = oooVarCol.addressOf(0L);
                        long oooVarColSize = oooVarCol.addressHi() - oooVarColAddress;
                        long oooAuxColAddress = oooColumns.get(TableWriter.getSecondaryColumnIndex(columnIndex)).addressOf(0L);
                        DedupColumnCommitAddresses.setO3DataAddressValues(addr, oooAuxColAddress, oooVarColAddress, oooVarColSize);
                    }
                    dedupRows = Vect.mergeDedupTimestampWithLongIndexIntKeys(timestampDataPtr, 0L, rowGroupSize - 1, sortedTimestampsAddr, mergeRangeLo, mergeRangeHi, timestampMergeIndexAddr, dedupCommitAddresses.getColumnCount(), DedupColumnCommitAddresses.getAddress(dedupColSinkAddr));
                }
                timestampMergeIndexAddr = Unsafe.realloc(timestampMergeIndexAddr, timestampMergeIndexSize, dedupRows * 16L, 45);
            }
            catch (Throwable e) {
                Unsafe.free(timestampMergeIndexAddr, timestampMergeIndexSize, 45);
                throw e;
            }
            timestampMergeIndexSize = dedupRows * 16L;
            duplicateCount = mergeRowCount - dedupRows;
            mergeRowCount = dedupRows;
        }
        assert (timestampMergeIndexAddr != 0L);
        try {
            partitionDescriptor.of(tableWriter.getTableToken().getTableName(), mergeRowCount, timestampIndex);
            int n = (int)parquetColumns.size() / 2;
            for (int bufferIndex = 0; bufferIndex < n; ++bufferIndex) {
                int columnIndex = parquetColumns.get((long)bufferIndex * 2L);
                int columnType = tableWriterMetadata.getColumnType(columnIndex);
                assert (columnIndex >= 0);
                assert (columnType >= 0);
                String columnName = tableWriterMetadata.getColumnName(columnIndex);
                int columnId = tableWriterMetadata.getColumnMetadata(columnIndex).getWriterIndex();
                boolean notTheTimestamp = columnIndex != timestampIndex;
                int columnOffset = TableWriter.getPrimaryColumnIndex(columnIndex);
                MemoryCR oooMem1 = oooColumns.getQuick(columnOffset);
                MemoryCR oooMem2 = oooColumns.getQuick(columnOffset + 1);
                if (ColumnType.isVarSize(columnType)) {
                    ColumnTypeDriver ctd = ColumnType.getDriver(columnType);
                    long columnDataPtr = rowGroupBuffers.getChunkDataPtr(bufferIndex);
                    assert (columnDataPtr != 0L);
                    long columnAuxPtr = rowGroupBuffers.getChunkAuxPtr(bufferIndex);
                    assert (columnAuxPtr != 0L);
                    long srcOooFixAddr = oooMem2.addressOf(0L);
                    long srcOooVarAddr = oooMem1.addressOf(0L);
                    long dstFixSize = ctd.auxRowsToBytes(srcOooBatchRowSize) + ctd.getAuxVectorSize(rowGroupSize);
                    long dstVarSize = ctd.getDataVectorSize(srcOooFixAddr, mergeRangeLo, mergeRangeHi) + ctd.getDataVectorSizeAt(columnAuxPtr, rowGroupSize - 1);
                    long dstFixMemAddr = Unsafe.malloc(dstFixSize, 45);
                    long dstVarMemAddr = Unsafe.malloc(dstVarSize, 45);
                    O3CopyJob.mergeCopy(columnType, timestampMergeIndexAddr, mergeRowCount, columnAuxPtr, columnDataPtr, srcOooFixAddr, srcOooVarAddr, dstFixMemAddr, dstVarMemAddr, 0L);
                    partitionDescriptor.addColumn(columnName, columnType, columnId, 0L, dstVarMemAddr, dstVarSize, dstFixMemAddr, dstFixSize, 0L, 0L);
                    continue;
                }
                long srcOooFixAddr = oooMem1.addressOf(0L);
                long dstFixSize = mergeRowCount * (long)ColumnType.sizeOf(columnType);
                long dstFixMemAddr = Unsafe.malloc(dstFixSize, 45);
                long columnDataPtr = rowGroupBuffers.getChunkDataPtr(bufferIndex);
                assert (columnDataPtr != 0L);
                O3CopyJob.mergeCopy(notTheTimestamp ? columnType : ColumnType.setDesignatedTimestampBit(columnType, true), timestampMergeIndexAddr, mergeRowCount, columnDataPtr, 0L, srcOooFixAddr, 0L, dstFixMemAddr, 0L, 0L);
                if (ColumnType.isSymbol(columnType)) {
                    MapWriter symbolMapWriter = tableWriter.getSymbolMapWriter(columnIndex);
                    MemoryR offsetsMem = symbolMapWriter.getSymbolOffsetsMemory();
                    MemoryR valuesMem = symbolMapWriter.getSymbolValuesMemory();
                    int symbolCount = symbolMapWriter.getSymbolCount();
                    long offset = SymbolMapWriter.keyToOffset(symbolCount);
                    long offsetsMemSize = offset - 64L;
                    assert (offsetsMemSize <= offsetsMem.size());
                    long valuesMemSize = offsetsMem.getLong(offset);
                    assert (valuesMemSize <= valuesMem.size());
                    partitionDescriptor.addColumn(columnName, columnType, columnId, 0L, dstFixMemAddr, dstFixSize, valuesMem.addressOf(0L), valuesMemSize, offsetsMem.addressOf(64L), offsetsMemSize);
                    continue;
                }
                partitionDescriptor.addColumn(columnName, columnType, columnId, 0L, dstFixMemAddr, dstFixSize, 0L, 0L, 0L, 0L);
            }
            partitionUpdater.updateRowGroup((short)rowGroupIndex, partitionDescriptor);
        }
        finally {
            Unsafe.free(timestampMergeIndexAddr, timestampMergeIndexSize, 45);
        }
        return duplicateCount;
    }

    private static void publishOpenColumnTaskContended(long cursor, int openColumnMode, Path pathToTable, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooTimestampMin, long partitionTimestamp, long oldPartitionTimestamp, long srcDataTop, long srcDataMax, long srcNameTxn, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int indexBlockCapacity, long activeFixFd, long activeVarFd, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long partitionUpdateSinkAddr, int columnIndex, long columnNameTxn) {
        while (cursor == -2L) {
            Os.pause();
            cursor = tableWriter.getO3OpenColumnPubSeq().next();
        }
        if (cursor > -1L) {
            O3PartitionJob.publishOpenColumnTaskHarmonized(cursor, openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, partitionTimestamp, oldPartitionTimestamp, srcDataTop, srcDataMax, srcNameTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, activeFixFd, activeVarFd, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr, columnIndex, columnNameTxn);
        } else {
            O3OpenColumnJob.openColumn(openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, partitionTimestamp, oldPartitionTimestamp, srcDataTop, srcDataMax, srcNameTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, indexBlockCapacity, activeFixFd, activeVarFd, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr, columnIndex, columnNameTxn);
        }
    }

    private static void publishOpenColumnTaskHarmonized(long cursor, int openColumnMode, Path pathToTable, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooTimestampMin, long partitionTimestamp, long oldPartitionTimestamp, long srcDataTop, long srcDataMax, long srcNameTxn, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long activeFixFd, long activeVarFd, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long partitionUpdateSinkAddr, int columnIndex, long columnNameTxn) {
        O3OpenColumnTask openColumnTask = tableWriter.getO3OpenColumnQueue().get(cursor);
        openColumnTask.of(openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, partitionTimestamp, oldPartitionTimestamp, srcDataTop, srcDataMax, srcNameTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, indexBlockCapacity, activeFixFd, activeVarFd, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr, columnIndex, columnNameTxn);
        tableWriter.getO3OpenColumnPubSeq().done(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishOpenColumnTasks(long txn, ObjList<MemoryMA> columns, ReadOnlyObjList<? extends MemoryCR> oooColumns, Path pathToTable, long srcOooLo, long srcOooHi, long srcOooMax, long oooTimestampMin, long partitionTimestamp, long oldPartitionTimestamp, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, long srcDataMax, long srcNameTxn, int openColumnMode, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int timestampIndex, long sortedTimestampsAddr, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, AtomicInteger columnCounter, O3Basket o3Basket, long partitionUpdateSinkAddr, long dedupColSinkAddr) {
        TableMetadata metadata;
        long timestampMergeIndexSize;
        long timestampMergeIndexAddr;
        long srcOooBatchRowSize;
        block34: {
            srcOooBatchRowSize = srcOooHi - srcOooLo + 1L;
            timestampMergeIndexAddr = 0L;
            timestampMergeIndexSize = 0L;
            metadata = tableWriter.getMetadata();
            if (mergeType == 3) {
                long mergeRowCount = mergeOOOHi - mergeOOOLo + 1L + mergeDataHi - mergeDataLo + 1L;
                long tempIndexSize = mergeRowCount * 16L;
                assert (tempIndexSize > 0L);
                try {
                    if (tableWriter.isCommitPlainInsert()) {
                        timestampMergeIndexSize = tempIndexSize;
                        timestampMergeIndexAddr = O3PartitionJob.createMergeIndex(srcTimestampAddr, sortedTimestampsAddr, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, timestampMergeIndexSize);
                        break block34;
                    }
                    if (tableWriter.isCommitDedupMode()) {
                        long tempIndexAddr = Unsafe.malloc(tempIndexSize, 45);
                        DedupColumnCommitAddresses dedupCommitAddresses = tableWriter.getDedupCommitAddresses();
                        Path tempTablePath = Path.getThreadLocal(tableWriter.getConfiguration().getDbRoot()).concat(tableWriter.getTableToken());
                        long dedupRows = O3PartitionJob.getDedupRows(oldPartitionTimestamp, srcNameTxn, srcTimestampAddr, mergeDataLo, mergeDataHi, sortedTimestampsAddr, mergeOOOLo, mergeOOOHi, oooColumns, dedupCommitAddresses, dedupColSinkAddr, tableWriter, tempTablePath, tempIndexAddr);
                        timestampMergeIndexSize = dedupRows * 16L;
                        timestampMergeIndexAddr = Unsafe.realloc(tempIndexAddr, tempIndexSize, timestampMergeIndexSize, 45);
                        long duplicateCount = mergeRowCount - dedupRows;
                        boolean appendOnly = false;
                        if (duplicateCount > 0L) {
                            if (duplicateCount == mergeOOOHi - mergeOOOLo + 1L && prefixType != 1 && tableWriter.checkDedupCommitIdenticalToPartition(oldPartitionTimestamp, srcNameTxn, srcDataOldPartitionSize, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, timestampMergeIndexAddr, dedupRows)) {
                                if (suffixType != 1) {
                                    LOG.info().$("deduplication resulted in noop [table=").$(tableWriter.getTableToken()).$(", partition=").$ts(partitionTimestamp).I$();
                                    O3PartitionJob.updatePartition(tableWriter.getFilesFacade(), srcTimestampAddr, srcTimestampSize, srcTimestampFd, tableWriter, partitionUpdateSinkAddr, oldPartitionTimestamp, Long.MAX_VALUE, -1L, srcDataOldPartitionSize, 0);
                                    timestampMergeIndexAddr = Unsafe.free(timestampMergeIndexAddr, timestampMergeIndexSize, 45);
                                    Path path = Path.getThreadLocal(pathToTable);
                                    TableUtils.setPathForNativePartition(path, tableWriter.getPartitionBy(), partitionTimestamp, txn);
                                    tableWriter.getConfiguration().getFilesFacade().rmdir(path, false);
                                    return;
                                }
                                appendOnly = true;
                            }
                        } else if (suffixType != 2) {
                            long dataMergeMaxTimestamp = Unsafe.getUnsafe().getLong(srcTimestampAddr + mergeDataHi * 8L);
                            boolean bl = appendOnly = oooTimestampMin >= dataMergeMaxTimestamp;
                        }
                        if (appendOnly) {
                            mergeType = -1;
                            mergeDataHi = -1L;
                            mergeDataLo = 0L;
                            mergeOOOHi = -1L;
                            mergeOOOLo = 0L;
                            if (duplicateCount > 0L) {
                                srcOooLo = suffixLo;
                            } else {
                                suffixType = 1;
                                suffixLo = srcOooLo;
                                suffixHi = srcOooHi;
                            }
                            if (o3SplitPartitionSize > 0L) {
                                LOG.info().$("dedup resulted in no merge, undo partition split [table=").$safe(tableWriter.getTableToken().getTableName()).$(", partition=").$ts(oldPartitionTimestamp).$(", split=").$ts(partitionTimestamp).I$();
                                partitionTimestamp = oldPartitionTimestamp;
                                srcDataNewPartitionSize += o3SplitPartitionSize;
                                o3SplitPartitionSize = 0L;
                            }
                            timestampMergeIndexAddr = Unsafe.free(timestampMergeIndexAddr, timestampMergeIndexSize, 45);
                            prefixType = 2;
                            prefixLo = 0L;
                            prefixHi = srcDataMax - 1L;
                            if (openColumnMode == 4) {
                                openColumnMode = 2;
                            } else if (openColumnMode == 3) {
                                openColumnMode = 1;
                            } else assert (false) : "unexpected open column mode: " + openColumnMode;
                        }
                        if (o3SplitPartitionSize > 0L) {
                            o3SplitPartitionSize -= duplicateCount;
                        } else {
                            srcDataNewPartitionSize -= duplicateCount;
                        }
                        LOG.info().$("dedup row reduction [table=").$safe(tableWriter.getTableToken().getTableName()).$(", partition=").$ts(partitionTimestamp).$(", duplicateCount=").$(duplicateCount).$(", srcDataNewPartitionSize=").$(srcDataNewPartitionSize).$(", srcDataOldPartitionSize=").$(srcDataOldPartitionSize).$(", o3SplitPartitionSize=").$(srcDataOldPartitionSize).$(", mergeDataLo=").$(mergeDataLo).$(", mergeDataHi=").$(mergeDataHi).$(", mergeOOOLo=").$(mergeOOOLo).$(", mergeOOOHi=").$(mergeOOOHi).I$();
                        break block34;
                    }
                    if (tableWriter.isCommitReplaceMode()) {
                        mergeType = 1;
                        break block34;
                    }
                    throw new IllegalStateException("commit mode not supported");
                }
                catch (Throwable e) {
                    tableWriter.o3BumpErrorCount(CairoException.isCairoOomError(e));
                    LOG.error().$("open column error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                    Unsafe.free(timestampMergeIndexAddr, timestampMergeIndexSize, 45);
                    O3CopyJob.closeColumnIdleQuick(0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter);
                    throw e;
                }
            }
        }
        tableWriter.addPhysicallyWrittenRows(O3OpenColumnJob.isOpenColumnModeForAppend(openColumnMode) ? srcOooBatchRowSize : (o3SplitPartitionSize == 0L ? srcDataNewPartitionSize : o3SplitPartitionSize));
        int columnCount = metadata.getColumnCount();
        columnCounter.set(TableUtils.compressColumnCount(metadata));
        int columnsInFlight = columnCount;
        if (openColumnMode == 4 || openColumnMode == 3) {
            Vect.memset(partitionUpdateSinkAddr + 64L, 8L * (long)columnCount, 0);
        }
        try {
            for (int i = 0; i < columnCount; ++i) {
                long srcOooVarAddr;
                long srcOooFixAddr;
                long activeVarFd;
                long activeFixFd;
                int columnType = metadata.getColumnType(i);
                if (columnType < 0) continue;
                int colOffset = TableWriter.getPrimaryColumnIndex(i);
                boolean notTheTimestamp = i != timestampIndex;
                MemoryCR oooMem1 = oooColumns.getQuick(colOffset);
                MemoryCR oooMem2 = oooColumns.getQuick(colOffset + 1);
                MemoryMA mem1 = columns.getQuick(colOffset);
                MemoryMA mem2 = columns.getQuick(colOffset + 1);
                if (!ColumnType.isVarSize(columnType)) {
                    activeFixFd = mem1.getFd();
                    activeVarFd = 0L;
                    srcOooFixAddr = i == timestampIndex ? sortedTimestampsAddr : oooMem1.addressOf(0L);
                    srcOooVarAddr = 0L;
                } else {
                    activeFixFd = mem2.getFd();
                    activeVarFd = mem1.getFd();
                    srcOooFixAddr = oooMem2.addressOf(0L);
                    srcOooVarAddr = oooMem1.addressOf(0L);
                }
                String columnName = metadata.getColumnName(i);
                boolean isIndexed = metadata.isColumnIndexed(i);
                int indexBlockCapacity = isIndexed ? metadata.getIndexValueBlockCapacity(i) : -1;
                long srcDataTop = openColumnMode == 2 || openColumnMode == 4 ? tableWriter.getColumnTop(i) : -1L;
                BitmapIndexWriter indexWriter = isIndexed ? o3Basket.nextIndexer() : null;
                try {
                    long cursor = tableWriter.getO3OpenColumnPubSeq().next();
                    long columnNameTxn = tableWriter.getColumnNameTxn(oldPartitionTimestamp, i);
                    if (cursor > -1L) {
                        O3PartitionJob.publishOpenColumnTaskHarmonized(cursor, openColumnMode, pathToTable, columnName, columnCounter, o3Basket.nextPartCounter(), notTheTimestamp ? columnType : ColumnType.setDesignatedTimestampBit(columnType, true), timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, partitionTimestamp, oldPartitionTimestamp, srcDataTop, srcDataMax, srcNameTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, activeFixFd, activeVarFd, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr, i, columnNameTxn);
                        continue;
                    }
                    O3PartitionJob.publishOpenColumnTaskContended(cursor, openColumnMode, pathToTable, columnName, columnCounter, o3Basket.nextPartCounter(), notTheTimestamp ? columnType : ColumnType.setDesignatedTimestampBit(columnType, true), timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, partitionTimestamp, oldPartitionTimestamp, srcDataTop, srcDataMax, srcNameTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, indexBlockCapacity, activeFixFd, activeVarFd, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr, i, columnNameTxn);
                    continue;
                }
                catch (Throwable e) {
                    tableWriter.o3BumpErrorCount(CairoException.isCairoOomError(e));
                    LOG.critical().$("open column error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                    columnsInFlight = i + 1;
                    throw e;
                }
            }
        }
        finally {
            int delta = columnsInFlight - columnCount;
            LOG.debug().$("idle [delta=").$(delta).I$();
            if (delta < 0 && columnCounter.addAndGet(delta) == 0) {
                O3CopyJob.closeColumnIdleQuick(timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateParquetIndexes(int partitionBy, long partitionTimestamp, TableWriter tableWriter, long srcNameTxn, O3Basket o3Basket, long newPartitionSize, long newParquetSize, Path pathToTable, Path path, FilesFacade ff, PartitionDecoder partitionDecoder, TableRecordMetadata tableWriterMetadata, DirectIntList parquetColumns, RowGroupBuffers rowGroupBuffers) {
        long parquetAddr = 0L;
        try {
            parquetAddr = TableUtils.mapRO(ff, path.$(), LOG, newParquetSize, 17);
            partitionDecoder.of(parquetAddr, newParquetSize, 65);
            path.of(pathToTable);
            TableUtils.setPathForNativePartition(path, partitionBy, partitionTimestamp, srcNameTxn);
            int pLen = path.size();
            BitmapIndexWriter indexWriter = null;
            int columnCount = tableWriterMetadata.getColumnCount();
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                int indexBlockCapacity;
                if (tableWriterMetadata.getColumnType(columnIndex) != 12 || !tableWriterMetadata.isColumnIndexed(columnIndex) || (indexBlockCapacity = tableWriterMetadata.getIndexValueBlockCapacity(columnIndex)) < 0) continue;
                String columnName = tableWriterMetadata.getColumnName(columnIndex);
                long columnNameTxn = tableWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
                long kFd = 0L;
                long vFd = 0L;
                try {
                    kFd = TableUtils.openRW(ff, BitmapIndexUtils.keyFileName(path.trimTo(pLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                    vFd = TableUtils.openRW(ff, BitmapIndexUtils.valueFileName(path.trimTo(pLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                }
                catch (Throwable th) {
                    O3Utils.close(ff, kFd);
                    O3Utils.close(ff, vFd);
                    throw th;
                }
                if (indexWriter == null) {
                    indexWriter = o3Basket.nextIndexer();
                }
                try {
                    PartitionDecoder.Metadata parquetMetadata = partitionDecoder.metadata();
                    int parquetColumnIndex = -1;
                    int cnt = parquetMetadata.columnCount();
                    for (int idx = 0; idx < cnt; ++idx) {
                        if (parquetMetadata.columnId(idx) != columnIndex) continue;
                        parquetColumnIndex = idx;
                        break;
                    }
                    if (parquetColumnIndex == -1) {
                        path.trimTo(pLen);
                        LOG.error().$("could not find symbol column for indexing in parquet, skipping [path=").$(path).$(", columnIndex=").$(columnIndex).I$();
                        continue;
                    }
                    indexWriter.of(tableWriter.getConfiguration(), kFd, vFd, true, indexBlockCapacity);
                    long columnTop = tableWriter.getColumnVersionReader().getColumnTop(partitionTimestamp, columnIndex);
                    if (columnTop > -1L && newPartitionSize > columnTop) {
                        parquetColumns.clear();
                        parquetColumns.add(parquetColumnIndex);
                        parquetColumns.add(12);
                        long rowCount = 0L;
                        int rowGroupCount = parquetMetadata.rowGroupCount();
                        for (int rowGroupIndex = 0; rowGroupIndex < rowGroupCount; ++rowGroupIndex) {
                            int rowGroupSize = parquetMetadata.rowGroupSize(rowGroupIndex);
                            if (rowCount + (long)rowGroupSize <= columnTop) {
                                rowCount += (long)rowGroupSize;
                                continue;
                            }
                            partitionDecoder.decodeRowGroup(rowGroupBuffers, parquetColumns, rowGroupIndex, (int)Math.max(0L, columnTop - rowCount), rowGroupSize);
                            long rowId = Math.max(rowCount, columnTop);
                            long addr = rowGroupBuffers.getChunkDataPtr(0);
                            long size = rowGroupBuffers.getChunkDataSize(0);
                            long p = addr;
                            long lim = addr + size;
                            while (p < lim) {
                                indexWriter.add(TableUtils.toIndexKey(Unsafe.getUnsafe().getInt(p)), rowId);
                                p += 4L;
                                ++rowId;
                            }
                            rowCount += (long)rowGroupSize;
                        }
                        indexWriter.setMaxValue(newPartitionSize - 1L);
                    }
                    indexWriter.commit();
                    continue;
                }
                finally {
                    Misc.free(indexWriter);
                }
            }
        }
        finally {
            ff.munmap(parquetAddr, newParquetSize, 17);
        }
    }

    private static void updatePartition(FilesFacade ff, long srcTimestampAddr, long srcTimestampSize, long srcTimestampFd, TableWriter tableWriter, long partitionUpdateSinkAddr, long partitionTimestamp, long timestampMin, long newPartitionSize, long oldPartitionSize, int partitionMutates) {
        O3PartitionJob.updatePartitionSink(partitionUpdateSinkAddr, partitionTimestamp, timestampMin, newPartitionSize, oldPartitionSize, partitionMutates);
        O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
        O3Utils.close(ff, srcTimestampFd);
        tableWriter.o3ClockDownPartitionUpdateCount();
        tableWriter.o3CountDownDoneLatch();
    }

    private static void updatePartitionSink(long partitionUpdateSinkAddr, long partitionTimestamp, long o3TimestampMin, long newPartitionSize, long oldPartitionSize, long partitionMutates) {
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr, partitionTimestamp);
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 8L, o3TimestampMin);
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 16L, newPartitionSize);
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 24L, oldPartitionSize);
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 32L, partitionMutates);
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 40L, 0L);
        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 56L, -1L);
    }

    @Override
    protected boolean doRun(int workerId, long cursor, Job.RunStatus runStatus) {
        O3PartitionJob.processPartition((O3PartitionTask)this.queue.get(cursor), cursor, this.subSeq);
        return true;
    }
}

