/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm.file;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.frm.FrameColumn;
import io.questdb.cairo.frm.file.RecycleBin;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;

public class ContiguousFileFixFrameColumn
implements FrameColumn {
    public static final int MEMORY_TAG = 12;
    private static final Log LOG = LogFactory.getLog(ContiguousFileFixFrameColumn.class);
    protected final FilesFacade ff;
    private final int fileOpts;
    private final boolean mixedIOFlag;
    protected boolean closed;
    private int columnIndex;
    private long columnTop;
    private int columnType;
    private long fd = -1L;
    private boolean isReadOnly;
    private long mapAddr;
    private long mapSize;
    private RecycleBin<FrameColumn> recycleBin;
    private int shl;

    public ContiguousFileFixFrameColumn(CairoConfiguration configuration) {
        this.ff = configuration.getFilesFacade();
        this.fileOpts = configuration.getWriterFileOpenOpts();
        this.mixedIOFlag = configuration.isWriterMixedIOEnabled();
    }

    @Override
    public void addTop(long value) {
        assert (value >= 0L);
        this.columnTop += value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void append(long appendOffsetRowCount, FrameColumn sourceColumn, long sourceLo, long sourceHi, int commitMode) {
        if (sourceColumn.getStorageType() != 0) throw new UnsupportedOperationException();
        sourceHi -= sourceColumn.getColumnTop();
        appendOffsetRowCount -= this.columnTop;
        assert ((sourceLo -= sourceColumn.getColumnTop()) >= 0L);
        assert (sourceHi >= 0L);
        assert (appendOffsetRowCount >= 0L);
        if (sourceHi <= 0L) return;
        long sourceFd = sourceColumn.getPrimaryFd();
        long size = sourceHi - sourceLo << this.shl;
        TableUtils.allocateDiskSpaceToPage(this.ff, this.fd, (appendOffsetRowCount << this.shl) + size);
        if (this.mixedIOFlag) {
            if (this.ff.copyData(sourceFd, this.fd, sourceLo << this.shl, appendOffsetRowCount << this.shl, size) != size) {
                throw CairoException.critical(this.ff.errno()).put("Cannot copy data [fd=").put(this.fd).put(", destOffset=").put(appendOffsetRowCount << this.shl).put(", size=").put(size).put(", fileSize=").put(this.ff.length(this.fd)).put(", srcFd=").put(sourceFd).put(", srcOffset=").put(sourceLo << this.shl).put(", srcFileSize=").put(this.ff.length(sourceFd)).put(']');
            }
            if (commitMode == 2) return;
            this.ff.fsync(this.fd);
            return;
        }
        long srcAddress = 0L;
        long dstAddress = 0L;
        try {
            srcAddress = TableUtils.mapAppendColumnBuffer(this.ff, sourceFd, sourceLo << this.shl, size, false, 12);
            dstAddress = TableUtils.mapAppendColumnBuffer(this.ff, this.fd, appendOffsetRowCount << this.shl, size, true, 12);
            Vect.memcpy(dstAddress, srcAddress, size);
            if (commitMode == 2) return;
            TableUtils.msync(this.ff, dstAddress, size, commitMode == 0);
            return;
        }
        finally {
            if (srcAddress != 0L) {
                TableUtils.mapAppendColumnBufferRelease(this.ff, srcAddress, sourceLo << this.shl, size, 12);
            }
            if (dstAddress != 0L) {
                TableUtils.mapAppendColumnBufferRelease(this.ff, dstAddress, appendOffsetRowCount << this.shl, size, 12);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendNulls(long rowCount, long sourceColumnTop, int commitMode) {
        assert ((rowCount -= this.columnTop) >= 0L);
        assert (sourceColumnTop >= 0L);
        if (sourceColumnTop > 0L) {
            TableUtils.allocateDiskSpaceToPage(this.ff, this.fd, rowCount + sourceColumnTop << this.shl);
            long mappedAddress = TableUtils.mapAppendColumnBuffer(this.ff, this.fd, rowCount << this.shl, sourceColumnTop << this.shl, true, 12);
            try {
                TableUtils.setNull(this.columnType, mappedAddress, sourceColumnTop);
                if (commitMode != 2) {
                    TableUtils.msync(this.ff, mappedAddress, sourceColumnTop << this.shl, commitMode == 0);
                }
            }
            finally {
                TableUtils.mapAppendColumnBufferRelease(this.ff, mappedAddress, rowCount << this.shl, sourceColumnTop << this.shl, 12);
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.mapAddr != 0L) {
                this.ff.munmap(this.mapAddr, this.mapSize, 12);
                this.mapAddr = 0L;
                this.mapSize = 0L;
            }
            if (this.fd > -1L) {
                this.ff.close(this.fd);
                this.fd = -1L;
            }
            this.closed = true;
            if (this.recycleBin != null && !this.recycleBin.isClosed()) {
                this.recycleBin.put(this);
            }
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public long getColumnTop() {
        return this.columnTop;
    }

    @Override
    public int getColumnType() {
        return this.columnType;
    }

    @Override
    public long getContiguousAuxAddr(long rowHi) {
        return 0L;
    }

    @Override
    public long getContiguousDataAddr(long rowHi) {
        if (rowHi <= this.columnTop) {
            return 0L;
        }
        this.mapAllRows(rowHi);
        return this.mapAddr;
    }

    @Override
    public long getPrimaryFd() {
        return this.fd;
    }

    @Override
    public long getSecondaryFd() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getStorageType() {
        return 0;
    }

    public void ofRO(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, long columnTop, int columnIndex, boolean isEmpty) {
        assert (this.fd == -1L);
        int plen = 0;
        try {
            this.of(columnType, columnTop, columnIndex);
            if (!isEmpty) {
                plen = partitionPath.size();
                TableUtils.dFile(partitionPath, columnName, columnTxn);
                this.fd = TableUtils.openRO(this.ff, partitionPath.$(), LOG);
                this.isReadOnly = true;
            }
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        finally {
            if (!isEmpty) {
                partitionPath.trimTo(plen);
            }
        }
    }

    public void ofRW(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, long columnTop, int columnIndex) {
        assert (this.fd == -1L);
        int plen = partitionPath.size();
        try {
            this.of(columnType, columnTop, columnIndex);
            TableUtils.dFile(partitionPath, columnName, columnTxn);
            this.fd = TableUtils.openRW(this.ff, partitionPath.$(), LOG, this.fileOpts);
            this.isReadOnly = false;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        finally {
            if (plen != 0) {
                partitionPath.trimTo(plen);
            }
        }
    }

    @Override
    public void setRecycleBin(RecycleBin<FrameColumn> recycleBin) {
        assert (this.recycleBin == null);
        this.recycleBin = recycleBin;
    }

    private void mapAllRows(long rowHi) {
        if (!this.isReadOnly) {
            throw new UnsupportedOperationException("Cannot map writable column");
        }
        long newMemSize = rowHi - this.columnTop << this.shl;
        if (this.mapSize > 0L) {
            if (this.mapSize <= newMemSize) {
                return;
            }
            throw new UnsupportedOperationException("Remap not supported for frame columns yet");
        }
        this.mapSize = newMemSize;
        if (newMemSize > 0L) {
            this.mapAddr = TableUtils.mapRO(this.ff, this.fd, this.mapSize, 12);
        }
    }

    private void of(int columnType, long columnTop, int columnIndex) {
        this.shl = ColumnType.pow2SizeOf(columnType);
        this.columnType = columnType;
        this.columnTop = columnTop;
        this.columnIndex = columnIndex;
        this.closed = false;
    }
}

