/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal.seq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.wal.TableWriterPressureControl;
import io.questdb.std.Rnd;
import io.questdb.std.datetime.millitime.MillisecondClock;

public class TableWriterPressureControlImpl
implements TableWriterPressureControl {
    private static final Rnd MEM_PRESSURE_RND = new Rnd();
    private static final int PARTITION_COUNT_SCALE_DOWN_FACTOR = 4;
    private static final int PARTITION_COUNT_SCALE_UP_FACTOR = 4;
    private static final int TXN_COUNT_SCALE_DOWN_FACTOR = 4;
    private static final int TXN_COUNT_SCALE_UP_FACTOR = 1000;
    private final CairoConfiguration configuration;
    private final MillisecondClock millisecondClock;
    private long inflightBlockRowCount;
    private long inflightTxnCount;
    private long maxBlockRowCount = Integer.MAX_VALUE;
    private int maxRecordedInflightPartitions = 1;
    private int memoryPressureRegulationValue = Integer.MAX_VALUE;
    private long walBackoffUntilEpochMs = Long.MIN_VALUE;

    public TableWriterPressureControlImpl(CairoConfiguration configuration) {
        this.configuration = configuration;
        this.millisecondClock = configuration.getMillisecondClock();
    }

    @Override
    public long getMaxBlockRowCount() {
        return Math.max(1L, this.maxBlockRowCount);
    }

    @Override
    public int getMemoryPressureLevel() {
        if (this.memoryPressureRegulationValue == Integer.MAX_VALUE) {
            return 0;
        }
        if (this.memoryPressureRegulationValue < 0) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getMemoryPressureRegulationValue() {
        return Math.max(1, this.memoryPressureRegulationValue);
    }

    @Override
    public boolean isReadyToProcess() {
        return this.getTicks() > this.walBackoffUntilEpochMs;
    }

    @Override
    public void onBlockApplyError() {
        this.maxBlockRowCount = Math.max(1L, this.inflightBlockRowCount / 4L);
        this.inflightBlockRowCount = 1L;
    }

    @Override
    public boolean onEnoughMemory() {
        this.maxRecordedInflightPartitions = 1;
        this.walBackoffUntilEpochMs = Long.MIN_VALUE;
        this.maxBlockRowCount = Math.max(this.maxBlockRowCount, this.maxBlockRowCount * 1000L);
        if (this.memoryPressureRegulationValue == Integer.MAX_VALUE) {
            return false;
        }
        if (this.memoryPressureRegulationValue < 0) {
            this.memoryPressureRegulationValue = 1;
            return true;
        }
        if (MEM_PRESSURE_RND.nextInt(4) == 0) {
            int beforeDoubling = this.memoryPressureRegulationValue;
            this.memoryPressureRegulationValue *= 4;
            if (this.memoryPressureRegulationValue < beforeDoubling) {
                this.memoryPressureRegulationValue = Integer.MAX_VALUE;
            }
        }
        return true;
    }

    @Override
    public void onOutOfMemory() {
        long inflightRows = this.inflightBlockRowCount;
        this.inflightBlockRowCount = this.maxBlockRowCount = Math.max(1L, inflightRows / 4L);
        if (this.maxRecordedInflightPartitions == 1 && this.inflightTxnCount <= 1L) {
            if (this.memoryPressureRegulationValue <= -5) {
                this.walBackoffUntilEpochMs = Long.MIN_VALUE;
                return;
            }
            this.memoryPressureRegulationValue = this.memoryPressureRegulationValue > 0 ? -1 : --this.memoryPressureRegulationValue;
            long delayMillis = 1L + MEM_PRESSURE_RND.nextLong(this.configuration.getWriteBackOffTimeoutOnMemPressureMs() - 1L);
            this.walBackoffUntilEpochMs = this.getTicks() + delayMillis;
            return;
        }
        this.walBackoffUntilEpochMs = Long.MIN_VALUE;
        this.memoryPressureRegulationValue = this.maxRecordedInflightPartitions / 4;
        this.maxRecordedInflightPartitions = 1;
    }

    @Override
    public void setMaxBlockRowCount(int count) {
        this.maxBlockRowCount = count;
    }

    @Override
    public void updateInflightPartitions(int count) {
        this.maxRecordedInflightPartitions = Math.max(this.maxRecordedInflightPartitions, count);
    }

    @Override
    public void updateInflightTxnBlockLength(long txnCount, long rowCount) {
        this.inflightBlockRowCount = rowCount;
        this.inflightTxnCount = txnCount;
    }

    private long getTicks() {
        return this.millisecondClock.getTicks();
    }
}

