/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.client;

import io.questdb.ClientTlsConfiguration;
import io.questdb.DefaultHttpClientConfiguration;
import io.questdb.HttpClientConfiguration;
import io.questdb.client.ArraySender;
import io.questdb.client.impl.ConfStringParser;
import io.questdb.cutlass.auth.AuthUtils;
import io.questdb.cutlass.line.AbstractLineTcpSender;
import io.questdb.cutlass.line.LineChannel;
import io.questdb.cutlass.line.LineSenderException;
import io.questdb.cutlass.line.LineTcpSenderV1;
import io.questdb.cutlass.line.LineTcpSenderV2;
import io.questdb.cutlass.line.http.AbstractLineHttpSender;
import io.questdb.cutlass.line.tcp.DelegatingTlsChannel;
import io.questdb.cutlass.line.tcp.PlainTcpLineChannel;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.bytes.DirectByteSlice;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import java.security.PrivateKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import javax.security.auth.DestroyFailedException;
import org.jetbrains.annotations.NotNull;

public interface Sender
extends Closeable,
ArraySender<Sender> {
    public static final int PROTOCOL_VERSION_NOT_SET_EXPLICIT = -1;
    public static final int PROTOCOL_VERSION_V1 = 1;
    public static final int PROTOCOL_VERSION_V2 = 2;

    public static LineSenderBuilder builder(CharSequence configurationString) {
        return new LineSenderBuilder().fromConfig(configurationString);
    }

    public static LineSenderBuilder builder(Transport transport) {
        return new LineSenderBuilder(transport == Transport.HTTP ? 1 : 0);
    }

    public static Sender fromConfig(CharSequence configurationString) {
        return Sender.builder(configurationString).build();
    }

    public static Sender fromEnv() {
        String configString = System.getenv("QDB_CLIENT_CONF");
        if (Chars.isBlank(configString)) {
            throw new LineSenderException((CharSequence)"QDB_CLIENT_CONF environment variable is not set");
        }
        return Sender.fromConfig(configString);
    }

    public void at(long var1, ChronoUnit var3);

    public void at(Instant var1);

    public void atNow();

    public Sender boolColumn(CharSequence var1, boolean var2);

    public DirectByteSlice bufferView();

    public void cancelRow();

    @Override
    public void close();

    public Sender doubleColumn(CharSequence var1, double var2);

    public void flush();

    public Sender longColumn(CharSequence var1, long var2);

    public Sender stringColumn(CharSequence var1, CharSequence var2);

    public Sender symbol(CharSequence var1, CharSequence var2);

    public Sender table(CharSequence var1);

    public Sender timestampColumn(CharSequence var1, long var2, ChronoUnit var4);

    public Sender timestampColumn(CharSequence var1, Instant var2);

    public static final class LineSenderBuilder {
        private static final int AUTO_FLUSH_DISABLED = 0;
        private static final int DEFAULT_AUTO_FLUSH_INTERVAL_MILLIS = 1000;
        private static final int DEFAULT_AUTO_FLUSH_ROWS = 75000;
        private static final int DEFAULT_BUFFER_CAPACITY = 65536;
        private static final int DEFAULT_HTTP_PORT = 9000;
        private static final int DEFAULT_HTTP_TIMEOUT = 30000;
        private static final int DEFAULT_MAXIMUM_BUFFER_CAPACITY = 0x6400000;
        private static final int DEFAULT_MAX_NAME_LEN = 127;
        private static final long DEFAULT_MAX_RETRY_NANOS = TimeUnit.SECONDS.toNanos(10L);
        private static final long DEFAULT_MIN_REQUEST_THROUGHPUT = 102400L;
        private static final int DEFAULT_TCP_PORT = 9009;
        private static final int MIN_BUFFER_SIZE = 513;
        private static final int PARAMETER_NOT_SET_EXPLICITLY = -1;
        private static final int PROTOCOL_HTTP = 1;
        private static final int PROTOCOL_TCP = 0;
        private int autoFlushIntervalMillis = -1;
        private int autoFlushRows = -1;
        private int bufferCapacity = -1;
        private String host;
        private String httpPath;
        private String httpSettingsPath;
        private int httpTimeout = -1;
        private String httpToken;
        private String keyId;
        private int maxNameLength = -1;
        private int maximumBufferCapacity = -1;
        private final HttpClientConfiguration httpClientConfiguration = new DefaultHttpClientConfiguration(this){
            final /* synthetic */ LineSenderBuilder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int getInitialRequestBufferSize() {
                return this.this$0.bufferCapacity == -1 ? 65536 : this.this$0.bufferCapacity;
            }

            @Override
            public int getMaximumRequestBufferSize() {
                return this.this$0.maximumBufferCapacity == -1 ? 0x6400000 : this.this$0.maximumBufferCapacity;
            }

            @Override
            public String getSettingsPath() {
                return this.this$0.httpSettingsPath == null ? super.getSettingsPath() : this.this$0.httpSettingsPath;
            }

            @Override
            public int getTimeout() {
                return this.this$0.httpTimeout == -1 ? 30000 : this.this$0.httpTimeout;
            }
        };
        private long minRequestThroughput = -1L;
        private String password;
        private int port = -1;
        private PrivateKey privateKey;
        private int protocol = -1;
        private int protocolVersion = -1;
        private int retryTimeoutMillis = -1;
        private boolean shouldDestroyPrivKey;
        private boolean tlsEnabled;
        private TlsValidationMode tlsValidationMode;
        private char[] trustStorePassword;
        private String trustStorePath;
        private String username;

        private LineSenderBuilder() {
        }

        private LineSenderBuilder(int protocol) {
            this.protocol = protocol;
        }

        public LineSenderBuilder address(CharSequence address) {
            if (this.host != null) {
                throw new LineSenderException((CharSequence)"server address is already configured ").put("[address=").put(this.host).put("]");
            }
            if (Chars.isBlank(address)) {
                throw new LineSenderException((CharSequence)"address cannot be empty nor null");
            }
            int portIndex = Chars.indexOf(address, ':');
            if (portIndex + 1 == address.length()) {
                throw new LineSenderException((CharSequence)"invalid address, use IPv4 address or a domain name [address=").put(address).put("]");
            }
            if (portIndex != -1) {
                if (this.port != -1) {
                    throw new LineSenderException((CharSequence)"address contains a port, but a port was already configured ").put("[address=").put(address).put(", port=").put(this.port).put("]");
                }
                this.host = address.subSequence(0, portIndex).toString();
                try {
                    this.port(Numbers.parseInt(address, portIndex + 1, address.length()));
                }
                catch (NumericException e) {
                    throw new LineSenderException((CharSequence)"cannot parse a port from the address, use IPv4 address or a domain name").put(" [address=").put(address).put("]");
                }
            } else {
                this.host = address.toString();
            }
            return this;
        }

        public AdvancedTlsSettings advancedTls() {
            if (this.trustStorePath != null) {
                throw new LineSenderException((CharSequence)"custom trust store was already configured ").put("[path=").put(this.trustStorePath).put("]");
            }
            if (this.tlsValidationMode == TlsValidationMode.INSECURE) {
                throw new LineSenderException((CharSequence)"TLS validation was already disabled");
            }
            return new AdvancedTlsSettings();
        }

        public LineSenderBuilder autoFlushIntervalMillis(int autoFlushIntervalMillis) {
            if (this.autoFlushIntervalMillis != -1 && this.autoFlushIntervalMillis != Integer.MAX_VALUE) {
                throw new LineSenderException((CharSequence)"auto flush interval was already configured ").put("[autoFlushIntervalMillis=").put(this.autoFlushIntervalMillis).put("]");
            }
            if (this.autoFlushIntervalMillis == Integer.MAX_VALUE && autoFlushIntervalMillis != Integer.MAX_VALUE) {
                throw new LineSenderException((CharSequence)"cannot set auto flush interval when interval based auto-flush is already disabled");
            }
            if (autoFlushIntervalMillis <= 0) {
                throw new LineSenderException((CharSequence)"auto flush interval cannot be negative ").put("[autoFlushIntervalMillis=").put(autoFlushIntervalMillis).put("]");
            }
            this.autoFlushIntervalMillis = autoFlushIntervalMillis;
            return this;
        }

        public LineSenderBuilder autoFlushRows(int autoFlushRows) {
            if (this.autoFlushRows != -1 && this.autoFlushRows != 0) {
                throw new LineSenderException((CharSequence)"auto flush rows was already configured ").put("[autoFlushRows=").put(this.autoFlushRows).put("]");
            }
            if (this.autoFlushRows == 0 && autoFlushRows != 0) {
                throw new LineSenderException((CharSequence)"cannot set auto flush rows when auto-flush is already disabled");
            }
            if (autoFlushRows < 0) {
                throw new LineSenderException((CharSequence)"auto flush rows cannot be negative ").put("[autoFlushRows=").put(autoFlushRows).put("]");
            }
            this.autoFlushRows = autoFlushRows;
            return this;
        }

        public LineSenderBuilder bufferCapacity(int bufferCapacity) {
            if (this.bufferCapacity != -1) {
                throw new LineSenderException((CharSequence)"buffer capacity was already configured ").put("[capacity=").put(this.bufferCapacity).put("]");
            }
            if (bufferCapacity < 0) {
                throw new LineSenderException((CharSequence)"buffer capacity cannot be negative ").put("[capacity=").put(bufferCapacity).put("]");
            }
            this.bufferCapacity = bufferCapacity;
            return this;
        }

        public Sender build() {
            AbstractLineTcpSender sender;
            this.configureDefaults();
            this.validateParameters();
            NetworkFacade nf = NetworkFacadeImpl.INSTANCE;
            if (this.protocol == 1) {
                long actualMinRequestThroughput;
                int actualAutoFlushRows = this.autoFlushRows == -1 ? 75000 : this.autoFlushRows;
                long actualMaxRetriesNanos = this.retryTimeoutMillis == -1 ? DEFAULT_MAX_RETRY_NANOS : (long)this.retryTimeoutMillis * 1000000L;
                long l = actualMinRequestThroughput = this.minRequestThroughput == -1L ? 102400L : this.minRequestThroughput;
                long actualAutoFlushIntervalMillis = this.autoFlushIntervalMillis == Integer.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toNanos(this.autoFlushIntervalMillis == -1 ? 1000L : (long)this.autoFlushIntervalMillis);
                ClientTlsConfiguration tlsConfig = null;
                if (this.tlsEnabled) {
                    assert (this.trustStorePath == null == (this.trustStorePassword == null));
                    tlsConfig = new ClientTlsConfiguration(this.trustStorePath, this.trustStorePassword, this.tlsValidationMode == TlsValidationMode.DEFAULT ? 0 : 1);
                }
                return AbstractLineHttpSender.createLineSender(this.host, this.port, this.httpPath, this.httpClientConfiguration, tlsConfig, actualAutoFlushRows, this.httpToken, this.username, this.password, this.maxNameLength, actualMaxRetriesNanos, actualMinRequestThroughput, actualAutoFlushIntervalMillis, this.protocolVersion);
            }
            assert (this.protocol == 0);
            LineChannel channel = new PlainTcpLineChannel(nf, this.host, this.port, this.bufferCapacity * 2);
            if (this.tlsEnabled) {
                DelegatingTlsChannel tlsChannel;
                try {
                    tlsChannel = new DelegatingTlsChannel(channel, this.trustStorePath, this.trustStorePassword, this.tlsValidationMode, this.host);
                }
                catch (Throwable t) {
                    channel.close();
                    throw LineSenderBuilder.rethrow(t);
                }
                channel = tlsChannel;
            }
            try {
                sender = this.protocolVersion == 1 ? new LineTcpSenderV1(channel, this.bufferCapacity, this.maxNameLength) : new LineTcpSenderV2(channel, this.bufferCapacity, this.maxNameLength);
            }
            catch (Throwable t) {
                channel.close();
                throw LineSenderBuilder.rethrow(t);
            }
            if (this.privateKey != null) {
                try {
                    sender.authenticate(this.keyId, this.privateKey);
                }
                catch (Throwable t) {
                    sender.close();
                    throw LineSenderBuilder.rethrow(t);
                }
                finally {
                    if (this.shouldDestroyPrivKey) {
                        try {
                            this.privateKey.destroy();
                        }
                        catch (DestroyFailedException t) {}
                    }
                }
            }
            return sender;
        }

        public LineSenderBuilder disableAutoFlush() {
            if (this.autoFlushRows != -1 && this.autoFlushRows != 0) {
                throw new LineSenderException((CharSequence)"auto flush rows was already configured ").put("[autoFlushRows=").put(this.autoFlushRows).put("]");
            }
            if (this.autoFlushIntervalMillis != -1 && this.autoFlushIntervalMillis != Integer.MAX_VALUE) {
                throw new LineSenderException((CharSequence)"auto flush interval was already configured ").put("[autoFlushIntervalMillis=").put(this.autoFlushIntervalMillis).put("]");
            }
            this.autoFlushRows = 0;
            this.autoFlushIntervalMillis = Integer.MAX_VALUE;
            return this;
        }

        public AuthBuilder enableAuth(String keyId) {
            if (this.keyId != null) {
                throw new LineSenderException((CharSequence)"authentication keyId was already configured ").put("[keyId=").put(this.keyId).put("]");
            }
            if (Chars.isBlank(keyId)) {
                throw new LineSenderException((CharSequence)"keyId cannot be empty nor null");
            }
            this.keyId = keyId;
            return new AuthBuilder();
        }

        public LineSenderBuilder enableTls() {
            if (this.tlsEnabled) {
                throw new LineSenderException((CharSequence)"tls was already enabled");
            }
            this.tlsEnabled = true;
            return this;
        }

        public LineSenderBuilder httpPath(String path) {
            if (this.httpPath != null) {
                throw new LineSenderException((CharSequence)"path was already configured");
            }
            if (Chars.isBlank(path)) {
                throw new LineSenderException((CharSequence)"path cannot be empty nor null");
            }
            if (!Chars.startsWith((CharSequence)path, '/')) {
                throw new LineSenderException((CharSequence)"the path has to start with '/'");
            }
            this.httpPath = path;
            return this;
        }

        public LineSenderBuilder httpSettingPath(String path) {
            if (this.httpSettingsPath != null) {
                throw new LineSenderException((CharSequence)"the path was already configured");
            }
            if (Chars.isBlank(path)) {
                throw new LineSenderException((CharSequence)"the path cannot be empty nor null");
            }
            if (!Chars.startsWith((CharSequence)path, '/')) {
                throw new LineSenderException((CharSequence)"the path has to start with '/'");
            }
            this.httpSettingsPath = path;
            return this;
        }

        public LineSenderBuilder httpTimeoutMillis(int httpTimeoutMillis) {
            if (this.httpTimeout != -1) {
                throw new LineSenderException((CharSequence)"HTTP timeout was already configured ").put("[timeout=").put(this.httpTimeout).put("]");
            }
            if (httpTimeoutMillis < 1) {
                throw new LineSenderException((CharSequence)"HTTP timeout must be positive ").put("[timeout=").put(httpTimeoutMillis).put("]");
            }
            this.httpTimeout = httpTimeoutMillis;
            return this;
        }

        public LineSenderBuilder httpToken(String token) {
            if (this.username != null) {
                throw new LineSenderException((CharSequence)"authentication username was already configured ").put("[username=").put(this.username).put("]");
            }
            if (this.httpToken != null) {
                throw new LineSenderException((CharSequence)"token was already configured");
            }
            if (Chars.isBlank(token)) {
                throw new LineSenderException((CharSequence)"token cannot be empty nor null");
            }
            this.httpToken = token;
            return this;
        }

        public LineSenderBuilder httpUsernamePassword(String username, String password) {
            if (this.username != null) {
                throw new LineSenderException((CharSequence)"authentication username was already configured ").put("[username=").put(this.username).put("]");
            }
            if (Chars.isBlank(username)) {
                throw new LineSenderException((CharSequence)"username cannot be empty nor null");
            }
            if (Chars.isBlank(password)) {
                throw new LineSenderException((CharSequence)"password cannot be empty nor null");
            }
            if (this.httpToken != null) {
                throw new LineSenderException((CharSequence)"token authentication is already configured");
            }
            this.username = username;
            this.password = password;
            return this;
        }

        public LineSenderBuilder maxBufferCapacity(int maximumBufferCapacity) {
            if (maximumBufferCapacity < 65536) {
                throw new LineSenderException((CharSequence)"maximum buffer capacity cannot be less than initial buffer capacity ").put("[maximumBufferCapacity=").put(maximumBufferCapacity).put(", initialBufferCapacity=").put(65536L).put("]");
            }
            this.maximumBufferCapacity = maximumBufferCapacity;
            return this;
        }

        public LineSenderBuilder maxNameLength(int maxNameLength) {
            if (this.maxNameLength != -1) {
                throw new LineSenderException((CharSequence)"max name length was already configured ").put("[max_name_len=").put(this.maxNameLength).put("]");
            }
            if (maxNameLength < 16) {
                throw new LineSenderException((CharSequence)"max_name_len must be at least 16 bytes ").put("[max_name_len=").put(maxNameLength).put("]");
            }
            this.maxNameLength = maxNameLength;
            return this;
        }

        public LineSenderBuilder minRequestThroughput(int minRequestThroughput) {
            if (minRequestThroughput < 1) {
                throw new LineSenderException((CharSequence)"minimum request throughput must not be negative ").put("[minRequestThroughput=").put(minRequestThroughput).put("]");
            }
            this.minRequestThroughput = minRequestThroughput;
            return this;
        }

        public LineSenderBuilder port(int port) {
            if (this.port != -1) {
                throw new LineSenderException((CharSequence)"post is already configured ").put("[port=").put(port).put("]");
            }
            if (port < 1 || port > 65535) {
                throw new LineSenderException((CharSequence)"invalid port [port=").put(port).put("]");
            }
            this.port = port;
            return this;
        }

        public LineSenderBuilder protocolVersion(int protocolVersion) {
            if (this.protocolVersion != -1) {
                throw new LineSenderException((CharSequence)"protocol version was already configured ").put("[protocolVersion=").put(this.protocolVersion).put("]");
            }
            if (protocolVersion < 1 || protocolVersion > 2) {
                throw new LineSenderException((CharSequence)"current client only supports protocol version 1(text format for all datatypes), 2(binary format for part datatypes) or explicitly unset");
            }
            this.protocolVersion = protocolVersion;
            return this;
        }

        public LineSenderBuilder retryTimeoutMillis(int retryTimeoutMillis) {
            if (this.retryTimeoutMillis != -1) {
                throw new LineSenderException((CharSequence)"retry timeout was already configured ").put("[retryTimeoutMillis=").put(this.retryTimeoutMillis).put("]");
            }
            if (retryTimeoutMillis < 0) {
                throw new LineSenderException((CharSequence)"retry timeout cannot be negative ").put("[retryTimeoutMillis=").put(retryTimeoutMillis).put("]");
            }
            if (this.protocol == 0) {
                throw new LineSenderException((CharSequence)"retrying is not supported for TCP protocol");
            }
            this.retryTimeoutMillis = retryTimeoutMillis;
            return this;
        }

        private static int getValue(CharSequence configurationString, int pos, StringSink sink, String name) {
            if ((pos = ConfStringParser.value(configurationString, pos, sink)) < 0) {
                throw new LineSenderException((CharSequence)"invalid ").put(name).put(" [error=").put(sink).put("]");
            }
            return pos;
        }

        private static int parseIntValue(@NotNull StringSink value, @NotNull String name) {
            if (Chars.isBlank(value)) {
                throw new LineSenderException((CharSequence)name).put(" cannot be empty");
            }
            try {
                return Numbers.parseInt(value);
            }
            catch (NumericException e) {
                throw new LineSenderException((CharSequence)"invalid ").put(name).put(" [value=").put(value).put("]");
            }
        }

        private static RuntimeException rethrow(Throwable t) {
            if (t instanceof LineSenderException) {
                throw (LineSenderException)t;
            }
            throw new LineSenderException(t);
        }

        private void configureDefaults() {
            if (this.protocol == -1) {
                this.protocol = 0;
            }
            if (this.bufferCapacity == -1) {
                this.bufferCapacity = 65536;
            }
            if (this.maximumBufferCapacity == -1) {
                int n = this.maximumBufferCapacity = this.protocol == 1 ? 0x6400000 : this.bufferCapacity;
            }
            if (this.port == -1) {
                int n = this.port = this.protocol == 1 ? 9000 : 9009;
            }
            if (this.tlsValidationMode == null) {
                this.tlsValidationMode = TlsValidationMode.DEFAULT;
            }
            if (this.protocol == 0 && this.protocolVersion == -1) {
                this.protocolVersion = 1;
            }
            if (this.maxNameLength == -1) {
                this.maxNameLength = 127;
            }
        }

        private LineSenderBuilder fromConfig(CharSequence configurationString) {
            if (Chars.isBlank(configurationString)) {
                throw new LineSenderException((CharSequence)"configuration string cannot be empty nor null");
            }
            StringSink sink = new StringSink();
            int pos = ConfStringParser.of(configurationString, sink);
            if (pos < 0) {
                throw new LineSenderException((CharSequence)"invalid configuration string: ").put(sink);
            }
            if (this.protocol != -1) {
                throw new LineSenderException((CharSequence)"protocol was already configured ").put("[protocol=").put(this.protocol == 1 ? "http" : "tcp").put("]");
            }
            if (this.host != null) {
                throw new LineSenderException((CharSequence)"server address was already configured ").put("[address=").put(this.host).put("]");
            }
            if (this.port != -1) {
                throw new LineSenderException((CharSequence)"server port was already configured ").put("[port=").put(this.port).put("]");
            }
            if (Chars.equals((CharSequence)"http", sink)) {
                if (this.tlsEnabled) {
                    throw new LineSenderException((CharSequence)"cannot use http protocol when TLS is enabled. use https instead");
                }
                this.http();
            } else if (Chars.equals((CharSequence)"tcp", sink)) {
                if (this.tlsEnabled) {
                    throw new LineSenderException((CharSequence)"cannot use tcp protocol when TLS is enabled. use tcps instead");
                }
                this.tcp();
            } else if (Chars.equals((CharSequence)"https", sink)) {
                this.http();
                this.tlsEnabled = true;
            } else if (Chars.equals((CharSequence)"tcps", sink)) {
                this.tcp();
                this.tlsEnabled = true;
            } else {
                throw new LineSenderException((CharSequence)"invalid schema [schema=").put(sink).put(", supported-schemas=[http, https, tcp, tcps]]");
            }
            String tcpToken = null;
            String user = null;
            String password = null;
            boolean initBufSizeSet = false;
            boolean autoFlushBytesSet = false;
            while (ConfStringParser.hasNext(configurationString, pos)) {
                if ((pos = ConfStringParser.nextKey(configurationString, pos, sink)) < 0) {
                    throw new LineSenderException((CharSequence)"invalid configuration string [error=").put(sink).put(']');
                }
                if (Chars.equals((CharSequence)"addr", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "address");
                    this.address(sink);
                    if (this.port != -1) continue;
                    this.port(this.protocol == 0 ? 9009 : 9000);
                    continue;
                }
                if (Chars.equals((CharSequence)"user", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "user");
                    user = sink.toString();
                    continue;
                }
                if (Chars.equals((CharSequence)"username", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "username");
                    user = sink.toString();
                    continue;
                }
                if (Chars.equals((CharSequence)"pass", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "pass");
                    if (this.protocol == 0) {
                        throw new LineSenderException((CharSequence)"password is not supported for TCP protocol");
                    }
                    password = sink.toString();
                    continue;
                }
                if (Chars.equals((CharSequence)"password", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "password");
                    if (this.protocol == 0) {
                        throw new LineSenderException((CharSequence)"password is not supported for TCP protocol");
                    }
                    password = sink.toString();
                    continue;
                }
                if (Chars.equals((CharSequence)"tls_verify", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "tls_verify");
                    if (this.tlsValidationMode != null) {
                        throw new LineSenderException((CharSequence)"tls_verify was already configured");
                    }
                    if (Chars.equals((CharSequence)"on", sink)) {
                        this.tlsValidationMode = TlsValidationMode.DEFAULT;
                        continue;
                    }
                    if (Chars.equals((CharSequence)"unsafe_off", sink)) {
                        this.tlsValidationMode = TlsValidationMode.INSECURE;
                        continue;
                    }
                    throw new LineSenderException((CharSequence)"invalid tls_verify [value=").put(sink).put(", allowed-values=[on, unsafe_off]]");
                }
                if (Chars.equals((CharSequence)"tls_roots", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "tls_roots");
                    if (this.trustStorePath != null) {
                        throw new LineSenderException((CharSequence)"tls_roots was already configured");
                    }
                    this.trustStorePath = sink.toString();
                    continue;
                }
                if (Chars.equals((CharSequence)"tls_roots_password", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "tls_roots_password");
                    if (this.trustStorePassword != null) {
                        throw new LineSenderException((CharSequence)"tls_roots_password was already configured");
                    }
                    this.trustStorePassword = new char[sink.length()];
                    int n = sink.length();
                    for (int i = 0; i < n; ++i) {
                        this.trustStorePassword[i] = sink.charAt(i);
                    }
                    continue;
                }
                if (Chars.equals((CharSequence)"token", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "token");
                    if (this.protocol == 0) {
                        tcpToken = sink.toString();
                        continue;
                    }
                    if (this.protocol == 1) {
                        this.httpToken(sink.toString());
                        continue;
                    }
                    throw new AssertionError();
                }
                if (Chars.equals((CharSequence)"retry_timeout", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "retry_timeout");
                    int timeout = LineSenderBuilder.parseIntValue(sink, "retry_timeout");
                    this.retryTimeoutMillis(timeout);
                    continue;
                }
                if (Chars.equals((CharSequence)"max_buf_size", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "max_buf_size");
                    int maxBufferSize = LineSenderBuilder.parseIntValue(sink, "max_buf_size");
                    this.maxBufferCapacity(maxBufferSize);
                    continue;
                }
                if (Chars.equals((CharSequence)"max_name_len", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "max_name_len");
                    int len = LineSenderBuilder.parseIntValue(sink, "max_name_len");
                    this.maxNameLength(len);
                    continue;
                }
                if (Chars.equals((CharSequence)"init_buf_size", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "init_buf_size");
                    int initBufSize = LineSenderBuilder.parseIntValue(sink, "init_buf_size");
                    if (autoFlushBytesSet) {
                        assert (this.protocol == 0);
                        if (initBufSize != this.bufferCapacity) {
                            throw new LineSenderException((CharSequence)"TCP transport requires init_buf_size and auto_flush_bytes to be set to the same value [init_buf_size=").put(initBufSize).put(", auto_flush_bytes=").put(this.bufferCapacity).put(']');
                        }
                    } else {
                        this.bufferCapacity(initBufSize);
                    }
                    initBufSizeSet = true;
                    continue;
                }
                if (Chars.equals((CharSequence)"auto_flush_rows", sink)) {
                    int autoFlushRows;
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "auto_flush_rows");
                    if (Chars.equalsIgnoreCase("off", sink)) {
                        autoFlushRows = 0;
                    } else {
                        autoFlushRows = LineSenderBuilder.parseIntValue(sink, "auto_flush_rows");
                        if (autoFlushRows < 1) {
                            throw new LineSenderException((CharSequence)"invalid auto_flush_rows [value=").put(autoFlushRows).put("]");
                        }
                    }
                    this.autoFlushRows(autoFlushRows);
                    continue;
                }
                if (Chars.equals((CharSequence)"auto_flush_interval", sink)) {
                    int autoFlushInterval;
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "auto_flush_interval");
                    if (Chars.equalsIgnoreCase("off", sink)) {
                        autoFlushInterval = Integer.MAX_VALUE;
                    } else {
                        autoFlushInterval = LineSenderBuilder.parseIntValue(sink, "auto_flush_interval");
                        if (autoFlushInterval < 1) {
                            throw new LineSenderException((CharSequence)"invalid auto_flush_interval [value=").put(autoFlushInterval).put("]");
                        }
                    }
                    this.autoFlushIntervalMillis(autoFlushInterval);
                    continue;
                }
                if (Chars.equals((CharSequence)"auto_flush_bytes", sink)) {
                    if (this.protocol != 0) {
                        throw new LineSenderException((CharSequence)"auto_flush_bytes is only supported for TCP transport");
                    }
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "auto_flush_bytes");
                    if (Chars.equalsIgnoreCase("off", sink)) {
                        throw new LineSenderException((CharSequence)"TCP transport must have auto_flush_bytes enabled");
                    }
                    int autoFlushBytes = LineSenderBuilder.parseIntValue(sink, "auto_flush_bytes");
                    if (initBufSizeSet) {
                        if (autoFlushBytes != this.bufferCapacity) {
                            throw new LineSenderException((CharSequence)"TCP transport requires init_buf_size and auto_flush_bytes to be set to the same value [init_buf_size=").put(this.bufferCapacity).put(", auto_flush_bytes=").put(autoFlushBytes).put(']');
                        }
                    } else {
                        this.bufferCapacity(autoFlushBytes);
                    }
                    autoFlushBytesSet = true;
                    continue;
                }
                if (Chars.equals((CharSequence)"auto_flush", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "auto_flush");
                    if (Chars.equalsIgnoreCase("off", sink)) {
                        this.disableAutoFlush();
                        continue;
                    }
                    if (Chars.equalsIgnoreCase("on", sink)) continue;
                    throw new LineSenderException((CharSequence)"invalid auto_flush [value=").put(sink).put(", allowed-values=[on, off]]");
                }
                if (Chars.equals((CharSequence)"request_timeout", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "request_timeout");
                    int requestTimeout = LineSenderBuilder.parseIntValue(sink, "request_timeout");
                    this.httpTimeoutMillis(requestTimeout);
                    continue;
                }
                if (Chars.equals((CharSequence)"request_min_throughput", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "request_min_throughput");
                    int requestMinThroughput = LineSenderBuilder.parseIntValue(sink, "request_min_throughput");
                    this.minRequestThroughput(requestMinThroughput);
                    continue;
                }
                if (Chars.equals((CharSequence)"protocol_version", sink)) {
                    pos = LineSenderBuilder.getValue(configurationString, pos, sink, "protocol_version");
                    if (Chars.equalsIgnoreCase("auto", sink)) continue;
                    int protocolVersion = LineSenderBuilder.parseIntValue(sink, "protocol_version");
                    this.protocolVersion(protocolVersion);
                    continue;
                }
                if ((pos = ConfStringParser.value(configurationString, pos, sink)) >= 0) continue;
                throw new LineSenderException((CharSequence)"invalid parameter [error=").put(sink).put("]");
            }
            if (this.host == null) {
                throw new LineSenderException((CharSequence)"addr is missing");
            }
            if (this.trustStorePath != null) {
                if (this.trustStorePassword == null) {
                    throw new LineSenderException((CharSequence)"tls_roots was configured, but tls_roots_password is missing");
                }
            } else if (this.trustStorePassword != null) {
                throw new LineSenderException((CharSequence)"tls_roots_password was configured, but tls_roots is missing");
            }
            if (this.protocol == 1) {
                if (user != null) {
                    this.httpUsernamePassword(user, password);
                } else if (password != null) {
                    throw new LineSenderException((CharSequence)"HTTP password is configured, but username is missing");
                }
            } else if (user != null) {
                this.enableAuth(user).authToken(tcpToken);
            } else if (tcpToken != null) {
                throw new LineSenderException((CharSequence)"TCP token is configured, but user is missing");
            }
            return this;
        }

        private void http() {
            if (this.protocol != -1) {
                throw new LineSenderException((CharSequence)"protocol was already configured ").put("[protocol=").put(this.protocol).put("]");
            }
            this.protocol = 1;
        }

        private void tcp() {
            if (this.protocol != -1) {
                throw new LineSenderException((CharSequence)"protocol was already configured ").put("[protocol=").put(this.protocol).put("]");
            }
            this.protocol = 0;
        }

        private void validateParameters() {
            if (this.host == null) {
                throw new LineSenderException((CharSequence)"questdb server address not set");
            }
            if (!this.tlsEnabled && this.trustStorePath != null) {
                throw new LineSenderException((CharSequence)"custom trust store configured, but TLS was not enabled ").put("[path=").put(this.trustStorePath).put("]");
            }
            if (!this.tlsEnabled && this.tlsValidationMode != TlsValidationMode.DEFAULT) {
                throw new LineSenderException((CharSequence)"TSL validation disabled, but TLS was not enabled");
            }
            if (this.keyId != null && this.bufferCapacity < 513) {
                throw new LineSenderException((CharSequence)"Requested buffer too small ").put("[minimalCapacity=").put(513L).put(", requestedCapacity=").put(this.bufferCapacity).put("]");
            }
            if (this.protocol == 1) {
                if (this.httpClientConfiguration.getMaximumRequestBufferSize() < this.httpClientConfiguration.getInitialRequestBufferSize()) {
                    throw new LineSenderException((CharSequence)"maximum buffer capacity cannot be less than initial buffer capacity ").put("[maximumBufferCapacity=").put(this.httpClientConfiguration.getMaximumRequestBufferSize()).put(", initialBufferCapacity=").put(this.httpClientConfiguration.getInitialRequestBufferSize()).put("]");
                }
                if (this.privateKey != null) {
                    throw new LineSenderException((CharSequence)"plain old token authentication is not supported for HTTP protocol. Did you mean to use HTTP token authentication?");
                }
            } else if (this.protocol == 0) {
                if (this.username != null || this.password != null) {
                    throw new LineSenderException((CharSequence)"username/password authentication is not supported for TCP protocol");
                }
                if (this.autoFlushRows == 0) {
                    throw new LineSenderException((CharSequence)"disabling auto-flush is not supported for TCP protocol");
                }
                if (this.autoFlushRows != -1) {
                    throw new LineSenderException((CharSequence)"auto flush rows is not supported for TCP protocol");
                }
                if (this.httpToken != null) {
                    throw new LineSenderException((CharSequence)"HTTP token authentication is not supported for TCP protocol");
                }
                if (this.retryTimeoutMillis != -1) {
                    throw new LineSenderException((CharSequence)"retrying is not supported for TCP protocol");
                }
                if (this.httpTimeout != -1) {
                    throw new LineSenderException((CharSequence)"HTTP timeout is not supported for TCP protocol");
                }
                if (this.minRequestThroughput != -1L) {
                    throw new LineSenderException((CharSequence)"minimum request throughput is not supported for TCP protocol");
                }
                if (this.maximumBufferCapacity != this.bufferCapacity) {
                    throw new LineSenderException((CharSequence)"maximum buffer capacity must be the same as initial buffer capacity for TCP protocol").put("[maximumBufferCapacity=").put(this.maximumBufferCapacity).put(", initialBufferCapacity=").put(this.bufferCapacity).put("]");
                }
                if (this.autoFlushIntervalMillis != -1) {
                    throw new LineSenderException((CharSequence)"auto flush interval is not supported for TCP protocol");
                }
            } else {
                throw new LineSenderException((CharSequence)"unsupported protocol ").put("[protocol=").put(this.protocol).put("]");
            }
        }

        public class AdvancedTlsSettings {
            public LineSenderBuilder customTrustStore(String trustStorePath, char[] trustStorePassword) {
                if (LineSenderBuilder.this.trustStorePath != null) {
                    throw new LineSenderException((CharSequence)"custom trust store was already configured ").put("[path=").put(LineSenderBuilder.this.trustStorePath).put("]");
                }
                if (Chars.isBlank(trustStorePath)) {
                    throw new LineSenderException((CharSequence)"trust store path cannot be empty nor null");
                }
                if (trustStorePassword == null) {
                    throw new LineSenderException((CharSequence)"trust store password cannot be null");
                }
                LineSenderBuilder.this.trustStorePath = trustStorePath;
                LineSenderBuilder.this.trustStorePassword = trustStorePassword;
                return LineSenderBuilder.this;
            }

            public LineSenderBuilder disableCertificateValidation() {
                LineSenderBuilder.this.tlsValidationMode = TlsValidationMode.INSECURE;
                return LineSenderBuilder.this;
            }
        }

        public class AuthBuilder {
            public LineSenderBuilder authToken(String token) {
                if (Chars.isBlank(token)) {
                    throw new LineSenderException((CharSequence)"token cannot be empty nor null");
                }
                try {
                    LineSenderBuilder.this.privateKey = AuthUtils.toPrivateKey(token);
                }
                catch (IllegalArgumentException e) {
                    throw new LineSenderException("could not import token", e);
                }
                LineSenderBuilder.this.shouldDestroyPrivKey = true;
                return LineSenderBuilder.this;
            }

            public LineSenderBuilder privateKey(PrivateKey privateKey) {
                LineSenderBuilder.this.privateKey = privateKey;
                return LineSenderBuilder.this;
            }
        }
    }

    public static enum Transport {
        HTTP,
        TCP;

    }

    public static enum TlsValidationMode {
        DEFAULT,
        INSECURE;

    }
}

