/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.std.Unsafe;

public class HttpSemantics {
    public static boolean isDelimiter(char c) {
        switch (c) {
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    public static boolean isToken(char c) {
        return c > ' ' && c < '\u007f' && !HttpSemantics.isDelimiter(c);
    }

    public static long swallowNextDelimiter(long lo, long hi) {
        if (lo < hi && HttpSemantics.isDelimiter((char)Unsafe.getUnsafe().getByte(lo))) {
            return lo + 1L;
        }
        return lo;
    }

    public static long swallowOWS(long lo, long hi) {
        while (lo < hi && (char)Unsafe.getUnsafe().getByte(lo) == ' ') {
            ++lo;
        }
        return lo;
    }

    public static long swallowTokens(long lo, long hi) {
        while (lo < hi && HttpSemantics.isToken((char)Unsafe.getUnsafe().getByte(lo))) {
            ++lo;
        }
        return lo;
    }
}

