/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.ServerConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cutlass.http.DefaultHttpCookieHandler;
import io.questdb.cutlass.http.DefaultHttpHeaderParserFactory;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpCookieHandler;
import io.questdb.cutlass.http.HttpFullFatServerConfiguration;
import io.questdb.cutlass.http.HttpHeaderParserFactory;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHandlerFactory;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpRequestProcessorSelector;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.WaitProcessor;
import io.questdb.cutlass.http.processors.LineHttpPingProcessor;
import io.questdb.cutlass.http.processors.LineHttpProcessorConfiguration;
import io.questdb.cutlass.http.processors.SettingsProcessor;
import io.questdb.cutlass.http.processors.StaticContentProcessorFactory;
import io.questdb.cutlass.http.processors.TableStatusCheckProcessor;
import io.questdb.cutlass.http.processors.TextImportProcessor;
import io.questdb.cutlass.http.processors.TextQueryProcessor;
import io.questdb.cutlass.http.processors.WarningsProcessor;
import io.questdb.mp.Job;
import io.questdb.mp.WorkerPool;
import io.questdb.network.HeartBeatException;
import io.questdb.network.IOContextFactoryImpl;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatchers;
import io.questdb.network.IORequestProcessor;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.PeerIsSlowToWriteException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.network.SocketFactory;
import io.questdb.std.AssociativeCache;
import io.questdb.std.ConcurrentAssociativeCache;
import io.questdb.std.Misc;
import io.questdb.std.NoOpAssociativeCache;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Utf8SequenceObjHashMap;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class HttpServer
implements Closeable {
    static final NoOpAssociativeCache<RecordCursorFactory> NO_OP_CACHE = new NoOpAssociativeCache();
    private final ObjList<Closeable> closeables = new ObjList();
    private final IODispatcher<HttpConnectionContext> dispatcher;
    private final HttpContextFactory httpContextFactory;
    private final WaitProcessor rescheduleContext;
    private final AssociativeCache<RecordCursorFactory> selectCache;
    private final ObjList<HttpRequestProcessorSelectorImpl> selectors;
    private final int workerCount;

    public HttpServer(HttpServerConfiguration configuration, WorkerPool pool, SocketFactory socketFactory) {
        this(configuration, pool, socketFactory, DefaultHttpCookieHandler.INSTANCE, DefaultHttpHeaderParserFactory.INSTANCE);
    }

    public HttpServer(HttpServerConfiguration configuration, WorkerPool networkSharedPool, SocketFactory socketFactory, HttpCookieHandler cookieHandler, HttpHeaderParserFactory headerParserFactory) {
        HttpFullFatServerConfiguration serverConfiguration;
        this.workerCount = networkSharedPool.getWorkerCount();
        this.selectors = new ObjList(this.workerCount);
        for (int i = 0; i < this.workerCount; ++i) {
            this.selectors.add(new HttpRequestProcessorSelectorImpl());
        }
        this.selectCache = configuration instanceof HttpFullFatServerConfiguration ? ((serverConfiguration = (HttpFullFatServerConfiguration)configuration).isQueryCacheEnabled() ? new ConcurrentAssociativeCache<RecordCursorFactory>(serverConfiguration.getConcurrentCacheConfiguration()) : NO_OP_CACHE) : NO_OP_CACHE;
        this.httpContextFactory = new HttpContextFactory(configuration, socketFactory, cookieHandler, headerParserFactory, this.selectCache);
        this.dispatcher = IODispatchers.create(configuration, this.httpContextFactory);
        networkSharedPool.assign(this.dispatcher);
        this.rescheduleContext = new WaitProcessor(configuration.getWaitProcessorConfiguration(), this.dispatcher);
        networkSharedPool.assign(this.rescheduleContext);
        for (int i = 0; i < this.workerCount; ++i) {
            final int index = i;
            networkSharedPool.assign(i, new Job(){
                private final HttpRequestProcessorSelector selector;
                private final IORequestProcessor<HttpConnectionContext> processor;
                {
                    this.selector = HttpServer.this.selectors.getQuick(index);
                    this.processor = (operation, context, dispatcher) -> HttpServer.this.handleClientOperation((HttpConnectionContext)context, operation, this.selector, HttpServer.this.rescheduleContext, dispatcher);
                }

                @Override
                public boolean run(int workerId, @NotNull Job.RunStatus runStatus) {
                    boolean useful = HttpServer.this.dispatcher.processIOQueue(this.processor);
                    return useful |= HttpServer.this.rescheduleContext.runReruns(this.selector);
                }
            });
            networkSharedPool.assignThreadLocalCleaner(i, this.httpContextFactory::freeThreadLocal);
        }
    }

    public static void addDefaultEndpoints(HttpServer server, ServerConfiguration serverConfiguration, final CairoEngine cairoEngine, final int sharedQueryWorkerCount, final HttpRequestHandlerBuilder jsonQueryProcessorBuilder, final HttpRequestHandlerBuilder ilpWriteProcessorBuilderV2) {
        final HttpFullFatServerConfiguration httpServerConfiguration = serverConfiguration.getHttpServerConfiguration();
        LineHttpProcessorConfiguration lineHttpProcessorConfiguration = httpServerConfiguration.getLineHttpProcessorConfiguration();
        if (httpServerConfiguration.isEnabled() && lineHttpProcessorConfiguration.isEnabled() && !httpServerConfiguration.getHttpContextConfiguration().readOnlySecurityContext()) {
            server.bind(new HttpRequestHandlerFactory(){

                @Override
                public ObjList<String> getUrls() {
                    return httpServerConfiguration.getContextPathILP();
                }

                @Override
                public HttpRequestHandler newInstance() {
                    return ilpWriteProcessorBuilderV2.newInstance();
                }
            });
            final LineHttpPingProcessor pingProcessor = new LineHttpPingProcessor(httpServerConfiguration.getLineHttpProcessorConfiguration().getInfluxPingVersion());
            server.bind(new HttpRequestHandlerFactory(){

                @Override
                public ObjList<String> getUrls() {
                    return httpServerConfiguration.getContextPathILPPing();
                }

                @Override
                public HttpRequestHandler newInstance() {
                    return pingProcessor;
                }
            });
        }
        final SettingsProcessor settingsProcessor = new SettingsProcessor(cairoEngine, serverConfiguration);
        server.bind(new HttpRequestHandlerFactory(){

            @Override
            public ObjList<String> getUrls() {
                return httpServerConfiguration.getContextPathSettings();
            }

            @Override
            public HttpRequestHandler newInstance() {
                return settingsProcessor;
            }
        });
        final WarningsProcessor warningsProcessor = new WarningsProcessor(serverConfiguration.getCairoConfiguration());
        server.bind(new HttpRequestHandlerFactory(){

            @Override
            public ObjList<String> getUrls() {
                return httpServerConfiguration.getContextPathWarnings();
            }

            @Override
            public HttpRequestHandler newInstance() {
                return warningsProcessor;
            }
        });
        server.bind(new HttpRequestHandlerFactory(){

            @Override
            public ObjList<String> getUrls() {
                return httpServerConfiguration.getContextPathExec();
            }

            @Override
            public HttpRequestHandler newInstance() {
                return jsonQueryProcessorBuilder.newInstance();
            }
        });
        server.bind(new HttpRequestHandlerFactory(){

            @Override
            public ObjList<String> getUrls() {
                return httpServerConfiguration.getContextPathImport();
            }

            @Override
            public HttpRequestHandler newInstance() {
                return new TextImportProcessor(cairoEngine, httpServerConfiguration.getJsonQueryProcessorConfiguration());
            }
        });
        server.bind(new HttpRequestHandlerFactory(){

            @Override
            public ObjList<String> getUrls() {
                return httpServerConfiguration.getContextPathExport();
            }

            @Override
            public HttpRequestHandler newInstance() {
                return new TextQueryProcessor(httpServerConfiguration.getJsonQueryProcessorConfiguration(), cairoEngine, sharedQueryWorkerCount);
            }
        });
        server.bind(new HttpRequestHandlerFactory(){

            @Override
            public ObjList<String> getUrls() {
                return httpServerConfiguration.getContextPathTableStatus();
            }

            @Override
            public HttpRequestHandler newInstance() {
                return new TableStatusCheckProcessor(cairoEngine, httpServerConfiguration.getJsonQueryProcessorConfiguration());
            }
        });
        server.bind(new StaticContentProcessorFactory(httpServerConfiguration));
    }

    public static Utf8Sequence normalizeUrl(DirectUtf8String url) {
        long p = url.ptr();
        long shift = 0L;
        boolean lastSlash = false;
        int n = url.size();
        for (int i = 0; i < n; ++i) {
            byte b = url.byteAt(i);
            if (b == 47) {
                if (lastSlash) {
                    ++shift;
                    continue;
                }
                lastSlash = true;
            } else {
                lastSlash = false;
            }
            if (shift <= 0L) continue;
            Unsafe.getUnsafe().putByte(p + (long)i - shift, b);
        }
        url.squeezeHi(shift);
        return url;
    }

    public void bind(HttpRequestHandlerFactory factory) {
        this.bind(factory, false);
    }

    public void bind(HttpRequestHandlerFactory factory, boolean useAsDefault) {
        ObjList<String> urls = factory.getUrls();
        assert (urls != null);
        int n = urls.size();
        for (int j = 0; j < n; ++j) {
            String url = urls.getQuick(j);
            for (int i = 0; i < this.workerCount; ++i) {
                HttpRequestProcessorSelectorImpl selector = this.selectors.getQuick(i);
                if ("*".equals(url)) {
                    selector.defaultRequestProcessor = factory.newInstance().getDefaultProcessor();
                    continue;
                }
                Utf8String key = new Utf8String(url);
                int keyIndex = selector.requestHandlerMap.keyIndex(key);
                if (keyIndex <= -1) continue;
                HttpRequestHandler requestHandler = factory.newInstance();
                selector.requestHandlerMap.putAt(keyIndex, key, requestHandler);
                if (!useAsDefault) continue;
                selector.defaultRequestProcessor = requestHandler.getDefaultProcessor();
            }
        }
    }

    public void clearSelectCache() {
        this.selectCache.clear();
    }

    @Override
    public void close() {
        Misc.free(this.dispatcher);
        Misc.free(this.rescheduleContext);
        Misc.freeObjListAndClear(this.selectors);
        Misc.freeObjListAndClear(this.closeables);
        Misc.free(this.httpContextFactory);
        Misc.free(this.selectCache);
    }

    public int getPort() {
        return this.dispatcher.getPort();
    }

    public void registerClosable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    private boolean handleClientOperation(HttpConnectionContext context, int operation, HttpRequestProcessorSelector selector, WaitProcessor rescheduleContext, IODispatcher<HttpConnectionContext> dispatcher) {
        try {
            return context.handleClientOperation(operation, selector, rescheduleContext);
        }
        catch (HeartBeatException e) {
            dispatcher.registerChannel(context, 8);
        }
        catch (PeerIsSlowToReadException e) {
            dispatcher.registerChannel(context, 4);
        }
        catch (ServerDisconnectException e) {
            dispatcher.disconnect(context, context.getDisconnectReason());
        }
        catch (PeerIsSlowToWriteException e) {
            dispatcher.registerChannel(context, 1);
        }
        return false;
    }

    private static class HttpRequestProcessorSelectorImpl
    implements HttpRequestProcessorSelector {
        private final Utf8SequenceObjHashMap<HttpRequestHandler> requestHandlerMap = new Utf8SequenceObjHashMap();
        private HttpRequestProcessor defaultRequestProcessor = null;

        private HttpRequestProcessorSelectorImpl() {
        }

        @Override
        public void close() {
            Misc.freeIfCloseable(this.defaultRequestProcessor);
            ObjList<Utf8String> requestHandlerKeys = this.requestHandlerMap.keys();
            int n = requestHandlerKeys.size();
            for (int i = 0; i < n; ++i) {
                Misc.freeIfCloseable(this.requestHandlerMap.get(requestHandlerKeys.getQuick(i)));
            }
        }

        @Override
        public HttpRequestProcessor getDefaultProcessor() {
            return this.defaultRequestProcessor;
        }

        @Override
        public HttpRequestProcessor select(HttpRequestHeader requestHeader) {
            Utf8Sequence normalizedUrl = HttpServer.normalizeUrl(requestHeader.getUrl());
            HttpRequestHandler requestHandler = this.requestHandlerMap.get(normalizedUrl);
            return requestHandler != null ? requestHandler.getProcessor(requestHeader) : null;
        }
    }

    private static class HttpContextFactory
    extends IOContextFactoryImpl<HttpConnectionContext> {
        public HttpContextFactory(HttpServerConfiguration configuration, SocketFactory socketFactory, HttpCookieHandler cookieHandler, HttpHeaderParserFactory headerParserFactory, AssociativeCache<RecordCursorFactory> selectCache) {
            super(() -> new HttpConnectionContext(configuration, socketFactory, cookieHandler, headerParserFactory, selectCache), configuration.getHttpContextConfiguration().getConnectionPoolInitialCapacity());
        }
    }

    @FunctionalInterface
    public static interface HttpRequestHandlerBuilder {
        public HttpRequestHandler newInstance();
    }
}

