/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.client;

import io.questdb.HttpClientConfiguration;
import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpHeaderParser;
import io.questdb.cutlass.http.HttpKeywords;
import io.questdb.cutlass.http.client.AbstractChunkedResponse;
import io.questdb.cutlass.http.client.AbstractResponse;
import io.questdb.cutlass.http.client.HttpClientCookieHandler;
import io.questdb.cutlass.http.client.HttpClientException;
import io.questdb.cutlass.http.client.Response;
import io.questdb.cutlass.line.array.ArrayBufferAppender;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NetworkFacade;
import io.questdb.network.Socket;
import io.questdb.network.SocketFactory;
import io.questdb.network.TlsSessionInitFailedException;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjectPool;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpClient
implements QuietCloseable {
    private static final String HEADER_CONTENT_LENGTH = "Content-Length: ";
    private static final String HTTP_NO_CONTENT = String.valueOf(204);
    private static final Log LOG = LogFactory.getLog(HttpClient.class);
    protected final NetworkFacade nf;
    protected final Socket socket;
    private final HttpClientCookieHandler cookieHandler;
    private final ObjectPool<DirectUtf8String> csPool = new ObjectPool<DirectUtf8String>(DirectUtf8String.FACTORY, 64);
    private final int defaultTimeout;
    private final boolean fixBrokenConnection;
    private final int maxBufferSize;
    private final Request request = new Request();
    private final ResponseHeaders responseHeaders;
    private final int responseParserBufSize;
    private long bufLo;
    private int bufferSize;
    private long contentStart = -1L;
    private CharSequence host;
    private int port;
    private long ptr = this.bufLo;
    private long responseParserBufLo;

    public HttpClient(HttpClientConfiguration configuration, SocketFactory socketFactory) {
        this.nf = configuration.getNetworkFacade();
        this.socket = socketFactory.newInstance(this.nf, LOG);
        this.defaultTimeout = configuration.getTimeout();
        this.cookieHandler = configuration.getCookieHandlerFactory().getInstance();
        this.bufferSize = configuration.getInitialRequestBufferSize();
        this.maxBufferSize = configuration.getMaximumRequestBufferSize();
        this.responseParserBufSize = configuration.getResponseBufferSize();
        this.fixBrokenConnection = configuration.fixBrokenConnection();
        this.bufLo = Unsafe.malloc(this.bufferSize, 19);
        this.responseParserBufLo = Unsafe.malloc(this.responseParserBufSize, 19);
        this.responseHeaders = new ResponseHeaders(this.responseParserBufLo, this.responseParserBufSize, this.defaultTimeout, 4096, this.csPool);
    }

    @Override
    public void close() {
        this.disconnect();
        if (this.bufLo != 0L) {
            Unsafe.free(this.bufLo, this.bufferSize, 19);
            this.bufLo = 0L;
            assert (this.responseParserBufLo != 0L);
            Unsafe.free(this.responseParserBufLo, this.responseParserBufSize, 19);
            this.responseParserBufLo = 0L;
        }
        this.responseHeaders.free();
    }

    public void disconnect() {
        Misc.free(this.socket);
    }

    public ResponseHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public Request newRequest(CharSequence host, int port) {
        if (!Chars.equalsNc(host, this.host) || port != this.port) {
            this.socket.close();
        }
        this.host = host;
        this.port = port;
        this.ptr = this.bufLo;
        this.contentStart = -1L;
        this.request.contentLengthHeaderReserved = 0;
        this.request.state = 0;
        return this.request;
    }

    private void checkCapacity(long capacity) {
        long usedBytes = this.ptr - this.bufLo;
        long requiredSize = usedBytes + capacity;
        if (requiredSize > (long)this.bufferSize) {
            this.growBuffer(requiredSize);
        }
    }

    private int dieIfNegative(int byteCount) {
        if (byteCount < 0) {
            throw new HttpClientException("peer disconnect [errno=").errno(this.nf.errno()).put(']');
        }
        return byteCount;
    }

    private int dieIfNotPositive(int byteCount) {
        if (byteCount < 0) {
            throw new HttpClientException("peer disconnect [errno=").errno(this.nf.errno()).put(']');
        }
        if (byteCount == 0) {
            throw new HttpClientException("timed out [errno=").errno(this.nf.errno()).put(']');
        }
        return byteCount;
    }

    private void growBuffer(long requiredSize) {
        if (requiredSize > (long)this.maxBufferSize) {
            throw new HttpClientException("transaction is too large, either flush more frequently or increase buffer size \"max_buf_size\" [maxBufferSize=").putSize(this.maxBufferSize).put(", transactionSize=").putSize(requiredSize).put(']');
        }
        long newBufferSize = Math.min(Numbers.ceilPow2((int)requiredSize), this.maxBufferSize);
        long newBufLo = Unsafe.realloc(this.bufLo, this.bufferSize, newBufferSize, 19);
        long offset = newBufLo - this.bufLo;
        this.ptr += offset;
        this.bufLo = newBufLo;
        this.bufferSize = (int)newBufferSize;
        if (this.contentStart > -1L) {
            this.contentStart += offset;
        }
    }

    private int recvOrDie(long lo, int len, int timeout) {
        long startTimeNanos = System.nanoTime();
        int n = this.dieIfNegative(this.socket.recv(lo, len));
        if (n == 0) {
            this.ioWait(this.remainingTime(timeout, startTimeNanos), 1);
            n = this.dieIfNegative(this.socket.recv(lo, len));
        }
        return n;
    }

    private int recvOrDie(long addr, int timeout) {
        return this.recvOrDie(addr, (int)((long)this.responseParserBufSize - (addr - this.responseParserBufLo)), timeout);
    }

    private int remainingTime(int timeoutMillis, long startTimeNanos) {
        if ((timeoutMillis -= (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNanos)) <= 0) {
            throw new HttpClientException("timed out [errno=").errno(this.nf.errno()).put(']');
        }
        return timeoutMillis;
    }

    private int sendOrDie(long lo, int len, int timeoutMillis) {
        long startTimeNanos = System.nanoTime();
        this.ioWait(timeoutMillis, 4);
        int n = this.dieIfNotPositive(this.socket.send(lo, len));
        while (this.socket.wantsTlsWrite()) {
            timeoutMillis = this.remainingTime(timeoutMillis, startTimeNanos);
            this.ioWait(timeoutMillis, 4);
            this.dieIfNegative(this.socket.tlsIO(1));
        }
        return n;
    }

    protected void dieWaiting(int n) {
        if (n == 1) {
            return;
        }
        if (n == 0) {
            throw new HttpClientException("timed out [errno=").put(this.nf.errno()).put(']');
        }
        throw new HttpClientException("queue error [errno=").put(this.nf.errno()).put(']');
    }

    protected abstract void ioWait(int var1, int var2);

    protected abstract void setupIoWait();

    public class Request
    implements Utf8Sink,
    ArrayBufferAppender {
        private static final int STATE_CONTENT = 5;
        private static final int STATE_HEADER = 4;
        private static final int STATE_QUERY = 3;
        private static final int STATE_REQUEST = 0;
        private static final int STATE_URL = 1;
        private static final int STATE_URL_DONE = 2;
        private BinarySequenceAdapter binarySequenceAdapter;
        private int contentLengthHeaderReserved = 0;
        private int state;
        private boolean urlEncode = false;

        public Request DELETE() {
            assert (this.state == 0);
            this.state = 1;
            return this.putAscii("DELETE ");
        }

        public Request GET() {
            assert (this.state == 0);
            this.state = 1;
            return this.putAscii("GET ");
        }

        public Request POST() {
            assert (this.state == 0);
            this.state = 1;
            return this.putAscii("POST ");
        }

        public Request PUT() {
            assert (this.state == 0);
            this.state = 1;
            return this.putAscii("PUT ");
        }

        public Request authBasic(CharSequence username, CharSequence password) {
            this.beforeHeader();
            this.putAsciiInternal("Authorization: Basic ");
            if (this.binarySequenceAdapter == null) {
                this.binarySequenceAdapter = new BinarySequenceAdapter();
            }
            this.binarySequenceAdapter.clear();
            this.binarySequenceAdapter.put(username).colon().put(password);
            Chars.base64Encode(this.binarySequenceAdapter, (int)this.binarySequenceAdapter.length(), this);
            this.eol();
            if (HttpClient.this.cookieHandler != null) {
                HttpClient.this.cookieHandler.setCookies(this, username);
            }
            return this;
        }

        public Request authToken(CharSequence username, CharSequence token) {
            this.beforeHeader();
            this.putAsciiInternal("Authorization: Bearer ");
            this.putAsciiInternal(token);
            this.eol();
            if (HttpClient.this.cookieHandler != null) {
                HttpClient.this.cookieHandler.setCookies(this, username);
            }
            return this;
        }

        public int getContentLength() {
            if (HttpClient.this.contentStart > -1L) {
                return (int)(HttpClient.this.ptr - HttpClient.this.contentStart);
            }
            return 0;
        }

        public long getContentStart() {
            return HttpClient.this.contentStart;
        }

        public long getPtr() {
            return HttpClient.this.ptr;
        }

        public Request header(CharSequence name, CharSequence value) {
            this.beforeHeader();
            this.put(name).putAsciiInternal(": ").put(value);
            return this.eol();
        }

        @Override
        public Request put(@Nullable Utf8Sequence us) {
            if (us != null) {
                int size = us.size();
                HttpClient.this.checkCapacity(size);
                Utf8s.strCpy(us, size, HttpClient.this.ptr);
                HttpClient.this.ptr += (long)size;
            }
            return this;
        }

        @Override
        public Request put(byte b) {
            HttpClient.this.checkCapacity(1L);
            Unsafe.getUnsafe().putByte(HttpClient.this.ptr, b);
            ++HttpClient.this.ptr;
            return this;
        }

        @Override
        public Request put(@Nullable CharSequence cs) {
            Utf8Sink.super.put(cs);
            return this;
        }

        @Override
        public Request put(char c) {
            Utf8Sink.super.put(c);
            return this;
        }

        @Override
        public Request putAscii(char c) {
            if (this.urlEncode) {
                this.putUrlEncoded(c);
            } else {
                this.putAsciiInternal(c);
            }
            return this;
        }

        @Override
        public Request putAscii(@Nullable CharSequence cs) {
            Utf8Sink.super.putAscii(cs);
            return this;
        }

        @Override
        public Request putAsciiQuoted(@NotNull CharSequence cs) {
            this.putAsciiInternal('\"').putAscii(cs).putAsciiInternal('\"');
            return this;
        }

        @Override
        public void putBlockOfBytes(long from, long len) {
            HttpClient.this.checkCapacity(len);
            Vect.memcpy(HttpClient.this.ptr, from, len);
            HttpClient.this.ptr += len;
        }

        @Override
        public void putByte(byte value) {
            this.put(value);
        }

        @Override
        public void putDouble(double value) {
            HttpClient.this.checkCapacity(8L);
            Unsafe.getUnsafe().putDouble(HttpClient.this.ptr, value);
            HttpClient.this.ptr += 8L;
        }

        @Override
        public void putInt(int value) {
            HttpClient.this.checkCapacity(4L);
            Unsafe.getUnsafe().putInt(HttpClient.this.ptr, value);
            HttpClient.this.ptr += 4L;
        }

        @Override
        public void putLong(long value) {
            HttpClient.this.checkCapacity(8L);
            Unsafe.getUnsafe().putLong(HttpClient.this.ptr, value);
            HttpClient.this.ptr += 8L;
        }

        @Override
        public Request putNonAscii(long lo, long hi) {
            long size = hi - lo;
            HttpClient.this.checkCapacity(size);
            Vect.memcpy(HttpClient.this.ptr, lo, size);
            HttpClient.this.ptr += size;
            return this;
        }

        @Override
        public Request putQuoted(@NotNull CharSequence cs) {
            this.putAsciiInternal('\"').put(cs).putAsciiInternal('\"');
            return this;
        }

        public Request query(CharSequence name, CharSequence value) {
            assert (this.state == 2 || this.state == 3);
            if (this.state == 2) {
                this.putAsciiInternal('?');
            } else {
                this.putAsciiInternal('&');
            }
            this.state = 3;
            this.urlEncode = true;
            try {
                this.put(name).putAsciiInternal('=').put(value);
            }
            finally {
                this.urlEncode = false;
            }
            return this;
        }

        public ResponseHeaders send() {
            return this.send(HttpClient.this.defaultTimeout);
        }

        public ResponseHeaders send(int timeout) {
            assert (this.state == 2 || this.state == 3 || this.state == 4 || this.state == 5);
            if (HttpClient.this.socket == null || HttpClient.this.socket.isClosed()) {
                this.connect(HttpClient.this.host, HttpClient.this.port);
            } else if (HttpClient.this.fixBrokenConnection && HttpClient.this.nf.testConnection(HttpClient.this.socket.getFd(), HttpClient.this.responseParserBufLo, 1)) {
                HttpClient.this.socket.close();
                this.connect(HttpClient.this.host, HttpClient.this.port);
            }
            if (this.state == 2 || this.state == 3) {
                this.putAsciiInternal(" HTTP/1.1").putEOL();
                ((Utf8Sink)this.putAsciiInternal("Host: ").put(HttpClient.this.host).putAscii(':').put(HttpClient.this.port)).putEOL();
            }
            if (HttpClient.this.contentStart > -1L) {
                assert (this.state == 5);
                this.sendHeaderAndContent(Integer.MAX_VALUE, timeout);
            } else {
                this.eol();
                this.doSend(HttpClient.this.bufLo, HttpClient.this.ptr, timeout);
            }
            HttpClient.this.responseHeaders.clear();
            return HttpClient.this.responseHeaders;
        }

        public void sendPartialContent(int maxContentLen, int timeout) {
            if (this.state != 5 || HttpClient.this.contentStart == -1L) {
                throw new IllegalStateException("No content to send");
            }
            if (HttpClient.this.socket == null || HttpClient.this.socket.isClosed()) {
                this.connect(HttpClient.this.host, HttpClient.this.port);
            }
            this.sendHeaderAndContent(maxContentLen, timeout);
        }

        public Request setCookie(CharSequence name, CharSequence value) {
            this.beforeHeader();
            this.put(HttpConstants.HEADER_COOKIE).putAscii(": ").put(name);
            if (value != null) {
                this.putAscii('=').put(value);
            }
            this.eol();
            return this;
        }

        public String toString() {
            StringSink ss = new StringSink();
            DirectUtf8String s = new DirectUtf8String();
            s.of(HttpClient.this.bufLo, HttpClient.this.ptr);
            ss.put(s);
            return ss.toString();
        }

        public void trimContentToLen(int contentLen) {
            HttpClient.this.ptr = HttpClient.this.contentStart + (long)contentLen;
        }

        public void truncate() {
            throw new UnsupportedOperationException();
        }

        public Request url(CharSequence url) {
            assert (this.state == 1);
            this.state = 2;
            return this.put(url);
        }

        public Request withChunkedContent() {
            this.beforeHeader();
            this.header("Transfer-Encoding", "chunked");
            this.putEOL();
            this.contentLengthHeaderReserved = 0;
            HttpClient.this.contentStart = HttpClient.this.ptr;
            this.state = 5;
            return this;
        }

        public Request withContent() {
            this.beforeHeader();
            this.putAscii(HttpClient.HEADER_CONTENT_LENGTH);
            this.contentLengthHeaderReserved = (int)Math.log10(HttpClient.this.maxBufferSize) + 2 + 4;
            HttpClient.this.checkCapacity(this.contentLengthHeaderReserved);
            HttpClient.this.ptr += (long)this.contentLengthHeaderReserved;
            HttpClient.this.contentStart = HttpClient.this.ptr;
            this.state = 5;
            return this;
        }

        private void beforeHeader() {
            assert (this.state == 3 || this.state == 2 || this.state == 4);
            switch (this.state) {
                case 2: 
                case 3: {
                    this.put(" HTTP/1.1").eol();
                    ((Utf8Sink)this.putAscii("Host").putAscii(": ").put(HttpClient.this.host).put(':').put(HttpClient.this.port)).putEOL();
                    this.state = 4;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    this.eol();
                }
            }
        }

        private void connect(CharSequence host, int port) {
            long fd = HttpClient.this.nf.socketTcp(true);
            if (fd < 0L) {
                throw new HttpClientException("could not allocate a file descriptor").errno(HttpClient.this.nf.errno());
            }
            if (HttpClient.this.nf.setTcpNoDelay(fd, true) < 0) {
                LOG.info().$("could not turn off Nagle's algorithm [fd=").$(fd).$(", errno=").$(HttpClient.this.nf.errno()).I$();
            }
            HttpClient.this.socket.of(fd);
            HttpClient.this.nf.configureKeepAlive(fd);
            long addrInfo = HttpClient.this.nf.getAddrInfo(host, port);
            if (addrInfo == -1L) {
                HttpClient.this.disconnect();
                throw new HttpClientException("could not resolve host ").put("[host=").put(host).put("]");
            }
            if (HttpClient.this.nf.connectAddrInfo(fd, addrInfo) != 0) {
                int errno = HttpClient.this.nf.errno();
                HttpClient.this.nf.freeAddrInfo(addrInfo);
                HttpClient.this.disconnect();
                throw new HttpClientException("could not connect to host ").put("[host=").put(host).put(", port=").put(port).put(", errno=").put(errno).put(']');
            }
            HttpClient.this.nf.freeAddrInfo(addrInfo);
            if (HttpClient.this.nf.configureNonBlocking(fd) < 0) {
                int errno = HttpClient.this.nf.errno();
                HttpClient.this.disconnect();
                throw new HttpClientException("could not configure socket to be non-blocking [fd=").put(fd).put(", errno=").put(errno).put(']');
            }
            if (HttpClient.this.socket.supportsTls()) {
                try {
                    HttpClient.this.socket.startTlsSession(host);
                }
                catch (TlsSessionInitFailedException e) {
                    int errno = HttpClient.this.nf.errno();
                    HttpClient.this.disconnect();
                    throw new HttpClientException("could not start TLS session [fd=").put(fd).put(", error=").put(e.getFlyweightMessage()).put(", errno=").put(errno).put(']');
                }
            }
            HttpClient.this.setupIoWait();
        }

        private void doSend(long lo, long hi, int timeoutMillis) {
            int len = (int)(hi - lo);
            if (len > 0) {
                long p = lo;
                do {
                    int sent;
                    if ((sent = HttpClient.this.sendOrDie(p, len, timeoutMillis)) <= 0) continue;
                    p += (long)sent;
                    len -= sent;
                } while (len > 0);
            }
        }

        private Request eol() {
            this.putEOL();
            return this;
        }

        private Request putAsciiInternal(char c) {
            Utf8Sink.super.putAscii(c);
            return this;
        }

        private Request putAsciiInternal(@Nullable CharSequence cs) {
            if (cs != null) {
                int l = cs.length();
                for (int i = 0; i < l; ++i) {
                    Utf8Sink.super.putAscii(cs.charAt(i));
                }
            }
            return this;
        }

        private void putUrlEncoded(char c) {
            switch (c) {
                case ' ': {
                    this.putAsciiInternal("%20");
                    break;
                }
                case '!': {
                    this.putAsciiInternal("%21");
                    break;
                }
                case '\"': {
                    this.putAsciiInternal("%22");
                    break;
                }
                case '#': {
                    this.putAsciiInternal("%23");
                    break;
                }
                case '$': {
                    this.putAsciiInternal("%24");
                    break;
                }
                case '%': {
                    this.putAsciiInternal("%25");
                    break;
                }
                case '&': {
                    this.putAsciiInternal("%26");
                    break;
                }
                case '\'': {
                    this.putAsciiInternal("%27");
                    break;
                }
                case '(': {
                    this.putAsciiInternal("%28");
                    break;
                }
                case ')': {
                    this.putAsciiInternal("%29");
                    break;
                }
                case '*': {
                    this.putAsciiInternal("%2A");
                    break;
                }
                case '+': {
                    this.putAsciiInternal("%2B");
                    break;
                }
                case ',': {
                    this.putAsciiInternal("%2C");
                    break;
                }
                case '-': {
                    this.putAsciiInternal("%2D");
                    break;
                }
                case '.': {
                    this.putAsciiInternal("%2E");
                    break;
                }
                case '/': {
                    this.putAsciiInternal("%2F");
                    break;
                }
                case ':': {
                    this.putAsciiInternal("%3A");
                    break;
                }
                case ';': {
                    this.putAsciiInternal("%3B");
                    break;
                }
                case '<': {
                    this.putAsciiInternal("%3C");
                    break;
                }
                case '=': {
                    this.putAsciiInternal("%3D");
                    break;
                }
                case '>': {
                    this.putAsciiInternal("%3E");
                    break;
                }
                case '?': {
                    this.putAsciiInternal("%3F");
                    break;
                }
                case '@': {
                    this.putAsciiInternal("%40");
                    break;
                }
                case '[': {
                    this.putAsciiInternal("%5B");
                    break;
                }
                case '\\': {
                    this.putAsciiInternal("%5C");
                    break;
                }
                case ']': {
                    this.putAsciiInternal("%5D");
                    break;
                }
                case '^': {
                    this.putAsciiInternal("%5E");
                    break;
                }
                case '_': {
                    this.putAsciiInternal("%5F");
                    break;
                }
                case '`': {
                    this.putAsciiInternal("%60");
                    break;
                }
                case '{': {
                    this.putAsciiInternal("%7B");
                    break;
                }
                case '|': {
                    this.putAsciiInternal("%7C");
                    break;
                }
                case '}': {
                    this.putAsciiInternal("%7D");
                    break;
                }
                case '\n': {
                    this.putAsciiInternal("%0A");
                    break;
                }
                case '\r': {
                    this.putAsciiInternal("%0D");
                    break;
                }
                case '\t': {
                    this.putAsciiInternal("%09");
                    break;
                }
                default: {
                    this.putAsciiInternal(c);
                }
            }
        }

        private void sendHeaderAndContent(int maxContentLen, int timeout) {
            long headerHi;
            int contentLength = (int)(HttpClient.this.ptr - HttpClient.this.contentStart);
            long hi = HttpClient.this.ptr;
            if (this.contentLengthHeaderReserved > 0) {
                HttpClient.this.ptr = HttpClient.this.contentStart - (long)this.contentLengthHeaderReserved;
                this.put(contentLength);
                this.eol();
                this.eol();
                headerHi = HttpClient.this.ptr;
                assert (headerHi < HttpClient.this.contentStart);
                HttpClient.this.ptr = hi;
            } else {
                headerHi = HttpClient.this.contentStart;
            }
            this.doSend(HttpClient.this.bufLo, headerHi, timeout);
            this.doSend(HttpClient.this.contentStart, HttpClient.this.contentStart + Math.min(hi - HttpClient.this.contentStart, (long)maxContentLen), timeout);
        }
    }

    public class ResponseHeaders
    extends HttpHeaderParser {
        private final ChunkedResponseImpl chunkedResponse;
        private final int defaultTimeout;
        private final ResponseImpl response;

        public ResponseHeaders(long respParserBufLo, int respParserBufSize, int defaultTimeout, int headerBufSize, ObjectPool<DirectUtf8String> pool) {
            super(headerBufSize, pool);
            this.defaultTimeout = defaultTimeout;
            this.response = new ResponseImpl(respParserBufLo, respParserBufLo + (long)respParserBufSize, defaultTimeout);
            this.chunkedResponse = new ChunkedResponseImpl(respParserBufLo, respParserBufLo + (long)respParserBufSize, defaultTimeout);
        }

        public void await() {
            this.await(this.defaultTimeout);
        }

        public void await(int timeout) {
            int totalBytesReceived = 0;
            long unprocessedLo = HttpClient.this.responseParserBufLo;
            while (this.isIncomplete()) {
                DirectUtf8Sequence statusCode;
                int len = HttpClient.this.recvOrDie(HttpClient.this.responseParserBufLo + (long)totalBytesReceived, timeout);
                if (len <= 0) continue;
                unprocessedLo = this.parse(unprocessedLo, HttpClient.this.responseParserBufLo + (long)(totalBytesReceived += len), false, true);
                if (this.isIncomplete()) continue;
                if (this.isChunked()) {
                    this.chunkedResponse.begin(unprocessedLo, HttpClient.this.responseParserBufLo + (long)totalBytesReceived);
                } else {
                    long contentLength = this.getContentLength();
                    if (contentLength > (long)HttpClient.this.bufferSize) {
                        throw new HttpClientException("insufficient http client buffer size: " + contentLength);
                    }
                    this.response.begin(unprocessedLo, HttpClient.this.responseParserBufLo + (long)totalBytesReceived, contentLength);
                }
                if ((statusCode = this.getStatusCode()) == null || !Utf8s.equalsNcAscii(HTTP_NO_CONTENT, this.getStatusCode())) continue;
                this.incomplete = false;
            }
            if (HttpClient.this.cookieHandler != null) {
                HttpClient.this.cookieHandler.processCookies(this);
            }
        }

        @Override
        public void clear() {
            super.clear();
            HttpClient.this.csPool.clear();
        }

        @Override
        public void close() {
            HttpClient.this.disconnect();
            this.clear();
        }

        public Response getResponse() {
            if (this.isChunked()) {
                return this.chunkedResponse;
            }
            return this.response;
        }

        public boolean isChunked() {
            if (this.isIncomplete()) {
                throw new HttpClientException("http response headers not yet received");
            }
            return HttpKeywords.isChunked(this.getHeader(HttpConstants.HEADER_TRANSFER_ENCODING));
        }

        private void free() {
            super.close();
        }
    }

    private class ResponseImpl
    extends AbstractResponse {
        public ResponseImpl(long bufLo, long bufHi, int defaultTimeout) {
            super(bufLo, bufHi, defaultTimeout);
        }

        @Override
        protected int recvOrDie(long bufLo, long bufHi, int timeout) {
            return HttpClient.this.recvOrDie(bufLo, timeout);
        }
    }

    private class ChunkedResponseImpl
    extends AbstractChunkedResponse {
        public ChunkedResponseImpl(long bufLo, long bufHi, int defaultTimeout) {
            super(bufLo, bufHi, defaultTimeout);
        }

        @Override
        protected int recvOrDie(long bufLo, long bufHi, int timeout) {
            return HttpClient.this.recvOrDie(bufLo, timeout);
        }
    }

    private static class BinarySequenceAdapter
    implements BinarySequence,
    Mutable {
        private final Utf8StringSink baseSink = new Utf8StringSink();

        private BinarySequenceAdapter() {
        }

        @Override
        public byte byteAt(long index) {
            return this.baseSink.byteAt((int)index);
        }

        @Override
        public void clear() {
            this.baseSink.clear();
        }

        @Override
        public long length() {
            return this.baseSink.size();
        }

        BinarySequenceAdapter colon() {
            this.baseSink.putAscii(':');
            return this;
        }

        BinarySequenceAdapter put(CharSequence value) {
            this.baseSink.put(value);
            return this;
        }
    }
}

