/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.BuildInformation;
import io.questdb.BuildInformationHolder;
import io.questdb.DynamicUsernamePasswordMatcher;
import io.questdb.ServerConfiguration;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cutlass.auth.SocketAuthenticator;
import io.questdb.cutlass.pgwire.OptionsListener;
import io.questdb.cutlass.pgwire.PGAuthenticatorFactory;
import io.questdb.cutlass.pgwire.PGCircuitBreakerRegistry;
import io.questdb.cutlass.pgwire.PGCleartextPasswordAuthenticator;
import io.questdb.cutlass.pgwire.PGConfiguration;
import io.questdb.cutlass.pgwire.PGHexTestsCircuitBreakRegistry;
import org.jetbrains.annotations.Nullable;

public final class DefaultPGAuthenticatorFactory
implements PGAuthenticatorFactory {
    public static final PGAuthenticatorFactory INSTANCE = new DefaultPGAuthenticatorFactory(null);
    private final BuildInformation buildInformation;
    private final ServerConfiguration serverConfiguration;

    public DefaultPGAuthenticatorFactory(@Nullable ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
        this.buildInformation = serverConfiguration == null ? new BuildInformationHolder() : serverConfiguration.getCairoConfiguration().getBuildInformation();
    }

    @Override
    public SocketAuthenticator getPgWireAuthenticator(PGConfiguration configuration, NetworkSqlExecutionCircuitBreaker circuitBreaker, PGCircuitBreakerRegistry registry, OptionsListener optionsListener) {
        DynamicUsernamePasswordMatcher matcher = new DynamicUsernamePasswordMatcher(this.serverConfiguration, configuration);
        BuildInformation buildInformationToUse = registry == PGHexTestsCircuitBreakRegistry.INSTANCE ? null : this.buildInformation;
        return new PGCleartextPasswordAuthenticator(configuration, buildInformationToUse, circuitBreaker, registry, optionsListener, matcher, true);
    }
}

