/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.FunctionArray;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.FunctionFactoryDescriptor;
import io.questdb.griffin.GeoHashUtil;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlCodeGenerator;
import io.questdb.griffin.SqlCompilerImpl;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.bind.IndexedParameterLinkFunction;
import io.questdb.griffin.engine.functions.bind.NamedParameterLinkFunction;
import io.questdb.griffin.engine.functions.cast.CastCharToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastGeoHashToGeoHashFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntervalToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastStrToDoubleArrayFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastStrToGeoHashFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastStrToTimestampFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastStrToUuidFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastUuidToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastUuidToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastVarcharToGeoHashFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastVarcharToTimestampFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastVarcharToUuidFunctionFactory;
import io.questdb.griffin.engine.functions.columns.ArrayColumn;
import io.questdb.griffin.engine.functions.columns.BinColumn;
import io.questdb.griffin.engine.functions.columns.BooleanColumn;
import io.questdb.griffin.engine.functions.columns.ByteColumn;
import io.questdb.griffin.engine.functions.columns.CharColumn;
import io.questdb.griffin.engine.functions.columns.DateColumn;
import io.questdb.griffin.engine.functions.columns.DoubleColumn;
import io.questdb.griffin.engine.functions.columns.FloatColumn;
import io.questdb.griffin.engine.functions.columns.GeoByteColumn;
import io.questdb.griffin.engine.functions.columns.GeoIntColumn;
import io.questdb.griffin.engine.functions.columns.GeoLongColumn;
import io.questdb.griffin.engine.functions.columns.GeoShortColumn;
import io.questdb.griffin.engine.functions.columns.IPv4Column;
import io.questdb.griffin.engine.functions.columns.IntColumn;
import io.questdb.griffin.engine.functions.columns.IntervalColumn;
import io.questdb.griffin.engine.functions.columns.Long128Column;
import io.questdb.griffin.engine.functions.columns.Long256Column;
import io.questdb.griffin.engine.functions.columns.LongColumn;
import io.questdb.griffin.engine.functions.columns.RecordColumn;
import io.questdb.griffin.engine.functions.columns.ShortColumn;
import io.questdb.griffin.engine.functions.columns.StrColumn;
import io.questdb.griffin.engine.functions.columns.SymbolColumn;
import io.questdb.griffin.engine.functions.columns.TimestampColumn;
import io.questdb.griffin.engine.functions.columns.UuidColumn;
import io.questdb.griffin.engine.functions.columns.VarcharColumn;
import io.questdb.griffin.engine.functions.constants.ArrayConstant;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.constants.ByteConstant;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.griffin.engine.functions.constants.CharTypeConstant;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.griffin.engine.functions.constants.DateConstant;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.griffin.engine.functions.constants.FloatConstant;
import io.questdb.griffin.engine.functions.constants.GeoByteConstant;
import io.questdb.griffin.engine.functions.constants.GeoHashTypeConstant;
import io.questdb.griffin.engine.functions.constants.GeoIntConstant;
import io.questdb.griffin.engine.functions.constants.GeoLongConstant;
import io.questdb.griffin.engine.functions.constants.GeoShortConstant;
import io.questdb.griffin.engine.functions.constants.IPv4Constant;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.griffin.engine.functions.constants.Long256Constant;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.functions.constants.NullConstant;
import io.questdb.griffin.engine.functions.constants.ShortConstant;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.griffin.engine.functions.constants.UuidConstant;
import io.questdb.griffin.engine.functions.constants.VarcharConstant;
import io.questdb.griffin.engine.functions.memoization.BooleanFunctionMemoizer;
import io.questdb.griffin.engine.functions.memoization.ByteFunctionMemoizer;
import io.questdb.griffin.engine.functions.memoization.CharFunctionMemoizer;
import io.questdb.griffin.engine.functions.memoization.DateFunctionMemoizer;
import io.questdb.griffin.engine.functions.memoization.DoubleFunctionMemoizer;
import io.questdb.griffin.engine.functions.memoization.FloatFunctionMemoizer;
import io.questdb.griffin.engine.functions.memoization.IPv4FunctionMemoizer;
import io.questdb.griffin.engine.functions.memoization.IntFunctionMemoizer;
import io.questdb.griffin.engine.functions.memoization.Long256FunctionMemoizer;
import io.questdb.griffin.engine.functions.memoization.LongFunctionMemoizer;
import io.questdb.griffin.engine.functions.memoization.ShortFunctionMemoizer;
import io.questdb.griffin.engine.functions.memoization.TimestampFunctionMemoizer;
import io.questdb.griffin.engine.functions.memoization.UuidFunctionMemoizer;
import io.questdb.griffin.engine.window.WindowFunction;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.IntStack;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Long256Impl;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionParser
implements PostOrderTreeTraversalAlgo.Visitor,
Mutable {
    private static final Log LOG = LogFactory.getLog(FunctionParser.class);
    private static final int MATCH_EXACT_MATCH = 3;
    private static final int MATCH_FUZZY_MATCH = 1;
    private static final int MATCH_NO_MATCH = 0;
    private static final int MATCH_PARTIAL_MATCH = 2;
    private final CairoConfiguration configuration;
    private final FunctionFactoryCache functionFactoryCache;
    private final ArrayDeque<Function> functionStack = new ArrayDeque();
    private final Long256Impl long256Sink = new Long256Impl();
    private final ArrayDeque<RecordMetadata> metadataStack = new ArrayDeque();
    private final IntList mutableArgPositions = new IntList();
    private final ObjList<Function> mutableArgs = new ObjList();
    private final IntStack positionStack = new IntStack();
    private final PostOrderTreeTraversalAlgo traverseAlgo = new PostOrderTreeTraversalAlgo();
    private final IntList undefinedVariables = new IntList();
    private RecordMetadata metadata;
    private SqlCodeGenerator sqlCodeGenerator;
    private SqlExecutionContext sqlExecutionContext;

    public FunctionParser(CairoConfiguration configuration, FunctionFactoryCache functionFactoryCache) {
        this.configuration = configuration;
        this.functionFactoryCache = functionFactoryCache;
    }

    @NotNull
    public static Function createColumn(int position, CharSequence name, RecordMetadata metadata) throws SqlException {
        int index = metadata.getColumnIndexQuiet(name);
        if (index == -1) {
            throw SqlException.invalidColumn(position, name);
        }
        int columnType = metadata.getColumnType(index);
        switch (ColumnType.tagOf(columnType)) {
            case 1: {
                return BooleanColumn.newInstance(index);
            }
            case 2: {
                return ByteColumn.newInstance(index);
            }
            case 3: {
                return ShortColumn.newInstance(index);
            }
            case 4: {
                return new CharColumn(index);
            }
            case 5: {
                return IntColumn.newInstance(index);
            }
            case 6: {
                return LongColumn.newInstance(index);
            }
            case 9: {
                return FloatColumn.newInstance(index);
            }
            case 10: {
                return DoubleColumn.newInstance(index);
            }
            case 11: {
                return new StrColumn(index);
            }
            case 26: {
                return new VarcharColumn(index);
            }
            case 12: {
                return new SymbolColumn(index, metadata.isSymbolTableStatic(index));
            }
            case 18: {
                return BinColumn.newInstance(index);
            }
            case 7: {
                return DateColumn.newInstance(index);
            }
            case 8: {
                return TimestampColumn.newInstance(index);
            }
            case 22: {
                return new RecordColumn(index, metadata.getMetadata(index));
            }
            case 14: {
                return GeoByteColumn.newInstance(index, columnType);
            }
            case 15: {
                return GeoShortColumn.newInstance(index, columnType);
            }
            case 16: {
                return GeoIntColumn.newInstance(index, columnType);
            }
            case 17: {
                return GeoLongColumn.newInstance(index, columnType);
            }
            case 33: {
                return NullConstant.NULL;
            }
            case 13: {
                return Long256Column.newInstance(index);
            }
            case 24: {
                return Long128Column.newInstance(index);
            }
            case 19: {
                return UuidColumn.newInstance(index);
            }
            case 25: {
                return new IPv4Column(index);
            }
            case 32: {
                return IntervalColumn.newInstance(index);
            }
            case 27: {
                return new ArrayColumn(index, columnType);
            }
        }
        throw SqlException.position(position).put("unsupported column type ").put(ColumnType.nameOf(columnType));
    }

    @Override
    public void clear() {
        this.positionStack.clear();
        this.functionStack.clear();
        this.sqlExecutionContext = null;
    }

    public Function createBindVariable(SqlExecutionContext sqlExecutionContext, int position, CharSequence name, int expressionType) throws SqlException {
        this.sqlExecutionContext = sqlExecutionContext;
        if (name != null) {
            if (name.length() > 0) {
                if (expressionType != 3) {
                    return new StrConstant(name);
                }
                switch (name.charAt(0)) {
                    case ':': {
                        return this.createNamedParameter(position, name);
                    }
                    case '$': {
                        return this.parseIndexedParameter(position, name);
                    }
                }
                return new StrConstant(name);
            }
            return StrConstant.EMPTY;
        }
        return NullConstant.NULL;
    }

    public Function createImplicitCast(int position, Function function, int toType) throws SqlException {
        Function cast = this.createImplicitCastOrNull(position, function, toType);
        if (cast != null && cast.isConstant()) {
            Function constant = this.functionToConstant(cast);
            function.close();
            return constant;
        }
        return cast;
    }

    public boolean findNoArgFunction(ExpressionNode node) {
        ObjList<FunctionFactoryDescriptor> overload = this.functionFactoryCache.getOverloadList(node.token);
        if (overload != null) {
            int n = overload.size();
            for (int i = 0; i < n; ++i) {
                if (overload.getQuick(i).getSigArgCount() != 0) continue;
                return true;
            }
        }
        return false;
    }

    public FunctionFactoryCache getFunctionFactoryCache() {
        return this.functionFactoryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function parseFunction(ExpressionNode node, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        this.sqlExecutionContext = executionContext;
        if (this.metadata != null) {
            this.metadataStack.push(this.metadata);
        }
        try {
            this.metadata = metadata;
            try {
                this.traverseAlgo.traverse(node, this);
            }
            catch (Exception e) {
                for (int i = this.functionStack.size(); i > 0; --i) {
                    Misc.free(this.functionStack.poll());
                }
                this.positionStack.clear();
                throw e;
            }
            Function function = this.functionStack.poll();
            this.positionStack.pop();
            assert (this.positionStack.size() == this.functionStack.size());
            if (function != null && function.isConstant() && function.extendedOps() == null) {
                Function function2 = this.functionToConstant(function);
                return function2;
            }
            if (function != null && !(function instanceof GroupByFunction) && !(function instanceof WindowFunction) && function.shouldMemoize()) {
                switch (function.getType()) {
                    case 6: {
                        LongFunctionMemoizer longFunctionMemoizer = new LongFunctionMemoizer(function);
                        return longFunctionMemoizer;
                    }
                    case 5: {
                        IntFunctionMemoizer intFunctionMemoizer = new IntFunctionMemoizer(function);
                        return intFunctionMemoizer;
                    }
                    case 8: {
                        TimestampFunctionMemoizer timestampFunctionMemoizer = new TimestampFunctionMemoizer(function);
                        return timestampFunctionMemoizer;
                    }
                    case 10: {
                        DoubleFunctionMemoizer doubleFunctionMemoizer = new DoubleFunctionMemoizer(function);
                        return doubleFunctionMemoizer;
                    }
                    case 3: {
                        ShortFunctionMemoizer shortFunctionMemoizer = new ShortFunctionMemoizer(function);
                        return shortFunctionMemoizer;
                    }
                    case 1: {
                        BooleanFunctionMemoizer booleanFunctionMemoizer = new BooleanFunctionMemoizer(function);
                        return booleanFunctionMemoizer;
                    }
                    case 2: {
                        ByteFunctionMemoizer byteFunctionMemoizer = new ByteFunctionMemoizer(function);
                        return byteFunctionMemoizer;
                    }
                    case 4: {
                        CharFunctionMemoizer charFunctionMemoizer = new CharFunctionMemoizer(function);
                        return charFunctionMemoizer;
                    }
                    case 7: {
                        DateFunctionMemoizer dateFunctionMemoizer = new DateFunctionMemoizer(function);
                        return dateFunctionMemoizer;
                    }
                    case 9: {
                        FloatFunctionMemoizer floatFunctionMemoizer = new FloatFunctionMemoizer(function);
                        return floatFunctionMemoizer;
                    }
                    case 25: {
                        IPv4FunctionMemoizer iPv4FunctionMemoizer = new IPv4FunctionMemoizer(function);
                        return iPv4FunctionMemoizer;
                    }
                    case 19: {
                        UuidFunctionMemoizer uuidFunctionMemoizer = new UuidFunctionMemoizer(function);
                        return uuidFunctionMemoizer;
                    }
                    case 13: {
                        Long256FunctionMemoizer long256FunctionMemoizer = new Long256FunctionMemoizer(function);
                        return long256FunctionMemoizer;
                    }
                }
            }
            Function function3 = function;
            return function3;
        }
        finally {
            this.metadata = this.metadataStack.isEmpty() ? null : this.metadataStack.poll();
        }
    }

    public void setSqlCodeGenerator(SqlCodeGenerator sqlCodeGenerator) {
        this.sqlCodeGenerator = sqlCodeGenerator;
    }

    @Override
    public void visit(ExpressionNode node) throws SqlException {
        int argCount = node.paramCount;
        if (argCount == 0) {
            switch (node.type) {
                case 7: {
                    this.functionStack.push(FunctionParser.createColumn(node.position, node.token, this.metadata));
                    break;
                }
                case 3: {
                    this.functionStack.push(this.createBindVariable0(node.position, node.token));
                    break;
                }
                case 8: {
                    this.functionStack.push(new StrConstant(node.token));
                    break;
                }
                case 4: {
                    this.functionStack.push(this.createConstant(node.position, node.token));
                    break;
                }
                case 10: {
                    this.functionStack.push(this.createCursorFunction(node));
                    break;
                }
                default: {
                    this.functionStack.push(this.createFunction(node, null, null));
                    break;
                }
            }
        } else {
            this.mutableArgs.clear();
            this.mutableArgs.setPos(argCount);
            this.mutableArgPositions.clear();
            this.mutableArgPositions.setPos(argCount);
            for (int n = 0; n < argCount; ++n) {
                Function arg = this.functionStack.poll();
                int pos = this.positionStack.pop();
                this.mutableArgs.setQuick(n, arg);
                this.mutableArgPositions.setQuick(n, pos);
                if (!(arg instanceof GroupByFunction)) continue;
                Misc.freeObjList(this.mutableArgs);
                throw SqlException.position(pos).put("Aggregate function cannot be passed as an argument");
            }
            this.functionStack.push(this.createFunction(node, this.mutableArgs, this.mutableArgPositions));
        }
        this.positionStack.push(node.position);
    }

    private static SqlException invalidArgument(ExpressionNode node, @Nullable ObjList<Function> args, IntList argPositions, FunctionFactoryDescriptor descriptor) {
        SqlException ex = SqlException.position(node.position);
        if (descriptor != null) {
            if (args != null) {
                if (args.size() != descriptor.getSigArgCount()) {
                    ex.put("wrong number of arguments for function `").put(node.token).put("`; expected: ").put(descriptor.getSigArgCount()).put(", provided: ").put(args.size());
                } else if (args.size() == 2) {
                    ex.put("expression type mismatch,");
                    int n = descriptor.getSigArgCount();
                    for (int i = 0; i < n; ++i) {
                        int typeWithFlags = descriptor.getArgTypeWithFlags(i);
                        short expectedType = FunctionFactoryDescriptor.toTypeTag(typeWithFlags);
                        boolean expectedConstant = FunctionFactoryDescriptor.isConstant(typeWithFlags);
                        int actualType = args.getQuick(i).getType();
                        boolean actualConstant = args.getQuick(i).isConstant();
                        if (expectedType == actualType && (!expectedConstant || actualConstant)) continue;
                        ex.put(" expected: ").put(ColumnType.nameOf(expectedType));
                        if (expectedType == actualType) {
                            ex.put(" constant");
                        }
                        ex.put(", actual: ").put(ColumnType.nameOf(actualType));
                        ex.setPosition(argPositions.getQuick(i));
                        break;
                    }
                } else {
                    ex.put("argument type mismatch for function `").put(node.token).put('`');
                    int n = descriptor.getSigArgCount();
                    for (int i = 0; i < n; ++i) {
                        int typeWithFlags = descriptor.getArgTypeWithFlags(i);
                        short expectedType = FunctionFactoryDescriptor.toTypeTag(typeWithFlags);
                        boolean expectedConstant = FunctionFactoryDescriptor.isConstant(typeWithFlags);
                        int actualType = args.getQuick(i).getType();
                        boolean actualConstant = args.getQuick(i).isConstant();
                        if (expectedType == actualType && (!expectedConstant || actualConstant)) continue;
                        ex.put(" at #").put(i + 1);
                        ex.put(" expected: ").put(ColumnType.nameOf(expectedType));
                        if (expectedType == actualType) {
                            ex.put(" constant");
                        }
                        ex.put(", actual: ").put(ColumnType.nameOf(actualType));
                        ex.setPosition(argPositions.getQuick(i));
                        break;
                    }
                }
                Misc.freeObjList(args);
                return ex;
            }
            ex.put("function `");
            ex.put(node.token);
            ex.put("` requires arguments: ");
            ex.put(node.token);
            ex.put('(');
            int n = descriptor.getSigArgCount();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    ex.put(", ");
                }
                int typeWithFlags = descriptor.getArgTypeWithFlags(i);
                ex.put(ColumnType.nameOf(FunctionFactoryDescriptor.toTypeTag(typeWithFlags)));
                if (FunctionFactoryDescriptor.isArray(typeWithFlags)) {
                    ex.put("[]");
                }
                if (!FunctionFactoryDescriptor.isConstant(typeWithFlags)) continue;
                ex.put(" constant");
            }
            ex.put(')');
            return ex;
        }
        OperatorExpression op = OperatorExpression.getRegistry().getOperatorDefinition(node.token);
        if (op == null) {
            if (args != null) {
                ex.put("there is no matching function `").put(node.token).put("` with the argument types: (");
                int n = args.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        ex.put(", ");
                    }
                    FunctionParser.putArgType(args, i, ex);
                }
                ex.put(')');
            } else {
                ex.put("function `").put(node.token).put("` requires arguments");
            }
            Misc.freeObjList(args);
            return ex;
        }
        if (args != null && args.size() == 2) {
            ex.put("there is no matching operator `").put(node.token).put("` with the argument types: ");
            FunctionParser.putArgType(args, 0, ex);
            ex.put(' ');
            ex.put(node.token);
            ex.put(' ');
            FunctionParser.putArgType(args, 1, ex);
            Misc.freeObjList(args);
            return ex;
        }
        assert (args != null);
        ex.put("there is no matching operator `").put(node.token).put("` with the argument type: ");
        FunctionParser.putArgType(args, 0, ex);
        Misc.freeObjList(args);
        return ex;
    }

    private static SqlException invalidFunction(ExpressionNode node, ObjList<Function> args) {
        SqlException ex = SqlException.position(node.position);
        ex.put("unknown function name");
        ex.put(": ");
        ex.put(node.token);
        ex.put('(');
        if (args != null) {
            int n = args.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    ex.put(',');
                }
                ex.put(ColumnType.nameOf(args.getQuick(i).getType()));
            }
        }
        ex.put(')');
        Misc.freeObjList(args);
        return ex;
    }

    private static long parseDate(CharSequence str, int position) throws SqlException {
        try {
            return DateFormatUtils.parseDate(str);
        }
        catch (NumericException e) {
            throw SqlException.invalidDate(str, position);
        }
    }

    private static void putArgType(ObjList<Function> args, int i, SqlException ex) {
        Function arg = args.getQuick(i);
        ex.put(ColumnType.nameOf(arg.getType()));
    }

    private Function checkAndCreateFunction(FunctionFactory factory, ObjList<Function> args, IntList argPositions, ExpressionNode node, CairoConfiguration configuration) throws SqlException {
        Function function;
        int position = node.position;
        try {
            LOG.debug().$("call ").$(node).$(" -> ").$safe(factory.getSignature()).$("[factory=").$(factory).I$();
            function = factory.newInstance(position, args, argPositions, configuration, this.sqlExecutionContext);
        }
        catch (ImplicitCastException | SqlException e) {
            Misc.freeObjList(args);
            throw e;
        }
        catch (Throwable e) {
            LOG.error().$("exception in function factory: ").$(e).$();
            Misc.freeObjList(args);
            throw SqlException.position(position).put("exception in function factory: ").put(e.getMessage());
        }
        if (function == null) {
            LOG.error().$("NULL function").$(" [signature=").$safe(factory.getSignature()).$(", class=").$safe(factory.getClass().getName()).I$();
            Misc.freeObjList(args);
            throw SqlException.position(position).put("bad function factory (NULL), check log");
        }
        if (!this.sqlExecutionContext.allowNonDeterministicFunctions() && function.isNonDeterministic()) {
            Misc.freeObjList(args);
            throw SqlException.nonDeterministicColumn(node.position, node.token);
        }
        if (args != null) {
            args.clear();
        }
        return function;
    }

    private Function createBindVariable0(int position, CharSequence name) throws SqlException {
        if (name.charAt(0) != ':') {
            return this.parseIndexedParameter(position, name);
        }
        return this.createNamedParameter(position, name);
    }

    private Function createConstant(int position, CharSequence tok) throws SqlException {
        int len = tok.length();
        if (SqlKeywords.isNullKeyword(tok) || SqlKeywords.isNanKeyword(tok)) {
            return NullConstant.NULL;
        }
        if (Chars.isQuoted(tok)) {
            switch (len) {
                case 3: {
                    return CharConstant.newInstance(tok.charAt(1));
                }
                case 2: {
                    return StrConstant.EMPTY;
                }
            }
            return new StrConstant(tok);
        }
        if (len > 2 && tok.charAt(0) == 'E' && tok.charAt(1) == '\'' && tok.charAt(len - 1) == '\'') {
            return new StrConstant(Chars.toString(tok, 2, len - 1));
        }
        if (SqlKeywords.isTrueKeyword(tok)) {
            return BooleanConstant.TRUE;
        }
        if (SqlKeywords.isFalseKeyword(tok)) {
            return BooleanConstant.FALSE;
        }
        try {
            return IntConstant.newInstance(Numbers.parseInt(tok));
        }
        catch (NumericException numericException) {
            try {
                return LongConstant.newInstance(Numbers.parseLong(tok));
            }
            catch (NumericException numericException2) {
                try {
                    return DoubleConstant.newInstance(Numbers.parseDouble(tok));
                }
                catch (NumericException numericException3) {
                    try {
                        return FloatConstant.newInstance(Numbers.parseFloat(tok));
                    }
                    catch (NumericException numericException4) {
                        ConstantFunction geoConstant;
                        int columnType = ColumnType.typeOf(tok);
                        short columnTag = ColumnType.tagOf(columnType);
                        if (columnTag >= 1 && columnTag <= 18 || columnTag == 28 || columnTag == 29 || columnTag == 30 || columnTag == 19 || columnTag == 25 || columnTag == 26 || columnTag == 32 || columnTag == 27) {
                            return Constants.getTypeConstant(columnType);
                        }
                        if (SqlKeywords.startsWithGeoHashKeyword(tok)) {
                            return GeoHashTypeConstant.getInstanceByPrecision(GeoHashUtil.parseGeoHashBits(position, 7, tok));
                        }
                        if (len > 1 && tok.charAt(0) == '#' && (geoConstant = GeoHashUtil.parseGeoHashConstant(position, tok, len)) != null) {
                            return geoConstant;
                        }
                        if (Numbers.extractLong256(tok, (Long256Acceptor)this.long256Sink)) {
                            return new Long256Constant(this.long256Sink);
                        }
                        throw SqlException.position(position).put("invalid constant: ").put(tok);
                    }
                }
            }
        }
    }

    private Function createCursorFunction(ExpressionNode node) throws SqlException {
        assert (node.queryModel != null);
        this.sqlExecutionContext.pushTimestampRequiredFlag(false);
        try {
            CursorFunction cursorFunction = new CursorFunction(this.sqlCodeGenerator.generate(node.queryModel, this.sqlExecutionContext));
            return cursorFunction;
        }
        finally {
            this.sqlExecutionContext.popTimestampRequiredFlag();
        }
    }

    private Function createFunction(ExpressionNode node, ObjList<Function> args, IntList argPositions) throws SqlException {
        int k;
        int i;
        boolean isWindowContext;
        int bestMatch;
        int candidateSigArgTypeScore;
        int candidateSigArgCount;
        boolean candidateSigVarArg;
        boolean candidateSigVarArgConst;
        FunctionFactoryDescriptor candidateDescriptor;
        FunctionFactory candidate;
        int argCount;
        ObjList<FunctionFactoryDescriptor> overload;
        block53: {
            overload = this.functionFactoryCache.getOverloadList(node.token);
            if (overload == null) {
                throw FunctionParser.invalidFunction(node, args);
            }
            argCount = args == null ? 0 : args.size();
            candidate = null;
            candidateDescriptor = null;
            candidateSigVarArgConst = false;
            candidateSigVarArg = true;
            candidateSigArgCount = 0;
            candidateSigArgTypeScore = -1;
            bestMatch = 0;
            boolean bl = isWindowContext = !this.sqlExecutionContext.getWindowContext().isEmpty();
            if (SqlKeywords.isCastKeyword(node.token) && argCount == 2 && args.getQuick(1).isConstant()) {
                if (args.getQuick(0).getType() == args.getQuick(1).getType()) {
                    return args.getQuick(0);
                }
                Function arg0 = args.getQuick(0);
                if (ColumnType.isUnderdefined(arg0.getType())) {
                    int assignType;
                    int castToType = args.getQuick(1).getType();
                    short castToTypeTag = ColumnType.tagOf(castToType);
                    switch (castToTypeTag) {
                        case 4: 
                        case 11: 
                        case 26: {
                            assignType = 11;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 9: 
                        case 10: {
                            assignType = 10;
                            break;
                        }
                        case 27: {
                            assignType = castToType;
                            break;
                        }
                        default: {
                            break block53;
                        }
                    }
                    arg0.assignType(assignType, this.sqlExecutionContext.getBindVariableService());
                    if (assignType == castToType) {
                        return arg0;
                    }
                }
            }
        }
        this.undefinedVariables.clear();
        for (i = 0; i < argCount; ++i) {
            if (!args.getQuick(i).isUndefined()) continue;
            this.undefinedVariables.add(i);
        }
        int n = overload.size();
        for (i = 0; i < n; ++i) {
            boolean sigVarArgConst;
            boolean sigVarArg;
            FunctionFactoryDescriptor descriptor = overload.getQuick(i);
            FunctionFactory factory = descriptor.getFactory();
            int sigArgCount = descriptor.getSigArgCount();
            if (sigArgCount > 0) {
                int lastSigArgTypeWithFlags = descriptor.getArgTypeWithFlags(sigArgCount - 1);
                sigVarArg = FunctionFactoryDescriptor.toTypeTag(lastSigArgTypeWithFlags) == 21;
                sigVarArgConst = FunctionFactoryDescriptor.isConstant(lastSigArgTypeWithFlags);
            } else {
                sigVarArg = false;
                sigVarArgConst = false;
            }
            if (sigVarArg) {
                --sigArgCount;
            }
            if (argCount == 0 && sigArgCount == 0) {
                if (factory.isWindow() != isWindowContext && n != 1) continue;
                return this.checkAndCreateFunction(factory, args, argPositions, node, this.configuration);
            }
            if (sigArgCount != argCount && (!sigVarArg || argCount < sigArgCount)) continue;
            int match = sigArgCount == 0 ? 3 : 0;
            int sigArgTypeScore = 0;
            for (int argIdx = 0; argIdx < sigArgCount; ++argIdx) {
                boolean sigIsStringArray;
                Function arg = args.getQuick(argIdx);
                int sigArgTypeWithFlags = descriptor.getArgTypeWithFlags(argIdx);
                if (FunctionFactoryDescriptor.isConstant(sigArgTypeWithFlags) && !arg.isConstant()) {
                    match = 0;
                    break;
                }
                int argType = arg.getType();
                short argTypeTag = ColumnType.tagOf(argType);
                short sigArgTypeTag = FunctionFactoryDescriptor.toTypeTag(sigArgTypeWithFlags);
                boolean sigIsArray = FunctionFactoryDescriptor.isArray(sigArgTypeWithFlags);
                boolean argIsArray = argTypeTag == 27;
                boolean argIsStringArray = argTypeTag == 30;
                boolean bl = sigIsStringArray = sigArgTypeTag == 30;
                if (sigIsArray != argIsArray || sigIsStringArray != argIsStringArray) {
                    match = 0;
                    break;
                }
                if (argIsStringArray) {
                    match = this.mergeWithExactMatch(match);
                    continue;
                }
                if (argIsArray) {
                    short argElemTypeTag = ColumnType.decodeArrayElementType(argType);
                    if (sigArgTypeTag == argElemTypeTag) {
                        match = this.mergeWithExactMatch(match);
                        continue;
                    }
                    match = 0;
                    break;
                }
                if (sigArgTypeTag == argTypeTag || argTypeTag == 4 && sigArgTypeTag == 11 && factory.supportImplicitCastCharToStr() && arg.isConstant() && arg != CharTypeConstant.INSTANCE || sigArgTypeTag == 23 && ColumnType.isGeoHash(argType)) {
                    match = this.mergeWithExactMatch(match);
                    continue;
                }
                boolean overloadPossible = false;
                if (argIdx != 1 || !SqlKeywords.isCastKeyword(node.token)) {
                    int overloadDistance = ColumnType.overloadDistance(argTypeTag, sigArgTypeTag);
                    if (argTypeTag == 11 && sigArgTypeTag == 4) {
                        if (arg.isConstant()) {
                            if (arg.getStrLen(null) > 1) {
                                overloadDistance = 10000;
                            }
                        } else {
                            overloadDistance = 2 * overloadDistance;
                        }
                    } else if (argTypeTag == 4 && sigArgTypeTag == 11 && !factory.supportImplicitCastCharToStr()) {
                        overloadDistance = 10000;
                    }
                    sigArgTypeScore += overloadDistance;
                    overloadPossible = overloadDistance != 10000;
                    overloadPossible |= arg.isUndefined();
                }
                if (overloadPossible) {
                    switch (match) {
                        case 0: {
                            if (argTypeTag == 33) {
                                match = 2;
                                break;
                            }
                            match = 1;
                            break;
                        }
                        case 3: {
                            match = 2;
                            break;
                        }
                    }
                    continue;
                }
                match = 0;
                break;
            }
            if (match == 0) continue;
            if (isWindowContext != factory.isWindow()) {
                match = 1;
            } else if (factory.isWindow()) {
                sigArgTypeScore -= 20;
            }
            if (match != 3 && match < bestMatch || match == bestMatch && sigVarArg && !candidateSigVarArg) continue;
            if (match != 3) {
                if (candidateSigArgTypeScore > sigArgTypeScore || bestMatch < match) {
                    candidate = factory;
                    candidateDescriptor = descriptor;
                    candidateSigArgCount = sigArgCount;
                    candidateSigVarArg = sigVarArg;
                    candidateSigVarArgConst = sigVarArgConst;
                    candidateSigArgTypeScore = sigArgTypeScore;
                }
                bestMatch = match;
                continue;
            }
            candidate = factory;
            candidateDescriptor = descriptor;
            candidateSigArgCount = sigArgCount;
            candidateSigVarArg = sigVarArg;
            candidateSigVarArgConst = sigVarArgConst;
            bestMatch = match;
            if (isWindowContext == factory.isWindow()) break;
        }
        if (candidate == null) {
            if (overload.size() == 1) {
                candidateDescriptor = overload.getQuick(0);
            }
            throw FunctionParser.invalidArgument(node, args, argPositions, candidateDescriptor);
        }
        if (candidateSigVarArgConst) {
            for (k = candidateSigArgCount; k < argCount; ++k) {
                Function func = args.getQuick(k);
                if (func.isConstant() || func.isRuntimeConstant()) continue;
                Misc.freeObjList(args);
                throw SqlException.$(argPositions.getQuick(k), "constant expected");
            }
        }
        n = this.undefinedVariables.size();
        for (i = 0; i < n; ++i) {
            int pos = this.undefinedVariables.getQuick(i);
            if (pos < candidateSigArgCount) {
                short sigArgType = FunctionFactoryDescriptor.toTypeTag(candidateDescriptor.getArgTypeWithFlags(pos));
                args.getQuick(pos).assignType(sigArgType, this.sqlExecutionContext.getBindVariableService());
                continue;
            }
            int type = candidate.resolvePreferredVariadicType(argPositions.getQuick(pos), pos, args);
            args.getQuick(pos).assignType(type, this.sqlExecutionContext.getBindVariableService());
        }
        for (k = 0; k < candidateSigArgCount; ++k) {
            Function arg = args.getQuick(k);
            short sigArgTypeTag = FunctionFactoryDescriptor.toTypeTag(candidateDescriptor.getArgTypeWithFlags(k));
            short argTypeTag = ColumnType.tagOf(arg.getType());
            if (argTypeTag == 10 && arg.isConstant() && Numbers.isNull(arg.getDouble(null))) {
                if (sigArgTypeTag == 6) {
                    args.setQuick(k, LongConstant.NULL);
                    continue;
                }
                if (sigArgTypeTag != 5) continue;
                args.setQuick(k, IntConstant.NULL);
                continue;
            }
            if ((argTypeTag == 11 || argTypeTag == 12 || argTypeTag == 26) && arg.isConstant()) {
                int position;
                if (sigArgTypeTag == 8) {
                    position = argPositions.getQuick(k);
                    long timestamp = this.parseTimestamp(arg.getStrA(null), position);
                    args.set(k, TimestampConstant.newInstance(timestamp));
                    continue;
                }
                if (sigArgTypeTag != 7) continue;
                position = argPositions.getQuick(k);
                long millis = FunctionParser.parseDate(arg.getStrA(null), position);
                args.set(k, DateConstant.newInstance(millis));
                continue;
            }
            if (argTypeTag == 19 && sigArgTypeTag == 11) {
                args.setQuick(k, new CastUuidToStrFunctionFactory.Func(arg));
                continue;
            }
            if (argTypeTag != 32 || sigArgTypeTag != 11) continue;
            args.setQuick(k, new CastIntervalToStrFunctionFactory.Func(arg));
        }
        return this.checkAndCreateFunction(candidate, args, argPositions, node, this.configuration);
    }

    @Nullable
    private Function createImplicitCastOrNull(int position, Function function, int toType) throws SqlException {
        int fromType = function.getType();
        switch (fromType) {
            case 11: 
            case 12: {
                if (toType == 19) {
                    return new CastStrToUuidFunctionFactory.Func(function);
                }
                if (toType == 8) {
                    return new CastStrToTimestampFunctionFactory.Func(function);
                }
                if (ColumnType.isArray(toType)) {
                    assert (ColumnType.decodeArrayElementType(toType) == 10);
                    return new CastStrToDoubleArrayFunctionFactory.Func(function, toType);
                }
                if (!ColumnType.isGeoHash(toType)) break;
                return CastStrToGeoHashFunctionFactory.newInstance(position, toType, function);
            }
            case 26: {
                if (toType == 19) {
                    return new CastVarcharToUuidFunctionFactory.Func(function);
                }
                if (toType == 8) {
                    return new CastVarcharToTimestampFunctionFactory.Func(function);
                }
                if (!ColumnType.isGeoHash(toType)) break;
                return CastVarcharToGeoHashFunctionFactory.newInstance(position, toType, function);
            }
            case 19: {
                if (toType == 11) {
                    return new CastUuidToStrFunctionFactory.Func(function);
                }
                if (toType != 26) break;
                return new CastUuidToVarcharFunctionFactory.Func(function);
            }
            case 4: {
                if (toType != 12) break;
                return new CastCharToSymbolFunctionFactory.Func(function);
            }
            default: {
                if (!ColumnType.isGeoHash(fromType)) break;
                int fromGeoBits = ColumnType.getGeoHashBits(fromType);
                int toGeoBits = ColumnType.getGeoHashBits(toType);
                if (!ColumnType.isGeoHash(toType) || toGeoBits >= fromGeoBits) break;
                return CastGeoHashToGeoHashFunctionFactory.newInstance(position, function, toType, fromType);
            }
        }
        return null;
    }

    private Function createIndexParameter(int variableIndex, int position) throws SqlException {
        Function function = this.getBindVariableService().getFunction(variableIndex);
        if (function == null) {
            return new IndexedParameterLinkFunction(variableIndex, 0, position);
        }
        return new IndexedParameterLinkFunction(variableIndex, function.getType(), position);
    }

    private Function createNamedParameter(int position, CharSequence name) throws SqlException {
        Function function = this.getBindVariableService().getFunction(name);
        if (function == null) {
            throw SqlException.position(position).put("undefined bind variable: ").put(name);
        }
        return new NamedParameterLinkFunction(Chars.toString(name), function.getType());
    }

    private Function functionToConstant(Function function) {
        Function newFunction = this.functionToConstant0(function);
        if (newFunction != function) {
            function.close();
        }
        return newFunction;
    }

    private Function functionToConstant0(Function function) {
        int type = function.getType();
        switch (ColumnType.tagOf(type)) {
            case 5: {
                if (function instanceof IntConstant) {
                    return function;
                }
                int intConst = function.getInt(null);
                long longConst = function.getLong(null);
                if (intConst == Integer.MIN_VALUE || (long)intConst == longConst) {
                    return IntConstant.newInstance(intConst);
                }
                return new LongConstant(longConst);
            }
            case 1: {
                if (function instanceof BooleanConstant) {
                    return function;
                }
                return BooleanConstant.of(function.getBool(null));
            }
            case 2: {
                if (function instanceof ByteConstant) {
                    return function;
                }
                return ByteConstant.newInstance(function.getByte(null));
            }
            case 3: {
                if (function instanceof ShortConstant) {
                    return function;
                }
                return ShortConstant.newInstance(function.getShort(null));
            }
            case 4: {
                if (function instanceof CharConstant) {
                    return function;
                }
                return CharConstant.newInstance(function.getChar(null));
            }
            case 9: {
                if (function instanceof FloatConstant) {
                    return function;
                }
                return FloatConstant.newInstance(function.getFloat(null));
            }
            case 10: {
                if (function instanceof DoubleConstant) {
                    return function;
                }
                return DoubleConstant.newInstance(function.getDouble(null));
            }
            case 6: {
                if (function instanceof LongConstant) {
                    return function;
                }
                return LongConstant.newInstance(function.getLong(null));
            }
            case 13: {
                if (function instanceof Long256Constant) {
                    return function;
                }
                return new Long256Constant(function.getLong256A(null));
            }
            case 14: {
                if (function instanceof GeoByteConstant) {
                    return function;
                }
                return new GeoByteConstant(function.getGeoByte(null), type);
            }
            case 15: {
                if (function instanceof GeoShortConstant) {
                    return function;
                }
                return new GeoShortConstant(function.getGeoShort(null), type);
            }
            case 16: {
                if (function instanceof GeoIntConstant) {
                    return function;
                }
                return new GeoIntConstant(function.getGeoInt(null), type);
            }
            case 17: {
                if (function instanceof GeoLongConstant) {
                    return function;
                }
                return new GeoLongConstant(function.getGeoLong(null), type);
            }
            case 7: {
                if (function instanceof DateConstant) {
                    return function;
                }
                return DateConstant.newInstance(function.getDate(null));
            }
            case 11: {
                if (function instanceof StrConstant) {
                    return function;
                }
                return StrConstant.newInstance(function.getStrA(null));
            }
            case 26: {
                if (function instanceof VarcharConstant) {
                    return function;
                }
                return VarcharConstant.newInstance(function.getVarcharA(null));
            }
            case 12: {
                if (function instanceof SymbolConstant) {
                    return function;
                }
                return SymbolConstant.newInstance(function.getSymbol(null));
            }
            case 8: {
                if (function instanceof TimestampConstant) {
                    return function;
                }
                return TimestampConstant.newInstance(function.getTimestamp(null));
            }
            case 19: {
                if (function instanceof UuidConstant) {
                    return function;
                }
                return new UuidConstant(function.getLong128Lo(null), function.getLong128Hi(null));
            }
            case 25: {
                if (function instanceof IPv4Constant) {
                    return function;
                }
                return IPv4Constant.newInstance(function.getIPv4(null));
            }
            case 27: {
                if (function instanceof ArrayConstant) {
                    return function;
                }
                ArrayView array = function.getArray(null);
                if (array instanceof FunctionArray) {
                    return new ArrayConstant((FunctionArray)array);
                }
                return function;
            }
        }
        return function;
    }

    @NotNull
    private BindVariableService getBindVariableService() throws SqlException {
        BindVariableService bindVariableService = this.sqlExecutionContext.getBindVariableService();
        if (bindVariableService == null) {
            throw SqlException.$(0, "bind variable service is not provided");
        }
        return bindVariableService;
    }

    private int mergeWithExactMatch(int match) {
        return match == 0 ? 3 : (match == 1 ? 2 : match);
    }

    private Function parseIndexedParameter(int position, CharSequence name) throws SqlException {
        try {
            int variableIndex = Numbers.parseInt(name, 1, name.length());
            if (variableIndex < 1) {
                throw SqlException.$(position, "invalid bind variable index [value=").put(variableIndex).put(']');
            }
            return this.createIndexParameter(variableIndex - 1, position);
        }
        catch (NumericException e) {
            throw SqlException.$(position, "invalid bind variable index [value=").put(name).put(']');
        }
    }

    private long parseTimestamp(CharSequence str, int position) throws SqlException {
        try {
            return IntervalUtils.parseFloorPartialTimestamp(str);
        }
        catch (NumericException e) {
            throw SqlException.invalidDate(str, position);
        }
    }

    static {
        int n = SqlCompilerImpl.sqlControlSymbols.size();
        for (int i = 0; i < n; ++i) {
            FunctionFactoryCache.invalidFunctionNames.add(SqlCompilerImpl.sqlControlSymbols.getQuick(i));
        }
        FunctionFactoryCache.invalidFunctionNameChars.add(32);
        FunctionFactoryCache.invalidFunctionNameChars.add(34);
        FunctionFactoryCache.invalidFunctionNameChars.add(39);
    }
}

