/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine;

import io.questdb.cairo.Reopenable;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;

public abstract class AbstractRedBlackTree
implements Mutable,
Reopenable {
    protected static final byte BLACK = 0;
    protected static final int EMPTY = -1;
    protected static final long OFFSET_LEFT = 4L;
    protected static final byte RED = 1;
    private static final long BLOCK_SIZE = 24L;
    private static final long MAX_KEY_HEAP_SIZE_LIMIT = Integer.toUnsignedLong(-1) - 1L << 3;
    private static final long OFFSET_COLOUR = 12L;
    private static final long OFFSET_LAST_REF = 20L;
    private static final long OFFSET_REF = 16L;
    private static final long OFFSET_RIGHT = 8L;
    private final long initialKeyHeapSize;
    private final long maxKeyHeapSize;
    protected int root = -1;
    private long keyHeapLimit;
    private long keyHeapPos;
    private long keyHeapSize;
    private long keyHeapStart;

    public AbstractRedBlackTree(long keyPageSize, int keyMaxPages) {
        assert (keyPageSize >= 24L);
        this.keyHeapSize = this.initialKeyHeapSize = keyPageSize;
        this.keyHeapStart = this.keyHeapPos = Unsafe.malloc(this.keyHeapSize, 59);
        this.keyHeapLimit = this.keyHeapStart + this.keyHeapSize;
        this.maxKeyHeapSize = Math.min(keyPageSize * (long)keyMaxPages, MAX_KEY_HEAP_SIZE_LIMIT);
    }

    @Override
    public void clear() {
        this.root = -1;
        this.keyHeapPos = this.keyHeapStart;
    }

    @Override
    public void close() {
        this.root = -1;
        if (this.keyHeapStart != 0L) {
            this.keyHeapStart = Unsafe.free(this.keyHeapStart, this.keyHeapSize, 59);
            this.keyHeapPos = 0L;
            this.keyHeapLimit = 0L;
            this.keyHeapSize = 0L;
        }
    }

    @Override
    public void reopen() {
        if (this.keyHeapStart == 0L) {
            this.keyHeapSize = this.initialKeyHeapSize;
            this.keyHeapStart = this.keyHeapPos = Unsafe.malloc(this.keyHeapSize, 59);
            this.keyHeapLimit = this.keyHeapStart + this.keyHeapSize;
        }
    }

    public long size() {
        return (this.keyHeapPos - this.keyHeapStart) / 24L;
    }

    private static int compressKeyOffset(long rawOffset) {
        return (int)(rawOffset >> 3);
    }

    private static long uncompressKeyOffset(int offset) {
        return (long)offset << 3;
    }

    private void checkKeyCapacity() {
        if (this.keyHeapPos + 24L > this.keyHeapLimit) {
            long newHeapSize = this.keyHeapSize << 1;
            if (newHeapSize > this.maxKeyHeapSize) {
                throw LimitOverflowException.instance().put("limit of ").put(this.maxKeyHeapSize).put(" memory exceeded in RedBlackTree");
            }
            long newHeapPos = Unsafe.realloc(this.keyHeapStart, this.keyHeapSize, newHeapSize, 59);
            this.keyHeapSize = newHeapSize;
            long delta = newHeapPos - this.keyHeapStart;
            this.keyHeapPos += delta;
            this.keyHeapStart = newHeapPos;
            this.keyHeapLimit = newHeapPos + newHeapSize;
        }
    }

    private void rotateLeft(int p) {
        if (p != -1) {
            int r = this.rightOf(p);
            int lr = this.leftOf(r);
            this.setRight(p, lr);
            if (lr != -1) {
                this.setParent(lr, p);
            }
            int pp = this.parentOf(p);
            this.setParent(r, pp);
            if (pp == -1) {
                this.root = r;
            } else if (this.leftOf(pp) == p) {
                this.setLeft(pp, r);
            } else {
                this.setRight(pp, r);
            }
            this.setLeft(r, p);
            this.setParent(p, r);
        }
    }

    private void rotateRight(int p) {
        if (p != -1) {
            int l = this.leftOf(p);
            int rl = this.rightOf(l);
            this.setLeft(p, rl);
            if (rl != -1) {
                this.setParent(rl, p);
            }
            int pp = this.parentOf(p);
            this.setParent(l, pp);
            if (pp == -1) {
                this.root = l;
            } else if (this.rightOf(pp) == p) {
                this.setRight(pp, l);
            } else {
                this.setLeft(pp, l);
            }
            this.setRight(l, p);
            this.setParent(p, l);
        }
    }

    protected int allocateBlock() {
        this.checkKeyCapacity();
        int offset = AbstractRedBlackTree.compressKeyOffset(this.keyHeapPos - this.keyHeapStart);
        this.setLeft(offset, -1);
        this.setRight(offset, -1);
        this.setColor(offset, (byte)0);
        this.keyHeapPos += 24L;
        return offset;
    }

    protected byte colorOf(int blockOffset) {
        return blockOffset == -1 ? (byte)0 : Unsafe.getUnsafe().getByte(this.keyHeapStart + AbstractRedBlackTree.uncompressKeyOffset(blockOffset) + 12L);
    }

    protected int findMaxNode() {
        int parent;
        int p = this.root;
        do {
            parent = p;
        } while ((p = this.rightOf(p)) > -1);
        return parent;
    }

    protected int findMinNode() {
        int parent;
        int p = this.root;
        do {
            parent = p;
        } while ((p = this.leftOf(p)) > -1);
        return parent;
    }

    void fixDelete(int node, int parent) {
        boolean isLeftChild;
        if (this.root == -1) {
            return;
        }
        boolean bl = isLeftChild = parent != -1 && this.leftOf(parent) == node;
        while (node != this.root && this.colorOf(node) == 0) {
            int sibling;
            if (isLeftChild) {
                sibling = this.rightOf(parent);
                if (this.colorOf(sibling) == 1) {
                    this.setColor(sibling, (byte)0);
                    this.setColor(parent, (byte)1);
                    this.rotateLeft(parent);
                    sibling = this.rightOf(parent);
                }
                if (this.colorOf(this.leftOf(sibling)) == 0 && this.colorOf(this.rightOf(sibling)) == 0) {
                    this.setColor(sibling, (byte)1);
                    node = parent;
                    parent = this.parentOf(parent);
                    isLeftChild = parent != -1 && this.leftOf(parent) == node;
                    continue;
                }
                if (this.colorOf(this.rightOf(sibling)) == 0) {
                    this.setColor(this.leftOf(sibling), (byte)0);
                    this.setColor(sibling, (byte)1);
                    this.rotateRight(sibling);
                    sibling = this.rightOf(parent);
                }
                this.setColor(sibling, this.colorOf(parent));
                this.setColor(parent, (byte)0);
                if (this.rightOf(sibling) != -1) {
                    this.setColor(this.rightOf(sibling), (byte)0);
                }
                this.rotateLeft(parent);
                break;
            }
            sibling = this.leftOf(parent);
            if (this.colorOf(sibling) == 1) {
                this.setColor(sibling, (byte)0);
                this.setColor(parent, (byte)1);
                this.rotateRight(parent);
                sibling = this.leftOf(parent);
            }
            if (this.colorOf(this.leftOf(sibling)) == 0 && this.colorOf(this.rightOf(sibling)) == 0) {
                this.setColor(sibling, (byte)1);
                node = parent;
                parent = this.parentOf(parent);
                isLeftChild = parent != -1 && this.leftOf(parent) == node;
                continue;
            }
            if (this.colorOf(this.leftOf(sibling)) == 0) {
                this.setColor(this.rightOf(sibling), (byte)0);
                this.setColor(sibling, (byte)1);
                this.rotateLeft(sibling);
                sibling = this.leftOf(parent);
            }
            this.setColor(sibling, this.colorOf(parent));
            this.setColor(parent, (byte)0);
            if (this.leftOf(sibling) != -1) {
                this.setColor(this.leftOf(sibling), (byte)0);
            }
            this.rotateRight(parent);
            break;
        }
        if (node != -1) {
            this.setColor(node, (byte)0);
        }
    }

    protected void fixInsert(int x) {
        int px;
        this.setColor(x, (byte)1);
        while (x != -1 && x != this.root && this.colorOf(px = this.parentOf(x)) == 1) {
            int y;
            int p20x = this.parent2Of(x);
            if (px == this.leftOf(p20x)) {
                y = this.rightOf(p20x);
                if (this.colorOf(y) == 1) {
                    this.setColor(px, (byte)0);
                    this.setColor(y, (byte)0);
                    this.setColor(p20x, (byte)1);
                    x = p20x;
                    continue;
                }
                if (x == this.rightOf(px)) {
                    x = px;
                    this.rotateLeft(x);
                    px = this.parentOf(x);
                    p20x = this.parent2Of(x);
                }
                this.setColor(px, (byte)0);
                this.setColor(p20x, (byte)1);
                this.rotateRight(p20x);
                continue;
            }
            y = this.leftOf(p20x);
            if (this.colorOf(y) == 1) {
                this.setColor(px, (byte)0);
                this.setColor(y, (byte)0);
                this.setColor(p20x, (byte)1);
                x = p20x;
                continue;
            }
            if (x == this.leftOf(px)) {
                x = this.parentOf(x);
                this.rotateRight(x);
                px = this.parentOf(x);
                p20x = this.parent2Of(x);
            }
            this.setColor(px, (byte)0);
            this.setColor(p20x, (byte)1);
            this.rotateLeft(p20x);
        }
        this.setColor(this.root, (byte)0);
    }

    protected int lastRefOf(int blockOffset) {
        return blockOffset == -1 ? -1 : Unsafe.getUnsafe().getInt(this.keyHeapStart + AbstractRedBlackTree.uncompressKeyOffset(blockOffset) + 20L);
    }

    protected int leftOf(int blockOffset) {
        return blockOffset == -1 ? -1 : Unsafe.getUnsafe().getInt(this.keyHeapStart + AbstractRedBlackTree.uncompressKeyOffset(blockOffset) + 4L);
    }

    protected int parent2Of(int blockOffset) {
        return this.parentOf(this.parentOf(blockOffset));
    }

    protected int parentOf(int blockOffset) {
        return blockOffset == -1 ? -1 : Unsafe.getUnsafe().getInt(this.keyHeapStart + AbstractRedBlackTree.uncompressKeyOffset(blockOffset));
    }

    protected void putParent(int value) {
        this.root = this.allocateBlock();
        this.setRef(this.root, value);
        this.setParent(this.root, -1);
    }

    protected int refOf(int blockOffset) {
        return blockOffset == -1 ? -1 : Unsafe.getUnsafe().getInt(this.keyHeapStart + AbstractRedBlackTree.uncompressKeyOffset(blockOffset) + 16L);
    }

    protected int remove(int node) {
        int nodeToRemove = this.leftOf(node) == -1 || this.rightOf(node) == -1 ? node : this.successor(node);
        int current = this.leftOf(nodeToRemove) != -1 ? this.leftOf(nodeToRemove) : this.rightOf(nodeToRemove);
        int parent = this.parentOf(nodeToRemove);
        if (current != -1) {
            this.setParent(current, parent);
        }
        if (parent == -1) {
            this.root = current;
        } else if (this.leftOf(parent) == nodeToRemove) {
            this.setLeft(parent, current);
        } else {
            this.setRight(parent, current);
        }
        if (nodeToRemove != node) {
            int tmp = this.refOf(nodeToRemove);
            this.setRef(nodeToRemove, this.refOf(node));
            this.setRef(node, tmp);
        }
        if (this.colorOf(nodeToRemove) == 0) {
            this.fixDelete(current, parent);
        }
        return nodeToRemove;
    }

    protected int rightOf(int blockOffset) {
        return blockOffset == -1 ? -1 : Unsafe.getUnsafe().getInt(this.keyHeapStart + AbstractRedBlackTree.uncompressKeyOffset(blockOffset) + 8L);
    }

    protected void setColor(int blockOffset, byte colour) {
        Unsafe.getUnsafe().putByte(this.keyHeapStart + AbstractRedBlackTree.uncompressKeyOffset(blockOffset) + 12L, colour);
    }

    protected void setLastRef(int blockOffset, int recRef) {
        Unsafe.getUnsafe().putInt(this.keyHeapStart + AbstractRedBlackTree.uncompressKeyOffset(blockOffset) + 20L, recRef);
    }

    protected void setLeft(int blockOffset, int left) {
        Unsafe.getUnsafe().putInt(this.keyHeapStart + AbstractRedBlackTree.uncompressKeyOffset(blockOffset) + 4L, left);
    }

    protected void setParent(int blockOffset, int parent) {
        Unsafe.getUnsafe().putInt(this.keyHeapStart + AbstractRedBlackTree.uncompressKeyOffset(blockOffset), parent);
    }

    protected void setRef(int blockOffset, int recRef) {
        Unsafe.getUnsafe().putInt(this.keyHeapStart + AbstractRedBlackTree.uncompressKeyOffset(blockOffset) + 16L, recRef);
    }

    protected void setRight(int blockOffset, int right) {
        Unsafe.getUnsafe().putInt(this.keyHeapStart + AbstractRedBlackTree.uncompressKeyOffset(blockOffset) + 8L, right);
    }

    protected int successor(int current) {
        int p = this.rightOf(current);
        if (p != -1) {
            int l;
            while ((l = this.leftOf(p)) != -1) {
                p = l;
            }
        } else {
            p = this.parentOf(current);
            int ch = current;
            while (p != -1 && ch == this.rightOf(p)) {
                ch = p;
                p = this.parentOf(p);
            }
        }
        return p;
    }
}

