/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class DoubleArrayPositionFunctionFactory
implements FunctionFactory {
    private static final String FUNCTION_NAME = "array_position";

    @Override
    public String getSignature() {
        return "array_position(D[]D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arrayArg = args.getQuick(0);
        if (ColumnType.decodeArrayDimensionality(arrayArg.getType()) != 1) {
            throw SqlException.position(argPositions.getQuick(0)).put("array is not one-dimensional");
        }
        Function valueArg = args.getQuick(1);
        if (valueArg.isConstant()) {
            double value = valueArg.getDouble(null);
            valueArg.close();
            return Numbers.isNull(value) ? new ArrayPositionConstNullFunction(arrayArg) : new ArrayPositionConstFunction(arrayArg, value);
        }
        return new ArrayIndexOfFunction(arrayArg, valueArg);
    }

    static int linearSearchNan(ArrayView array) {
        if (array.isNull() || array.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        int dimLen = array.getDimLen(0);
        for (int i = 0; i < dimLen; ++i) {
            if (!Numbers.isNull(array.getDouble(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    static int linearSearchValue(ArrayView array, double value) {
        if (array.isNull() || array.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        if (array.isVanilla()) {
            return array.flatView().linearSearch(value, array.getFlatViewOffset(), array.getFlatViewLength());
        }
        int stride = array.getStride(0);
        int index = 0;
        int n = array.getDimLen(0);
        for (int i = 0; i < n; ++i) {
            double d = array.getDouble(index);
            if (Numbers.isFinite(d) && Math.abs(d - value) <= 1.0E-10) {
                return i;
            }
            index += stride;
        }
        return Integer.MIN_VALUE;
    }

    static class ArrayPositionConstNullFunction
    extends IntFunction
    implements UnaryFunction {
        private final Function arrayArg;

        ArrayPositionConstNullFunction(Function arrayArg) {
            this.arrayArg = arrayArg;
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public int getInt(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                return Integer.MIN_VALUE;
            }
            return DoubleArrayPositionFunctionFactory.linearSearchNan(arr) + 1;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(DoubleArrayPositionFunctionFactory.FUNCTION_NAME).val('(').val(this.arrayArg).val(", null)");
        }
    }

    static class ArrayPositionConstFunction
    extends IntFunction
    implements UnaryFunction {
        private final Function arrayArg;
        private final double value;

        ArrayPositionConstFunction(Function arrayArg, double value) {
            this.arrayArg = arrayArg;
            this.value = value;
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public int getInt(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                return Integer.MIN_VALUE;
            }
            int pos = DoubleArrayPositionFunctionFactory.linearSearchValue(arr, this.value);
            return Integer.MIN_VALUE == pos ? Integer.MIN_VALUE : pos + 1;
        }

        @Override
        public String getName() {
            return DoubleArrayPositionFunctionFactory.FUNCTION_NAME;
        }
    }

    static class ArrayIndexOfFunction
    extends IntFunction
    implements BinaryFunction {
        private final Function arrayArg;
        private final Function valueArg;

        ArrayIndexOfFunction(Function arrayArg, Function valueArg) {
            this.arrayArg = arrayArg;
            this.valueArg = valueArg;
        }

        @Override
        public int getInt(Record rec) {
            ArrayView array = this.arrayArg.getArray(rec);
            if (array.isNull()) {
                return Integer.MIN_VALUE;
            }
            double value = this.valueArg.getDouble(rec);
            int index = Numbers.isNull(value) ? DoubleArrayPositionFunctionFactory.linearSearchNan(array) : DoubleArrayPositionFunctionFactory.linearSearchValue(array, value);
            return Integer.MIN_VALUE == index ? Integer.MIN_VALUE : index + 1;
        }

        @Override
        public Function getLeft() {
            return this.arrayArg;
        }

        @Override
        public Function getRight() {
            return this.valueArg;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(DoubleArrayPositionFunctionFactory.FUNCTION_NAME).val('(').val(this.arrayArg).val(", ").val(this.valueArg).val(')');
        }
    }
}

