/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToStrFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class CastIPv4ToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Xs)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function ipv4Func = args.getQuick(0);
        if (ipv4Func.isConstant()) {
            StringSink sink = Misc.getThreadLocalSink();
            Numbers.intToIPv4Sink(sink, ipv4Func.getIPv4(null));
            return new StrConstant(Chars.toString(sink));
        }
        return new Func(args.getQuick(0));
    }

    public static class Func
    extends AbstractCastToStrFunction {
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public Func(Function arg) {
            super(arg);
        }

        @Override
        public CharSequence getStrA(Record rec) {
            int value = this.arg.getIPv4(rec);
            return this.toSink(value, this.sinkA);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            int value = this.arg.getIPv4(rec);
            return this.toSink(value, this.sinkB);
        }

        @Nullable
        private StringSink toSink(int value, StringSink sinkB) {
            if (value != 0) {
                sinkB.clear();
                Numbers.intToIPv4Sink(sinkB, value);
                return sinkB;
            }
            return null;
        }
    }
}

