/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.window.BaseWindowFunction;
import io.questdb.griffin.engine.functions.window.WindowDoubleFunction;
import io.questdb.griffin.engine.functions.window.WindowLongFunction;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public abstract class AbstractWindowFunctionFactory
implements FunctionFactory {
    @Override
    public boolean isWindow() {
        return true;
    }

    static void expandRingBuffer(MemoryARW memory, RingBufferDesc desc, int recordSize) {
        desc.capacity <<= 1;
        long oldAddress = memory.getPageAddress(0) + desc.startOffset;
        long newAddress = -1L;
        int n = desc.freeList.size();
        for (int i = 0; i < n; i += 2) {
            if (desc.freeList.getQuick(i) != desc.capacity) continue;
            newAddress = memory.getPageAddress(0) + desc.freeList.getQuick(i + 1);
            desc.freeList.setQuick(i, desc.size);
            desc.freeList.setQuick(i + 1, desc.startOffset);
            break;
        }
        if (newAddress == -1L) {
            newAddress = memory.appendAddressFor(desc.capacity * (long)recordSize);
            oldAddress = memory.getPageAddress(0) + desc.startOffset;
            desc.freeList.add(desc.size, desc.startOffset);
        }
        if (desc.firstIdx == 0L) {
            Vect.memcpy(newAddress, oldAddress, desc.size * (long)recordSize);
        } else {
            desc.firstIdx %= desc.size;
            long firstPieceSize = (desc.size - desc.firstIdx) * (long)recordSize;
            Vect.memcpy(newAddress, oldAddress + desc.firstIdx * (long)recordSize, firstPieceSize);
            Vect.memcpy(newAddress + firstPieceSize, oldAddress, desc.firstIdx * (long)recordSize);
            desc.firstIdx = 0L;
        }
        desc.startOffset = newAddress - memory.getPageAddress(0);
    }

    protected boolean supportNullsDesc() {
        return false;
    }

    protected static class RingBufferDesc {
        long capacity;
        long firstIdx;
        LongList freeList;
        long size;
        long startOffset;

        protected RingBufferDesc() {
        }

        void reset(long capacity, long startOffset, long size, long firstIdx, LongList freeList) {
            this.capacity = capacity;
            this.startOffset = startOffset;
            this.size = size;
            this.firstIdx = firstIdx;
            this.freeList = freeList;
        }
    }

    static class LongNullFunction
    extends BaseNullFunction
    implements WindowLongFunction {
        private final Long zeroValue;

        LongNullFunction(Function arg, String name, long rowLo, long rowHi, boolean isRange, VirtualRecord partitionByRecord, long zeroValue) {
            super(arg, name, rowLo, rowHi, isRange, partitionByRecord);
            this.zeroValue = zeroValue;
        }

        @Override
        public long getLong(Record rec) {
            return this.zeroValue;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.zeroValue);
        }
    }

    static class DoubleNullFunction
    extends BaseNullFunction
    implements WindowDoubleFunction {
        DoubleNullFunction(Function arg, String name, long rowLo, long rowHi, boolean isRange, VirtualRecord partitionByRecord) {
            super(arg, name, rowLo, rowHi, isRange, partitionByRecord);
        }

        @Override
        public double getDouble(Record rec) {
            return Double.NaN;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), Double.NaN);
        }
    }

    static abstract class BaseNullFunction
    extends BaseWindowFunction {
        private final boolean isRange;
        private final String name;
        private final VirtualRecord partitionByRecord;
        private final long rowHi;
        private final long rowLo;

        BaseNullFunction(Function arg, String name, long rowLo, long rowHi, boolean isRange, VirtualRecord partitionByRecord) {
            super(arg);
            this.name = name;
            this.rowLo = rowLo;
            this.rowHi = rowHi;
            this.isRange = isRange;
            this.partitionByRecord = partitionByRecord;
        }

        @Override
        public void close() {
            super.close();
            if (this.partitionByRecord != null) {
                Misc.freeObjList(this.partitionByRecord.getFunctions());
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            if (this.arg != null) {
                sink.val('(').val(this.arg).val(')');
            } else {
                sink.val("(*)");
            }
            sink.val(" over (");
            if (this.partitionByRecord != null) {
                sink.val("partition by ");
                sink.val(this.partitionByRecord.getFunctions());
            }
            if (this.isRange) {
                sink.val(" range between ");
            } else {
                sink.val(" rows between ");
            }
            if (this.rowLo != Long.MIN_VALUE) {
                sink.val(Math.abs(this.rowLo));
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.rowHi == 0L) {
                sink.val("current row");
            } else {
                sink.val(Math.abs(this.rowHi)).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
        }
    }
}

