/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class DistinctRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final DistinctRecordCursor cursor;
    private final Function limitHiFunction;
    private final Function limitLoFunction;
    private final RecordSink mapSink;

    public DistinctRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull EntityColumnFilter columnFilter, @NotNull BytecodeAssembler asm, Function limitLoFunction, Function limitHiFunction) {
        super(base.getMetadata());
        this.base = base;
        this.limitLoFunction = limitLoFunction;
        this.limitHiFunction = limitHiFunction;
        try {
            RecordMetadata metadata = base.getMetadata();
            columnFilter.of(metadata.getColumnCount());
            this.mapSink = RecordSinkFactory.getInstance(asm, metadata, columnFilter);
            this.cursor = new DistinctRecordCursor(configuration, metadata, limitLoFunction, limitHiFunction);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, this.mapSink, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable e) {
            this.cursor.close();
            throw e;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Distinct");
        sink.attr("keys").val(this.getMetadata());
        long earlyExit = DistinctRecordCursorFactory.computeEarlyExit(this.limitLoFunction, this.limitHiFunction);
        if (earlyExit != Long.MAX_VALUE) {
            sink.attr("earlyExit").val(earlyExit);
        }
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    private static long computeEarlyExit(Function limitLoFunction, Function limitHiFunction) {
        long limitLo;
        long earlyExit = Long.MAX_VALUE;
        if (limitLoFunction != null && (limitLo = limitLoFunction.getLong(null)) > 0L) {
            if (limitHiFunction != null) {
                long limitHi = limitHiFunction.getLong(null);
                if (limitHi > 0L) {
                    earlyExit = limitHi;
                }
            } else {
                earlyExit = limitLo;
            }
        }
        return earlyExit;
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
        Misc.free(this.cursor);
        Misc.free(this.limitLoFunction);
        Misc.free(this.limitHiFunction);
    }

    private static class DistinctRecordCursor
    implements NoRandomAccessRecordCursor {
        private final IntList columnIndex = new IntList();
        private final Map dataMap;
        private final Function limitHiFunction;
        private final Function limitLoFunction;
        private RecordCursor baseCursor;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isMapBuilt;
        private boolean isOpen = true;
        private RecordCursor mapCursor;
        private MapRecord recordA;
        private RecordSink recordSink;

        public DistinctRecordCursor(CairoConfiguration configuration, RecordMetadata metadata, Function limitLoFunction, Function limitHiFunction) {
            this.dataMap = MapFactory.createOrderedMap(configuration, metadata);
            int n = metadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.columnIndex.add(i);
            }
            this.limitLoFunction = limitLoFunction;
            this.limitHiFunction = limitHiFunction;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.baseCursor = Misc.free(this.baseCursor);
                Misc.free(this.dataMap);
            }
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            this.buildMap();
            return this.mapCursor.hasNext();
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.baseCursor.newSymbolTable(columnIndex);
        }

        public void of(RecordCursor baseCursor, RecordSink recordSink, SqlExecutionCircuitBreaker circuitBreaker) {
            this.baseCursor = baseCursor;
            if (!this.isOpen) {
                this.isOpen = true;
                this.dataMap.reopen();
            }
            this.isMapBuilt = false;
            this.recordA = this.dataMap.getRecord();
            this.recordA.setSymbolTableResolver(baseCursor, this.columnIndex);
            this.recordSink = recordSink;
            this.circuitBreaker = circuitBreaker;
        }

        @Override
        public long preComputedStateSize() {
            return this.dataMap.size();
        }

        @Override
        public long size() {
            this.buildMap();
            return this.dataMap.size();
        }

        @Override
        public void toTop() {
            if (this.isMapBuilt && this.mapCursor != null) {
                this.mapCursor.toTop();
            }
        }

        private void buildMap() {
            if (!this.isMapBuilt) {
                this.buildMapSlow();
            }
        }

        private void buildMapSlow() {
            long earlyExit = DistinctRecordCursorFactory.computeEarlyExit(this.limitLoFunction, this.limitHiFunction);
            Record record = this.baseCursor.getRecord();
            while (this.baseCursor.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                MapKey key = this.dataMap.withKey();
                this.recordSink.copy(record, key);
                if (!key.create() || earlyExit-- != 0L) continue;
                break;
            }
            this.mapCursor = this.dataMap.getCursor();
            this.isMapBuilt = true;
        }
    }
}

