/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableMetadata;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.CreateTableOperation;
import io.questdb.griffin.engine.ops.CreateTableOperationBuilderImpl;
import io.questdb.griffin.engine.ops.CreateTableOperationFuture;
import io.questdb.griffin.model.CreateTableColumnModel;
import io.questdb.mp.SCSequence;
import io.questdb.std.Chars;
import io.questdb.std.LongList;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateTableOperationImpl
implements CreateTableOperation {
    private final LowerCaseCharSequenceObjHashMap<TableColumnMetadata> augmentedColumnMetadata = new LowerCaseCharSequenceObjHashMap();
    private final long batchO3MaxLag;
    private final long batchSize;
    private final LowerCaseCharSequenceIntHashMap colNameToCastClausePos = new LowerCaseCharSequenceIntHashMap();
    private final LowerCaseCharSequenceIntHashMap colNameToDedupClausePos = new LowerCaseCharSequenceIntHashMap();
    private final LowerCaseCharSequenceIntHashMap colNameToIndexClausePos = new LowerCaseCharSequenceIntHashMap();
    private final LongList columnBits = new LongList();
    private final ObjList<String> columnNames = new ObjList();
    private final CreateTableOperationFuture future = new CreateTableOperationFuture();
    private final boolean ignoreIfExists;
    private final String likeTableName;
    private final int likeTableNamePosition;
    private final String selectText;
    private final int selectTextPosition;
    private final String sqlText;
    private final String tableName;
    private final int tableNamePosition;
    private final String volumeAlias;
    private final int volumePosition;
    private int defaultSymbolCapacity = -1;
    private int maxUncommittedRows;
    private long o3MaxLag;
    private int partitionBy;
    private String timestampColumnName;
    private int timestampColumnNamePosition;
    private int timestampIndex = -1;
    private int ttlHoursOrMonths;
    private int ttlPosition;
    private boolean walEnabled;

    public CreateTableOperationImpl(@NotNull String sqlText, @NotNull String tableName, int tableNamePosition, int partitionBy, @Nullable String volumeAlias, int volumePosition, @Nullable String likeTableName, int likeTableNamePosition, boolean ignoreIfExists) {
        this.sqlText = sqlText;
        this.tableName = tableName;
        this.tableNamePosition = tableNamePosition;
        this.partitionBy = partitionBy;
        this.volumeAlias = volumeAlias;
        this.volumePosition = volumePosition;
        this.likeTableName = likeTableName;
        this.likeTableNamePosition = likeTableNamePosition;
        this.ignoreIfExists = ignoreIfExists;
        this.selectText = null;
        this.selectTextPosition = 0;
        this.timestampColumnName = null;
        this.timestampColumnNamePosition = 0;
        this.batchSize = 0L;
        this.batchO3MaxLag = 0L;
    }

    public CreateTableOperationImpl(@NotNull String sqlText, @NotNull String tableName, int tableNamePosition, int partitionBy, @Nullable String volumeAlias, int volumePosition, boolean ignoreIfExists, ObjList<CharSequence> columnNames, LowerCaseCharSequenceObjHashMap<CreateTableColumnModel> createColumnModelMap, int timestampIndex, long o3MaxLag, int maxUncommittedRows, int ttlHoursOrMonths, int ttlPosition, boolean walEnabled) {
        this.sqlText = sqlText;
        this.tableName = tableName;
        this.tableNamePosition = tableNamePosition;
        this.partitionBy = partitionBy;
        this.volumeAlias = volumeAlias;
        this.volumePosition = volumePosition;
        this.ignoreIfExists = ignoreIfExists;
        int n = columnNames.size();
        for (int i = 0; i < n; ++i) {
            CharSequence colName = columnNames.get(i);
            this.columnNames.add(Chars.toString(colName));
            CreateTableColumnModel model = createColumnModelMap.get(colName);
            this.addColumnBits(model.getColumnType(), model.getSymbolCacheFlag(), model.getSymbolCapacity(), model.isIndexed(), model.getIndexValueBlockSize(), model.isDedupKey());
        }
        this.timestampColumnName = null;
        this.timestampColumnNamePosition = 0;
        this.timestampIndex = timestampIndex;
        this.o3MaxLag = o3MaxLag;
        this.maxUncommittedRows = maxUncommittedRows;
        this.ttlHoursOrMonths = ttlHoursOrMonths;
        this.ttlPosition = ttlPosition;
        this.walEnabled = walEnabled;
        this.selectText = null;
        this.selectTextPosition = 0;
        this.likeTableName = null;
        this.likeTableNamePosition = -1;
        this.batchSize = 0L;
        this.batchO3MaxLag = 0L;
    }

    public CreateTableOperationImpl(String sqlText, @NotNull String tableName, int tableNamePosition, @NotNull String selectText, int selectTextPosition, boolean ignoreIfExists, int partitionBy, @Nullable String timestampColumnName, int timestampColumnNamePosition, @Nullable String volumeAlias, int volumePosition, int ttlHoursOrMonths, int ttlPosition, boolean walEnabled, int defaultSymbolCapacity, int maxUncommittedRows, long o3MaxLag, LowerCaseCharSequenceObjHashMap<CreateTableColumnModel> createColumnModelMap, long batchSize, long batchO3MaxLag) {
        this.sqlText = sqlText;
        this.tableName = tableName;
        this.tableNamePosition = tableNamePosition;
        this.selectText = selectText;
        this.selectTextPosition = selectTextPosition;
        this.partitionBy = partitionBy;
        this.volumeAlias = volumeAlias;
        this.volumePosition = volumePosition;
        this.ignoreIfExists = ignoreIfExists;
        this.timestampColumnName = timestampColumnName;
        this.timestampColumnNamePosition = timestampColumnNamePosition;
        this.ttlHoursOrMonths = ttlHoursOrMonths;
        this.ttlPosition = ttlPosition;
        this.defaultSymbolCapacity = defaultSymbolCapacity;
        this.batchSize = batchSize;
        this.batchO3MaxLag = batchO3MaxLag;
        this.o3MaxLag = o3MaxLag;
        this.maxUncommittedRows = maxUncommittedRows;
        this.walEnabled = walEnabled;
        this.likeTableName = null;
        this.likeTableNamePosition = -1;
        this.initColumnMetadata(createColumnModelMap);
    }

    @Override
    public void close() {
    }

    @Override
    public OperationFuture execute(SqlExecutionContext sqlExecutionContext, @Nullable SCSequence eventSubSeq) throws SqlException {
        try (SqlCompiler compiler = sqlExecutionContext.getCairoEngine().getSqlCompiler();){
            compiler.execute(this, sqlExecutionContext);
        }
        return this.future;
    }

    public LowerCaseCharSequenceObjHashMap<TableColumnMetadata> getAugmentedColumnMetadata() {
        return this.augmentedColumnMetadata;
    }

    @Override
    public long getBatchO3MaxLag() {
        return this.batchO3MaxLag;
    }

    @Override
    public long getBatchSize() {
        return this.batchSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public CharSequence getColumnName(int index) {
        return this.columnNames.getQuick(index);
    }

    @Override
    public int getColumnType(int index) {
        return this.getLowAt(index * 2);
    }

    @Override
    public int getIndexBlockCapacity(int index) {
        return this.getHighAt(index * 2 + 1);
    }

    @Override
    public CharSequence getLikeTableName() {
        return this.likeTableName;
    }

    @Override
    public int getLikeTableNamePosition() {
        return this.likeTableNamePosition;
    }

    @Override
    public int getMaxUncommittedRows() {
        return this.maxUncommittedRows;
    }

    @Override
    public long getO3MaxLag() {
        return this.o3MaxLag;
    }

    @Override
    public int getOperationCode() {
        return 1;
    }

    @Override
    public OperationFuture getOperationFuture() {
        return this.future;
    }

    @Override
    public int getPartitionBy() {
        return this.partitionBy;
    }

    @Override
    public String getSelectText() {
        return this.selectText;
    }

    @Override
    public int getSelectTextPosition() {
        return this.selectTextPosition;
    }

    @Override
    public String getSqlText() {
        return this.sqlText;
    }

    @Override
    public boolean getSymbolCacheFlag(int index) {
        return (this.getLowAt(index * 2 + 1) & 1) != 0;
    }

    @Override
    public int getSymbolCapacity(int index) {
        int capacity = this.getHighAt(index * 2);
        assert (capacity != -1) : "Symbol capacity is not set";
        return capacity;
    }

    @Override
    public CharSequence getTableName() {
        return this.tableName;
    }

    @Override
    public int getTableNamePosition() {
        return this.tableNamePosition;
    }

    @Override
    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    @Override
    public int getTtlHoursOrMonths() {
        return this.ttlHoursOrMonths;
    }

    public int getTtlPosition() {
        return this.ttlPosition;
    }

    @Override
    public CharSequence getVolumeAlias() {
        return this.volumeAlias;
    }

    @Override
    public int getVolumePosition() {
        return this.volumePosition;
    }

    @Override
    public boolean ignoreIfExists() {
        return this.ignoreIfExists;
    }

    public void initColumnMetadata(LowerCaseCharSequenceObjHashMap<CreateTableColumnModel> createColumnModelMap) {
        assert (this.columnNames.size() == 0);
        assert (this.columnBits.size() == 0);
        this.colNameToDedupClausePos.clear();
        this.colNameToIndexClausePos.clear();
        this.colNameToCastClausePos.clear();
        this.augmentedColumnMetadata.clear();
        ObjList colNames = createColumnModelMap.keys();
        int n = colNames.size();
        for (int i = 0; i < n; ++i) {
            CharSequence columnName = (CharSequence)colNames.get(i);
            CreateTableColumnModel model = createColumnModelMap.get(columnName);
            String columnNameStr = Chars.toString(columnName);
            int symbolCapacity = model.getSymbolCapacity();
            if (symbolCapacity == -1) {
                symbolCapacity = this.defaultSymbolCapacity;
            }
            if (model.isDedupKey()) {
                this.colNameToDedupClausePos.put(columnName, model.getDedupColumnPos());
            }
            if (model.isIndexed()) {
                this.colNameToIndexClausePos.put(columnName, model.getIndexColumnPos());
            }
            if (model.isCast()) {
                this.colNameToCastClausePos.put(columnName, model.getColumnNamePos());
            }
            TableColumnMetadata columnMetadata = new TableColumnMetadata(columnNameStr, model.getColumnType(), model.isIndexed(), model.getIndexValueBlockSize(), true, null, -1, model.isDedupKey(), -1, model.getSymbolCacheFlag(), symbolCapacity);
            this.augmentedColumnMetadata.put(columnNameStr, columnMetadata);
        }
    }

    @Override
    public boolean isDedupKey(int index) {
        return (this.getLowAt(index * 2 + 1) & 4) != 0;
    }

    @Override
    public boolean isIndexed(int index) {
        return (this.getLowAt(index * 2 + 1) & 2) != 0;
    }

    @Override
    public boolean isWalEnabled() {
        return this.walEnabled;
    }

    public void setPartitionBy(int partitionBy) {
        this.partitionBy = partitionBy;
    }

    public void setTimestampColumnName(String timestampColumnName) {
        this.timestampColumnName = timestampColumnName;
    }

    public void setTimestampColumnNamePosition(int timestampColumnNamePosition) {
        this.timestampColumnNamePosition = timestampColumnNamePosition;
    }

    @Override
    public void updateFromLikeTableMetadata(TableMetadata likeTableMetadata) {
        this.maxUncommittedRows = likeTableMetadata.getMaxUncommittedRows();
        this.o3MaxLag = likeTableMetadata.getO3MaxLag();
        this.partitionBy = likeTableMetadata.getPartitionBy();
        this.timestampIndex = likeTableMetadata.getTimestampIndex();
        this.walEnabled = likeTableMetadata.isWalEnabled();
        this.ttlHoursOrMonths = likeTableMetadata.getTtlHoursOrMonths();
        this.columnNames.clear();
        this.columnBits.clear();
        for (int i = 0; i < likeTableMetadata.getColumnCount(); ++i) {
            TableColumnMetadata colMeta = likeTableMetadata.getColumnMetadata(i);
            this.addColumnBits(colMeta.getColumnType(), colMeta.isSymbolCacheFlag(), colMeta.getSymbolCapacity(), colMeta.isSymbolIndexFlag(), colMeta.getIndexValueBlockCapacity(), colMeta.isDedupKeyFlag());
            this.columnNames.add(colMeta.getColumnName());
        }
    }

    @Override
    public void updateOperationFutureAffectedRowsCount(long affectedRowsCount) {
        this.future.of(affectedRowsCount);
    }

    @Override
    public void updateOperationFutureTableToken(TableToken tableToken) {
        this.future.tableToken = tableToken;
    }

    @Override
    public void validateAndUpdateMetadataFromSelect(RecordMetadata metadata) throws SqlException {
        assert (this.selectText != null);
        this.columnBits.clear();
        if (this.timestampColumnName == null) {
            this.timestampIndex = metadata.getTimestampIndex();
        } else {
            this.timestampIndex = metadata.getColumnIndexQuiet(this.timestampColumnName);
            if (this.timestampIndex == -1) {
                throw SqlException.position(this.timestampColumnNamePosition).put("designated timestamp column doesn't exist [name=").put(this.timestampColumnName).put(']');
            }
            int timestampColType = metadata.getColumnType(this.timestampIndex);
            if (timestampColType != 8) {
                throw SqlException.position(this.timestampColumnNamePosition).put("TIMESTAMP column expected [actual=").put(ColumnType.nameOf(timestampColType)).put(']');
            }
        }
        ObjList castColNames = this.colNameToCastClausePos.keys();
        int n = castColNames.size();
        for (int i = 0; i < n; ++i) {
            CharSequence castColName = (CharSequence)castColNames.get(i);
            if (metadata.getColumnIndexQuiet(castColName) >= 0) continue;
            throw SqlException.position(this.colNameToCastClausePos.get(castColName)).put("CAST column doesn't exist [column=").put(castColName).put(']');
        }
        ObjList indexColNames = this.colNameToIndexClausePos.keys();
        int n2 = indexColNames.size();
        for (int i = 0; i < n2; ++i) {
            CharSequence indexedColName = (CharSequence)indexColNames.get(i);
            if (metadata.getColumnIndexQuiet(indexedColName) >= 0) continue;
            throw SqlException.position(this.colNameToIndexClausePos.get(indexedColName)).put("INDEX column doesn't exist [column=").put(indexedColName).put(']');
        }
        ObjList dedupColNames = this.colNameToDedupClausePos.keys();
        int n3 = dedupColNames.size();
        for (int i = 0; i < n3; ++i) {
            CharSequence dedupColName = (CharSequence)dedupColNames.get(i);
            if (metadata.getColumnIndexQuiet(dedupColName) >= 0) continue;
            throw SqlException.position(this.colNameToDedupClausePos.get(dedupColName)).put("DEDUP column doesn't exist [column=").put(dedupColName).put(']');
        }
        this.columnNames.clear();
        boolean hasDedup = false;
        boolean isTimestampDeduped = false;
        int n4 = metadata.getColumnCount();
        for (int i = 0; i < n4; ++i) {
            int indexBlockCapacity;
            boolean isDedupKey;
            boolean symbolIndexed;
            boolean symbolCacheFlag;
            int symbolCapacity;
            int columnType;
            String columnName = metadata.getColumnName(i);
            TableColumnMetadata augMeta = this.augmentedColumnMetadata.get(columnName);
            if (!TableUtils.isValidColumnName(columnName, 255)) {
                throw SqlException.position(this.tableNamePosition).put("invalid column name [name=").put(columnName).put(", position=").put(i).put(']');
            }
            if (augMeta != null) {
                int fromType = metadata.getColumnType(i);
                columnType = augMeta.getColumnType();
                if (columnType == 0) {
                    columnType = fromType;
                }
                if (!CreateTableOperationBuilderImpl.isCompatibleCast(fromType, columnType)) {
                    throw SqlException.unsupportedCast(this.colNameToCastClausePos.get(columnName), columnName, fromType, columnType);
                }
                symbolCapacity = augMeta.getSymbolCapacity();
                symbolCacheFlag = augMeta.isSymbolCacheFlag();
                symbolIndexed = augMeta.isSymbolIndexFlag();
                isDedupKey = augMeta.isDedupKeyFlag();
                indexBlockCapacity = augMeta.getIndexValueBlockCapacity();
            } else {
                columnType = metadata.getColumnType(i);
                if (ColumnType.isNull(columnType)) {
                    throw SqlException.$(0, "cannot create NULL-type column, please use type cast, e.g. ").put(columnName).put("::").put("type");
                }
                symbolCapacity = this.defaultSymbolCapacity;
                symbolCacheFlag = true;
                symbolIndexed = false;
                isDedupKey = false;
                indexBlockCapacity = 0;
            }
            if (!ColumnType.isSymbol(columnType) && symbolIndexed) {
                throw SqlException.$(0, "indexes are supported only for SYMBOL columns: ").put(columnName);
            }
            if (isDedupKey) {
                hasDedup = true;
                if (i == this.timestampIndex) {
                    isTimestampDeduped = true;
                }
            }
            this.columnNames.add(columnName);
            this.addColumnBits(columnType, symbolCacheFlag, symbolCapacity, symbolIndexed, indexBlockCapacity, isDedupKey);
        }
        if (hasDedup && !isTimestampDeduped) {
            int firstDedupColumnPos = Integer.MAX_VALUE;
            int n5 = dedupColNames.size();
            for (int i = 0; i < n5; ++i) {
                int dedupColPos = this.colNameToDedupClausePos.get((CharSequence)dedupColNames.get(i));
                if (firstDedupColumnPos <= dedupColPos) continue;
                firstDedupColumnPos = dedupColPos;
            }
            throw SqlException.position(firstDedupColumnPos).put("deduplicate key list must include dedicated timestamp column");
        }
    }

    private void addColumnBits(int columnType, boolean symbolCacheFlag, int symbolCapacity, boolean indexFlag, int indexBlockCapacity, boolean dedupFlag) {
        int flags = (symbolCacheFlag ? 1 : 0) | (indexFlag ? 2 : 0) | (dedupFlag ? 4 : 0);
        this.columnBits.add(Numbers.encodeLowHighInts(columnType, symbolCapacity), Numbers.encodeLowHighInts(flags, indexBlockCapacity));
    }

    private int getHighAt(int index) {
        return Numbers.decodeHighInt(this.columnBits.getQuick(index));
    }

    private int getLowAt(int index) {
        return Numbers.decodeLowInt(this.columnBits.getQuick(index));
    }

    String getTimestampColumnName() {
        return this.timestampColumnName;
    }

    int getTimestampColumnNamePosition() {
        return this.timestampColumnNamePosition;
    }
}

