/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.orderby.RecordTreeChain;
import io.questdb.std.Misc;

class SortedRecordCursor
implements DelegatingRecordCursor {
    private final RecordTreeChain chain;
    private RecordCursor baseCursor;
    private RecordTreeChain.TreeCursor chainCursor;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private boolean isChainBuilt;
    private boolean isOpen;

    public SortedRecordCursor(RecordTreeChain chain) {
        this.chain = chain;
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.chainCursor = Misc.free(this.chainCursor);
            this.baseCursor = Misc.free(this.baseCursor);
            Misc.free(this.chain);
        }
    }

    @Override
    public Record getRecord() {
        return this.chainCursor.getRecord();
    }

    @Override
    public Record getRecordB() {
        return this.chainCursor.getRecordB();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.chainCursor.getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (!this.isChainBuilt) {
            this.buildChain();
            this.isChainBuilt = true;
        }
        return this.chainCursor.hasNext();
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.chainCursor.newSymbolTable(columnIndex);
    }

    @Override
    public void of(RecordCursor baseCursor, SqlExecutionContext executionContext) {
        this.baseCursor = baseCursor;
        if (!this.isOpen) {
            this.isOpen = true;
            this.chain.reopen();
        }
        this.chainCursor = this.chain.getCursor(baseCursor);
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.isChainBuilt = false;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.chainCursor.recordAt(record, atRowId);
    }

    @Override
    public long size() {
        return this.baseCursor.size();
    }

    @Override
    public long preComputedStateSize() {
        return this.chain.size();
    }

    @Override
    public void toTop() {
        this.chainCursor.toTop();
    }

    private void buildChain() {
        Record record = this.baseCursor.getRecord();
        while (this.baseCursor.hasNext()) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            this.chain.put(record);
        }
        this.toTop();
    }
}

