/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractTreeSetRecordCursorFactory;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDeferredTreeSetRecordCursorFactory
extends AbstractTreeSetRecordCursorFactory {
    protected final int columnIndex;
    protected final ObjList<Function> deferredSymbolFuncs;
    protected final IntHashSet deferredSymbolKeys;
    protected final IntHashSet symbolKeys;

    public AbstractDeferredTreeSetRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, int columnIndex, ObjList<Function> keyValueFuncs, SymbolMapReader symbolMapReader, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts) {
        super(configuration, metadata, partitionFrameCursorFactory, columnIndexes, columnSizeShifts);
        int nKeyValues = keyValueFuncs.size();
        IntHashSet symbolKeys = new IntHashSet(nKeyValues);
        IntHashSet deferredSymbolKeys = null;
        ObjList<Function> deferredFuncs = null;
        try {
            for (int i = 0; i < nKeyValues; ++i) {
                int symbolKey;
                Function symbolFunc = keyValueFuncs.get(i);
                int n = symbolKey = symbolFunc.isRuntimeConstant() ? -2 : symbolMapReader.keyOf(symbolFunc.getStrA(null));
                if (symbolKey == -2) {
                    if (deferredFuncs == null) {
                        deferredFuncs = new ObjList<Function>();
                        deferredSymbolKeys = new IntHashSet();
                    }
                    deferredFuncs.add(symbolFunc);
                    continue;
                }
                symbolKeys.add(TableUtils.toIndexKey(symbolKey));
            }
            this.columnIndex = columnIndex;
            this.symbolKeys = symbolKeys;
            this.deferredSymbolKeys = deferredSymbolKeys;
            this.deferredSymbolFuncs = deferredFuncs;
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    protected RecordCursor initRecordCursor(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        if (this.deferredSymbolFuncs != null) {
            this.deferredSymbolKeys.clear();
            StaticSymbolTable symbolTable = pageFrameCursor.getSymbolTable(this.columnIndex);
            int n = this.deferredSymbolFuncs.size();
            for (int i = 0; i < n; ++i) {
                Function symbolFunc = this.deferredSymbolFuncs.get(i);
                CharSequence symbol = symbolFunc.getStrA(null);
                int symbolKey = symbolTable.keyOf(symbol);
                if (symbolKey == -2) continue;
                this.deferredSymbolKeys.add(TableUtils.toIndexKey(symbolKey));
            }
        }
        return super.initRecordCursor(pageFrameCursor, executionContext);
    }
}

