/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.ExecutionCircuitBreaker;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.StatefulAtom;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.PerWorkerLocks;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.GroupByAllocatorFactory;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdaterFactory;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.table.AsyncJitFilteredRecordCursorFactory;
import io.questdb.jit.CompiledFilter;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.QuietCloseable;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncGroupByAtom
implements StatefulAtom,
Closeable,
Reopenable,
Plannable {
    private static final int MAX_SHARDS = 128;
    private final ObjList<Function> bindVarFunctions;
    private final MemoryCARW bindVarMemory;
    private final CompiledFilter compiledFilter;
    private final CairoConfiguration configuration;
    private final ObjList<Map> destShards;
    private final ColumnTypes keyTypes;
    private final MapStats lastOwnerStats;
    private final ObjList<MapStats> lastShardStats;
    private final GroupByAllocator ownerAllocator;
    private final Function ownerFilter;
    private final MapFragment ownerFragment;
    private final GroupByFunctionsUpdater ownerFunctionUpdater;
    private final ObjList<GroupByFunction> ownerGroupByFunctions;
    private final ObjList<Function> ownerKeyFunctions;
    private final RecordSink ownerMapSink;
    private final ObjList<GroupByAllocator> perWorkerAllocators;
    private final ObjList<Function> perWorkerFilters;
    private final ObjList<MapFragment> perWorkerFragments;
    private final ObjList<GroupByFunctionsUpdater> perWorkerFunctionUpdaters;
    private final ObjList<ObjList<GroupByFunction>> perWorkerGroupByFunctions;
    private final ObjList<ObjList<Function>> perWorkerKeyFunctions;
    private final PerWorkerLocks perWorkerLocks;
    private final ObjList<RecordSink> perWorkerMapSinks;
    private final int shardCount;
    private final int shardCountShr;
    private final ColumnTypes valueTypes;
    private boolean lastSharded;
    private volatile boolean sharded;

    public AsyncGroupByAtom(@NotNull BytecodeAssembler asm, @NotNull CairoConfiguration configuration, @NotNull ColumnTypes columnTypes, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, @NotNull ListColumnFilter listColumnFilter, @NotNull ObjList<GroupByFunction> ownerGroupByFunctions, @Nullable ObjList<ObjList<GroupByFunction>> perWorkerGroupByFunctions, @NotNull ObjList<Function> ownerKeyFunctions, @Nullable ObjList<ObjList<Function>> perWorkerKeyFunctions, @Nullable CompiledFilter compiledFilter, @Nullable MemoryCARW bindVarMemory, @Nullable ObjList<Function> bindVarFunctions, @Nullable Function ownerFilter, @Nullable ObjList<Function> perWorkerFilters, int workerCount) {
        assert (perWorkerFilters == null || perWorkerFilters.size() == workerCount);
        assert (perWorkerKeyFunctions == null || perWorkerKeyFunctions.size() == workerCount);
        int slotCount = Math.min(workerCount, configuration.getPageFrameReduceQueueCapacity());
        try {
            int i;
            int i2;
            this.configuration = configuration;
            this.keyTypes = new ArrayColumnTypes().addAll(keyTypes);
            this.valueTypes = new ArrayColumnTypes().addAll(valueTypes);
            this.compiledFilter = compiledFilter;
            this.bindVarMemory = bindVarMemory;
            this.bindVarFunctions = bindVarFunctions;
            this.ownerFilter = ownerFilter;
            this.perWorkerFilters = perWorkerFilters;
            this.ownerKeyFunctions = ownerKeyFunctions;
            this.perWorkerKeyFunctions = perWorkerKeyFunctions;
            this.ownerGroupByFunctions = ownerGroupByFunctions;
            this.perWorkerGroupByFunctions = perWorkerGroupByFunctions;
            Class<GroupByFunctionsUpdater> updaterClass = GroupByFunctionsUpdaterFactory.getInstanceClass(asm, ownerGroupByFunctions.size());
            this.ownerFunctionUpdater = GroupByFunctionsUpdaterFactory.getInstance(updaterClass, ownerGroupByFunctions);
            if (perWorkerGroupByFunctions != null) {
                this.perWorkerFunctionUpdaters = new ObjList(slotCount);
                for (i2 = 0; i2 < slotCount; ++i2) {
                    this.perWorkerFunctionUpdaters.extendAndSet(i2, GroupByFunctionsUpdaterFactory.getInstance(updaterClass, perWorkerGroupByFunctions.getQuick(i2)));
                }
            } else {
                this.perWorkerFunctionUpdaters = null;
            }
            this.perWorkerLocks = new PerWorkerLocks(configuration, slotCount);
            this.shardCount = Math.min(Numbers.ceilPow2(2 * workerCount), 128);
            this.shardCountShr = Long.numberOfLeadingZeros(this.shardCount) + 1;
            this.lastShardStats = new ObjList(this.shardCount);
            for (i2 = 0; i2 < this.shardCount; ++i2) {
                this.lastShardStats.extendAndSet(i2, new MapStats());
            }
            this.lastOwnerStats = new MapStats();
            this.ownerFragment = new MapFragment(true);
            this.perWorkerFragments = new ObjList(slotCount);
            for (i2 = 0; i2 < slotCount; ++i2) {
                this.perWorkerFragments.extendAndSet(i2, new MapFragment(false));
            }
            this.destShards = new ObjList(this.shardCount);
            this.destShards.setPos(this.shardCount);
            Class<RecordSink> sinkClass = RecordSinkFactory.getInstanceClass(asm, columnTypes, listColumnFilter, ownerKeyFunctions, null);
            this.ownerMapSink = RecordSinkFactory.getInstance(sinkClass, ownerKeyFunctions);
            if (perWorkerKeyFunctions != null) {
                this.perWorkerMapSinks = new ObjList(slotCount);
                for (i = 0; i < slotCount; ++i) {
                    this.perWorkerMapSinks.extendAndSet(i, RecordSinkFactory.getInstance(sinkClass, perWorkerKeyFunctions.getQuick(i)));
                }
            } else {
                this.perWorkerMapSinks = null;
            }
            this.ownerAllocator = GroupByAllocatorFactory.createAllocator(configuration);
            this.perWorkerAllocators = new ObjList(slotCount);
            for (i = 0; i < slotCount; ++i) {
                this.perWorkerAllocators.extendAndSet(i, GroupByAllocatorFactory.createAllocator(configuration));
            }
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void clear() {
        this.sharded = false;
        Misc.free(this.ownerFragment);
        Misc.freeObjListAndKeepObjects(this.perWorkerFragments);
        Misc.freeObjListAndKeepObjects(this.destShards);
        if (this.perWorkerGroupByFunctions != null) {
            int n = this.perWorkerGroupByFunctions.size();
            for (int i = 0; i < n; ++i) {
                Misc.clearObjList(this.perWorkerGroupByFunctions.getQuick(i));
            }
        }
        Misc.free(this.ownerAllocator);
        Misc.freeObjListAndKeepObjects(this.perWorkerAllocators);
    }

    @Override
    public void close() {
        int i;
        int n;
        Misc.free(this.ownerFragment);
        Misc.freeObjList(this.perWorkerFragments);
        Misc.freeObjList(this.destShards);
        Misc.free(this.compiledFilter);
        Misc.free(this.bindVarMemory);
        Misc.freeObjList(this.bindVarFunctions);
        Misc.free(this.ownerFilter);
        Misc.freeObjList(this.ownerKeyFunctions);
        Misc.freeObjList(this.perWorkerFilters);
        Misc.free(this.ownerAllocator);
        Misc.freeObjList(this.perWorkerAllocators);
        if (this.perWorkerKeyFunctions != null) {
            n = this.perWorkerKeyFunctions.size();
            for (i = 0; i < n; ++i) {
                Misc.freeObjList(this.perWorkerKeyFunctions.getQuick(i));
            }
        }
        if (this.perWorkerGroupByFunctions != null) {
            n = this.perWorkerGroupByFunctions.size();
            for (i = 0; i < n; ++i) {
                Misc.freeObjList(this.perWorkerGroupByFunctions.getQuick(i));
            }
        }
    }

    public void finalizeShardStats() {
        if (this.configuration.isGroupByPresizeEnabled()) {
            int i;
            long maxHeapSize = 0L;
            for (i = 0; i < this.shardCount; ++i) {
                MapStats stats = this.lastShardStats.getQuick(i);
                maxHeapSize = Math.max(maxHeapSize, stats.maxHeapSize);
            }
            for (i = 0; i < this.shardCount; ++i) {
                this.lastShardStats.getQuick((int)i).maxHeapSize = maxHeapSize;
            }
        }
    }

    public ObjList<Function> getBindVarFunctions() {
        return this.bindVarFunctions;
    }

    public MemoryCARW getBindVarMemory() {
        return this.bindVarMemory;
    }

    public CompiledFilter getCompiledFilter() {
        return this.compiledFilter;
    }

    public ObjList<Map> getDestShards() {
        return this.destShards;
    }

    public Function getFilter(int slotId) {
        if (slotId == -1 || this.perWorkerFilters == null) {
            return this.ownerFilter;
        }
        return this.perWorkerFilters.getQuick(slotId);
    }

    public MapFragment getFragment(int slotId) {
        if (slotId == -1) {
            return this.ownerFragment;
        }
        return this.perWorkerFragments.getQuick(slotId);
    }

    public GroupByFunctionsUpdater getFunctionUpdater(int slotId) {
        if (slotId == -1 || this.perWorkerFunctionUpdaters == null) {
            GroupByUtils.setAllocator(this.ownerGroupByFunctions, this.ownerAllocator);
            return this.ownerFunctionUpdater;
        }
        GroupByUtils.setAllocator(this.perWorkerGroupByFunctions.getQuick(slotId), this.perWorkerAllocators.getQuick(slotId));
        return this.perWorkerFunctionUpdaters.getQuick(slotId);
    }

    public RecordSink getMapSink(int slotId) {
        if (slotId == -1 || this.perWorkerMapSinks == null) {
            return this.ownerMapSink;
        }
        return this.perWorkerMapSinks.getQuick(slotId);
    }

    public int getShardCount() {
        return this.shardCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        int i;
        int n;
        boolean current;
        if (this.ownerFilter != null) {
            this.ownerFilter.init(symbolTableSource, executionContext);
        }
        if (this.perWorkerFilters != null) {
            current = executionContext.getCloneSymbolTables();
            executionContext.setCloneSymbolTables(true);
            try {
                Function.init(this.perWorkerFilters, symbolTableSource, executionContext, this.ownerFilter);
            }
            finally {
                executionContext.setCloneSymbolTables(current);
            }
        }
        if (this.ownerKeyFunctions != null) {
            Function.init(this.ownerKeyFunctions, symbolTableSource, executionContext, null);
        }
        if (this.perWorkerKeyFunctions != null) {
            current = executionContext.getCloneSymbolTables();
            executionContext.setCloneSymbolTables(true);
            try {
                n = this.perWorkerKeyFunctions.size();
                for (i = 0; i < n; ++i) {
                    Function.init(this.perWorkerKeyFunctions.getQuick(i), symbolTableSource, executionContext, null);
                }
            }
            finally {
                executionContext.setCloneSymbolTables(current);
            }
        }
        if (this.perWorkerGroupByFunctions != null) {
            current = executionContext.getCloneSymbolTables();
            executionContext.setCloneSymbolTables(true);
            try {
                n = this.perWorkerGroupByFunctions.size();
                for (i = 0; i < n; ++i) {
                    Function.init(this.perWorkerGroupByFunctions.getQuick(i), symbolTableSource, executionContext, null);
                }
            }
            finally {
                executionContext.setCloneSymbolTables(current);
            }
        }
        if (this.bindVarFunctions != null) {
            Function.init(this.bindVarFunctions, symbolTableSource, executionContext, null);
            AsyncJitFilteredRecordCursorFactory.prepareBindVarMemory(executionContext, symbolTableSource, this.bindVarFunctions, this.bindVarMemory);
        }
    }

    public boolean isSharded() {
        return this.sharded;
    }

    public int maybeAcquire(int workerId, boolean owner, SqlExecutionCircuitBreaker circuitBreaker) {
        if (workerId == -1 && owner) {
            return -1;
        }
        return this.perWorkerLocks.acquireSlot(workerId, circuitBreaker);
    }

    public int maybeAcquire(int workerId, boolean owner, ExecutionCircuitBreaker circuitBreaker) {
        if (workerId == -1 && owner) {
            return -1;
        }
        return this.perWorkerLocks.acquireSlot(workerId, circuitBreaker);
    }

    public Map mergeOwnerMap() {
        Map srcMap;
        int i;
        this.lastSharded = false;
        Map destMap = this.ownerFragment.reopenMap();
        int perWorkerMapCount = this.perWorkerFragments.size();
        GroupByFunctionsUpdater functionUpdater = this.getFunctionUpdater(-1);
        MapStats stats = this.lastOwnerStats;
        LongList medianList = stats.medianList;
        medianList.clear();
        for (int i2 = 0; i2 < perWorkerMapCount; ++i2) {
            Map srcMap2 = this.perWorkerFragments.getQuick(i2).getMap();
            if (srcMap2.size() <= 0L) continue;
            medianList.add(srcMap2.size());
        }
        medianList.sort();
        long medianSize = medianList.size() > 0 ? medianList.getQuick(Math.min(medianList.size() - 1, medianList.size() / 2 + 1)) : 0L;
        medianList.clear();
        long maxHeapSize = -1L;
        if (destMap.getUsedHeapSize() != -1L) {
            for (i = 0; i < perWorkerMapCount; ++i) {
                srcMap = this.perWorkerFragments.getQuick(i).getMap();
                maxHeapSize = Math.max(maxHeapSize, srcMap.getHeapSize());
            }
        }
        for (i = 0; i < perWorkerMapCount; ++i) {
            srcMap = this.perWorkerFragments.getQuick(i).getMap();
            destMap.merge(srcMap, functionUpdater);
            srcMap.close();
        }
        if (this.configuration.isGroupByPresizeEnabled()) {
            stats.update(medianSize, maxHeapSize, destMap.size(), destMap.getHeapSize());
        }
        return destMap;
    }

    public void mergeShard(int slotId, int shardIndex) {
        Map srcMap;
        MapFragment srcFragment;
        int i;
        assert (this.sharded);
        GroupByFunctionsUpdater functionUpdater = this.getFunctionUpdater(slotId);
        Map destMap = this.reopenDestShard(shardIndex);
        int perWorkerMapCount = this.perWorkerFragments.size();
        MapStats stats = this.lastShardStats.getQuick(shardIndex);
        LongList medianList = stats.medianList;
        medianList.clear();
        for (int i2 = 0; i2 < perWorkerMapCount; ++i2) {
            MapFragment srcFragment2 = this.perWorkerFragments.getQuick(i2);
            Map srcMap2 = srcFragment2.getShards().getQuick(shardIndex);
            if (srcMap2.size() <= 0L) continue;
            medianList.add(srcMap2.size());
        }
        Map srcOwnerMap = this.ownerFragment.getShards().getQuick(shardIndex);
        if (srcOwnerMap.size() > 0L) {
            medianList.add(srcOwnerMap.size());
        }
        medianList.sort();
        long medianSize = medianList.size() > 0 ? medianList.getQuick(Math.min(medianList.size() - 1, medianList.size() / 2 + 1)) : 0L;
        long maxHeapSize = -1L;
        if (destMap.getUsedHeapSize() != -1L) {
            for (i = 0; i < perWorkerMapCount; ++i) {
                srcFragment = this.perWorkerFragments.getQuick(i);
                srcMap = srcFragment.getShards().getQuick(shardIndex);
                maxHeapSize = Math.max(maxHeapSize, srcMap.getHeapSize());
            }
        }
        for (i = 0; i < perWorkerMapCount; ++i) {
            srcFragment = this.perWorkerFragments.getQuick(i);
            srcMap = srcFragment.getShards().getQuick(shardIndex);
            destMap.merge(srcMap, functionUpdater);
            srcMap.close();
        }
        destMap.merge(srcOwnerMap, functionUpdater);
        srcOwnerMap.close();
        if (this.configuration.isGroupByPresizeEnabled()) {
            stats.update(medianSize, maxHeapSize, destMap.size(), destMap.getHeapSize());
        }
    }

    public void release(int slotId) {
        this.perWorkerLocks.releaseSlot(slotId);
    }

    @Override
    public void reopen() {
        if (this.lastSharded) {
            this.sharded = true;
        }
    }

    public void requestSharding(MapFragment fragment) {
        if (!this.sharded && fragment.getMap().size() > (long)this.configuration.getGroupByShardingThreshold()) {
            this.sharded = true;
        }
    }

    public void shardAll() {
        this.lastSharded = true;
        this.ownerFragment.shard();
        int n = this.perWorkerFragments.size();
        for (int i = 0; i < n; ++i) {
            this.perWorkerFragments.getQuick(i).shard();
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.ownerFilter);
    }

    public void toTop() {
        if (this.perWorkerGroupByFunctions != null) {
            int n = this.perWorkerGroupByFunctions.size();
            for (int i = 0; i < n; ++i) {
                GroupByUtils.toTop(this.perWorkerGroupByFunctions.getQuick(i));
            }
        }
    }

    private Map reopenDestShard(int shardIndex) {
        Map destMap = this.destShards.getQuick(shardIndex);
        if (destMap == null) {
            destMap = MapFactory.createUnorderedMap(this.configuration, this.keyTypes, this.valueTypes);
            this.destShards.set(shardIndex, destMap);
        } else if (!destMap.isOpen()) {
            MapStats stats = this.lastShardStats.getQuick(shardIndex);
            int keyCapacity = this.targetKeyCapacity(stats, true);
            long heapSize = this.targetHeapSize(stats, true);
            destMap.reopen(keyCapacity, heapSize);
        }
        return destMap;
    }

    private long targetHeapSize(MapStats stats, boolean dest) {
        long statHeapSize = dest ? stats.mergedHeapSize : stats.maxHeapSize;
        long statLimit = dest ? this.configuration.getGroupByPresizeMaxHeapSize() : this.configuration.getGroupByPresizeMaxHeapSize() / (long)this.perWorkerFragments.size();
        long heapSize = this.configuration.getSqlSmallMapPageSize();
        if (statHeapSize <= statLimit) {
            heapSize = Math.max(statHeapSize, heapSize);
        }
        return heapSize;
    }

    private int targetKeyCapacity(MapStats stats, boolean dest) {
        long statKeyCapacity = dest ? stats.mergedSize : stats.medianSize;
        long statLimit = dest ? this.configuration.getGroupByPresizeMaxCapacity() : this.configuration.getGroupByPresizeMaxCapacity() / (long)this.perWorkerFragments.size();
        int keyCapacity = this.configuration.getSqlSmallMapKeyCapacity();
        if (statKeyCapacity <= statLimit) {
            keyCapacity = Math.max((int)statKeyCapacity, keyCapacity);
        }
        return keyCapacity;
    }

    private static class MapStats {
        long maxHeapSize;
        LongList medianList = new LongList();
        long medianSize;
        long mergedHeapSize;
        long mergedSize;

        private MapStats() {
        }

        void update(long medianSize, long maxHeapSize, long mergedSize, long mergedHeapSize) {
            this.medianSize = medianSize;
            this.maxHeapSize = maxHeapSize;
            this.mergedSize = mergedSize;
            this.mergedHeapSize = mergedHeapSize;
        }
    }

    public class MapFragment
    implements QuietCloseable {
        private final Map map;
        private final boolean owner;
        private final ObjList<Map> shards;
        private boolean sharded;

        private MapFragment(boolean owner) {
            this.map = MapFactory.createUnorderedMap(AsyncGroupByAtom.this.configuration, AsyncGroupByAtom.this.keyTypes, AsyncGroupByAtom.this.valueTypes);
            this.shards = new ObjList(AsyncGroupByAtom.this.shardCount);
            this.owner = owner;
        }

        @Override
        public void close() {
            this.sharded = false;
            this.map.close();
            int n = this.shards.size();
            for (int i = 0; i < n; ++i) {
                Map m = this.shards.getQuick(i);
                Misc.free(m);
            }
        }

        public Map getMap() {
            return this.map;
        }

        public Map getShardMap(long hashCode) {
            return this.shards.getQuick((int)(hashCode >>> AsyncGroupByAtom.this.shardCountShr));
        }

        public ObjList<Map> getShards() {
            return this.shards;
        }

        public boolean isNotSharded() {
            return !this.sharded;
        }

        public Map reopenMap() {
            if (!this.map.isOpen()) {
                int keyCapacity = AsyncGroupByAtom.this.targetKeyCapacity(AsyncGroupByAtom.this.lastOwnerStats, this.owner);
                long heapSize = AsyncGroupByAtom.this.targetHeapSize(AsyncGroupByAtom.this.lastOwnerStats, this.owner);
                this.map.reopen(keyCapacity, heapSize);
            }
            return this.map;
        }

        public void shard() {
            if (this.sharded) {
                return;
            }
            this.reopenShards();
            if (this.map.size() > 0L) {
                MapRecordCursor cursor = this.map.getCursor();
                MapRecord record = this.map.getRecord();
                while (cursor.hasNext()) {
                    long hashCode = record.keyHashCode();
                    Map shard = this.getShardMap(hashCode);
                    MapKey shardKey = shard.withKey();
                    record.copyToKey(shardKey);
                    MapValue shardValue = shardKey.createValue(hashCode);
                    record.copyValue(shardValue);
                }
            }
            this.map.close();
            this.sharded = true;
        }

        private void reopenShards() {
            int size = this.shards.size();
            if (size == 0) {
                for (int i = 0; i < AsyncGroupByAtom.this.shardCount; ++i) {
                    this.shards.add(MapFactory.createUnorderedMap(AsyncGroupByAtom.this.configuration, AsyncGroupByAtom.this.keyTypes, AsyncGroupByAtom.this.valueTypes));
                }
            } else {
                assert (size == AsyncGroupByAtom.this.shardCount);
                for (int i = 0; i < AsyncGroupByAtom.this.shardCount; ++i) {
                    MapStats stats = AsyncGroupByAtom.this.lastShardStats.getQuick(i);
                    int keyCapacity = AsyncGroupByAtom.this.targetKeyCapacity(stats, false);
                    long heapSize = AsyncGroupByAtom.this.targetHeapSize(stats, false);
                    this.shards.getQuick(i).reopen(keyCapacity, heapSize);
                }
            }
        }
    }
}

