/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.table.AbstractDeferredValueRecordCursorFactory;
import io.questdb.griffin.engine.table.AbstractLatestByValueRecordCursor;
import io.questdb.griffin.engine.table.LatestByValueIndexedFilteredRecordCursor;
import io.questdb.std.IntList;
import org.jetbrains.annotations.NotNull;

public class LatestByValueDeferredIndexedFilteredRecordCursorFactory
extends AbstractDeferredValueRecordCursorFactory {
    private final CairoConfiguration configuration;

    public LatestByValueDeferredIndexedFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, int columnIndex, Function symbolFunc, @NotNull Function filter, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts) {
        super(configuration, metadata, partitionFrameCursorFactory, columnIndex, symbolFunc, filter, columnIndexes, columnSizeShifts);
        this.configuration = configuration;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index backward scan").meta("on").putColumnName(this.columnIndex);
        super.toPlan(sink);
    }

    @Override
    public boolean usesIndex() {
        return true;
    }

    @Override
    protected AbstractLatestByValueRecordCursor createCursorFor(int symbolKey) {
        assert (this.filter != null);
        return new LatestByValueIndexedFilteredRecordCursor(this.configuration, this.getMetadata(), this.columnIndex, TableUtils.toIndexKey(symbolKey), this.filter);
    }
}

