/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.metrics.Counter;
import io.questdb.metrics.HealthMetrics;
import io.questdb.metrics.MetricsRegistry;
import io.questdb.std.Mutable;

public class HealthMetricsImpl
implements HealthMetrics,
Mutable {
    private final Counter queryErrorCounter;
    private final Counter readerLeakCounter;
    private final Counter unhandledErrorCounter;

    public HealthMetricsImpl(MetricsRegistry metricsRegistry) {
        this.unhandledErrorCounter = metricsRegistry.newCounter("unhandled_errors");
        this.readerLeakCounter = metricsRegistry.newCounter("reader_leak_counter");
        this.queryErrorCounter = metricsRegistry.newCounter("query_error_counter");
    }

    @Override
    public void clear() {
        this.unhandledErrorCounter.reset();
        this.readerLeakCounter.reset();
        this.queryErrorCounter.reset();
    }

    @Override
    public void incrementQueryErrorCounter() {
        this.queryErrorCounter.inc();
    }

    @Override
    public void incrementReaderLeakCounter(int count) {
        this.readerLeakCounter.add(count);
    }

    @Override
    public void incrementUnhandledErrors() {
        this.unhandledErrorCounter.inc();
    }

    @Override
    public long queryErrorCounter() {
        return this.queryErrorCounter.getValue();
    }

    @Override
    public long readerLeakCounter() {
        return this.readerLeakCounter.getValue();
    }

    @Override
    public long unhandledErrorsCount() {
        return this.unhandledErrorCounter.getValue();
    }
}

