/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Utf8Sink
extends CharSink<Utf8Sink> {
    default public Utf8Sink escapeCsvStr(@NotNull CharSequence cs, int lo, int hi) {
        int i = lo;
        block4: while (i < hi) {
            char c;
            if ((c = cs.charAt(i++)) < ' ') {
                this.escapeJsonStrChar(c);
                continue;
            }
            if (c < '\u0080') {
                switch (c) {
                    case '\"': {
                        this.putAscii("\"\"");
                        continue block4;
                    }
                    case '\\': {
                        this.putAscii("\\\\");
                        continue block4;
                    }
                }
                this.putAscii(c);
                continue;
            }
            i = Utf8s.encodeUtf16Char(this, cs, hi, i, c);
        }
        return this;
    }

    default public Utf8Sink escapeCsvStr(Utf8Sequence utf8) {
        int i = 0;
        int hi = utf8.size();
        block4: while (i < hi) {
            char c;
            if ((c = (char)utf8.byteAt(i++)) > '\u0000' && c < ' ') {
                this.escapeJsonStrChar(c);
                continue;
            }
            if (c > '\u0000' && c < '\u0080') {
                switch (c) {
                    case '\"': {
                        this.putAscii("\"\"");
                        continue block4;
                    }
                    case '\\': {
                        this.putAscii("\\\\");
                        continue block4;
                    }
                }
                this.putAscii(c);
                continue;
            }
            this.put((byte)c);
        }
        return this;
    }

    default public Utf8Sink escapeCsvStr(@NotNull CharSequence cs) {
        return this.escapeCsvStr(cs, 0, cs.length());
    }

    default public Utf8Sink escapeJsonStr(@NotNull CharSequence cs) {
        return this.escapeJsonStr(cs, 0, cs.length());
    }

    default public Utf8Sink escapeJsonStr(@NotNull CharSequence cs, int lo, int hi) {
        int i = lo;
        while (i < hi) {
            char c;
            if ((c = cs.charAt(i++)) < ' ') {
                this.escapeJsonStrChar(c);
                continue;
            }
            if (c < '\u0080') {
                switch (c) {
                    case '\"': 
                    case '\\': {
                        this.putAscii('\\');
                    }
                }
                this.putAscii(c);
                continue;
            }
            i = Utf8s.encodeUtf16Char(this, cs, hi, i, c);
        }
        return this;
    }

    default public Utf8Sink escapeJsonStr(Utf8Sequence utf8) {
        int i = 0;
        int hi = utf8.size();
        while (i < hi) {
            char c;
            if ((c = (char)utf8.byteAt(i++)) > '\u0000' && c < ' ') {
                this.escapeJsonStrChar(c);
                continue;
            }
            if (c > '\u0000' && c < '\u0080') {
                switch (c) {
                    case '\"': 
                    case '\\': {
                        this.putAscii('\\');
                    }
                }
                this.putAscii(c);
                continue;
            }
            this.put((byte)c);
        }
        return this;
    }

    @Override
    default public int getEncoding() {
        return 8;
    }

    public Utf8Sink put(byte var1);

    @Override
    default public Utf8Sink put(@Nullable CharSequence cs) {
        if (cs != null) {
            this.put(cs, 0, cs.length());
        }
        return this;
    }

    @Override
    default public Utf8Sink put(char c) {
        if (c < '\u0080') {
            this.putAscii(c);
        } else if (c < '\u0800') {
            this.put((byte)(0xC0 | c >> 6)).put((byte)(0x80 | c & 0x3F));
        } else if (Character.isSurrogate(c)) {
            this.putAscii('?');
        } else {
            this.put((byte)(0xE0 | c >> 12)).put((byte)(0x80 | c >> 6 & 0x3F)).put((byte)(0x80 | c & 0x3F));
        }
        return this;
    }

    default public Utf8Sink put(@Nullable DirectUtf8Sequence dus) {
        if (dus != null) {
            this.putNonAscii(dus.lo(), dus.hi());
        }
        return this;
    }

    default public Utf8Sink put(Utf8Sequence seq, int lo, int hi) {
        if (seq != null) {
            if (seq.isAscii()) {
                this.putAscii(seq.asAsciiCharSequence(), lo, hi);
            } else {
                for (int i = lo; i < hi; ++i) {
                    this.putAny(seq.byteAt(i));
                }
            }
        }
        return this;
    }

    @Override
    default public Utf8Sink put(@NotNull CharSequence cs, int lo, int hi) {
        int i = lo;
        while (i < hi) {
            char c;
            if ((c = cs.charAt(i++)) < '\u0080') {
                this.putAscii(c);
                continue;
            }
            i = Utf8s.encodeUtf16Char(this, cs, hi, i, c);
        }
        return this;
    }

    default public Utf8Sink putAny(byte b) {
        return this.put(b);
    }

    default public Utf8Sink putAny(@Nullable Utf8Sequence us) {
        if (us == null) {
            return this;
        }
        return this.putAny(us, 0, us.size());
    }

    default public Utf8Sink putAny(Utf8Sequence seq, int lo, int hi) {
        for (int i = lo; i < hi; ++i) {
            this.putAny(seq.byteAt(i));
        }
        return this;
    }

    @Override
    default public Utf8Sink putAscii(char c) {
        return this.put((byte)c);
    }

    @Override
    default public Utf8Sink putAscii(@Nullable CharSequence cs) {
        if (cs == null) {
            return this;
        }
        int l = cs.length();
        for (int i = 0; i < l; ++i) {
            this.putAscii(cs.charAt(i));
        }
        return this;
    }

    default public Utf8Sink putQuote() {
        this.putAscii('\"');
        return this;
    }

    @Override
    default public Utf8Sink putQuoted(@NotNull CharSequence cs) {
        this.putAscii('\"').put(cs).putAscii('\"');
        return this;
    }

    default public boolean putWithLimit(@NotNull CharSequence cs, int maxBytes) {
        return Utf8s.encodeUtf16WithLimit(this, cs, maxBytes);
    }
}

