/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import org.hibernate.MappingException;
import org.hibernate.SharedSessionContract;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EmbeddableDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.AbstractEmbeddableMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ExplicitColumnDiscriminatorMappingImpl;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.MutableAttributeMappingList;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.mapping.internal.SimpleAttributeMetadata;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultImpl;
import org.hibernate.type.AnyType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.spi.CompositeTypeImplementor;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddableMappingTypeImpl
extends AbstractEmbeddableMapping
implements SelectableMappings {
    private final JavaType<?> embeddableJtd;
    private final EmbeddableRepresentationStrategy representationStrategy;
    private final EmbeddableValuedModelPart valueMapping;
    private final EmbeddableDiscriminatorMapping discriminatorMapping;
    private final Map<String, ConcreteEmbeddableTypeImpl> concreteEmbeddableBySubclass;
    private final Map<Object, ConcreteEmbeddableTypeImpl> concreteEmbeddableByDiscriminator;
    private final boolean createEmptyCompositesEnabled;
    private final SelectableMapping aggregateMapping;
    private final boolean aggregateMappingRequiresColumnWriter;
    private final boolean preferSelectAggregateMapping;
    private final boolean preferBindAggregateMapping;

    public static EmbeddableMappingTypeImpl from(Component bootDescriptor, CompositeType compositeType, boolean[] insertability, boolean[] updateability, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, MappingModelCreationProcess creationProcess) {
        return EmbeddableMappingTypeImpl.from(bootDescriptor, compositeType, null, null, null, null, 0, insertability, updateability, embeddedPartBuilder, creationProcess);
    }

    public static EmbeddableMappingTypeImpl from(Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, Property componentProperty, DependantValue dependantValue, int dependantColumnIndex, boolean[] insertability, boolean[] updateability, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, MappingModelCreationProcess creationProcess) {
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        EmbeddableMappingTypeImpl mappingType = new EmbeddableMappingTypeImpl(bootDescriptor, componentProperty, embeddedPartBuilder, creationContext);
        if (compositeType instanceof CompositeTypeImplementor) {
            ((CompositeTypeImplementor)compositeType).injectMappingModelPart(mappingType.getEmbeddedValueMapping(), creationProcess);
        }
        creationProcess.registerInitializationCallback("EmbeddableMappingType(" + mappingType.getNavigableRole().getFullPath() + ")#finishInitialization", () -> mappingType.finishInitialization(bootDescriptor, compositeType, rootTableExpression, rootTableKeyColumnNames, dependantValue, dependantColumnIndex, insertability, updateability, creationProcess));
        return mappingType;
    }

    /*
     * WARNING - void declaration
     */
    private EmbeddableMappingTypeImpl(Component bootDescriptor, Property componentProperty, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, RuntimeModelCreationContext creationContext) {
        super(new MutableAttributeMappingList(5));
        this.representationStrategy = creationContext.getBootstrapContext().getRepresentationStrategySelector().resolveStrategy(bootDescriptor, () -> this, creationContext);
        this.embeddableJtd = this.representationStrategy.getMappedJavaType();
        this.valueMapping = embeddedPartBuilder.apply(this);
        this.discriminatorMapping = this.generateDiscriminatorMapping(bootDescriptor, creationContext);
        if (bootDescriptor.isPolymorphic()) {
            this.concreteEmbeddableByDiscriminator = new HashMap<Object, ConcreteEmbeddableTypeImpl>();
            this.concreteEmbeddableBySubclass = new HashMap<String, ConcreteEmbeddableTypeImpl>();
            int subclassId = 0;
            TreeSet entries = new TreeSet(Map.Entry.comparingByValue());
            entries.addAll(bootDescriptor.getDiscriminatorValues().entrySet());
            for (Map.Entry entry : entries) {
                ConcreteEmbeddableTypeImpl concreteEmbeddableType = new ConcreteEmbeddableTypeImpl(this.representationStrategy.getInstantiatorForDiscriminator(entry.getKey()), entry.getKey(), subclassId++);
                this.concreteEmbeddableByDiscriminator.put(entry.getKey(), concreteEmbeddableType);
                this.concreteEmbeddableBySubclass.put((String)entry.getValue(), concreteEmbeddableType);
            }
        } else {
            this.concreteEmbeddableByDiscriminator = null;
            this.concreteEmbeddableBySubclass = null;
        }
        this.createEmptyCompositesEnabled = ConfigurationHelper.getBoolean("hibernate.create_empty_composites.enabled", creationContext.getServiceRegistry().requireService(ConfigurationService.class).getSettings());
        AggregateColumn aggregateColumn = bootDescriptor.getAggregateColumn();
        if (aggregateColumn != null) {
            void var8_13;
            boolean insertable;
            Dialect dialect = creationContext.getDialect();
            if (componentProperty == null) {
                insertable = true;
                boolean bl = true;
            } else {
                insertable = componentProperty.isInsertable();
                boolean bl = componentProperty.isUpdateable();
            }
            this.aggregateMapping = SelectableMappingImpl.from(bootDescriptor.getOwner().getTable().getQualifiedName(creationContext.getSqlStringGenerationContext()), (Selectable)aggregateColumn, bootDescriptor.getParentAggregateColumn() != null ? bootDescriptor.getParentAggregateColumn().getSelectablePath() : null, this.resolveJdbcMapping(bootDescriptor, creationContext), creationContext.getTypeConfiguration(), insertable, (boolean)var8_13, false, dialect, null, creationContext);
            AggregateSupport aggregateSupport = dialect.getAggregateSupport();
            int sqlTypeCode = aggregateColumn.getSqlTypeCode();
            this.aggregateMappingRequiresColumnWriter = aggregateSupport.requiresAggregateCustomWriteExpressionRenderer(sqlTypeCode);
            this.preferSelectAggregateMapping = aggregateSupport.preferSelectAggregateMapping(sqlTypeCode);
            this.preferBindAggregateMapping = aggregateSupport.preferBindAggregateMapping(sqlTypeCode);
        } else {
            this.aggregateMapping = null;
            this.aggregateMappingRequiresColumnWriter = false;
            this.preferSelectAggregateMapping = false;
            this.preferBindAggregateMapping = false;
        }
    }

    private JdbcMapping resolveJdbcMapping(Component bootDescriptor, RuntimeModelCreationContext creationContext) {
        BasicType<?> resolvedJdbcMapping;
        TypeConfiguration typeConfiguration = creationContext.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        AggregateColumn aggregateColumn = bootDescriptor.getAggregateColumn();
        Integer aggregateSqlTypeCode = aggregateColumn.getSqlTypeCode();
        boolean isArray = false;
        String structTypeName = null;
        switch (aggregateSqlTypeCode) {
            case 2002: {
                structTypeName = aggregateColumn.getSqlType(creationContext.getMetadata());
                break;
            }
            case 3016: 
            case 3017: {
                String arrayTypeName;
                isArray = true;
                aggregateSqlTypeCode = 2002;
                structTypeName = bootDescriptor.getStructName().render();
                if (structTypeName != null || !(arrayTypeName = aggregateColumn.getSqlType(creationContext.getMetadata())).endsWith(" array")) break;
                structTypeName = arrayTypeName.substring(0, arrayTypeName.length() - " array".length());
                break;
            }
            case 3018: {
                isArray = true;
                aggregateSqlTypeCode = 3001;
                break;
            }
            case 3019: {
                isArray = true;
                aggregateSqlTypeCode = 2009;
            }
        }
        JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
        AggregateJdbcType aggregateJdbcType = jdbcTypeRegistry.resolveAggregateDescriptor(aggregateSqlTypeCode, structTypeName, this, creationContext);
        BasicType<?> basicType = basicTypeRegistry.resolve(this.getMappedJavaType(), aggregateJdbcType);
        if (bootDescriptor.getStructName() != null) {
            basicTypeRegistry.register(basicType, bootDescriptor.getStructName().render());
            basicTypeRegistry.register(basicType, this.getMappedJavaType().getJavaTypeClass().getName());
        }
        BasicValue basicValue = (BasicValue)aggregateColumn.getValue();
        if (isArray) {
            JdbcTypeConstructor arrayConstructor = jdbcTypeRegistry.getConstructor(2003);
            if (arrayConstructor == null) {
                throw new IllegalArgumentException("No JdbcTypeConstructor registered for SqlTypes.ARRAY");
            }
            BasicType<?> arrayType = ((BasicPluralJavaType)((Object)basicValue.getResolution().getDomainJavaType())).resolveType(typeConfiguration, creationContext.getDialect(), basicType, aggregateColumn, typeConfiguration.getCurrentBaseSqlTypeIndicators());
            basicTypeRegistry.register(arrayType);
            resolvedJdbcMapping = arrayType;
        } else {
            resolvedJdbcMapping = basicType;
        }
        basicValue.getResolution().updateResolution(resolvedJdbcMapping);
        return resolvedJdbcMapping;
    }

    public EmbeddableMappingTypeImpl(EmbeddedAttributeMapping valueMapping, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, EmbeddableMappingType inverseMappingType, MappingModelCreationProcess creationProcess) {
        super(new MutableAttributeMappingList(5));
        this.embeddableJtd = inverseMappingType.getJavaType();
        this.representationStrategy = inverseMappingType.getRepresentationStrategy();
        this.valueMapping = valueMapping;
        this.discriminatorMapping = null;
        this.concreteEmbeddableBySubclass = null;
        this.concreteEmbeddableByDiscriminator = null;
        this.createEmptyCompositesEnabled = inverseMappingType.isCreateEmptyCompositesEnabled();
        this.aggregateMapping = null;
        this.aggregateMappingRequiresColumnWriter = false;
        this.preferSelectAggregateMapping = false;
        this.preferBindAggregateMapping = false;
        this.selectableMappings = selectableMappings;
        creationProcess.registerInitializationCallback("EmbeddableMappingType(" + inverseMappingType.getNavigableRole().getFullPath() + ".{inverse})#finishInitialization", () -> this.inverseInitializeCallback(declaringTableGroupProducer, selectableMappings, inverseMappingType, creationProcess, this, this.attributeMappings));
    }

    @Override
    public EmbeddableMappingType createInverseMappingType(EmbeddedAttributeMapping valueMapping, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, MappingModelCreationProcess creationProcess) {
        return new EmbeddableMappingTypeImpl(valueMapping, declaringTableGroupProducer, selectableMappings, this, creationProcess);
    }

    private boolean finishInitialization(Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, DependantValue dependantValue, int dependantColumnIndex, boolean[] insertability, boolean[] updateability, MappingModelCreationProcess creationProcess) {
        TypeConfiguration typeConfiguration = creationProcess.getCreationContext().getTypeConfiguration();
        JdbcServices jdbcServices = creationProcess.getCreationContext().getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        String baseTableExpression = this.valueMapping.getContainingTableExpression();
        Type[] subtypes = compositeType.getSubtypes();
        int attributeIndex = 0;
        int columnPosition = 0;
        this.attributeMappings.clear();
        for (Property bootPropertyDescriptor : bootDescriptor.getProperties()) {
            AttributeMapping attributeMapping;
            Type subtype = subtypes[attributeIndex];
            Value value = bootPropertyDescriptor.getValue();
            if (subtype instanceof BasicType) {
                SelectablePath selectablePath;
                boolean nullable;
                boolean isLob;
                Integer temporalPrecision;
                Integer scale;
                Integer precision;
                Long length;
                String columnDefinition;
                String containingTableExpression;
                String columnExpression;
                Selectable selectable;
                BasicValue basicValue = (BasicValue)value;
                Selectable selectable2 = selectable = dependantValue != null ? (Selectable)dependantValue.getColumns().get(dependantColumnIndex + columnPosition) : basicValue.getColumn();
                if (rootTableKeyColumnNames == null) {
                    columnExpression = selectable.isFormula() ? selectable.getTemplate(dialect, creationProcess.getCreationContext().getTypeConfiguration(), creationProcess.getSqmFunctionRegistry()) : selectable.getText(dialect);
                    if (selectable instanceof Column) {
                        Column column = (Column)selectable;
                        containingTableExpression = MappingModelCreationHelper.getTableIdentifierExpression(column.getValue().getTable(), creationProcess);
                    } else {
                        containingTableExpression = baseTableExpression;
                    }
                } else {
                    containingTableExpression = rootTableExpression;
                    columnExpression = rootTableKeyColumnNames[columnPosition];
                }
                NavigableRole role = this.valueMapping.getNavigableRole().append(bootPropertyDescriptor.getName());
                if (selectable instanceof Column) {
                    Column column = (Column)selectable;
                    columnDefinition = column.getSqlType();
                    length = column.getLength();
                    precision = column.getPrecision();
                    scale = column.getScale();
                    temporalPrecision = column.getTemporalPrecision();
                    isLob = column.isSqlTypeLob(creationProcess.getCreationContext().getMetadata());
                    nullable = bootPropertyDescriptor.isOptional() && column.isNullable();
                    selectablePath = basicValue.createSelectablePath(column.getQuotedName(dialect));
                    MappingModelCreationHelper.resolveAggregateColumnBasicType(creationProcess, role, column);
                } else {
                    columnDefinition = null;
                    length = null;
                    precision = null;
                    scale = null;
                    temporalPrecision = null;
                    isLob = false;
                    nullable = bootPropertyDescriptor.isOptional();
                    selectablePath = new SelectablePath(this.determineEmbeddablePrefix() + bootPropertyDescriptor.getName());
                }
                attributeMapping = MappingModelCreationHelper.buildBasicAttributeMapping(bootPropertyDescriptor.getName(), role, attributeIndex, attributeIndex, bootPropertyDescriptor, this, basicValue.getResolution().getLegacyResolvedBasicType(), containingTableExpression, columnExpression, selectablePath, selectable.isFormula(), selectable.getCustomReadExpression(), selectable.getWriteExpr(basicValue.getResolution().getJdbcMapping(), dialect), columnDefinition, length, precision, scale, temporalPrecision, isLob, nullable, insertability[columnPosition], updateability[columnPosition], this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                ++columnPosition;
            } else if (subtype instanceof AnyType) {
                Any bootValueMapping = (Any)value;
                AnyType anyType = (AnyType)subtype;
                PropertyAccess propertyAccess = this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor);
                boolean nullable = bootValueMapping.isNullable();
                boolean insertable = insertability[columnPosition];
                boolean updateable = updateability[columnPosition];
                boolean includeInOptimisticLocking = bootPropertyDescriptor.isOptimisticLocked();
                CascadeStyle cascadeStyle = compositeType.getCascadeStyle(attributeIndex);
                SimpleAttributeMetadata attributeMetadataAccess = new SimpleAttributeMetadata(propertyAccess, EmbeddableMappingTypeImpl.getMutabilityPlan(updateable), nullable, insertable, updateable, includeInOptimisticLocking, true, cascadeStyle);
                attributeMapping = new DiscriminatedAssociationAttributeMapping(this.valueMapping.getNavigableRole().append(bootPropertyDescriptor.getName()), typeConfiguration.getJavaTypeRegistry().getDescriptor((java.lang.reflect.Type)((Object)Object.class)), this, attributeIndex, attributeIndex, attributeMetadataAccess, bootPropertyDescriptor.isLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE, propertyAccess, bootPropertyDescriptor, anyType, bootValueMapping, creationProcess);
            } else if (subtype instanceof CompositeType) {
                String[] subRootTableKeyColumnNames;
                String subTableExpression;
                CompositeType subCompositeType = (CompositeType)subtype;
                int columnSpan = subCompositeType.getColumnSpan(creationProcess.getCreationContext().getMetadata());
                if (rootTableKeyColumnNames == null) {
                    subTableExpression = baseTableExpression;
                    subRootTableKeyColumnNames = null;
                } else {
                    subTableExpression = rootTableExpression;
                    subRootTableKeyColumnNames = new String[columnSpan];
                    System.arraycopy(rootTableKeyColumnNames, columnPosition, subRootTableKeyColumnNames, 0, columnSpan);
                }
                attributeMapping = MappingModelCreationHelper.buildEmbeddedAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, attributeIndex, bootPropertyDescriptor, dependantValue, dependantColumnIndex + columnPosition, this, subCompositeType, subTableExpression, subRootTableKeyColumnNames, this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                columnPosition += columnSpan;
            } else if (subtype instanceof CollectionType) {
                attributeMapping = MappingModelCreationHelper.buildPluralAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, attributeIndex, bootPropertyDescriptor, this, this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), compositeType.getFetchMode(attributeIndex), creationProcess);
            } else if (subtype instanceof EntityType) {
                EntityPersister entityPersister = creationProcess.getEntityPersister(bootDescriptor.getOwner().getEntityName());
                attributeMapping = MappingModelCreationHelper.buildSingularAssociationAttributeMapping(bootPropertyDescriptor.getName(), this.valueMapping.getNavigableRole().append(bootPropertyDescriptor.getName()), attributeIndex, attributeIndex, bootPropertyDescriptor, this, entityPersister, (EntityType)subtype, this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                columnPosition += bootPropertyDescriptor.getColumnSpan();
            } else {
                throw new MappingException(String.format(Locale.ROOT, "Unable to determine attribute nature : %s#%s", bootDescriptor.getOwner().getEntityName(), bootPropertyDescriptor.getName()));
            }
            if (this.isPolymorphic()) {
                String declaringClass = bootDescriptor.getPropertyDeclaringClass(bootPropertyDescriptor);
                for (Map.Entry<String, ConcreteEmbeddableTypeImpl> entry : this.concreteEmbeddableBySubclass.entrySet()) {
                    if (!this.isDefinedInClassOrSuperclass(bootDescriptor, declaringClass, entry.getKey())) continue;
                    entry.getValue().declaredAttributes.set(attributeMapping.getStateArrayPosition());
                }
            }
            this.addAttribute(attributeMapping);
            ++attributeIndex;
        }
        creationProcess.registerInitializationCallback("EmbeddableMappingType(" + this.valueMapping.getNavigableRole().getFullPath() + ")#initColumnMappings", this::initColumnMappings);
        return true;
    }

    private boolean isDefinedInClassOrSuperclass(Component bootDescriptor, String declaringClass, String subclass) {
        while (subclass != null) {
            if (declaringClass.equals(subclass)) {
                return true;
            }
            subclass = bootDescriptor.getSuperclass(subclass);
        }
        return false;
    }

    private static MutabilityPlan<?> getMutabilityPlan(boolean updateable) {
        if (updateable) {
            return new MutabilityPlan<Object>(){

                @Override
                public boolean isMutable() {
                    return true;
                }

                @Override
                public Object deepCopy(Object value) {
                    return value;
                }

                @Override
                public Serializable disassemble(Object value, SharedSessionContract session) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Object assemble(Serializable cached, SharedSessionContract session) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return ImmutableMutabilityPlan.INSTANCE;
    }

    private EmbeddableDiscriminatorMapping generateDiscriminatorMapping(Component bootDescriptor, RuntimeModelCreationContext creationContext) {
        Integer scale;
        Integer precision;
        Long length;
        String columnDefinition;
        String discriminatorColumnExpression;
        String name;
        Value discriminator = bootDescriptor.getDiscriminator();
        if (discriminator == null) {
            return null;
        }
        Selectable selectable = discriminator.getSelectables().get(0);
        boolean isFormula = discriminator.hasFormula();
        if (isFormula) {
            Formula formula = (Formula)selectable;
            discriminatorColumnExpression = name = formula.getTemplate(creationContext.getDialect(), creationContext.getTypeConfiguration(), creationContext.getFunctionRegistry());
            columnDefinition = null;
            length = null;
            precision = null;
            scale = null;
        } else {
            Column column = discriminator.getColumns().get(0);
            assert (column != null) : "Embeddable discriminators require a column";
            discriminatorColumnExpression = column.getReadExpr(creationContext.getDialect());
            columnDefinition = column.getSqlType();
            name = column.getName();
            length = column.getLength();
            precision = column.getPrecision();
            scale = column.getScale();
        }
        return new ExplicitColumnDiscriminatorMappingImpl(this, name, bootDescriptor.getTable().getName(), discriminatorColumnExpression, isFormula, !isFormula, !isFormula, columnDefinition, selectable.getCustomReadExpression(), length, precision, scale, bootDescriptor.getDiscriminatorType());
    }

    @Override
    public EmbeddableValuedModelPart getEmbeddedValueMapping() {
        return this.valueMapping;
    }

    @Override
    public EmbeddableDiscriminatorMapping getDiscriminatorMapping() {
        return this.discriminatorMapping;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.embeddableJtd;
    }

    @Override
    public EmbeddableRepresentationStrategy getRepresentationStrategy() {
        return this.representationStrategy;
    }

    @Override
    public String getPartName() {
        return this.getEmbeddedValueMapping().getPartName();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.valueMapping.getNavigableRole();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableResultImpl(navigablePath, this.valueMapping, resultVariable, creationState);
    }

    @Override
    public EmbeddableMappingType.ConcreteEmbeddableType findSubtypeByDiscriminator(Object discriminatorValue) {
        return this.concreteEmbeddableByDiscriminator == null ? this : (EmbeddableMappingType.ConcreteEmbeddableType)this.concreteEmbeddableByDiscriminator.get(discriminatorValue);
    }

    @Override
    public EmbeddableMappingType.ConcreteEmbeddableType findSubtypeBySubclass(String subclassName) {
        return this.concreteEmbeddableBySubclass == null ? this : (EmbeddableMappingType.ConcreteEmbeddableType)this.concreteEmbeddableBySubclass.get(subclassName);
    }

    @Override
    public Collection<EmbeddableMappingType.ConcreteEmbeddableType> getConcreteEmbeddableTypes() {
        return this.concreteEmbeddableBySubclass == null ? Collections.singleton(this) : this.concreteEmbeddableBySubclass.values();
    }

    @Override
    protected Object[] getAttributeValues(Object compositeInstance) {
        if (!this.isPolymorphic()) {
            return super.getAttributeValues(compositeInstance);
        }
        int numberOfAttributes = this.getNumberOfAttributeMappings();
        Object[] results = new Object[numberOfAttributes + 1];
        EmbeddableMappingType.ConcreteEmbeddableType concreteEmbeddableType = this.findSubtypeBySubclass(compositeInstance.getClass().getName());
        for (int i = 0; i < numberOfAttributes; ++i) {
            results[i] = concreteEmbeddableType.declaresAttribute(i) ? this.getValue(compositeInstance, i) : null;
        }
        results[i] = compositeInstance.getClass().getName();
        return results;
    }

    @Override
    protected void setAttributeValues(Object component, Object[] values) {
        if (!this.isPolymorphic()) {
            super.setAttributeValues(component, values);
        } else {
            String compositeClassName = component.getClass().getName();
            EmbeddableMappingType.ConcreteEmbeddableType concreteEmbeddableType = this.findSubtypeBySubclass(compositeClassName);
            for (int i = 0; i < this.getNumberOfAttributeMappings(); ++i) {
                AttributeMapping attributeMapping = this.getAttributeMapping(i);
                if (concreteEmbeddableType.declaresAttribute(attributeMapping)) {
                    this.setValue(component, i, values[i]);
                    continue;
                }
                if (values[i] == null) continue;
                throw new IllegalArgumentException(String.format("Unexpected non-null value for embeddable subtype '%s'", compositeClassName));
            }
        }
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        if (EntityDiscriminatorMapping.matchesRoleName(name)) {
            return this.discriminatorMapping;
        }
        return super.findSubPart(name, treatTargetType);
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        int size = this.attributeMappings.size();
        int span = 0;
        if (domainValue instanceof Object[]) {
            int i;
            Object[] values = (Object[])domainValue;
            assert (values.length == size + (this.isPolymorphic() ? 1 : 0));
            for (i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                if (attributeMapping.isPluralAttributeMapping()) continue;
                Object attributeValue = values[i];
                span += attributeMapping.breakDownJdbcValues(attributeValue, offset + span, x, y, valueConsumer, session);
            }
            if (this.isPolymorphic()) {
                span += this.discriminatorMapping.breakDownJdbcValues(values[i], offset + span, x, y, valueConsumer, session);
            }
        } else {
            EmbeddableMappingType.ConcreteEmbeddableType concreteEmbeddableType = domainValue == null ? null : this.findSubtypeBySubclass(domainValue.getClass().getName());
            for (int i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                if (attributeMapping.isPluralAttributeMapping()) continue;
                Object attributeValue = concreteEmbeddableType == null || !concreteEmbeddableType.declaresAttribute(attributeMapping) ? null : this.getValue(domainValue, i);
                span += attributeMapping.breakDownJdbcValues(attributeValue, offset + span, x, y, valueConsumer, session);
            }
            if (this.isPolymorphic()) {
                Object d = concreteEmbeddableType == null ? null : concreteEmbeddableType.getDiscriminatorValue();
                span += this.discriminatorMapping.breakDownJdbcValues(d, offset + span, x, y, valueConsumer, session);
            }
        }
        return span;
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        if (value == null) {
            for (int i = 0; i < this.attributeMappings.size(); ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                if (attributeMapping instanceof PluralAttributeMapping) continue;
                span += attributeMapping.forEachJdbcValue(null, span + offset, x, y, valuesConsumer, session);
            }
            if (this.isPolymorphic()) {
                span += this.discriminatorMapping.forEachJdbcValue(null, offset + span, x, y, valuesConsumer, session);
            }
        } else {
            EmbeddableMappingType.ConcreteEmbeddableType concreteEmbeddableType = this.findSubtypeBySubclass(value.getClass().getName());
            for (int i = 0; i < this.attributeMappings.size(); ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                if (attributeMapping instanceof PluralAttributeMapping) continue;
                Object attributeValue = concreteEmbeddableType == null || !concreteEmbeddableType.declaresAttribute(attributeMapping) ? null : this.getValue(value, i);
                span += attributeMapping.forEachJdbcValue(attributeValue, span + offset, x, y, valuesConsumer, session);
            }
            if (this.isPolymorphic()) {
                Object d = concreteEmbeddableType == null ? null : concreteEmbeddableType.getDiscriminatorValue();
                span += this.discriminatorMapping.forEachJdbcValue(d, offset + span, x, y, valuesConsumer, session);
            }
        }
        return span;
    }

    @Override
    public <X, Y> int decompose(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        if (this.shouldBindAggregateMapping()) {
            valueConsumer.consume(offset, x, y, domainValue, this.aggregateMapping);
            return 1;
        }
        int size = this.attributeMappings.size();
        int span = 0;
        if (domainValue instanceof Object[]) {
            int i;
            Object[] values = (Object[])domainValue;
            assert (values.length == size + (this.isPolymorphic() ? 1 : 0));
            for (i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                Object attributeValue = values[i];
                span += attributeMapping.decompose(attributeValue, offset + span, x, y, valueConsumer, session);
            }
            if (this.isPolymorphic()) {
                span += this.discriminatorMapping.decompose(values[i], offset + span, x, y, valueConsumer, session);
            }
        } else {
            EmbeddableMappingType.ConcreteEmbeddableType concreteEmbeddableType = domainValue == null ? null : this.findSubtypeBySubclass(domainValue.getClass().getName());
            for (int i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                if (attributeMapping.isPluralAttributeMapping()) continue;
                Object attributeValue = concreteEmbeddableType == null || !concreteEmbeddableType.declaresAttribute(attributeMapping) ? null : attributeMapping.getPropertyAccess().getGetter().get(domainValue);
                span += attributeMapping.decompose(attributeValue, offset + span, x, y, valueConsumer, session);
            }
            if (this.isPolymorphic()) {
                Object d = concreteEmbeddableType == null ? null : concreteEmbeddableType.getDiscriminatorValue();
                span += this.discriminatorMapping.decompose(d, offset + span, x, y, valueConsumer, session);
            }
        }
        return span;
    }

    @Override
    public void forEachInsertable(int offset, SelectableConsumer consumer) {
        if (this.shouldMutateAggregateMapping()) {
            if (this.aggregateMapping.isInsertable()) {
                consumer.accept(offset, this.aggregateMapping);
            }
        } else {
            int jdbcTypeCount = this.selectableMappings.getJdbcTypeCount();
            for (int i = 0; i < jdbcTypeCount; ++i) {
                SelectableMapping selectable = this.selectableMappings.getSelectable(i);
                if (!selectable.isInsertable()) continue;
                consumer.accept(offset + i, selectable);
            }
        }
    }

    @Override
    public void forEachUpdatable(int offset, SelectableConsumer consumer) {
        if (this.shouldMutateAggregateMapping()) {
            if (this.aggregateMapping.isUpdateable()) {
                consumer.accept(offset, this.aggregateMapping);
            }
        } else {
            int jdbcTypeCount = this.selectableMappings.getJdbcTypeCount();
            for (int i = 0; i < jdbcTypeCount; ++i) {
                SelectableMapping selectable = this.selectableMappings.getSelectable(i);
                if (!selectable.isUpdateable()) continue;
                consumer.accept(offset + i, selectable);
            }
        }
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.valueMapping.findContainingEntityMapping();
    }

    @Override
    public boolean isCreateEmptyCompositesEnabled() {
        return this.createEmptyCompositesEnabled;
    }

    @Override
    public SelectableMapping getAggregateMapping() {
        return this.aggregateMapping;
    }

    @Override
    public boolean requiresAggregateColumnWriter() {
        return this.aggregateMappingRequiresColumnWriter;
    }

    @Override
    public boolean shouldSelectAggregateMapping() {
        return this.preferSelectAggregateMapping;
    }

    @Override
    public boolean shouldBindAggregateMapping() {
        return this.preferBindAggregateMapping;
    }

    private static final class ConcreteEmbeddableTypeImpl
    implements EmbeddableMappingType.ConcreteEmbeddableType {
        private final EmbeddableInstantiator instantiator;
        private final Object discriminatorValue;
        private final int subclassId;
        private final BitSet declaredAttributes;

        public ConcreteEmbeddableTypeImpl(EmbeddableInstantiator instantiator, Object discriminatorValue, int subclassId) {
            this.instantiator = instantiator;
            this.discriminatorValue = discriminatorValue;
            this.subclassId = subclassId;
            this.declaredAttributes = new BitSet();
        }

        @Override
        public EmbeddableInstantiator getInstantiator() {
            return this.instantiator;
        }

        @Override
        public Object getDiscriminatorValue() {
            return this.discriminatorValue;
        }

        @Override
        public int getSubclassId() {
            return this.subclassId;
        }

        @Override
        public boolean declaresAttribute(AttributeMapping attributeMapping) {
            return this.declaredAttributes.get(attributeMapping.getStateArrayPosition());
        }

        @Override
        public boolean declaresAttribute(int attributeIndex) {
            return this.declaredAttributes.get(attributeIndex);
        }
    }
}

