/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.constants.HertzBeatKeywordsEnum;

public class HertzBeatKeywordsUtil {
    private static final Map<String, HertzBeatKeywordsEnum> KEYWORDS = Arrays.stream(HertzBeatKeywordsEnum.values()).collect(Collectors.toMap(HertzBeatKeywordsEnum::getKeyword, e -> e));

    public static void verifyKeywords(String field) {
        HertzBeatKeywordsEnum keyword = KEYWORDS.get(field);
        if (null == keyword) {
            return;
        }
        throw new IllegalArgumentException(String.format("Field matches keyword `%s`, please set alias `%s`.", keyword.getKeyword(), keyword.getAlias()));
    }
}

