/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import org.reactivestreams.Subscription;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.CoreSubscriber;

final class TraceWebClientSubscriber
implements CoreSubscriber<ClientResponse> {
    private final Instrumenter<ClientRequest, ClientResponse> instrumenter;
    private final ClientRequest request;
    private final CoreSubscriber<? super ClientResponse> actual;
    private final reactor.util.context.Context reactorContext;
    private final Context otelClientContext;
    private final Context otelParentContext;

    TraceWebClientSubscriber(Instrumenter<ClientRequest, ClientResponse> instrumenter, ClientRequest request, CoreSubscriber<? super ClientResponse> actual, Context otelClientContext, Context otelParentContext) {
        this.instrumenter = instrumenter;
        this.request = request;
        this.actual = actual;
        this.reactorContext = actual.currentContext();
        this.otelClientContext = otelClientContext;
        this.otelParentContext = otelParentContext;
    }

    public void onSubscribe(Subscription subscription) {
        this.actual.onSubscribe(subscription);
    }

    public void onNext(ClientResponse response) {
        this.instrumenter.end(this.otelClientContext, (Object)this.request, (Object)response, null);
        try (Scope ignored = this.otelParentContext.makeCurrent();){
            this.actual.onNext((Object)response);
        }
    }

    public void onError(Throwable t) {
        this.instrumenter.end(this.otelClientContext, (Object)this.request, null, t);
        try (Scope ignored = this.otelParentContext.makeCurrent();){
            this.actual.onError(t);
        }
    }

    public void onComplete() {
        try (Scope ignored = this.otelParentContext.makeCurrent();){
            this.actual.onComplete();
        }
    }

    public reactor.util.context.Context currentContext() {
        return this.reactorContext;
    }
}

