/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rw;

import dm.jdbc.desc.DmProperties;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.enums.RWSite;
import dm.jdbc.rw.RWCounter$EPCounter;
import dm.jdbc.util.MathUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

public class RWCounter {
    private static Boolean rwMapMutex = new Boolean(true);
    private static HashMap rwMap = new HashMap();
    private int standbyCount;
    private int primaryIncrement;
    private int standbyIncrement;
    private double primaryPercent = 0.0;
    private double standbyPercent = 0.0;
    private RWCounter$EPCounter primaryCounter;
    private RWCounter$EPCounter standbysCounter;
    private HashMap standbyMap;
    private Random standbyChooser = new Random();

    private RWCounter(int n2, int n3) {
        this.reset(n2, n3);
    }

    private synchronized void reset(int n2, int n3) {
        this.standbyCount = n3;
        int[] nArray = new int[n3 + 1];
        nArray[0] = n2 * n3;
        Arrays.fill(nArray, 1, nArray.length, 100 - n2);
        nArray = MathUtil.divis(nArray);
        this.primaryIncrement = nArray[0];
        int n4 = this.standbyIncrement = n3 > 0 ? nArray[1] : 0;
        if (n3 > 0) {
            this.primaryPercent = (double)n2 / 100.0;
            this.standbyPercent = (double)(100 - n2) / 100.0 / (double)n3;
        } else {
            this.primaryPercent = 1.0;
            this.standbyPercent = 0.0;
        }
        this.primaryCounter = new RWCounter$EPCounter(this);
        this.primaryCounter.balance = this.primaryIncrement;
        this.standbysCounter = new RWCounter$EPCounter(this);
        this.standbysCounter.balance = this.standbyIncrement * n3;
        this.standbyMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RWCounter getInstance(DmdbConnection dmdbConnection, int n2) {
        String string = String.valueOf(dmdbConnection.host) + "_" + dmdbConnection.port + "_" + dmdbConnection.rwPercent;
        RWCounter rWCounter = null;
        Boolean bl = rwMapMutex;
        synchronized (bl) {
            rWCounter = (RWCounter)rwMap.get(string);
            if (rWCounter == null) {
                rWCounter = new RWCounter(dmdbConnection.rwPercent, n2);
                rwMap.put(string, rWCounter);
            } else if (n2 != rWCounter.standbyCount) {
                rWCounter.reset(dmdbConnection.rwPercent, n2);
            }
        }
        return rWCounter;
    }

    public synchronized RWSite countPrimary() {
        this.adjustNtrx();
        this.primaryCounter.incrementNtrx();
        return RWSite.PRIMARY;
    }

    public synchronized RWSite count(RWSite rWSite, DmdbConnection dmdbConnection) {
        this.adjustNtrx();
        switch (rWSite) {
            case ANY: {
                if (this.primaryPercent == 1.0 || this.primaryCounter.balance > this.getStandbyCounter((DmdbConnection)dmdbConnection).balance && this.primaryCounter.balance > this.standbysCounter.balance) {
                    this.primaryCounter.incrementNtrx();
                    rWSite = RWSite.PRIMARY;
                    break;
                }
                this.getStandbyCounter(dmdbConnection).incrementNtrx();
                this.standbysCounter.incrementNtrx();
                rWSite = RWSite.STANDBY;
                break;
            }
            case STANDBY: {
                this.getStandbyCounter(dmdbConnection).incrementNtrx();
                this.standbysCounter.incrementNtrx();
                break;
            }
            case PRIMARY: {
                this.primaryCounter.incrementNtrx();
                break;
            }
            default: {
                DBError.throwRuntimeException("Invalid RWSite!");
            }
        }
        return rWSite;
    }

    private synchronized void adjustNtrx() {
        if (this.primaryCounter.ntrx + this.standbysCounter.ntrx >= Long.MAX_VALUE) {
            long l2 = 0L;
            for (RWCounter$EPCounter rWCounter$EPCounter : this.standbyMap.values()) {
                if (rWCounter$EPCounter.ntrx >= l2 && l2 != 0L) continue;
                l2 = rWCounter$EPCounter.ntrx;
            }
            l2 = l2 < this.primaryCounter.ntrx ? l2 : this.primaryCounter.ntrx;
            this.primaryCounter.ntrx /= l2;
            long l3 = 0L;
            for (RWCounter$EPCounter rWCounter$EPCounter : this.standbyMap.values()) {
                rWCounter$EPCounter.ntrx /= l2;
                l3 += rWCounter$EPCounter.ntrx;
            }
            this.standbysCounter.ntrx = l3;
        }
        if (this.primaryCounter.balance <= 0 && this.standbysCounter.balance <= 0) {
            this.primaryCounter.balance += this.primaryIncrement;
            for (RWCounter$EPCounter rWCounter$EPCounter : this.standbyMap.values()) {
                rWCounter$EPCounter.balance += this.standbyIncrement;
            }
        }
    }

    private synchronized RWCounter$EPCounter getStandbyCounter(DmdbConnection dmdbConnection) {
        String string = String.valueOf(dmdbConnection.host) + ":" + dmdbConnection.port;
        RWCounter$EPCounter rWCounter$EPCounter = (RWCounter$EPCounter)this.standbyMap.get(string);
        if (rWCounter$EPCounter == null) {
            rWCounter$EPCounter = new RWCounter$EPCounter(this);
            rWCounter$EPCounter.balance = this.standbyIncrement;
            rWCounter$EPCounter.id = string;
            this.standbyMap.put(string, rWCounter$EPCounter);
        }
        return rWCounter$EPCounter;
    }

    public int chooseStandbyIndex(int n2) {
        return this.standbyChooser.nextInt(n2 > this.standbyCount ? this.standbyCount : n2);
    }

    public String toString() {
        return "PERCENT(P/S) : " + this.primaryPercent + "/" + this.standbyPercent + "\nNTRX_PRIMARY : " + this.primaryCounter.ntrx + "\nNTRX_STANDBY : " + this.standbysCounter.ntrx;
    }

    public static void main(String[] stringArray) {
        RWCounter rWCounter = new RWCounter(20, 2);
        DmdbConnection dmdbConnection = new DmdbConnection(new DmProperties());
        dmdbConnection.host = "localhost";
        dmdbConnection.port = 7237;
        DmdbConnection dmdbConnection2 = new DmdbConnection(new DmProperties());
        dmdbConnection.host = "localhost";
        dmdbConnection.port = 7238;
        RWSite rWSite = RWSite.ANY;
        Random random = new Random();
        while (true) {
            rWSite = rWCounter.count(RWSite.ANY, random.nextInt(2) == 1 ? dmdbConnection : dmdbConnection2);
            if ((rWCounter.primaryCounter.ntrx + rWCounter.standbysCounter.ntrx) % 1000L == 0L) {
                System.out.println("trx count p: " + rWCounter.primaryCounter.ntrx + ", s: " + rWCounter.standbysCounter.ntrx + ", dest: " + (Object)((Object)rWSite));
                Thread.sleep(1000L);
            }
            if ((rWCounter.primaryCounter.ntrx + rWCounter.standbysCounter.ntrx) % 5000L != 0L) continue;
            rWCounter.reset(20, random.nextInt(5));
        }
    }
}

