/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseDataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public enum ClickHouseAggregateFunction {
    aggThrow(false, 0, true, 0, ClickHouseDataType.Nothing, new String[0]),
    any(false, 1, true, 1, null, new String[0]),
    anyHeavy(false, 1, false, 1, null, new String[0]),
    anyLast(false, 1, true, 1, null, new String[0]),
    argMax(false, 2, false, 1, null, new String[0]),
    argMin(false, 2, false, 1, null, new String[0]),
    avg(true, 1, false, 1, null, new String[0]),
    avgWeighted(false, 2, false, 1, null, new String[0]),
    boundingRatio(false, 2, false, 0, ClickHouseDataType.Float64, new String[0]),
    categoricalInformationValue(false, Integer.MAX_VALUE, false, 0, ClickHouseDataType.Float64, new String[0]),
    corr(true, 2, false, 0, ClickHouseDataType.Float64, new String[0]),
    corrStable(false, 2, false, 0, ClickHouseDataType.Float64, new String[0]),
    count(true, 1, true, 0, ClickHouseDataType.UInt64, new String[0]),
    covarPop(false, 2, false, 0, ClickHouseDataType.Float64, "COVAR_POP"),
    covarPopStable(false, 2, false, 0, ClickHouseDataType.Float64, new String[0]),
    covarSamp(false, 2, false, 0, ClickHouseDataType.Float64, "COVAR_SAMP"),
    covarSampStable(false, 2, false, 0, ClickHouseDataType.Float64, new String[0]),
    deltaSum(false, 1, false, 1, null, new String[0]),
    deltaSumTimestamp(false, 2, false, 1, null, new String[0]),
    dense_rank(true, new String[0]),
    entropy(false, 1, false, 0, ClickHouseDataType.Float64, new String[0]),
    exponentialMovingAverage(false, 3, false, 0, ClickHouseDataType.Float64, new String[0]),
    exponentialTimeDecayedAvg(false, new String[0]),
    exponentialTimeDecayedCount(false, new String[0]),
    exponentialTimeDecayedMax(false, new String[0]),
    exponentialTimeDecayedSum(false, new String[0]),
    first_value(true, 1, true, 1, null, new String[0]),
    groupArray(false, 2, false, 1, null, new String[0]),
    groupArrayInsertAt(false, new String[0]),
    groupArrayMovingAvg(false, new String[0]),
    groupArrayMovingSum(false, new String[0]),
    groupArraySample(false, new String[0]),
    groupBitAnd(false, "BIT_AND"),
    groupBitOr(false, "BIT_OR"),
    groupBitXor(false, "BIT_XOR"),
    groupBitmap(false, new String[0]),
    groupBitmapAnd(false, new String[0]),
    groupBitmapOr(false, new String[0]),
    groupBitmapXor(false, new String[0]),
    groupUniqArray(false, new String[0]),
    histogram(false, new String[0]),
    intervalLengthSum(false, new String[0]),
    kurtPop(false, new String[0]),
    kurtSamp(false, new String[0]),
    lagInFrame(false, new String[0]),
    last_value(true, 1, true, 1, null, new String[0]),
    leadInFrame(false, new String[0]),
    mannWhitneyUTest(false, new String[0]),
    max(true, 1, true, 1, null, new String[0]),
    maxIntersections(false, new String[0]),
    maxIntersectionsPosition(false, new String[0]),
    maxMappedArrays(false, new String[0]),
    min(true, 1, true, 1, null, new String[0]),
    minMappedArrays(false, new String[0]),
    quantile(false, 2, false, 0, ClickHouseDataType.Float64, "median"),
    quantileBFloat16(false, 2, false, 0, ClickHouseDataType.Float64, "medianBFloat16"),
    quantileBFloat16Weighted(false, "medianBFloat16Weighted"),
    quantileDeterministic(false, "medianDeterministic"),
    quantileExact(false, "medianExact"),
    quantileExactExclusive(false, new String[0]),
    quantileExactHigh(false, "medianExactHigh"),
    quantileExactInclusive(false, new String[0]),
    quantileExactLow(false, "medianExactLow"),
    quantileExactWeighted(false, "medianExactWeighted"),
    quantileTDigest(false, "medianTDigest"),
    quantileTDigestWeighted(false, "medianTDigestWeighted"),
    quantileTiming(false, "medianTiming"),
    quantileTimingWeighted(false, "medianTimingWeighted"),
    quantiles(false, Integer.MAX_VALUE, false, 0, ClickHouseDataType.Float64, new String[0]),
    quantilesBFloat16(false, new String[0]),
    quantilesBFloat16Weighted(false, new String[0]),
    quantilesDeterministic(false, new String[0]),
    quantilesExact(false, new String[0]),
    quantilesExactExclusive(false, new String[0]),
    quantilesExactHigh(false, new String[0]),
    quantilesExactInclusive(false, new String[0]),
    quantilesExactLow(false, new String[0]),
    quantilesExactWeighted(false, new String[0]),
    quantilesTDigest(false, new String[0]),
    quantilesTDigestWeighted(false, new String[0]),
    quantilesTiming(false, new String[0]),
    quantilesTimingWeighted(false, new String[0]),
    rank(true, new String[0]),
    rankCorr(false, new String[0]),
    retention(false, new String[0]),
    row_number(true, new String[0]),
    sequenceCount(false, new String[0]),
    sequenceMatch(false, new String[0]),
    sequenceNextNode(false, new String[0]),
    simpleLinearRegression(false, new String[0]),
    singleValueOrNull(false, new String[0]),
    skewPop(false, new String[0]),
    skewSamp(false, new String[0]),
    sparkbar(false, new String[0]),
    stddevPop(false, "STDDEV_POP"),
    stddevPopStable(false, new String[0]),
    stddevSamp(false, "STDDEV_SAMP"),
    stddevSampStable(false, new String[0]),
    stochasticLinearRegression(false, new String[0]),
    stochasticLogisticRegression(false, new String[0]),
    studentTTest(false, new String[0]),
    sum(true, 1, true, 1, null, new String[0]),
    sumCount(false, new String[0]),
    sumKahan(false, new String[0]),
    sumMapFiltered(false, new String[0]),
    sumMapFilteredWithOverflow(false, new String[0]),
    sumMapWithOverflow(false, new String[0]),
    sumMappedArrays(false, new String[0]),
    sumWithOverflow(false, new String[0]),
    topK(false, new String[0]),
    topKWeighted(false, new String[0]),
    uniq(false, new String[0]),
    uniqCombined(false, new String[0]),
    uniqCombined64(false, new String[0]),
    uniqExact(false, new String[0]),
    uniqHLL12(false, new String[0]),
    uniqTheta(false, new String[0]),
    uniqUpTo(false, new String[0]),
    varPop(false, "VAR_POP"),
    varPopStable(false, new String[0]),
    varSamp(false, "VAR_SAMP"),
    varSampStable(false, new String[0]),
    welchTTest(false, new String[0]),
    windowFunnel(false, new String[0]);

    public static final Map<String, ClickHouseAggregateFunction> name2func;
    private final boolean caseSensitive;
    private final int maxArgs;
    private final boolean singleValue;
    private final int refArgIndex;
    private final ClickHouseDataType valueType;
    private final List<String> aliases;

    public static ClickHouseAggregateFunction of(String function) {
        if (function == null || (function = function.trim()).isEmpty()) {
            throw new IllegalArgumentException("Non-empty function is required");
        }
        ClickHouseAggregateFunction f = name2func.get(function);
        if (f == null) {
            f = name2func.get(function.toUpperCase());
        }
        if (f == null) {
            throw new IllegalArgumentException("Unknown aggregate function: " + function);
        }
        return f;
    }

    private ClickHouseAggregateFunction(boolean caseSensitive, String ... aliases) {
        this(caseSensitive, 1, false, 0, ClickHouseDataType.Nothing, aliases);
    }

    private ClickHouseAggregateFunction(boolean caseSensitive, int maxArgs, boolean singleValue, int refArgIndex, ClickHouseDataType valueType, String ... aliases) {
        this.caseSensitive = caseSensitive;
        this.maxArgs = maxArgs < 0 ? 0 : maxArgs;
        this.singleValue = singleValue;
        this.refArgIndex = refArgIndex < 0 ? 0 : (refArgIndex > this.maxArgs ? this.maxArgs : refArgIndex);
        this.valueType = this.refArgIndex > 0 || valueType == null ? ClickHouseDataType.Nothing : valueType;
        this.aliases = aliases == null || aliases.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(aliases));
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    static {
        HashMap<String, ClickHouseAggregateFunction> map = new HashMap<String, ClickHouseAggregateFunction>();
        String errorMsg = "[%s] is used by type [%s]";
        ClickHouseAggregateFunction used = null;
        for (ClickHouseAggregateFunction t : ClickHouseAggregateFunction.values()) {
            String name = t.name();
            if (!t.isCaseSensitive()) {
                name = name.toUpperCase();
            }
            if ((used = map.put(name, t)) == null) continue;
            throw new IllegalStateException(String.format(Locale.ROOT, errorMsg, name, used.name()));
        }
        name2func = Collections.unmodifiableMap(map);
    }
}

