/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.config;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class AlertSseManager {
    private static final Logger log = LoggerFactory.getLogger(AlertSseManager.class);
    private final Map<Long, SseEmitter> emitters = new ConcurrentHashMap<Long, SseEmitter>();

    public SseEmitter createEmitter(Long clientId) {
        SseEmitter emitter = new SseEmitter(Long.valueOf(Long.MAX_VALUE));
        emitter.onCompletion(() -> this.removeEmitter(clientId));
        emitter.onTimeout(() -> this.removeEmitter(clientId));
        emitter.onError(ex -> this.removeEmitter(clientId));
        this.emitters.put(clientId, emitter);
        return emitter;
    }

    @Async
    public void broadcast(String data) {
        this.emitters.forEach((clientId, emitter) -> {
            try {
                emitter.send(SseEmitter.event().id(String.valueOf(System.currentTimeMillis())).name("ALERT_EVENT").data((Object)data));
            }
            catch (IOException | IllegalStateException e) {
                this.tryCompleteAndClean((Long)clientId, (SseEmitter)emitter);
            }
            catch (Exception exception) {
                log.error("Failed to broadcast alert data to client: {}", (Object)exception.getMessage());
                this.tryCompleteAndClean((Long)clientId, (SseEmitter)emitter);
            }
        });
    }

    private void tryCompleteAndClean(Long clientId, SseEmitter emitter) {
        try {
            Optional.ofNullable(emitter).ifPresent(ResponseBodyEmitter::complete);
        }
        catch (Throwable e) {
            log.debug("Failed to complete emitter for client {}: {}", (Object)clientId, (Object)e.getMessage());
        }
        this.removeEmitter(clientId);
    }

    private void removeEmitter(Long clientId) {
        this.emitters.remove(clientId);
    }
}

