/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.hertzbeat.alert.expr.AlertExpressionEvalVisitor;
import org.apache.hertzbeat.alert.expr.AlertExpressionLexer;
import org.apache.hertzbeat.alert.expr.AlertExpressionParser;
import org.apache.hertzbeat.alert.service.DataSourceService;
import org.apache.hertzbeat.common.support.exception.AlertExpressionException;
import org.apache.hertzbeat.common.support.valid.SqlSecurityException;
import org.apache.hertzbeat.common.support.valid.SqlSecurityValidator;
import org.apache.hertzbeat.common.util.ResourceBundleUtil;
import org.apache.hertzbeat.warehouse.db.QueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DataSourceServiceImpl
implements DataSourceService {
    private static final Logger log = LoggerFactory.getLogger(DataSourceServiceImpl.class);
    private static final List<String> DEFAULT_ALLOWED_TABLES = List.of("hertzbeat_logs");
    protected ResourceBundle bundle = ResourceBundleUtil.getBundle((String)"alerter");
    private List<QueryExecutor> executors;
    private final SqlSecurityValidator sqlSecurityValidator;
    private final Cache<String, ParseTree> expressionCache = Caffeine.newBuilder().maximumSize(256L).expireAfterAccess(1L, TimeUnit.HOURS).recordStats().build();

    public DataSourceServiceImpl(@Autowired(required=false) List<QueryExecutor> executors) {
        this.executors = executors != null ? executors : Collections.emptyList();
        this.sqlSecurityValidator = new SqlSecurityValidator(DEFAULT_ALLOWED_TABLES);
    }

    @Override
    public List<Map<String, Object>> calculate(String datasource, String expr) {
        if (!StringUtils.hasText((String)expr)) {
            throw new IllegalArgumentException("Empty expression");
        }
        if (this.executors == null || this.executors.isEmpty()) {
            throw new IllegalArgumentException(this.bundle.getString("alerter.datasource.executor.not.found"));
        }
        QueryExecutor executor = this.executors.stream().filter(e -> e.support(datasource)).findFirst().orElse(null);
        if (executor == null) {
            throw new IllegalArgumentException("Unsupported datasource: " + datasource);
        }
        expr = expr.replaceAll("\\s+", " ");
        try {
            return this.evaluate(expr, executor);
        }
        catch (AlertExpressionException ae) {
            log.error("Calculate query parse error, datasource: {}, expr: {}, msg: {}", new Object[]{datasource, expr, ae.getMessage(), ae});
            throw ae;
        }
        catch (Exception e2) {
            log.error("Error executing query on datasource {}: {}", (Object)datasource, (Object)e2.getMessage());
            throw new RuntimeException("Query execution failed", e2);
        }
    }

    @Override
    public List<Map<String, Object>> query(String datasource, String expr) {
        if (!StringUtils.hasText((String)expr)) {
            throw new IllegalArgumentException("Empty expression");
        }
        if (this.executors == null || this.executors.isEmpty()) {
            throw new IllegalArgumentException(this.bundle.getString("alerter.datasource.executor.not.found"));
        }
        QueryExecutor executor = this.executors.stream().filter(e -> e.support(datasource)).findFirst().orElse(null);
        if (executor == null) {
            throw new IllegalArgumentException("Unsupported datasource: " + datasource);
        }
        expr = expr.replaceAll("\\s+", " ");
        if (this.isSqlDatasource(datasource)) {
            this.validateSqlSecurity(expr);
        }
        try {
            return executor.execute(expr);
        }
        catch (Exception e2) {
            log.error("Error executing query on datasource {}: {}", (Object)datasource, (Object)e2.getMessage());
            throw new AlertExpressionException(e2.getMessage());
        }
    }

    private boolean isSqlDatasource(String datasource) {
        return datasource != null && datasource.equalsIgnoreCase("sql");
    }

    private void validateSqlSecurity(String sql) {
        try {
            this.sqlSecurityValidator.validate(sql);
        }
        catch (SqlSecurityException e) {
            log.warn("SQL security validation failed: {}", (Object)e.getMessage());
            throw new AlertExpressionException("SQL security validation failed: " + e.getMessage());
        }
    }

    private List<Map<String, Object>> evaluate(String expr, QueryExecutor executor) {
        CommonTokenStream tokens = this.createTokenStream(expr);
        AlertExpressionParser parser = new AlertExpressionParser((TokenStream)tokens);
        ParseTree tree = (ParseTree)this.expressionCache.get((Object)expr, e -> parser.expr());
        if (tokens.index() > 0 && tokens.LA(1) != -1) {
            throw new AlertExpressionException(this.bundle.getString("alerter.calculate.parse.error"));
        }
        AlertExpressionEvalVisitor visitor = new AlertExpressionEvalVisitor(executor, tokens);
        return (List)visitor.visit(tree);
    }

    private CommonTokenStream createTokenStream(String expr) {
        AlertExpressionLexer lexer = new AlertExpressionLexer((CharStream)CharStreams.fromString((String)expr));
        return new CommonTokenStream((TokenSource)lexer);
    }

    @Override
    public Map<String, Object> getAvailableExecutors() {
        boolean hasPromqlExecutor = false;
        boolean hasSqlExecutor = false;
        HashSet<String> availableExecutors = new HashSet<String>();
        if (this.executors != null) {
            for (QueryExecutor executor : this.executors) {
                String datasource = executor.getDatasource();
                availableExecutors.add(datasource);
                if (executor.support("promql")) {
                    hasPromqlExecutor = true;
                }
                if (!executor.support("sql")) continue;
                hasSqlExecutor = true;
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("hasPromqlExecutor", hasPromqlExecutor);
        result.put("hasSqlExecutor", hasSqlExecutor);
        result.put("availableExecutors", availableExecutors);
        return result;
    }

    public void setExecutors(List<QueryExecutor> executors) {
        this.executors = executors;
    }

    public Cache<String, ParseTree> getExpressionCache() {
        return this.expressionCache;
    }
}

