/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.log.notice;

import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.springframework.util.StringUtils;

@Schema(description="Log filtering criteria for SSE (Server-Sent Events) log streaming")
public class LogSseFilterCriteria {
    @Schema(description="Numerical value of the severity.", example="1", accessMode=Schema.AccessMode.READ_WRITE)
    private Integer severityNumber;
    @Schema(description="The severity text (also known as log level).", example="INFO", accessMode=Schema.AccessMode.READ_WRITE)
    private String severityText;
    @Schema(description="Log content text filtering", example="error occurred", accessMode=Schema.AccessMode.READ_WRITE)
    private String logContent;
    @Schema(description="A unique identifier for a trace.", example="1234567890", accessMode=Schema.AccessMode.READ_WRITE)
    private String traceId;
    @Schema(description="A unique identifier for a span.", example="1234567890", accessMode=Schema.AccessMode.READ_WRITE)
    private String spanId;

    public boolean matches(LogEntry log) {
        if (log == null) {
            return false;
        }
        if (StringUtils.hasText((String)this.severityText) && !this.severityText.equalsIgnoreCase(log.getSeverityText())) {
            return false;
        }
        if (this.severityNumber != null && log.getSeverityNumber() != null && !this.severityNumber.equals(log.getSeverityNumber())) {
            return false;
        }
        if (StringUtils.hasText((String)this.logContent)) {
            Object body = log.getBody();
            if (body == null) {
                return false;
            }
            String bodyStr = body.toString();
            if (!StringUtils.hasText((String)bodyStr) || !bodyStr.toLowerCase().contains(this.logContent.toLowerCase())) {
                return false;
            }
        }
        if (StringUtils.hasText((String)this.traceId) && !this.traceId.equalsIgnoreCase(log.getTraceId())) {
            return false;
        }
        return !StringUtils.hasText((String)this.spanId) || this.spanId.equalsIgnoreCase(log.getSpanId());
    }

    public Integer getSeverityNumber() {
        return this.severityNumber;
    }

    public String getSeverityText() {
        return this.severityText;
    }

    public String getLogContent() {
        return this.logContent;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public void setSeverityNumber(Integer severityNumber) {
        this.severityNumber = severityNumber;
    }

    public void setSeverityText(String severityText) {
        this.severityText = severityText;
    }

    public void setLogContent(String logContent) {
        this.logContent = logContent;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogSseFilterCriteria)) {
            return false;
        }
        LogSseFilterCriteria other = (LogSseFilterCriteria)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$severityNumber = this.getSeverityNumber();
        Integer other$severityNumber = other.getSeverityNumber();
        if (this$severityNumber == null ? other$severityNumber != null : !((Object)this$severityNumber).equals(other$severityNumber)) {
            return false;
        }
        String this$severityText = this.getSeverityText();
        String other$severityText = other.getSeverityText();
        if (this$severityText == null ? other$severityText != null : !this$severityText.equals(other$severityText)) {
            return false;
        }
        String this$logContent = this.getLogContent();
        String other$logContent = other.getLogContent();
        if (this$logContent == null ? other$logContent != null : !this$logContent.equals(other$logContent)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$spanId = this.getSpanId();
        String other$spanId = other.getSpanId();
        return !(this$spanId == null ? other$spanId != null : !this$spanId.equals(other$spanId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogSseFilterCriteria;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $severityNumber = this.getSeverityNumber();
        result = result * 59 + ($severityNumber == null ? 43 : ((Object)$severityNumber).hashCode());
        String $severityText = this.getSeverityText();
        result = result * 59 + ($severityText == null ? 43 : $severityText.hashCode());
        String $logContent = this.getLogContent();
        result = result * 59 + ($logContent == null ? 43 : $logContent.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $spanId = this.getSpanId();
        result = result * 59 + ($spanId == null ? 43 : $spanId.hashCode());
        return result;
    }

    public String toString() {
        return "LogSseFilterCriteria(severityNumber=" + this.getSeverityNumber() + ", severityText=" + this.getSeverityText() + ", logContent=" + this.getLogContent() + ", traceId=" + this.getTraceId() + ", spanId=" + this.getSpanId() + ")";
    }

    public LogSseFilterCriteria(Integer severityNumber, String severityText, String logContent, String traceId, String spanId) {
        this.severityNumber = severityNumber;
        this.severityText = severityText;
        this.logContent = logContent;
        this.traceId = traceId;
        this.spanId = spanId;
    }

    public LogSseFilterCriteria() {
    }
}

