/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.BuildInformation;
import io.questdb.BuildInformationHolder;
import io.questdb.DefaultFactoryProvider;
import io.questdb.DefaultTelemetryConfiguration;
import io.questdb.FactoryProvider;
import io.questdb.Metrics;
import io.questdb.PropServerConfiguration;
import io.questdb.TelemetryConfiguration;
import io.questdb.VolumeDefinitions;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.cutlass.text.DefaultTextConfiguration;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.griffin.DefaultSqlExecutionCircuitBreakerConfiguration;
import io.questdb.griffin.engine.table.parquet.ParquetCompression;
import io.questdb.griffin.engine.table.parquet.ParquetVersion;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.NanosecondClockImpl;
import io.questdb.std.Os;
import io.questdb.std.Rnd;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import java.util.function.LongSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultCairoConfiguration
implements CairoConfiguration {
    private final BuildInformation buildInformation = new BuildInformationHolder();
    private final CharSequence checkpointRoot;
    private final SqlExecutionCircuitBreakerConfiguration circuitBreakerConfiguration = new DefaultSqlExecutionCircuitBreakerConfiguration();
    private final CharSequence confRoot;
    private final long databaseIdHi;
    private final long databaseIdLo;
    private final String dbRoot;
    private final LongSupplier importIDSupplier = () -> this.getRandom().nextPositiveLong();
    private final String installRoot;
    private final CharSequence legacyCheckpointRoot;
    private final DefaultTelemetryConfiguration telemetryConfiguration = new DefaultTelemetryConfiguration();
    private final TextConfiguration textConfiguration;
    private final VolumeDefinitions volumeDefinitions = new VolumeDefinitions();
    private final boolean writerMixedIOEnabled;

    public DefaultCairoConfiguration(CharSequence dbRoot) {
        this(dbRoot, null);
    }

    public DefaultCairoConfiguration(CharSequence dbRoot, CharSequence installRoot) {
        this.dbRoot = Chars.toString(dbRoot);
        this.installRoot = Chars.toString(installRoot);
        this.confRoot = PropServerConfiguration.rootSubdir(dbRoot, "conf");
        this.textConfiguration = new DefaultTextConfiguration(Chars.toString(this.confRoot));
        this.checkpointRoot = PropServerConfiguration.rootSubdir(dbRoot, ".checkpoint");
        this.legacyCheckpointRoot = PropServerConfiguration.rootSubdir(dbRoot, "snapshot");
        Rnd rnd = new Rnd(NanosecondClockImpl.INSTANCE.getTicks(), MicrosecondClockImpl.INSTANCE.getTicks());
        this.databaseIdLo = rnd.nextLong();
        this.databaseIdHi = rnd.nextLong();
        this.writerMixedIOEnabled = this.getFilesFacade().allowMixedIO(dbRoot);
    }

    @Override
    public boolean attachPartitionCopy() {
        return false;
    }

    @Override
    public boolean enableTestFactories() {
        return true;
    }

    @Override
    public boolean freeLeakedReaders() {
        return false;
    }

    @Override
    public boolean getAllowTableRegistrySharedWrite() {
        return false;
    }

    @Override
    @NotNull
    public String getAttachPartitionSuffix() {
        return ".attachable";
    }

    @Override
    public DateFormat getBackupDirTimestampFormat() {
        return null;
    }

    @Override
    public int getBackupMkDirMode() {
        return 509;
    }

    @Override
    public CharSequence getBackupRoot() {
        return null;
    }

    @Override
    @NotNull
    public CharSequence getBackupTempDirName() {
        return "tmp";
    }

    @Override
    public int getBinaryEncodingMaxLength() {
        return 32768;
    }

    @Override
    public int getBindVariablePoolSize() {
        return 8;
    }

    @Override
    @NotNull
    public BuildInformation getBuildInformation() {
        return this.buildInformation;
    }

    @Override
    public boolean getCairoSqlLegacyOperatorPrecedence() {
        return false;
    }

    @Override
    @NotNull
    public CharSequence getCheckpointRoot() {
        return this.checkpointRoot;
    }

    @Override
    @NotNull
    public SqlExecutionCircuitBreakerConfiguration getCircuitBreakerConfiguration() {
        return this.circuitBreakerConfiguration;
    }

    @Override
    public int getColumnAliasGeneratedMaxSize() {
        return 64;
    }

    @Override
    public int getColumnIndexerQueueCapacity() {
        return 1024;
    }

    @Override
    public int getColumnPurgeQueueCapacity() {
        return 64;
    }

    @Override
    public long getColumnPurgeRetryDelay() {
        return 10000L;
    }

    @Override
    public long getColumnPurgeRetryDelayLimit() {
        return 60000000L;
    }

    @Override
    public double getColumnPurgeRetryDelayMultiplier() {
        return 2.0;
    }

    @Override
    public int getColumnPurgeTaskPoolCapacity() {
        return this.getColumnPurgeQueueCapacity();
    }

    @Override
    public long getCommitLatency() {
        return 30000000L;
    }

    @Override
    public int getCommitMode() {
        return 2;
    }

    @Override
    @NotNull
    public CharSequence getConfRoot() {
        return this.confRoot;
    }

    @Override
    @NotNull
    public LongSupplier getCopyIDSupplier() {
        return this.importIDSupplier;
    }

    @Override
    public int getCopyPoolCapacity() {
        return 16;
    }

    @Override
    public int getCountDistinctCapacity() {
        return 3;
    }

    @Override
    public double getCountDistinctLoadFactor() {
        return 0.75;
    }

    @Override
    public int getCreateAsSelectRetryCount() {
        return 5;
    }

    @Override
    public int getCreateTableColumnModelPoolCapacity() {
        return 32;
    }

    @Override
    public long getCreateTableModelBatchSize() {
        return 1000000L;
    }

    @Override
    public long getDataAppendPageSize() {
        return 0x200000L;
    }

    @Override
    public long getDataIndexKeyAppendPageSize() {
        return Files.PAGE_SIZE;
    }

    @Override
    public long getDataIndexValueAppendPageSize() {
        return Files.ceilPageSize(0x100000L);
    }

    @Override
    public long getDatabaseIdHi() {
        return this.databaseIdHi;
    }

    @Override
    public long getDatabaseIdLo() {
        return this.databaseIdLo;
    }

    @Override
    @NotNull
    public CharSequence getDbDirectory() {
        return "db";
    }

    @Override
    @NotNull
    public String getDbRoot() {
        return this.dbRoot;
    }

    @Override
    public boolean getDebugWalApplyBlockFailureNoRetry() {
        return true;
    }

    @Override
    @NotNull
    public DateLocale getDefaultDateLocale() {
        return DateFormatUtils.EN_LOCALE;
    }

    @Override
    public int getDefaultSeqPartTxnCount() {
        return 0;
    }

    @Override
    public boolean getDefaultSymbolCacheFlag() {
        return true;
    }

    @Override
    public int getDefaultSymbolCapacity() {
        return 128;
    }

    @Override
    public int getDetachedMkDirMode() {
        return 509;
    }

    @Override
    public int getExplainPoolCapacity() {
        return 32;
    }

    @Override
    @NotNull
    public FactoryProvider getFactoryProvider() {
        return DefaultFactoryProvider.INSTANCE;
    }

    @Override
    public int getFileOperationRetryCount() {
        return 30;
    }

    @Override
    public boolean getFileDescriptorCacheEnabled() {
        return true;
    }

    @Override
    @NotNull
    public FilesFacade getFilesFacade() {
        return FilesFacadeImpl.INSTANCE;
    }

    @Override
    public long getGroupByAllocatorDefaultChunkSize() {
        return 16384L;
    }

    @Override
    public long getGroupByAllocatorMaxChunkSize() {
        return 0x40000000L;
    }

    @Override
    public int getGroupByMapCapacity() {
        return 1024;
    }

    @Override
    public int getGroupByMergeShardQueueCapacity() {
        return 32;
    }

    @Override
    public int getGroupByPoolCapacity() {
        return 1024;
    }

    @Override
    public long getGroupByPresizeMaxCapacity() {
        return 1000000L;
    }

    @Override
    public long getGroupByPresizeMaxHeapSize() {
        return 0x8000000L;
    }

    @Override
    public int getGroupByShardingThreshold() {
        return 1000;
    }

    @Override
    public int getIdGenerateBatchStep() {
        return 512;
    }

    @Override
    public long getIdleCheckInterval() {
        return 100L;
    }

    @Override
    public int getInactiveReaderMaxOpenPartitions() {
        return 128;
    }

    @Override
    public long getInactiveReaderTTL() {
        return -10000L;
    }

    @Override
    public long getInactiveWalWriterTTL() {
        return 60000L;
    }

    @Override
    public long getInactiveWriterTTL() {
        return -10000L;
    }

    @Override
    public int getIndexValueBlockSize() {
        return 256;
    }

    @Override
    public long getInsertModelBatchSize() {
        return 1000000L;
    }

    @Override
    public int getInsertModelPoolCapacity() {
        return 8;
    }

    @Override
    @NotNull
    public String getInstallRoot() {
        if (this.installRoot == null) {
            throw new UnsupportedOperationException("installRoot was required in this test, but not set");
        }
        return this.installRoot;
    }

    @Override
    public int getLatestByQueueCapacity() {
        return 32;
    }

    @Override
    @NotNull
    public CharSequence getLegacyCheckpointRoot() {
        return this.legacyCheckpointRoot;
    }

    @Override
    public boolean getLogLevelVerbose() {
        return false;
    }

    @Override
    public boolean getLogSqlQueryProgressExe() {
        return true;
    }

    @Override
    public DateFormat getLogTimestampFormat() {
        return null;
    }

    @Override
    @Nullable
    public String getLogTimestampTimezone() {
        return null;
    }

    @Override
    public DateLocale getLogTimestampTimezoneLocale() {
        return null;
    }

    @Override
    public TimeZoneRules getLogTimestampTimezoneRules() {
        return null;
    }

    @Override
    public long getMatViewInsertAsSelectBatchSize() {
        return 1000000L;
    }

    @Override
    public int getMatViewMaxRefreshIntervals() {
        return 100;
    }

    @Override
    public int getMatViewMaxRefreshRetries() {
        return 10;
    }

    @Override
    public long getMatViewRefreshIntervalsUpdatePeriod() {
        return 15000L;
    }

    @Override
    public long getMatViewRefreshOomRetryTimeout() {
        return 200L;
    }

    @Override
    public int getMatViewRowsPerQueryEstimate() {
        return 10000000;
    }

    @Override
    public int getMaxCrashFiles() {
        return 1;
    }

    @Override
    public int getMaxFileNameLength() {
        return 127;
    }

    @Override
    public int getMaxSqlRecompileAttempts() {
        return 10;
    }

    @Override
    public int getMaxSwapFileCount() {
        return 30;
    }

    @Override
    public int getMaxSymbolNotEqualsCount() {
        return 100;
    }

    @Override
    public int getMaxUncommittedRows() {
        return 1000;
    }

    @Override
    public int getMetadataPoolCapacity() {
        return this.getSqlModelPoolCapacity();
    }

    @Override
    public Metrics getMetrics() {
        return Metrics.ENABLED;
    }

    @Override
    public long getMiscAppendPageSize() {
        return this.getFilesFacade().getPageSize();
    }

    @Override
    public int getMkDirMode() {
        return 509;
    }

    @Override
    public int getO3CallbackQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3ColumnMemorySize() {
        return 0x800000;
    }

    @Override
    public int getO3CopyQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3LagCalculationWindowsSize() {
        return 4;
    }

    @Override
    public int getO3LastPartitionMaxSplits() {
        return 15;
    }

    @Override
    public long getO3MaxLag() {
        return 300000000L;
    }

    @Override
    public int getO3MemMaxPages() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getO3MinLag() {
        return 1000000L;
    }

    @Override
    public int getO3OpenColumnQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3PartitionQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3PurgeDiscoveryQueueCapacity() {
        return 1024;
    }

    @Override
    public int getPageFrameReduceColumnListCapacity() {
        return 16;
    }

    @Override
    public int getPageFrameReduceQueueCapacity() {
        return 32;
    }

    @Override
    public int getPageFrameReduceRowIdListCapacity() {
        return 32;
    }

    @Override
    public int getPageFrameReduceShardCount() {
        return 4;
    }

    @Override
    public int getParallelIndexThreshold() {
        return 100000;
    }

    @Override
    public int getPartitionEncoderParquetCompressionCodec() {
        return ParquetCompression.COMPRESSION_UNCOMPRESSED;
    }

    @Override
    public int getPartitionEncoderParquetCompressionLevel() {
        return 0;
    }

    @Override
    public int getPartitionEncoderParquetDataPageSize() {
        return 0;
    }

    @Override
    public int getPartitionEncoderParquetRowGroupSize() {
        return 0;
    }

    @Override
    public int getPartitionEncoderParquetVersion() {
        return ParquetVersion.PARQUET_VERSION_V1;
    }

    @Override
    public long getPartitionO3SplitMinSize() {
        return 0x3200000L;
    }

    @Override
    public int getPartitionPurgeListCapacity() {
        return 64;
    }

    @Override
    public int getPreferencesStringPoolCapacity() {
        return 64;
    }

    @Override
    public int getQueryCacheEventQueueCapacity() {
        return 4;
    }

    @Override
    public int getQueryRegistryPoolSize() {
        return 8;
    }

    @Override
    public int getReaderPoolMaxSegments() {
        return 5;
    }

    @Override
    public int getRenameTableModelPoolCapacity() {
        return 8;
    }

    @Override
    public int getRepeatMigrationsFromVersion() {
        return -1;
    }

    @Override
    public int getRndFunctionMemoryMaxPages() {
        return 128;
    }

    @Override
    public int getRndFunctionMemoryPageSize() {
        return 8192;
    }

    @Override
    public boolean getSampleByDefaultAlignmentCalendar() {
        return true;
    }

    @Override
    public int getSampleByIndexSearchPageSize() {
        return 0;
    }

    @Override
    public int getScoreboardFormat() {
        return 2;
    }

    @Override
    public long getSequencerCheckInterval() {
        return 10000L;
    }

    @Override
    @NotNull
    public CharSequence getSnapshotInstanceId() {
        return "";
    }

    @Override
    public long getSpinLockTimeout() {
        return 5000L;
    }

    @Override
    public int getSqlAsOfJoinLookAhead() {
        return 100;
    }

    @Override
    public int getSqlAsOfJoinMapEvacuationThreshold() {
        return 10000000;
    }

    @Override
    public int getSqlAsOfJoinShortCircuitCacheCapacity() {
        return 10000000;
    }

    @Override
    public int getSqlCharacterStoreCapacity() {
        return 64;
    }

    @Override
    public int getSqlCharacterStoreSequencePoolCapacity() {
        return 64;
    }

    @Override
    public int getSqlColumnPoolCapacity() {
        return 4096;
    }

    @Override
    public int getSqlCompilerPoolCapacity() {
        return 10;
    }

    @Override
    public int getSqlCopyBufferSize() {
        return 0x100000;
    }

    @Override
    public CharSequence getSqlCopyInputRoot() {
        return null;
    }

    @Override
    public CharSequence getSqlCopyInputWorkRoot() {
        return null;
    }

    @Override
    public int getSqlCopyLogRetentionDays() {
        return 3;
    }

    @Override
    public long getSqlCopyMaxIndexChunkSize() {
        return 0x100000L;
    }

    @Override
    public int getSqlCopyQueueCapacity() {
        return 32;
    }

    @Override
    public int getSqlDistinctTimestampKeyCapacity() {
        return 256;
    }

    @Override
    public double getSqlDistinctTimestampLoadFactor() {
        return 0.5;
    }

    @Override
    public int getSqlExpressionPoolCapacity() {
        return 8192;
    }

    @Override
    public double getSqlFastMapLoadFactor() {
        return 0.7;
    }

    @Override
    public int getSqlHashJoinLightValueMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlHashJoinLightValuePageSize() {
        return 131072;
    }

    @Override
    public int getSqlHashJoinValueMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlHashJoinValuePageSize() {
        return 0x1000000;
    }

    @Override
    public int getSqlJitBindVarsMemoryMaxPages() {
        return 8;
    }

    @Override
    public int getSqlJitBindVarsMemoryPageSize() {
        return 4096;
    }

    @Override
    public int getSqlJitIRMemoryMaxPages() {
        return 8;
    }

    @Override
    public int getSqlJitIRMemoryPageSize() {
        return 8192;
    }

    @Override
    public int getSqlJitMode() {
        return 0;
    }

    @Override
    public int getSqlJitPageAddressCacheThreshold() {
        return 0x100000;
    }

    @Override
    public int getSqlJoinContextPoolCapacity() {
        return 64;
    }

    @Override
    public int getSqlJoinMetadataMaxResizes() {
        return 10;
    }

    @Override
    public int getSqlJoinMetadataPageSize() {
        return 16384;
    }

    @Override
    public long getSqlLatestByRowCount() {
        return 1000L;
    }

    @Override
    public int getSqlLexerPoolCapacity() {
        return 2048;
    }

    @Override
    public int getSqlMapMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlMapMaxResizes() {
        return 64;
    }

    @Override
    public int getSqlMaxNegativeLimit() {
        return 10000;
    }

    @Override
    public int getSqlModelPoolCapacity() {
        return 1024;
    }

    @Override
    public int getSqlOrderByRadixSortThreshold() {
        return 600;
    }

    @Override
    public int getSqlPageFrameMaxRows() {
        return 1000000;
    }

    @Override
    public int getSqlPageFrameMinRows() {
        return 1000;
    }

    @Override
    public double getSqlParallelFilterPreTouchThreshold() {
        return 0.05;
    }

    @Override
    public int getSqlParallelWorkStealingThreshold() {
        return 16;
    }

    @Override
    public int getSqlParquetFrameCacheCapacity() {
        return 3;
    }

    @Override
    public int getSqlSmallMapKeyCapacity() {
        return 64;
    }

    @Override
    public long getSqlSmallMapPageSize() {
        return 4096L;
    }

    @Override
    public int getSqlSortKeyMaxPages() {
        return 1024;
    }

    @Override
    public long getSqlSortKeyPageSize() {
        return 131072L;
    }

    @Override
    public int getSqlSortLightValueMaxPages() {
        return 1024;
    }

    @Override
    public long getSqlSortLightValuePageSize() {
        return 131072L;
    }

    @Override
    public int getSqlSortValueMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlSortValuePageSize() {
        return 0x1000000;
    }

    @Override
    public int getSqlUnorderedMapMaxEntrySize() {
        return 16;
    }

    @Override
    public int getSqlWindowInitialRangeBufferSize() {
        return 32;
    }

    @Override
    public int getSqlWindowMaxRecursion() {
        return 128;
    }

    @Override
    public int getSqlWindowRowIdMaxPages() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSqlWindowRowIdPageSize() {
        return 1024;
    }

    @Override
    public int getSqlWindowStoreMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlWindowStorePageSize() {
        return 0x100000;
    }

    @Override
    public int getSqlWindowTreeKeyMaxPages() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSqlWindowTreeKeyPageSize() {
        return 4096;
    }

    @Override
    public int getStrFunctionMaxBufferLength() {
        return 0x100000;
    }

    @Override
    public long getSymbolTableAppendPageSize() {
        return 262144L;
    }

    @Override
    public long getSystemDataAppendPageSize() {
        return 262144L;
    }

    @Override
    public int getSystemO3ColumnMemorySize() {
        return 262144;
    }

    @Override
    @NotNull
    public CharSequence getSystemTableNamePrefix() {
        return "__sys";
    }

    @Override
    public long getSystemWalDataAppendPageSize() {
        return 16384L;
    }

    @Override
    public long getSystemWalEventAppendPageSize() {
        return 131072L;
    }

    @Override
    public long getTableRegistryAutoReloadFrequency() {
        return 500L;
    }

    @Override
    public int getTableRegistryCompactionThreshold() {
        return 100;
    }

    @Override
    @NotNull
    public TelemetryConfiguration getTelemetryConfiguration() {
        return this.telemetryConfiguration;
    }

    @Override
    public CharSequence getTempRenamePendingTablePrefix() {
        return "temp_5822f658-31f6-11ee-be56-0242ac120002";
    }

    @Override
    @NotNull
    public TextConfiguration getTextConfiguration() {
        return this.textConfiguration;
    }

    @Override
    public int getTxnScoreboardEntryCount() {
        return 8192;
    }

    @Override
    public int getVectorAggregateQueueCapacity() {
        return 1024;
    }

    @Override
    @NotNull
    public VolumeDefinitions getVolumeDefinitions() {
        return this.volumeDefinitions;
    }

    @Override
    public int getWalApplyLookAheadTransactionCount() {
        return 20;
    }

    @Override
    public long getWalApplyTableTimeQuota() {
        return 1000L;
    }

    @Override
    public long getWalDataAppendPageSize() {
        return 0x100000L;
    }

    @Override
    public boolean getWalEnabledDefault() {
        return false;
    }

    @Override
    public long getWalEventAppendPageSize() {
        return 65536L;
    }

    @Override
    public double getWalLagRowsMultiplier() {
        return 20.0;
    }

    @Override
    public long getWalMaxLagSize() {
        return 0x4B00000L;
    }

    @Override
    public int getWalMaxLagTxnCount() {
        return 20;
    }

    @Override
    public int getWalMaxSegmentFileDescriptorsCache() {
        return 1000;
    }

    @Override
    public long getWalPurgeInterval() {
        return 30000L;
    }

    @Override
    public int getWalRecreateDistressedSequencerAttempts() {
        return 3;
    }

    @Override
    public long getWalSegmentRolloverRowCount() {
        return 200000L;
    }

    @Override
    public long getWalSegmentRolloverSize() {
        return 0L;
    }

    @Override
    public int getWalTxnNotificationQueueCapacity() {
        return 4096;
    }

    @Override
    public int getWalWriterPoolMaxSegments() {
        return 5;
    }

    @Override
    public int getWindowColumnPoolCapacity() {
        return 64;
    }

    @Override
    public int getWithClauseModelPoolCapacity() {
        return 128;
    }

    @Override
    public long getWorkStealTimeoutNanos() {
        return 10000L;
    }

    @Override
    public long getWriteBackOffTimeoutOnMemPressureMs() {
        return 4000L;
    }

    @Override
    public long getWriterAsyncCommandBusyWaitTimeout() {
        return 1000L;
    }

    @Override
    public long getWriterAsyncCommandMaxTimeout() {
        return 30000L;
    }

    @Override
    public int getWriterCommandQueueCapacity() {
        return 4;
    }

    @Override
    public long getWriterCommandQueueSlotSize() {
        return 1024L;
    }

    @Override
    public int getWriterFileOpenOpts() {
        return Os.type != 3 ? 64 : 0;
    }

    @Override
    public int getWriterTickRowsCountMod() {
        return 1023;
    }

    @Override
    public boolean isCheckpointRecoveryEnabled() {
        return false;
    }

    @Override
    public boolean isColumnAliasExpressionEnabled() {
        return true;
    }

    @Override
    public boolean isDevModeEnabled() {
        return false;
    }

    @Override
    public boolean isGroupByPresizeEnabled() {
        return true;
    }

    @Override
    public boolean isIOURingEnabled() {
        return true;
    }

    @Override
    public boolean isMatViewEnabled() {
        return true;
    }

    @Override
    public boolean isMatViewParallelSqlEnabled() {
        return true;
    }

    @Override
    public boolean isMultiKeyDedupEnabled() {
        return false;
    }

    @Override
    public boolean isO3QuickSortEnabled() {
        return false;
    }

    @Override
    public boolean isParallelIndexingEnabled() {
        return true;
    }

    @Override
    public boolean isPartitionEncoderParquetRawArrayEncoding() {
        return false;
    }

    @Override
    public boolean isPartitionEncoderParquetStatisticsEnabled() {
        return true;
    }

    @Override
    public boolean isPartitionO3OverwriteControlEnabled() {
        return false;
    }

    @Override
    public boolean isQueryTracingEnabled() {
        return false;
    }

    @Override
    public boolean isReadOnlyInstance() {
        return false;
    }

    @Override
    public boolean isSqlJitDebugEnabled() {
        return false;
    }

    @Override
    public boolean isSqlOrderBySortEnabled() {
        return true;
    }

    @Override
    public boolean isSqlParallelFilterEnabled() {
        return true;
    }

    @Override
    public boolean isSqlParallelFilterPreTouchEnabled() {
        return true;
    }

    @Override
    public boolean isSqlParallelGroupByEnabled() {
        return true;
    }

    @Override
    public boolean isSqlParallelReadParquetEnabled() {
        return true;
    }

    @Override
    public boolean isSqlParallelTopKEnabled() {
        return true;
    }

    @Override
    public boolean isTableTypeConversionEnabled() {
        return true;
    }

    @Override
    public boolean isWalApplyEnabled() {
        return true;
    }

    @Override
    public boolean isWalApplyParallelSqlEnabled() {
        return true;
    }

    @Override
    public boolean isWalSupported() {
        return true;
    }

    @Override
    public boolean isWriterMixedIOEnabled() {
        return this.writerMixedIOEnabled;
    }

    @Override
    public boolean mangleTableDirNames() {
        return false;
    }

    @Override
    public int maxArrayElementCount() {
        return 1000000;
    }

    @Override
    public boolean useFastAsOfJoin() {
        return true;
    }

    @Override
    public boolean useWithinLatestByOptimisation() {
        return false;
    }
}

