/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableReader;
import io.questdb.cairo.TimestampFinder;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.Mutable;
import io.questdb.std.Vect;

public class NativeTimestampFinder
implements TimestampFinder,
Mutable {
    private MemoryR column;
    private long maxTimestampApprox;
    private long minTimestampApprox;
    private TableReader reader;
    private long rowCount;
    private int timestampColumnOffset;

    @Override
    public void clear() {
        this.column = null;
        this.rowCount = 0L;
    }

    @Override
    public long findTimestamp(long value, long rowLo, long rowHi) {
        long idx = Vect.binarySearch64Bit(this.column.getPageAddress(0), value, rowLo, rowHi, 1);
        if (idx < 0L) {
            return -idx - 2L;
        }
        return idx;
    }

    @Override
    public long maxTimestampApproxFromMetadata() {
        return this.maxTimestampApprox;
    }

    @Override
    public long maxTimestampExact() {
        return this.column.getLong((this.rowCount - 1L) * 8L);
    }

    @Override
    public long minTimestampApproxFromMetadata() {
        return this.minTimestampApprox;
    }

    @Override
    public long minTimestampExact() {
        return this.column.getLong(0L);
    }

    public NativeTimestampFinder of(TableReader reader, int partitionIndex, int timestampIndex, long rowCount) {
        this.timestampColumnOffset = TableReader.getPrimaryColumnIndex(reader.getColumnBase(partitionIndex), timestampIndex);
        this.reader = reader;
        this.rowCount = rowCount;
        this.minTimestampApprox = reader.getPartitionMinTimestampFromMetadata(partitionIndex);
        this.maxTimestampApprox = reader.getPartitionMaxTimestampFromMetadata(partitionIndex);
        return this;
    }

    @Override
    public void prepare() {
        this.column = this.reader.getColumn(this.timestampColumnOffset);
    }

    @Override
    public long timestampAt(long rowIndex) {
        return this.column.getLong(rowIndex * 8L);
    }
}

